/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.executor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.StorageEngine;
import org.apache.iotdb.db.engine.querycontext.QueryDataSource;
import org.apache.iotdb.db.engine.storagegroup.DataRegion;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.path.AlignedPath;
import org.apache.iotdb.db.metadata.path.MeasurementPath;
import org.apache.iotdb.db.metadata.utils.MetaUtils;
import org.apache.iotdb.db.qp.physical.crud.AggregationPlan;
import org.apache.iotdb.db.qp.physical.crud.QueryPlan;
import org.apache.iotdb.db.qp.physical.crud.RawDataQueryPlan;
import org.apache.iotdb.db.query.aggregation.AggregateResult;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.control.QueryResourceManager;
import org.apache.iotdb.db.query.dataset.SingleDataSet;
import org.apache.iotdb.db.query.factory.AggregateResultFactory;
import org.apache.iotdb.db.query.filter.TsFileFilter;
import org.apache.iotdb.db.query.reader.series.AlignedSeriesAggregateReader;
import org.apache.iotdb.db.query.reader.series.IAggregateReader;
import org.apache.iotdb.db.query.reader.series.IReaderByTimestamp;
import org.apache.iotdb.db.query.reader.series.SeriesAggregateReader;
import org.apache.iotdb.db.query.reader.series.SeriesReaderByTimestamp;
import org.apache.iotdb.db.query.timegenerator.ServerTimeGenerator;
import org.apache.iotdb.db.utils.QueryUtils;
import org.apache.iotdb.db.utils.ValueIterator;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.common.BatchData;
import org.apache.iotdb.tsfile.read.common.IBatchDataIterator;
import org.apache.iotdb.tsfile.read.common.Path;
import org.apache.iotdb.tsfile.read.common.RowRecord;
import org.apache.iotdb.tsfile.read.expression.IExpression;
import org.apache.iotdb.tsfile.read.expression.impl.GlobalTimeExpression;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;
import org.apache.iotdb.tsfile.read.query.executor.ExecutorWithTimeGenerator;
import org.apache.iotdb.tsfile.read.query.timegenerator.TimeGenerator;
import org.apache.iotdb.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AggregationExecutor {
    private static final Logger logger = LoggerFactory.getLogger(AggregationExecutor.class);
    private List<PartialPath> selectedSeries = new ArrayList<PartialPath>();
    protected List<TSDataType> dataTypes;
    protected List<String> aggregations;
    protected IExpression expression;
    protected boolean ascending;
    protected QueryContext context;
    protected AggregateResult[] aggregateResultList;
    private int aggregateFetchSize;

    protected AggregationExecutor(QueryContext context, AggregationPlan aggregationPlan) {
        aggregationPlan.getDeduplicatedPaths().forEach(k -> this.selectedSeries.add(((MeasurementPath)((Object)k)).transformToExactPath()));
        this.dataTypes = aggregationPlan.getDeduplicatedDataTypes();
        this.aggregations = aggregationPlan.getDeduplicatedAggregations();
        this.expression = aggregationPlan.getExpression();
        this.aggregateFetchSize = IoTDBDescriptor.getInstance().getConfig().getBatchSize();
        this.ascending = aggregationPlan.isAscending();
        this.context = context;
        this.aggregateResultList = new AggregateResult[this.selectedSeries.size()];
    }

    public QueryDataSet executeWithoutValueFilter(AggregationPlan aggregationPlan) throws StorageEngineException, IOException, QueryProcessException {
        Filter timeFilter = null;
        if (this.expression != null) {
            timeFilter = ((GlobalTimeExpression)this.expression).getFilter();
        }
        Map<PartialPath, List<Integer>> pathToAggrIndexesMap = MetaUtils.groupAggregationsBySeries(this.selectedSeries);
        Map<AlignedPath, List<List<Integer>>> alignedPathToAggrIndexesMap = MetaUtils.groupAlignedSeriesWithAggregations(pathToAggrIndexesMap);
        ArrayList<PartialPath> groupedPathList = new ArrayList<PartialPath>(pathToAggrIndexesMap.size() + alignedPathToAggrIndexesMap.size());
        groupedPathList.addAll(pathToAggrIndexesMap.keySet());
        groupedPathList.addAll(alignedPathToAggrIndexesMap.keySet());
        Pair<List<DataRegion>, Map<DataRegion, List<PartialPath>>> lockListAndProcessorToSeriesMapPair = StorageEngine.getInstance().mergeLock(groupedPathList);
        List lockList = (List)lockListAndProcessorToSeriesMapPair.left;
        Map processorToSeriesMap = (Map)lockListAndProcessorToSeriesMapPair.right;
        try {
            QueryResourceManager.getInstance().initQueryDataSourceCache(processorToSeriesMap, this.context, timeFilter);
        }
        catch (Exception e) {
            logger.error("Meet error when init QueryDataSource ", (Throwable)e);
            throw new QueryProcessException("Meet error when init QueryDataSource.", e);
        }
        finally {
            StorageEngine.getInstance().mergeUnLock(lockList);
        }
        for (Map.Entry<PartialPath, List<Integer>> entry : pathToAggrIndexesMap.entrySet()) {
            PartialPath seriesPath = entry.getKey();
            this.aggregateOneSeries(seriesPath, entry.getValue(), aggregationPlan.getAllMeasurementsInDevice(seriesPath.getDevice()), timeFilter);
        }
        for (Map.Entry<Object, List<Object>> entry : alignedPathToAggrIndexesMap.entrySet()) {
            AlignedPath alignedPath = (AlignedPath)((Object)entry.getKey());
            this.aggregateOneAlignedSeries(alignedPath, entry.getValue(), aggregationPlan.getAllMeasurementsInDevice(alignedPath.getDevice()), timeFilter);
        }
        return this.constructDataSet(Arrays.asList(this.aggregateResultList), aggregationPlan);
    }

    protected void aggregateOneSeries(PartialPath seriesPath, List<Integer> indexes, Set<String> allMeasurementsInDevice, Filter timeFilter) throws IOException, QueryProcessException, StorageEngineException {
        ArrayList<AggregateResult> ascAggregateResultList = new ArrayList<AggregateResult>();
        ArrayList<AggregateResult> descAggregateResultList = new ArrayList<AggregateResult>();
        boolean[] isAsc = new boolean[this.aggregateResultList.length];
        TSDataType tsDataType = this.dataTypes.get(indexes.get(0));
        for (int i : indexes) {
            AggregateResult aggregateResult = AggregateResultFactory.getAggrResultByName(this.aggregations.get(i), tsDataType);
            if (aggregateResult.isAscending()) {
                ascAggregateResultList.add(aggregateResult);
                isAsc[i] = true;
                continue;
            }
            descAggregateResultList.add(aggregateResult);
        }
        AggregationExecutor.aggregateOneSeries(seriesPath, allMeasurementsInDevice, this.context, timeFilter, tsDataType, ascAggregateResultList, descAggregateResultList, null, this.ascending);
        int ascIndex = 0;
        int descIndex = 0;
        for (int i : indexes) {
            this.aggregateResultList[i] = isAsc[i] ? (AggregateResult)ascAggregateResultList.get(ascIndex++) : (AggregateResult)descAggregateResultList.get(descIndex++);
        }
    }

    protected void aggregateOneAlignedSeries(AlignedPath alignedPath, List<List<Integer>> subIndexes, Set<String> allMeasurementsInDevice, Filter timeFilter) throws IOException, QueryProcessException, StorageEngineException {
        ArrayList<List<AggregateResult>> ascAggregateResultList = new ArrayList<List<AggregateResult>>();
        ArrayList<List<AggregateResult>> descAggregateResultList = new ArrayList<List<AggregateResult>>();
        boolean[] isAsc = new boolean[this.aggregateResultList.length];
        for (List<Integer> subIndex : subIndexes) {
            TSDataType tsDataType = this.dataTypes.get(subIndex.get(0));
            ArrayList<AggregateResult> subAscResultList = new ArrayList<AggregateResult>();
            ArrayList<AggregateResult> subDescResultList = new ArrayList<AggregateResult>();
            for (int i : subIndex) {
                AggregateResult aggregateResult = AggregateResultFactory.getAggrResultByName(this.aggregations.get(i), tsDataType);
                if (aggregateResult.isAscending()) {
                    subAscResultList.add(aggregateResult);
                    isAsc[i] = true;
                    continue;
                }
                subDescResultList.add(aggregateResult);
            }
            ascAggregateResultList.add(subAscResultList);
            descAggregateResultList.add(subDescResultList);
        }
        AggregationExecutor.aggregateOneAlignedSeries(alignedPath, allMeasurementsInDevice, this.context, timeFilter, TSDataType.VECTOR, ascAggregateResultList, descAggregateResultList, null, this.ascending);
        for (int i = 0; i < subIndexes.size(); ++i) {
            List<Integer> subIndex;
            subIndex = subIndexes.get(i);
            List subAscResultList = (List)ascAggregateResultList.get(i);
            List subDescResultList = (List)descAggregateResultList.get(i);
            int ascIndex = 0;
            int descIndex = 0;
            for (int index : subIndex) {
                this.aggregateResultList[index] = isAsc[index] ? (AggregateResult)subAscResultList.get(ascIndex++) : (AggregateResult)subDescResultList.get(descIndex++);
            }
        }
    }

    public static void aggregateOneSeries(PartialPath seriesPath, Set<String> measurements, QueryContext context, Filter timeFilter, TSDataType tsDataType, List<AggregateResult> ascAggregateResultList, List<AggregateResult> descAggregateResultList, TsFileFilter fileFilter, boolean ascending) throws StorageEngineException, IOException, QueryProcessException {
        SeriesAggregateReader seriesReader;
        QueryDataSource queryDataSource = QueryResourceManager.getInstance().getQueryDataSource(seriesPath, context, timeFilter, ascending);
        if (fileFilter != null) {
            QueryUtils.filterQueryDataSource(queryDataSource, fileFilter);
        }
        timeFilter = queryDataSource.updateFilterUsingTTL(timeFilter);
        if (ascAggregateResultList != null && !ascAggregateResultList.isEmpty()) {
            seriesReader = new SeriesAggregateReader(seriesPath, measurements, tsDataType, context, queryDataSource, timeFilter, null, null, true);
            AggregationExecutor.aggregateFromReader(seriesReader, ascAggregateResultList);
        }
        if (descAggregateResultList != null && !descAggregateResultList.isEmpty()) {
            seriesReader = new SeriesAggregateReader(seriesPath, measurements, tsDataType, context, queryDataSource, timeFilter, null, null, false);
            AggregationExecutor.aggregateFromReader(seriesReader, descAggregateResultList);
        }
    }

    public static void aggregateOneAlignedSeries(AlignedPath alignedPath, Set<String> measurements, QueryContext context, Filter timeFilter, TSDataType tsDataType, List<List<AggregateResult>> ascAggregateResultList, List<List<AggregateResult>> descAggregateResultList, TsFileFilter fileFilter, boolean ascending) throws StorageEngineException, IOException, QueryProcessException {
        AlignedSeriesAggregateReader seriesReader;
        QueryDataSource queryDataSource = QueryResourceManager.getInstance().getQueryDataSource(alignedPath, context, timeFilter, ascending);
        if (fileFilter != null) {
            QueryUtils.filterQueryDataSource(queryDataSource, fileFilter);
        }
        timeFilter = queryDataSource.updateFilterUsingTTL(timeFilter);
        if (!AggregationExecutor.isAggregateResultEmpty(ascAggregateResultList)) {
            seriesReader = new AlignedSeriesAggregateReader(alignedPath, measurements, tsDataType, context, queryDataSource, timeFilter, null, null, true);
            AggregationExecutor.aggregateFromAlignedReader(seriesReader, ascAggregateResultList);
        }
        if (!AggregationExecutor.isAggregateResultEmpty(descAggregateResultList)) {
            seriesReader = new AlignedSeriesAggregateReader(alignedPath, measurements, tsDataType, context, queryDataSource, timeFilter, null, null, false);
            AggregationExecutor.aggregateFromAlignedReader(seriesReader, descAggregateResultList);
        }
    }

    private static boolean isAggregateResultEmpty(List<List<AggregateResult>> resultList) {
        for (List<AggregateResult> result : resultList) {
            if (result.isEmpty()) continue;
            return false;
        }
        return true;
    }

    private static void aggregateFromReader(IAggregateReader seriesReader, List<AggregateResult> aggregateResultList) throws QueryProcessException, IOException {
        int remainingToCalculate = aggregateResultList.size();
        boolean[] isCalculatedArray = new boolean[aggregateResultList.size()];
        while (seriesReader.hasNextFile()) {
            if (seriesReader.canUseCurrentFileStatistics()) {
                Statistics fileStatistics = seriesReader.currentFileStatistics();
                if ((remainingToCalculate = AggregationExecutor.aggregateStatistics(aggregateResultList, isCalculatedArray, remainingToCalculate, fileStatistics)) == 0) {
                    return;
                }
                seriesReader.skipCurrentFile();
                continue;
            }
            while (seriesReader.hasNextChunk()) {
                if (seriesReader.canUseCurrentChunkStatistics()) {
                    Statistics chunkStatistics = seriesReader.currentChunkStatistics();
                    if ((remainingToCalculate = AggregationExecutor.aggregateStatistics(aggregateResultList, isCalculatedArray, remainingToCalculate, chunkStatistics)) == 0) {
                        return;
                    }
                    seriesReader.skipCurrentChunk();
                    continue;
                }
                if ((remainingToCalculate = AggregationExecutor.aggregatePages(seriesReader, aggregateResultList, isCalculatedArray, remainingToCalculate)) != 0) continue;
                return;
            }
        }
    }

    private static void aggregateFromAlignedReader(AlignedSeriesAggregateReader seriesReader, List<List<AggregateResult>> aggregateResultList) throws QueryProcessException, IOException {
        int remainingToCalculate = 0;
        ArrayList<boolean[]> isCalculatedArray = new ArrayList<boolean[]>();
        for (List<AggregateResult> subAggregateResults : aggregateResultList) {
            remainingToCalculate += subAggregateResults.size();
            boolean[] subCalculatedArray = new boolean[subAggregateResults.size()];
            isCalculatedArray.add(subCalculatedArray);
        }
        while (seriesReader.hasNextFile()) {
            if (seriesReader.canUseCurrentFileStatistics()) {
                while (seriesReader.hasNextSubSeries()) {
                    Statistics fileStatistics = seriesReader.currentFileStatistics();
                    remainingToCalculate = AggregationExecutor.aggregateStatistics(aggregateResultList.get(seriesReader.getCurIndex()), (boolean[])isCalculatedArray.get(seriesReader.getCurIndex()), remainingToCalculate, fileStatistics);
                    if (remainingToCalculate == 0) {
                        seriesReader.resetIndex();
                        return;
                    }
                    seriesReader.nextSeries();
                }
                seriesReader.skipCurrentFile();
                continue;
            }
            while (seriesReader.hasNextChunk()) {
                if (seriesReader.canUseCurrentChunkStatistics()) {
                    while (seriesReader.hasNextSubSeries()) {
                        Statistics chunkStatistics = seriesReader.currentChunkStatistics();
                        remainingToCalculate = AggregationExecutor.aggregateStatistics(aggregateResultList.get(seriesReader.getCurIndex()), (boolean[])isCalculatedArray.get(seriesReader.getCurIndex()), remainingToCalculate, chunkStatistics);
                        if (remainingToCalculate == 0) {
                            seriesReader.resetIndex();
                            return;
                        }
                        seriesReader.nextSeries();
                    }
                    seriesReader.skipCurrentChunk();
                    continue;
                }
                if ((remainingToCalculate = AggregationExecutor.aggregateAlignedPages(seriesReader, aggregateResultList, isCalculatedArray, remainingToCalculate)) != 0) continue;
                return;
            }
        }
    }

    private static int aggregateStatistics(List<AggregateResult> aggregateResultList, boolean[] isCalculatedArray, int remainingToCalculate, Statistics statistics) throws QueryProcessException {
        if (statistics == null) {
            return remainingToCalculate;
        }
        int newRemainingToCalculate = remainingToCalculate;
        for (int i = 0; i < aggregateResultList.size(); ++i) {
            if (isCalculatedArray[i]) continue;
            AggregateResult aggregateResult = aggregateResultList.get(i);
            aggregateResult.updateResultFromStatistics(statistics);
            if (!aggregateResult.hasFinalResult()) continue;
            isCalculatedArray[i] = true;
            if (--newRemainingToCalculate != 0) continue;
            return newRemainingToCalculate;
        }
        return newRemainingToCalculate;
    }

    private static int aggregatePages(IAggregateReader seriesReader, List<AggregateResult> aggregateResultList, boolean[] isCalculatedArray, int remainingToCalculate) throws IOException, QueryProcessException {
        while (seriesReader.hasNextPage()) {
            if (seriesReader.canUseCurrentPageStatistics()) {
                Statistics pageStatistic = seriesReader.currentPageStatistics();
                if ((remainingToCalculate = AggregationExecutor.aggregateStatistics(aggregateResultList, isCalculatedArray, remainingToCalculate, pageStatistic)) == 0) {
                    return 0;
                }
                seriesReader.skipCurrentPage();
                continue;
            }
            BatchData.BatchDataIterator batchDataIterator = seriesReader.nextPage().getBatchDataIterator();
            remainingToCalculate = AggregationExecutor.aggregateBatchData(aggregateResultList, isCalculatedArray, remainingToCalculate, (IBatchDataIterator)batchDataIterator);
        }
        return remainingToCalculate;
    }

    private static int aggregateAlignedPages(AlignedSeriesAggregateReader seriesReader, List<List<AggregateResult>> aggregateResultList, List<boolean[]> isCalculatedArray, int remainingToCalculate) throws IOException, QueryProcessException {
        while (seriesReader.hasNextPage()) {
            if (seriesReader.canUseCurrentPageStatistics()) {
                while (seriesReader.hasNextSubSeries()) {
                    Statistics pageStatistic = seriesReader.currentPageStatistics();
                    remainingToCalculate = AggregationExecutor.aggregateStatistics(aggregateResultList.get(seriesReader.getCurIndex()), isCalculatedArray.get(seriesReader.getCurIndex()), remainingToCalculate, pageStatistic);
                    if (remainingToCalculate == 0) {
                        seriesReader.resetIndex();
                        return 0;
                    }
                    seriesReader.nextSeries();
                }
                seriesReader.skipCurrentPage();
                continue;
            }
            BatchData nextOverlappedPageData = seriesReader.nextPage();
            while (seriesReader.hasNextSubSeries()) {
                int subIndex = seriesReader.getCurIndex();
                IBatchDataIterator batchIterator = nextOverlappedPageData.getBatchDataIterator(subIndex);
                remainingToCalculate = AggregationExecutor.aggregateBatchData(aggregateResultList.get(subIndex), isCalculatedArray.get(subIndex), remainingToCalculate, batchIterator);
                if (remainingToCalculate == 0) {
                    seriesReader.resetIndex();
                    return 0;
                }
                seriesReader.nextSeries();
            }
        }
        return remainingToCalculate;
    }

    private static int aggregateBatchData(List<AggregateResult> aggregateResultList, boolean[] isCalculatedArray, int remainingToCalculate, IBatchDataIterator batchIterator) throws QueryProcessException, IOException {
        int newRemainingToCalculate = remainingToCalculate;
        for (int i = 0; i < aggregateResultList.size(); ++i) {
            if (isCalculatedArray[i]) continue;
            AggregateResult aggregateResult = aggregateResultList.get(i);
            aggregateResult.updateResultFromPageData(batchIterator);
            batchIterator.reset();
            if (!aggregateResult.hasFinalResult()) continue;
            isCalculatedArray[i] = true;
            if (--remainingToCalculate != 0) continue;
            return newRemainingToCalculate;
        }
        return newRemainingToCalculate;
    }

    public QueryDataSet executeWithValueFilter(AggregationPlan queryPlan) throws StorageEngineException, IOException, QueryProcessException {
        IReaderByTimestamp seriesReaderByTimestamp;
        this.optimizeLastElementFunc(queryPlan);
        TimeGenerator timestampGenerator = this.getTimeGenerator(this.context, queryPlan);
        HashMap<IReaderByTimestamp, List<List<Integer>>> readerToAggrIndexesMap = new HashMap<IReaderByTimestamp, List<List<Integer>>>();
        Map<PartialPath, List<Integer>> pathToAggrIndexesMap = MetaUtils.groupAggregationsBySeries(this.selectedSeries);
        Map<AlignedPath, List<List<Integer>>> alignedPathToAggrIndexesMap = MetaUtils.groupAlignedSeriesWithAggregations(pathToAggrIndexesMap);
        ArrayList<PartialPath> groupedPathList = new ArrayList<PartialPath>(pathToAggrIndexesMap.size() + alignedPathToAggrIndexesMap.size());
        groupedPathList.addAll(pathToAggrIndexesMap.keySet());
        groupedPathList.addAll(alignedPathToAggrIndexesMap.keySet());
        Pair<List<DataRegion>, Map<DataRegion, List<PartialPath>>> lockListAndProcessorToSeriesMapPair = StorageEngine.getInstance().mergeLock(groupedPathList);
        List lockList = (List)lockListAndProcessorToSeriesMapPair.left;
        Map processorToSeriesMap = (Map)lockListAndProcessorToSeriesMapPair.right;
        try {
            QueryResourceManager.getInstance().initQueryDataSourceCache(processorToSeriesMap, this.context, timestampGenerator.getTimeFilter());
        }
        catch (Exception e) {
            logger.error("Meet error when init QueryDataSource ", (Throwable)e);
            throw new QueryProcessException("Meet error when init QueryDataSource.", e);
        }
        finally {
            StorageEngine.getInstance().mergeUnLock(lockList);
        }
        for (PartialPath path : pathToAggrIndexesMap.keySet()) {
            seriesReaderByTimestamp = this.getReaderByTime(path, queryPlan, path.getSeriesType(), this.context);
            readerToAggrIndexesMap.put(seriesReaderByTimestamp, Collections.singletonList(pathToAggrIndexesMap.get(path)));
        }
        pathToAggrIndexesMap = null;
        for (AlignedPath vectorPath : alignedPathToAggrIndexesMap.keySet()) {
            seriesReaderByTimestamp = this.getReaderByTime(vectorPath, queryPlan, vectorPath.getSeriesType(), this.context);
            readerToAggrIndexesMap.put(seriesReaderByTimestamp, alignedPathToAggrIndexesMap.get((Object)vectorPath));
        }
        alignedPathToAggrIndexesMap = null;
        for (int i = 0; i < this.selectedSeries.size(); ++i) {
            this.aggregateResultList[i] = AggregateResultFactory.getAggrResultByName(this.aggregations.get(i), this.dataTypes.get(i), this.ascending);
        }
        this.aggregateWithValueFilter(timestampGenerator, readerToAggrIndexesMap);
        return this.constructDataSet(Arrays.asList(this.aggregateResultList), queryPlan);
    }

    private void optimizeLastElementFunc(QueryPlan queryPlan) {
        String aggregationFunc;
        int index;
        for (index = 0; index < this.aggregations.size() && ((aggregationFunc = this.aggregations.get(index)).equals("max_time") || aggregationFunc.equals("last_value")); ++index) {
        }
        if (index >= this.aggregations.size()) {
            queryPlan.setAscending(false);
            this.ascending = false;
        }
    }

    protected TimeGenerator getTimeGenerator(QueryContext context, RawDataQueryPlan queryPlan) throws StorageEngineException {
        return new ServerTimeGenerator(context, queryPlan);
    }

    protected IReaderByTimestamp getReaderByTime(PartialPath path, RawDataQueryPlan queryPlan, TSDataType dataType, QueryContext context) throws StorageEngineException, QueryProcessException {
        return new SeriesReaderByTimestamp(path, queryPlan.getAllMeasurementsInDevice(path.getDevice()), dataType, context, QueryResourceManager.getInstance().getQueryDataSource(path, context, null, this.ascending), null, this.ascending);
    }

    private void aggregateWithValueFilter(TimeGenerator timestampGenerator, Map<IReaderByTimestamp, List<List<Integer>>> readerToAggrIndexesMap) throws IOException {
        List cached = ExecutorWithTimeGenerator.markFilterdPaths((IExpression)this.expression, new ArrayList<PartialPath>(this.selectedSeries), (boolean)timestampGenerator.hasOrNode());
        while (timestampGenerator.hasNext()) {
            long[] timeArray = new long[this.aggregateFetchSize];
            int timeArrayLength = 0;
            for (int cnt = 0; cnt < this.aggregateFetchSize && timestampGenerator.hasNext(); ++cnt) {
                timeArray[timeArrayLength++] = timestampGenerator.next();
            }
            for (Map.Entry<IReaderByTimestamp, List<List<Integer>>> entry : readerToAggrIndexesMap.entrySet()) {
                Object[] values;
                ValueIterator valueIterator;
                boolean[] cachedOrNot = new boolean[entry.getValue().size()];
                for (int i = 0; i < entry.getValue().size(); ++i) {
                    Object[] values2;
                    ValueIterator valueIterator2;
                    List<Integer> subIndexes = entry.getValue().get(i);
                    int pathId = subIndexes.get(0);
                    if (!((Boolean)cached.get(pathId)).booleanValue() || (valueIterator2 = QueryUtils.generateValueIterator(values2 = timestampGenerator.getValues((Path)this.selectedSeries.get(pathId)))) == null) continue;
                    for (Integer index : subIndexes) {
                        this.aggregateResultList[index].updateResultUsingValues(timeArray, timeArrayLength, valueIterator2);
                        valueIterator2.reset();
                    }
                    cachedOrNot[i] = true;
                }
                if (!this.hasRemaining(cachedOrNot) || (valueIterator = QueryUtils.generateValueIterator(values = entry.getKey().getValuesInTimestamps(timeArray, timeArrayLength))) == null) continue;
                for (int i = 0; i < entry.getValue().size(); ++i) {
                    if (cachedOrNot[i]) continue;
                    valueIterator.setSubMeasurementIndex(i);
                    for (Integer index : entry.getValue().get(i)) {
                        this.aggregateResultList[index].updateResultUsingValues(timeArray, timeArrayLength, valueIterator);
                        valueIterator.reset();
                    }
                }
            }
        }
    }

    private boolean hasRemaining(boolean[] cachedOrNot) {
        for (int i = 0; i < cachedOrNot.length; ++i) {
            if (cachedOrNot[i]) continue;
            return true;
        }
        return false;
    }

    private QueryDataSet constructDataSet(List<AggregateResult> aggregateResultList, AggregationPlan plan) {
        SingleDataSet dataSet;
        RowRecord record = new RowRecord(0L);
        if (plan.isGroupByLevel()) {
            Map<String, AggregateResult> groupPathsResultMap = plan.groupAggResultByLevel(aggregateResultList);
            ArrayList<PartialPath> paths = new ArrayList<PartialPath>();
            ArrayList<TSDataType> dataTypes = new ArrayList<TSDataType>();
            for (AggregateResult resultData : groupPathsResultMap.values()) {
                dataTypes.add(resultData.getResultDataType());
                record.addField(resultData.getResult(), resultData.getResultDataType());
            }
            dataSet = new SingleDataSet(paths, dataTypes);
        } else {
            for (AggregateResult resultData : aggregateResultList) {
                TSDataType dataType = resultData.getResultDataType();
                record.addField(resultData.getResult(), dataType);
            }
            dataSet = new SingleDataSet(this.selectedSeries, this.dataTypes);
        }
        dataSet.setRecord(record);
        return dataSet;
    }
}

