/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.pool;

import java.util.concurrent.ThreadPoolExecutor;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.concurrent.ThreadName;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.rescon.AbstractPoolManager;
import org.apache.iotdb.db.service.metrics.MetricsService;
import org.apache.iotdb.db.service.metrics.enums.Metric;
import org.apache.iotdb.db.service.metrics.enums.Tag;
import org.apache.iotdb.metrics.config.MetricConfigDescriptor;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RawQueryReadTaskPoolManager
extends AbstractPoolManager {
    private static final Logger LOGGER = LoggerFactory.getLogger(RawQueryReadTaskPoolManager.class);

    private RawQueryReadTaskPoolManager() {
        int threadCnt = Math.min(Runtime.getRuntime().availableProcessors(), IoTDBDescriptor.getInstance().getConfig().getConcurrentSubRawQueryThread());
        this.pool = IoTDBThreadPoolFactory.newFixedThreadPool((int)threadCnt, (String)ThreadName.SUB_RAW_QUERY_SERVICE.getName());
        if (MetricConfigDescriptor.getInstance().getMetricConfig().getEnableMetric().booleanValue()) {
            MetricsService.getInstance().getMetricManager().getOrCreateAutoGauge(Metric.QUEUE.toString(), MetricLevel.IMPORTANT, (Object)this.pool, p -> ((ThreadPoolExecutor)p).getActiveCount(), new String[]{Tag.NAME.toString(), ThreadName.SUB_RAW_QUERY_SERVICE.getName(), Tag.STATUS.toString(), "running"});
            MetricsService.getInstance().getMetricManager().getOrCreateAutoGauge(Metric.QUEUE.toString(), MetricLevel.IMPORTANT, (Object)this.pool, p -> ((ThreadPoolExecutor)p).getQueue().size(), new String[]{Tag.NAME.toString(), ThreadName.SUB_RAW_QUERY_SERVICE.getName(), Tag.STATUS.toString(), "waiting"});
        }
    }

    public static RawQueryReadTaskPoolManager getInstance() {
        return InstanceHolder.instance;
    }

    @Override
    public Logger getLogger() {
        return LOGGER;
    }

    @Override
    public String getName() {
        return "raw query read task";
    }

    @Override
    public void start() {
        if (this.pool == null) {
            int threadCnt = Math.min(Runtime.getRuntime().availableProcessors(), IoTDBDescriptor.getInstance().getConfig().getConcurrentSubRawQueryThread());
            this.pool = IoTDBThreadPoolFactory.newFixedThreadPool((int)threadCnt, (String)ThreadName.SUB_RAW_QUERY_SERVICE.getName());
        }
    }

    @Override
    public void stop() {
        if (this.pool != null) {
            this.close();
            this.pool = null;
        }
    }

    private static class InstanceHolder {
        private static RawQueryReadTaskPoolManager instance = new RawQueryReadTaskPoolManager();

        private InstanceHolder() {
        }
    }
}

