/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.service;

import org.apache.iotdb.commons.concurrent.ThreadName;
import org.apache.iotdb.commons.exception.runtime.RPCServiceException;
import org.apache.iotdb.commons.service.ServiceType;
import org.apache.iotdb.commons.service.ThriftService;
import org.apache.iotdb.commons.service.ThriftServiceThread;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.service.InfluxDBRPCServiceMBean;
import org.apache.iotdb.db.service.thrift.handler.InfluxDBServiceThriftHandler;
import org.apache.iotdb.db.service.thrift.impl.InfluxDBServiceImpl;
import org.apache.iotdb.protocol.influxdb.rpc.thrift.InfluxDBService;
import org.apache.thrift.server.TServerEventHandler;

public class InfluxDBRPCService
extends ThriftService
implements InfluxDBRPCServiceMBean {
    private InfluxDBServiceImpl impl;

    public static InfluxDBRPCService getInstance() {
        return InfluxDBServiceHolder.INSTANCE;
    }

    public void initTProcessor() throws ClassNotFoundException, IllegalAccessException, InstantiationException {
        this.impl = (InfluxDBServiceImpl)Class.forName(IoTDBDescriptor.getInstance().getConfig().getInfluxDBImplClassName()).newInstance();
        this.initSyncedServiceImpl(null);
        this.processor = new InfluxDBService.Processor((InfluxDBService.Iface)this.impl);
    }

    public void initThriftServiceThread() throws IllegalAccessException, InstantiationException, ClassNotFoundException {
        IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
        try {
            this.thriftServiceThread = new ThriftServiceThread(this.processor, this.getID().getName(), ThreadName.INFLUXDB_CLIENT.getName(), config.getRpcAddress(), config.getInfluxDBRpcPort(), config.getRpcMaxConcurrentClientNum(), config.getThriftServerAwaitTimeForStopService(), (TServerEventHandler)new InfluxDBServiceThriftHandler(this.impl), IoTDBDescriptor.getInstance().getConfig().isRpcThriftCompressionEnable());
        }
        catch (RPCServiceException e) {
            throw new IllegalAccessException(e.getMessage());
        }
        this.thriftServiceThread.setName(ThreadName.INFLUXDB_SERVICE.getName());
    }

    public String getBindIP() {
        return IoTDBDescriptor.getInstance().getConfig().getRpcAddress();
    }

    public int getBindPort() {
        return IoTDBDescriptor.getInstance().getConfig().getInfluxDBRpcPort();
    }

    @Override
    public int getRPCPort() {
        return this.getBindPort();
    }

    public ServiceType getID() {
        return ServiceType.INFLUX_SERVICE;
    }

    private static class InfluxDBServiceHolder {
        private static final InfluxDBRPCService INSTANCE = new InfluxDBRPCService();

        private InfluxDBServiceHolder() {
        }
    }
}

