/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.service.metrics.recorder;

import java.util.concurrent.TimeUnit;
import org.apache.iotdb.db.engine.compaction.constant.CompactionTaskStatus;
import org.apache.iotdb.db.engine.compaction.constant.CompactionType;
import org.apache.iotdb.db.engine.compaction.constant.ProcessChunkType;
import org.apache.iotdb.db.engine.compaction.cross.CrossSpaceCompactionTask;
import org.apache.iotdb.db.engine.compaction.inner.InnerSpaceCompactionTask;
import org.apache.iotdb.db.engine.compaction.task.AbstractCompactionTask;
import org.apache.iotdb.db.service.metrics.MetricsService;
import org.apache.iotdb.db.service.metrics.enums.Metric;
import org.apache.iotdb.db.service.metrics.enums.Tag;
import org.apache.iotdb.metrics.config.MetricConfigDescriptor;
import org.apache.iotdb.metrics.utils.MetricLevel;

public class CompactionMetricsRecorder {
    private static final boolean ENABLE_METRIC = MetricConfigDescriptor.getInstance().getMetricConfig().getEnableMetric();

    public static void recordWriteInfo(CompactionType compactionType, ProcessChunkType processChunkType, boolean aligned, long byteNum) {
        if (!ENABLE_METRIC) {
            return;
        }
        MetricsService.getInstance().getMetricManager().count(byteNum / 1024L, Metric.DATA_WRITTEN.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), "compaction", Tag.NAME.toString(), compactionType.toString(), Tag.TYPE.toString(), aligned ? "ALIGNED" : "NOT_ALIGNED", Tag.TYPE.toString(), processChunkType.toString()});
        MetricsService.getInstance().getMetricManager().count(byteNum / 1024L, Metric.DATA_WRITTEN.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), "compaction", Tag.TYPE.toString(), "total"});
    }

    public static void recordReadInfo(long byteNum) {
        if (!ENABLE_METRIC) {
            return;
        }
        MetricsService.getInstance().getMetricManager().count(byteNum, Metric.DATA_READ.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), "compaction"});
    }

    public static void recordTaskInfo(AbstractCompactionTask task, CompactionTaskStatus status, int size) {
        if (!ENABLE_METRIC) {
            return;
        }
        String taskType = "unknown";
        boolean isInnerTask = false;
        if (task instanceof InnerSpaceCompactionTask) {
            isInnerTask = true;
            taskType = "inner";
        } else if (task instanceof CrossSpaceCompactionTask) {
            taskType = "cross";
        }
        switch (status) {
            case ADD_TO_QUEUE: 
            case POLL_FROM_QUEUE: {
                MetricsService.getInstance().getMetricManager().getOrCreateGauge(Metric.QUEUE.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), "compaction_" + taskType, Tag.STATUS.toString(), "waiting"}).set((long)size);
                break;
            }
            case READY_TO_EXECUTE: {
                MetricsService.getInstance().getMetricManager().getOrCreateGauge(Metric.QUEUE.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), "compaction_" + taskType, Tag.STATUS.toString(), "running"}).set((long)size);
                break;
            }
            case FINISHED: {
                MetricsService.getInstance().getMetricManager().getOrCreateGauge(Metric.QUEUE.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), "compaction_" + taskType, Tag.STATUS.toString(), "running"}).set((long)size);
                MetricsService.getInstance().getMetricManager().timer(task.getTimeCost(), TimeUnit.MILLISECONDS, Metric.COST_TASK.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), isInnerTask ? "inner_compaction" : "cross_compaction"});
                if (isInnerTask) {
                    MetricsService.getInstance().getMetricManager().count(1L, Metric.COMPACTION_TASK_COUNT.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), "inner_compaction_count", Tag.TYPE.toString(), ((InnerSpaceCompactionTask)task).isSequence() ? "sequence" : "unsequence"});
                    break;
                }
                MetricsService.getInstance().getMetricManager().count(1L, Metric.COMPACTION_TASK_COUNT.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), "cross_compaction_count"});
                break;
            }
        }
    }
}

