/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.wal.buffer;

import java.io.DataInputStream;
import java.io.IOException;
import java.util.Objects;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.memtable.AbstractMemTable;
import org.apache.iotdb.db.engine.memtable.IMemTable;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeType;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.write.InsertRowNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.write.InsertTabletNode;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.crud.DeletePlan;
import org.apache.iotdb.db.qp.physical.crud.InsertRowPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertTabletPlan;
import org.apache.iotdb.db.utils.SerializedSize;
import org.apache.iotdb.db.wal.buffer.IWALByteBufferView;
import org.apache.iotdb.db.wal.buffer.WALEntryType;
import org.apache.iotdb.db.wal.buffer.WALEntryValue;
import org.apache.iotdb.db.wal.utils.WALMode;
import org.apache.iotdb.db.wal.utils.listener.WALFlushListener;

public class WALEntry
implements SerializedSize {
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private static final int FIXED_SERIALIZED_SIZE = 9;
    private final WALEntryType type;
    private final long memTableId;
    private final WALEntryValue value;
    private TabletInfo tabletInfo;
    private final WALFlushListener walFlushListener;

    public WALEntry(long memTableId, WALEntryValue value) {
        this(memTableId, value, config.getWalMode() == WALMode.SYNC);
        if (value instanceof InsertTabletPlan) {
            this.tabletInfo = new TabletInfo(0, ((InsertTabletPlan)value).getRowCount());
        } else if (value instanceof InsertTabletNode) {
            this.tabletInfo = new TabletInfo(0, ((InsertTabletNode)value).getRowCount());
        }
    }

    public WALEntry(long memTableId, InsertTabletPlan value, int tabletStart, int tabletEnd) {
        this(memTableId, value, config.getWalMode() == WALMode.SYNC);
        this.tabletInfo = new TabletInfo(tabletStart, tabletEnd);
    }

    public WALEntry(long memTableId, InsertTabletNode value, int tabletStart, int tabletEnd) {
        this(memTableId, value, config.getWalMode() == WALMode.SYNC);
        this.tabletInfo = new TabletInfo(tabletStart, tabletEnd);
    }

    public WALEntry(long memTableId, WALEntryValue value, boolean wait) {
        this.memTableId = memTableId;
        this.value = value;
        if (value instanceof InsertRowPlan) {
            this.type = WALEntryType.INSERT_ROW_PLAN;
        } else if (value instanceof InsertTabletPlan) {
            this.type = WALEntryType.INSERT_TABLET_PLAN;
        } else if (value instanceof DeletePlan) {
            this.type = WALEntryType.DELETE_PLAN;
        } else if (value instanceof IMemTable) {
            this.type = WALEntryType.MEMORY_TABLE_SNAPSHOT;
        } else if (value instanceof InsertRowNode) {
            this.type = WALEntryType.INSERT_ROW_NODE;
        } else if (value instanceof InsertTabletNode) {
            this.type = WALEntryType.INSERT_TABLET_NODE;
        } else {
            throw new RuntimeException("Unknown WALEntry type");
        }
        this.walFlushListener = new WALFlushListener(wait);
    }

    private WALEntry(WALEntryType type, long memTableId, WALEntryValue value) {
        this.type = type;
        this.memTableId = memTableId;
        this.value = value;
        this.walFlushListener = null;
    }

    @Override
    public int serializedSize() {
        return 9 + this.value.serializedSize();
    }

    public void serialize(IWALByteBufferView buffer) {
        buffer.put(this.type.getCode());
        buffer.putLong(this.memTableId);
        switch (this.type) {
            case INSERT_TABLET_PLAN: {
                ((InsertTabletPlan)this.value).serializeToWAL(buffer, this.tabletInfo.tabletStart, this.tabletInfo.tabletEnd);
                break;
            }
            case INSERT_TABLET_NODE: {
                ((InsertTabletNode)this.value).serializeToWAL(buffer, this.tabletInfo.tabletStart, this.tabletInfo.tabletEnd);
                break;
            }
            case INSERT_ROW_PLAN: 
            case INSERT_ROW_NODE: 
            case DELETE_PLAN: 
            case MEMORY_TABLE_SNAPSHOT: {
                this.value.serializeToWAL(buffer);
            }
        }
    }

    public static WALEntry deserialize(DataInputStream stream) throws IllegalPathException, IOException {
        byte typeNum = stream.readByte();
        WALEntryType type = WALEntryType.valueOf(typeNum);
        if (type == null) {
            throw new IOException("unrecognized wal entry type " + typeNum);
        }
        long memTableId = stream.readLong();
        WALEntryValue value = null;
        switch (type) {
            case INSERT_ROW_PLAN: {
                value = (InsertRowPlan)PhysicalPlan.Factory.create(stream);
                break;
            }
            case INSERT_TABLET_PLAN: {
                value = (InsertTabletPlan)PhysicalPlan.Factory.create(stream);
                break;
            }
            case DELETE_PLAN: {
                value = (DeletePlan)PhysicalPlan.Factory.create(stream);
                break;
            }
            case MEMORY_TABLE_SNAPSHOT: {
                value = AbstractMemTable.Factory.create(stream);
                break;
            }
            case INSERT_ROW_NODE: {
                value = (InsertRowNode)PlanNodeType.deserialize(stream);
                break;
            }
            case INSERT_TABLET_NODE: {
                value = (InsertTabletNode)PlanNodeType.deserialize(stream);
            }
        }
        return new WALEntry(type, memTableId, value);
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof WALEntry)) {
            return false;
        }
        WALEntry other = (WALEntry)obj;
        return this.type == other.type && this.memTableId == other.memTableId && Objects.equals(this.value, other.value);
    }

    public WALEntryType getType() {
        return this.type;
    }

    public long getMemTableId() {
        return this.memTableId;
    }

    public WALEntryValue getValue() {
        return this.value;
    }

    public WALFlushListener getWalFlushListener() {
        return this.walFlushListener;
    }

    public boolean isSignal() {
        return false;
    }

    private static class TabletInfo {
        private final int tabletStart;
        private final int tabletEnd;

        public TabletInfo(int tabletStart, int tabletEnd) {
            this.tabletStart = tabletStart;
            this.tabletEnd = tabletEnd;
        }
    }
}

