/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.wal.checkpoint;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.iotdb.commons.file.SystemFileFactory;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.wal.checkpoint.Checkpoint;
import org.apache.iotdb.db.wal.checkpoint.CheckpointType;
import org.apache.iotdb.db.wal.checkpoint.MemTableInfo;
import org.apache.iotdb.db.wal.io.CheckpointWriter;
import org.apache.iotdb.db.wal.io.ILogWriter;
import org.apache.iotdb.db.wal.utils.CheckpointFileUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CheckpointManager
implements AutoCloseable {
    private static final Logger logger = LoggerFactory.getLogger(CheckpointManager.class);
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    protected final String identifier;
    protected final String logDirectory;
    private final Lock infoLock = new ReentrantLock();
    private final Map<Long, MemTableInfo> memTableId2Info = new HashMap<Long, MemTableInfo>();
    private volatile ByteBuffer cachedByteBuffer;
    private long maxMemTableId = 0L;
    private int currentCheckPointFileVersion = 0;
    private ILogWriter currentLogWriter;

    public CheckpointManager(String identifier, String logDirectory) throws FileNotFoundException {
        this.identifier = identifier;
        this.logDirectory = logDirectory;
        File logDirFile = SystemFileFactory.INSTANCE.getFile(logDirectory);
        if (!logDirFile.exists() && logDirFile.mkdirs()) {
            logger.info("create folder {} for wal buffer-{}.", (Object)logDirectory, (Object)identifier);
        }
        this.currentLogWriter = new CheckpointWriter(SystemFileFactory.INSTANCE.getFile(logDirectory, CheckpointFileUtils.getLogFileName(this.currentCheckPointFileVersion)));
        this.logHeader();
    }

    private void logHeader() {
        this.infoLock.lock();
        try {
            ByteBuffer tmpBuffer = ByteBuffer.allocate(8);
            tmpBuffer.putLong(this.maxMemTableId);
            try {
                this.currentLogWriter.write(tmpBuffer);
            }
            catch (IOException e) {
                logger.error("Fail to log max memTable id: {}", (Object)this.maxMemTableId, (Object)e);
            }
            this.makeGlobalInfoCP();
        }
        finally {
            this.infoLock.unlock();
        }
    }

    private void makeGlobalInfoCP() {
        Checkpoint checkpoint = new Checkpoint(CheckpointType.GLOBAL_MEMORY_TABLE_INFO, new ArrayList<MemTableInfo>(this.memTableId2Info.values()));
        this.logByCachedByteBuffer(checkpoint);
    }

    public void makeCreateMemTableCP(MemTableInfo memTableInfo) {
        this.infoLock.lock();
        try {
            this.maxMemTableId = Math.max(this.maxMemTableId, memTableInfo.getMemTableId());
            this.memTableId2Info.put(memTableInfo.getMemTableId(), memTableInfo);
            Checkpoint checkpoint = new Checkpoint(CheckpointType.CREATE_MEMORY_TABLE, Collections.singletonList(memTableInfo));
            this.logByCachedByteBuffer(checkpoint);
        }
        finally {
            this.infoLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void makeFlushMemTableCP(long memTableId) {
        this.infoLock.lock();
        try {
            MemTableInfo memTableInfo = this.memTableId2Info.remove(memTableId);
            if (memTableInfo == null) {
                return;
            }
            Checkpoint checkpoint = new Checkpoint(CheckpointType.FLUSH_MEMORY_TABLE, Collections.singletonList(memTableInfo));
            this.logByCachedByteBuffer(checkpoint);
        }
        finally {
            this.infoLock.unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void logByCachedByteBuffer(Checkpoint checkpoint) {
        int estimateSize = checkpoint.serializedSize();
        if (this.cachedByteBuffer == null || estimateSize > this.cachedByteBuffer.capacity()) {
            this.cachedByteBuffer = ByteBuffer.allocate(estimateSize);
        }
        checkpoint.serialize(this.cachedByteBuffer);
        try {
            this.currentLogWriter.write(this.cachedByteBuffer);
        }
        catch (IOException e) {
            logger.error("Fail to make checkpoint: {}", (Object)checkpoint, (Object)e);
        }
        finally {
            this.cachedByteBuffer.clear();
        }
        this.fsyncCheckpointFile();
    }

    private void fsyncCheckpointFile() {
        this.infoLock.lock();
        try {
            try {
                this.currentLogWriter.force();
            }
            catch (IOException e) {
                logger.error("Fail to fsync wal node-{}'s checkpoint writer, change system mode to read-only.", (Object)this.identifier, (Object)e);
                config.setReadOnly(true);
            }
            try {
                if (this.tryRollingLogWriter()) {
                    this.logHeader();
                    this.currentLogWriter.force();
                    File oldFile = SystemFileFactory.INSTANCE.getFile(this.logDirectory, CheckpointFileUtils.getLogFileName(this.currentCheckPointFileVersion - 1));
                    oldFile.delete();
                }
            }
            catch (IOException e) {
                logger.error("Fail to roll wal node-{}'s checkpoint writer, change system mode to read-only.", (Object)this.identifier, (Object)e);
                config.setReadOnly(true);
            }
        }
        finally {
            this.infoLock.unlock();
        }
    }

    private boolean tryRollingLogWriter() throws IOException {
        if (this.currentLogWriter.size() < config.getCheckpointFileSizeThresholdInByte()) {
            return false;
        }
        this.currentLogWriter.close();
        ++this.currentCheckPointFileVersion;
        File nextLogFile = SystemFileFactory.INSTANCE.getFile(this.logDirectory, CheckpointFileUtils.getLogFileName(this.currentCheckPointFileVersion));
        this.currentLogWriter = new CheckpointWriter(nextLogFile);
        return true;
    }

    public MemTableInfo getOldestMemTableInfo() {
        ArrayList<MemTableInfo> memTableInfos;
        this.infoLock.lock();
        try {
            memTableInfos = new ArrayList<MemTableInfo>(this.memTableId2Info.values());
        }
        finally {
            this.infoLock.unlock();
        }
        if (memTableInfos.isEmpty()) {
            return null;
        }
        MemTableInfo oldestMemTableInfo = (MemTableInfo)memTableInfos.get(0);
        for (MemTableInfo memTableInfo : memTableInfos) {
            if (oldestMemTableInfo.getFirstFileVersionId() <= memTableInfo.getFirstFileVersionId()) continue;
            oldestMemTableInfo = memTableInfo;
        }
        return oldestMemTableInfo;
    }

    public long getFirstValidWALVersionId() {
        ArrayList<MemTableInfo> memTableInfos;
        this.infoLock.lock();
        try {
            memTableInfos = new ArrayList<MemTableInfo>(this.memTableId2Info.values());
        }
        finally {
            this.infoLock.unlock();
        }
        long firstValidVersionId = memTableInfos.isEmpty() ? Long.MIN_VALUE : Long.MAX_VALUE;
        for (MemTableInfo memTableInfo : memTableInfos) {
            firstValidVersionId = Math.min(firstValidVersionId, memTableInfo.getFirstFileVersionId());
        }
        return firstValidVersionId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getTotalCostOfActiveMemTables() {
        ArrayList<MemTableInfo> memTableInfos;
        long totalCost = 0L;
        if (!config.isEnableMemControl()) {
            this.infoLock.lock();
            try {
                totalCost = this.memTableId2Info.size();
            }
            finally {
                this.infoLock.unlock();
            }
        }
        this.infoLock.lock();
        try {
            memTableInfos = new ArrayList<MemTableInfo>(this.memTableId2Info.values());
        }
        finally {
            this.infoLock.unlock();
        }
        for (MemTableInfo memTableInfo : memTableInfos) {
            totalCost += memTableInfo.getMemTable().getTVListsRamCost();
        }
        return totalCost;
    }

    @Override
    public void close() {
        this.infoLock.lock();
        try {
            if (this.currentLogWriter != null) {
                try {
                    this.currentLogWriter.close();
                }
                catch (IOException e) {
                    logger.error("Fail to close wal node-{}'s checkpoint writer.", (Object)this.identifier, (Object)e);
                }
            }
        }
        finally {
            this.infoLock.unlock();
        }
    }
}

