/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.wal.checkpoint;

import java.io.DataInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import org.apache.iotdb.db.engine.memtable.IMemTable;
import org.apache.iotdb.db.utils.SerializedSize;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class MemTableInfo
implements SerializedSize {
    private static final int FIXED_SERIALIZED_SIZE = 16;
    private IMemTable memTable;
    private long memTableId;
    private String tsFilePath;
    private volatile long firstFileVersionId;

    private MemTableInfo() {
    }

    public MemTableInfo(IMemTable memTable, String tsFilePath, long firstFileVersionId) {
        this.memTable = memTable;
        this.memTableId = memTable.getMemTableId();
        this.tsFilePath = tsFilePath;
        this.firstFileVersionId = firstFileVersionId;
    }

    @Override
    public int serializedSize() {
        return 16 + ReadWriteIOUtils.sizeToWrite((String)this.tsFilePath);
    }

    public void serialize(ByteBuffer buffer) {
        buffer.putLong(this.memTableId);
        ReadWriteIOUtils.write((String)this.tsFilePath, (ByteBuffer)buffer);
        buffer.putLong(this.firstFileVersionId);
    }

    public static MemTableInfo deserialize(DataInputStream stream) throws IOException {
        MemTableInfo memTableInfo = new MemTableInfo();
        memTableInfo.memTableId = stream.readLong();
        memTableInfo.tsFilePath = ReadWriteIOUtils.readString((InputStream)stream);
        memTableInfo.firstFileVersionId = stream.readLong();
        return memTableInfo;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof MemTableInfo)) {
            return false;
        }
        MemTableInfo other = (MemTableInfo)obj;
        return this.memTableId == other.memTableId && Objects.equals(this.tsFilePath, other.tsFilePath) && this.firstFileVersionId == other.firstFileVersionId;
    }

    public IMemTable getMemTable() {
        return this.memTable;
    }

    public long getMemTableId() {
        return this.memTableId;
    }

    public String getTsFilePath() {
        return this.tsFilePath;
    }

    public long getFirstFileVersionId() {
        return this.firstFileVersionId;
    }

    public void setFirstFileVersionId(long firstFileVersionId) {
        this.firstFileVersionId = firstFileVersionId;
    }
}

