/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.common.rpc.thrift.TFlushReq;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.common.rpc.thrift.TSetTTLReq;
import org.apache.iotdb.common.rpc.thrift.TTimePartitionSlot;
import org.apache.iotdb.commons.concurrent.IoTDBThreadPoolFactory;
import org.apache.iotdb.commons.concurrent.ThreadName;
import org.apache.iotdb.commons.concurrent.threadpool.ScheduledExecutorUtil;
import org.apache.iotdb.commons.conf.CommonDescriptor;
import org.apache.iotdb.commons.consensus.DataRegionId;
import org.apache.iotdb.commons.exception.ShutdownException;
import org.apache.iotdb.commons.file.SystemFileFactory;
import org.apache.iotdb.commons.service.IService;
import org.apache.iotdb.commons.service.ServiceType;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.consensus.statemachine.visitor.DataExecutionVisitor;
import org.apache.iotdb.db.engine.flush.CloseFileListener;
import org.apache.iotdb.db.engine.flush.FlushListener;
import org.apache.iotdb.db.engine.flush.TsFileFlushPolicy;
import org.apache.iotdb.db.engine.storagegroup.DataRegion;
import org.apache.iotdb.db.engine.storagegroup.TsFileProcessor;
import org.apache.iotdb.db.exception.DataRegionException;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.TsFileProcessorException;
import org.apache.iotdb.db.exception.WriteProcessRejectException;
import org.apache.iotdb.db.exception.runtime.StorageEngineFailureException;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.rescon.SystemInfo;
import org.apache.iotdb.db.sync.SyncService;
import org.apache.iotdb.db.utils.ThreadUtils;
import org.apache.iotdb.db.utils.UpgradeUtils;
import org.apache.iotdb.db.wal.WALManager;
import org.apache.iotdb.db.wal.exception.WALException;
import org.apache.iotdb.db.wal.recover.WALRecoverManager;
import org.apache.iotdb.rpc.RpcUtils;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.utils.FilePathUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class StorageEngineV2
implements IService {
    private static final Logger logger = LoggerFactory.getLogger(StorageEngineV2.class);
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private static final long TTL_CHECK_INTERVAL = 60000L;
    private static long timePartitionInterval = -1L;
    private static boolean enablePartition = config.isEnablePartition();
    private final boolean enableMemControl = config.isEnableMemControl();
    private final String systemDir = FilePathUtils.regularizePath((String)config.getSystemDir()) + "storage_groups";
    private final ConcurrentHashMap<DataRegionId, DataRegion> dataRegionMap = new ConcurrentHashMap();
    private final ConcurrentHashMap<DataRegionId, DataRegion> deletingDataRegionMap = new ConcurrentHashMap();
    private AtomicInteger readyDataRegionNum;
    private AtomicBoolean isAllSgReady = new AtomicBoolean(false);
    private ScheduledExecutorService ttlCheckThread;
    private ScheduledExecutorService seqMemtableTimedFlushCheckThread;
    private ScheduledExecutorService unseqMemtableTimedFlushCheckThread;
    private TsFileFlushPolicy fileFlushPolicy = new TsFileFlushPolicy.DirectFlushPolicy();
    private ExecutorService recoveryThreadPool;
    private List<CloseFileListener> customCloseFileListeners = new ArrayList<CloseFileListener>();
    private List<FlushListener> customFlushListeners = new ArrayList<FlushListener>();
    private int recoverDataRegionNum = 0;

    private StorageEngineV2() {
    }

    public static StorageEngineV2 getInstance() {
        return InstanceHolder.INSTANCE;
    }

    private static void initTimePartition() {
        timePartitionInterval = StorageEngineV2.convertMilliWithPrecision(IoTDBDescriptor.getInstance().getConfig().getPartitionInterval() * 1000L);
    }

    public static long convertMilliWithPrecision(long milliTime) {
        String timePrecision;
        long result = milliTime;
        switch (timePrecision = IoTDBDescriptor.getInstance().getConfig().getTimestampPrecision()) {
            case "ns": {
                result = milliTime * 1000000L;
                break;
            }
            case "us": {
                result = milliTime * 1000L;
                break;
            }
        }
        return result;
    }

    public static long getTimePartitionInterval() {
        if (timePartitionInterval == -1L) {
            StorageEngineV2.initTimePartition();
        }
        return timePartitionInterval;
    }

    public static void setTimePartitionInterval(long timePartitionInterval) {
        StorageEngineV2.timePartitionInterval = timePartitionInterval;
    }

    public static long getTimePartition(long time) {
        if (timePartitionInterval == -1L) {
            StorageEngineV2.initTimePartition();
        }
        return enablePartition ? time / timePartitionInterval : 0L;
    }

    public static boolean isEnablePartition() {
        return enablePartition;
    }

    public static void setEnablePartition(boolean enablePartition) {
        StorageEngineV2.enablePartition = enablePartition;
    }

    public static void blockInsertionIfReject(TsFileProcessor tsFileProcessor) throws WriteProcessRejectException {
        long startTime = System.currentTimeMillis();
        while (SystemInfo.getInstance().isRejected() && (tsFileProcessor == null || !tsFileProcessor.shouldFlush())) {
            try {
                TimeUnit.MILLISECONDS.sleep(config.getCheckPeriodWhenInsertBlocked());
                if (System.currentTimeMillis() - startTime <= (long)config.getMaxWaitingTimeWhenInsertBlocked()) continue;
                throw new WriteProcessRejectException("System rejected over " + (System.currentTimeMillis() - startTime) + "ms");
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    public static TTimePartitionSlot getTimePartitionSlot(long time) {
        TTimePartitionSlot timePartitionSlot = new TTimePartitionSlot();
        if (enablePartition) {
            if (timePartitionInterval == -1L) {
                StorageEngineV2.initTimePartition();
            }
            timePartitionSlot.setStartTime(time - time % timePartitionInterval);
        } else {
            timePartitionSlot.setStartTime(0L);
        }
        return timePartitionSlot;
    }

    public boolean isAllSgReady() {
        return this.isAllSgReady.get();
    }

    public void setAllSgReady(boolean allSgReady) {
        this.isAllSgReady.set(allSgReady);
    }

    public void recover() {
        this.setAllSgReady(false);
        this.recoveryThreadPool = IoTDBThreadPoolFactory.newCachedThreadPool((String)ThreadName.DATA_REGION_RECOVER_SERVICE.getName());
        LinkedList<Future<Void>> futures = new LinkedList<Future<Void>>();
        this.asyncRecover(this.recoveryThreadPool, futures);
        if (!config.isClusterMode() || !config.getDataRegionConsensusProtocolClass().equals("org.apache.iotdb.consensus.ratis.RatisConsensus")) {
            try {
                WALRecoverManager.getInstance().recover();
            }
            catch (WALException e) {
                logger.error("Fail to recover wal.", (Throwable)((Object)e));
            }
        }
        Thread recoverEndTrigger = new Thread(() -> {
            for (Future future : futures) {
                try {
                    future.get();
                }
                catch (ExecutionException e) {
                    throw new StorageEngineFailureException("StorageEngine failed to recover.", e);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new StorageEngineFailureException("StorageEngine failed to recover.", e);
                }
            }
            this.recoveryThreadPool.shutdown();
            this.setAllSgReady(true);
        });
        recoverEndTrigger.start();
    }

    private void asyncRecover(ExecutorService pool, List<Future<Void>> futures) {
        Map<String, List<DataRegionId>> localDataRegionInfo = this.getLocalDataRegionInfo();
        localDataRegionInfo.values().forEach(list -> this.recoverDataRegionNum += list.size());
        this.readyDataRegionNum = new AtomicInteger(0);
        WALRecoverManager.getInstance().setAllDataRegionScannedLatch(new CountDownLatch(this.recoverDataRegionNum));
        for (Map.Entry<String, List<DataRegionId>> entry : localDataRegionInfo.entrySet()) {
            String sgName = entry.getKey();
            for (DataRegionId dataRegionId : entry.getValue()) {
                Callable<Void> recoverDataRegionTask = () -> {
                    DataRegion dataRegion = null;
                    try {
                        dataRegion = this.buildNewDataRegion(sgName, dataRegionId, Long.MAX_VALUE);
                    }
                    catch (DataRegionException e) {
                        logger.error("Failed to recover data region {}[{}]", new Object[]{sgName, dataRegionId.getId(), e});
                    }
                    this.dataRegionMap.put(dataRegionId, dataRegion);
                    logger.info("Data regions have been recovered {}/{}", (Object)this.readyDataRegionNum.incrementAndGet(), (Object)this.recoverDataRegionNum);
                    return null;
                };
                futures.add(pool.submit(recoverDataRegionTask));
            }
        }
    }

    public Map<String, List<DataRegionId>> getLocalDataRegionInfo() {
        File system = SystemFileFactory.INSTANCE.getFile(this.systemDir);
        File[] sgDirs = system.listFiles();
        HashMap<String, List<DataRegionId>> localDataRegionInfo = new HashMap<String, List<DataRegionId>>();
        if (sgDirs == null) {
            return localDataRegionInfo;
        }
        for (File sgDir : sgDirs) {
            if (!sgDir.isDirectory()) continue;
            String sgName = sgDir.getName();
            ArrayList<DataRegionId> dataRegionIdList = new ArrayList<DataRegionId>();
            for (File dataRegionDir : sgDir.listFiles()) {
                if (!dataRegionDir.isDirectory()) continue;
                dataRegionIdList.add(new DataRegionId(Integer.parseInt(dataRegionDir.getName())));
            }
            localDataRegionInfo.put(sgName, dataRegionIdList);
        }
        return localDataRegionInfo;
    }

    public void start() {
        if (!enablePartition) {
            timePartitionInterval = Long.MAX_VALUE;
        } else {
            StorageEngineV2.initTimePartition();
        }
        try {
            FileUtils.forceMkdir((File)SystemFileFactory.INSTANCE.getFile(this.systemDir));
        }
        catch (IOException e) {
            throw new StorageEngineFailureException(e);
        }
        UpgradeUtils.recoverUpgrade();
        this.recover();
        this.ttlCheckThread = IoTDBThreadPoolFactory.newSingleThreadScheduledExecutor((String)"TTL-Check");
        ScheduledExecutorUtil.safelyScheduleAtFixedRate((ScheduledExecutorService)this.ttlCheckThread, this::checkTTL, (long)60000L, (long)60000L, (TimeUnit)TimeUnit.MILLISECONDS);
        logger.info("start ttl check thread successfully.");
        this.startTimedService();
    }

    private void checkTTL() {
        try {
            for (DataRegion dataRegion : this.dataRegionMap.values()) {
                if (dataRegion == null) continue;
                dataRegion.checkFilesTTL();
            }
        }
        catch (ConcurrentModificationException concurrentModificationException) {
        }
        catch (Exception e) {
            logger.error("An error occurred when checking TTL", (Throwable)e);
        }
    }

    private void startTimedService() {
        if (config.isEnableTimedFlushSeqMemtable()) {
            this.seqMemtableTimedFlushCheckThread = IoTDBThreadPoolFactory.newSingleThreadScheduledExecutor((String)ThreadName.TIMED_FlUSH_SEQ_MEMTABLE.getName());
            ScheduledExecutorUtil.safelyScheduleAtFixedRate((ScheduledExecutorService)this.seqMemtableTimedFlushCheckThread, this::timedFlushSeqMemTable, (long)config.getSeqMemtableFlushCheckInterval(), (long)config.getSeqMemtableFlushCheckInterval(), (TimeUnit)TimeUnit.MILLISECONDS);
            logger.info("start sequence memtable timed flush check thread successfully.");
        }
        if (config.isEnableTimedFlushUnseqMemtable()) {
            this.unseqMemtableTimedFlushCheckThread = IoTDBThreadPoolFactory.newSingleThreadScheduledExecutor((String)ThreadName.TIMED_FlUSH_UNSEQ_MEMTABLE.getName());
            ScheduledExecutorUtil.safelyScheduleAtFixedRate((ScheduledExecutorService)this.unseqMemtableTimedFlushCheckThread, this::timedFlushUnseqMemTable, (long)config.getUnseqMemtableFlushCheckInterval(), (long)config.getUnseqMemtableFlushCheckInterval(), (TimeUnit)TimeUnit.MILLISECONDS);
            logger.info("start unsequence memtable timed flush check thread successfully.");
        }
    }

    private void timedFlushSeqMemTable() {
        for (DataRegion dataRegion : this.dataRegionMap.values()) {
            if (dataRegion == null) continue;
            dataRegion.timedFlushSeqMemTable();
        }
    }

    private void timedFlushUnseqMemTable() {
        for (DataRegion dataRegion : this.dataRegionMap.values()) {
            if (dataRegion == null) continue;
            dataRegion.timedFlushUnseqMemTable();
        }
    }

    public void stop() {
        for (DataRegion dataRegion : this.dataRegionMap.values()) {
            if (dataRegion == null) continue;
            ThreadUtils.stopThreadPool(dataRegion.getTimedCompactionScheduleTask(), ThreadName.COMPACTION_SCHEDULE);
        }
        this.syncCloseAllProcessor();
        ThreadUtils.stopThreadPool(this.ttlCheckThread, ThreadName.TTL_CHECK_SERVICE);
        ThreadUtils.stopThreadPool(this.seqMemtableTimedFlushCheckThread, ThreadName.TIMED_FlUSH_SEQ_MEMTABLE);
        ThreadUtils.stopThreadPool(this.unseqMemtableTimedFlushCheckThread, ThreadName.TIMED_FlUSH_UNSEQ_MEMTABLE);
        this.recoveryThreadPool.shutdownNow();
        this.dataRegionMap.clear();
    }

    public void shutdown(long milliseconds) throws ShutdownException {
        try {
            for (DataRegion dataRegion : this.dataRegionMap.values()) {
                ThreadUtils.stopThreadPool(dataRegion.getTimedCompactionScheduleTask(), ThreadName.COMPACTION_SCHEDULE);
            }
            this.forceCloseAllProcessor();
        }
        catch (TsFileProcessorException e) {
            throw new ShutdownException((Throwable)((Object)e));
        }
        this.shutdownTimedService(this.ttlCheckThread, "TTlCheckThread");
        this.shutdownTimedService(this.seqMemtableTimedFlushCheckThread, "SeqMemtableTimedFlushCheckThread");
        this.shutdownTimedService(this.unseqMemtableTimedFlushCheckThread, "UnseqMemtableTimedFlushCheckThread");
        this.recoveryThreadPool.shutdownNow();
        this.dataRegionMap.clear();
    }

    private void shutdownTimedService(ScheduledExecutorService pool, String poolName) {
        if (pool != null) {
            pool.shutdownNow();
            try {
                pool.awaitTermination(30L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                logger.warn("{} still doesn't exit after 30s", (Object)poolName);
                Thread.currentThread().interrupt();
            }
        }
    }

    private void stopTimedServiceAndThrow(ScheduledExecutorService pool, String poolName) throws ShutdownException {
        if (pool != null) {
            pool.shutdownNow();
            try {
                pool.awaitTermination(30L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                logger.warn("{} still doesn't exit after 30s", (Object)poolName);
                throw new ShutdownException((Throwable)e);
            }
        }
    }

    public ServiceType getID() {
        return ServiceType.STORAGE_ENGINE_SERVICE;
    }

    public DataRegion buildNewDataRegion(String logicalStorageGroupName, DataRegionId dataRegionId, long ttl) throws DataRegionException {
        logger.info("construct a data region instance, the storage group is {}, Thread is {}", (Object)logicalStorageGroupName, (Object)Thread.currentThread().getId());
        DataRegion dataRegion = new DataRegion(this.systemDir + File.separator + logicalStorageGroupName, String.valueOf(dataRegionId.getId()), this.fileFlushPolicy, logicalStorageGroupName);
        dataRegion.setDataTTL(ttl);
        dataRegion.setCustomFlushListeners(this.customFlushListeners);
        dataRegion.setCustomCloseFileListeners(this.customCloseFileListeners);
        return dataRegion;
    }

    public TSStatus write(DataRegionId groupId, PlanNode planNode) {
        return planNode.accept(new DataExecutionVisitor(), this.dataRegionMap.get(groupId));
    }

    public synchronized void reset() {
        this.dataRegionMap.clear();
    }

    public void syncCloseAllProcessor() {
        logger.info("Start closing all storage group processor");
        for (DataRegion dataRegion : this.dataRegionMap.values()) {
            if (dataRegion == null) continue;
            dataRegion.syncCloseAllWorkingTsFileProcessors();
        }
    }

    public void forceCloseAllProcessor() throws TsFileProcessorException {
        logger.info("Start force closing all storage group processor");
        for (DataRegion dataRegion : this.dataRegionMap.values()) {
            if (dataRegion == null) continue;
            dataRegion.forceCloseAllWorkingTsFileProcessors();
        }
    }

    public void closeStorageGroupProcessor(String storageGroupPath, boolean isSeq) {
        for (DataRegion dataRegion : this.dataRegionMap.values()) {
            if (!dataRegion.getStorageGroupName().equals(storageGroupPath)) continue;
            if (isSeq) {
                for (TsFileProcessor tsFileProcessor : dataRegion.getWorkSequenceTsFileProcessors()) {
                    dataRegion.syncCloseOneTsFileProcessor(isSeq, tsFileProcessor);
                }
                continue;
            }
            for (TsFileProcessor tsFileProcessor : dataRegion.getWorkUnsequenceTsFileProcessors()) {
                dataRegion.syncCloseOneTsFileProcessor(isSeq, tsFileProcessor);
            }
        }
    }

    public void mergeAll() throws StorageEngineException {
        if (CommonDescriptor.getInstance().getConfig().isReadOnly()) {
            throw new StorageEngineException("Current system mode is read only, does not support merge");
        }
        this.dataRegionMap.values().forEach(DataRegion::compact);
    }

    public TSStatus operateFlush(TFlushReq req) {
        if (req.storageGroups == null) {
            StorageEngineV2.getInstance().syncCloseAllProcessor();
            WALManager.getInstance().deleteOutdatedWALFiles();
        } else {
            for (String storageGroup : req.storageGroups) {
                if (req.isSeq == null) {
                    StorageEngineV2.getInstance().closeStorageGroupProcessor(storageGroup, true);
                    StorageEngineV2.getInstance().closeStorageGroupProcessor(storageGroup, false);
                    continue;
                }
                StorageEngineV2.getInstance().closeStorageGroupProcessor(storageGroup, Boolean.parseBoolean(req.isSeq));
            }
        }
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    public void setTTL(List<DataRegionId> dataRegionIdList, long dataTTL) {
        for (DataRegionId dataRegionId : dataRegionIdList) {
            DataRegion dataRegion = this.dataRegionMap.get(dataRegionId);
            if (dataRegion == null) continue;
            dataRegion.setDataTTL(dataTTL);
        }
    }

    public void registerFlushListener(FlushListener listener) {
        this.customFlushListeners.add(listener);
    }

    public void registerCloseFileListener(CloseFileListener listener) {
        this.customCloseFileListeners.add(listener);
    }

    private void makeSureNoOldRegion(DataRegionId regionId) {
        while (this.deletingDataRegionMap.containsKey(regionId)) {
            DataRegion oldRegion = this.deletingDataRegionMap.get(regionId);
            if (oldRegion == null) continue;
            oldRegion.waitForDeleted();
        }
    }

    public DataRegion createDataRegion(DataRegionId regionId, String sg, long ttl) throws DataRegionException {
        this.makeSureNoOldRegion(regionId);
        AtomicReference<Object> exceptionAtomicReference = new AtomicReference<Object>(null);
        DataRegion dataRegion = this.dataRegionMap.computeIfAbsent(regionId, x -> {
            try {
                return this.buildNewDataRegion(sg, (DataRegionId)x, ttl);
            }
            catch (DataRegionException e) {
                exceptionAtomicReference.set(e);
                return null;
            }
        });
        if (exceptionAtomicReference.get() != null) {
            throw (DataRegionException)exceptionAtomicReference.get();
        }
        return dataRegion;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deleteDataRegion(DataRegionId regionId) {
        if (!this.dataRegionMap.containsKey(regionId) || this.deletingDataRegionMap.containsKey(regionId)) {
            return;
        }
        DataRegion region = this.deletingDataRegionMap.computeIfAbsent(regionId, k -> this.dataRegionMap.remove(regionId));
        if (region != null) {
            try {
                region.abortCompaction();
                region.syncDeleteDataFiles();
                region.deleteFolder(this.systemDir);
                if (config.isClusterMode() && config.getDataRegionConsensusProtocolClass().equals("org.apache.iotdb.consensus.multileader.MultiLeaderConsensus")) {
                    WALManager.getInstance().deleteWALNode(region.getStorageGroupName() + "-" + region.getDataRegionId());
                }
                SyncService.getInstance().deleteSyncManager(region.getDataRegionId());
            }
            catch (Exception e) {
                logger.error("Error occurs when deleting data region {}-{}", new Object[]{region.getStorageGroupName(), region.getDataRegionId(), e});
            }
            finally {
                this.deletingDataRegionMap.remove(regionId);
                region.markDeleted();
            }
        }
    }

    public DataRegion getDataRegion(DataRegionId regionId) {
        return this.dataRegionMap.get(regionId);
    }

    public List<DataRegion> getAllDataRegions() {
        return new ArrayList<DataRegion>(this.dataRegionMap.values());
    }

    public List<DataRegionId> getAllDataRegionIds() {
        return new ArrayList<DataRegionId>(this.dataRegionMap.keySet());
    }

    public void setDataRegion(DataRegionId regionId, DataRegion newRegion) {
        if (this.dataRegionMap.containsKey(regionId)) {
            DataRegion oldRegion = this.dataRegionMap.get(regionId);
            oldRegion.syncCloseAllWorkingTsFileProcessors();
            oldRegion.abortCompaction();
        }
        this.dataRegionMap.put(regionId, newRegion);
    }

    public TSStatus setTTL(TSetTTLReq req) {
        Map<String, List<DataRegionId>> localDataRegionInfo = StorageEngineV2.getInstance().getLocalDataRegionInfo();
        ArrayList dataRegionIdList = new ArrayList();
        req.storageGroupPathPattern.forEach(storageGroup -> dataRegionIdList.addAll((Collection)localDataRegionInfo.get(storageGroup)));
        for (DataRegionId dataRegionId : dataRegionIdList) {
            DataRegion dataRegion = this.dataRegionMap.get(dataRegionId);
            if (dataRegion == null) continue;
            dataRegion.setDataTTL(req.TTL);
        }
        return RpcUtils.getStatus((TSStatusCode)TSStatusCode.SUCCESS_STATUS);
    }

    public TsFileFlushPolicy getFileFlushPolicy() {
        return this.fileFlushPolicy;
    }

    static class InstanceHolder {
        private static final StorageEngineV2 INSTANCE = new StorageEngineV2();

        private InstanceHolder() {
        }
    }
}

