/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.cross.rewrite;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.engine.storagegroup.TsFileResourceStatus;

public class CrossSpaceCompactionResource {
    private List<TsFileResource> seqFiles;
    private List<TsFileResource> unseqFiles = new ArrayList<TsFileResource>();
    private long ttlLowerBound = Long.MIN_VALUE;

    public CrossSpaceCompactionResource(List<TsFileResource> seqFiles, List<TsFileResource> unseqFiles) {
        this.seqFiles = seqFiles.stream().filter(this::filterSeqResource).collect(Collectors.toList());
        this.filterUnseqResource(unseqFiles);
    }

    private boolean filterSeqResource(TsFileResource res) {
        return !res.isDeleted() && res.stillLives(this.ttlLowerBound);
    }

    private void filterUnseqResource(List<TsFileResource> unseqResources) {
        for (TsFileResource resource : unseqResources) {
            if (resource.getStatus() != TsFileResourceStatus.CLOSED) {
                return;
            }
            if (resource.isDeleted() || !resource.stillLives(this.ttlLowerBound)) continue;
            this.unseqFiles.add(resource);
        }
    }

    public CrossSpaceCompactionResource(Collection<TsFileResource> seqFiles, List<TsFileResource> unseqFiles, long ttlLowerBound) {
        this.ttlLowerBound = ttlLowerBound;
        this.seqFiles = seqFiles.stream().filter(this::filterSeqResource).collect(Collectors.toList());
        this.filterUnseqResource(unseqFiles);
    }

    public List<TsFileResource> getSeqFiles() {
        return this.seqFiles;
    }

    public List<TsFileResource> getUnseqFiles() {
        return this.unseqFiles;
    }
}

