/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.reader;

import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.engine.compaction.reader.IDataBlockReader;
import org.apache.iotdb.db.engine.querycontext.QueryDataSource;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.metadata.path.AlignedPath;
import org.apache.iotdb.db.metadata.path.MeasurementPath;
import org.apache.iotdb.db.mpp.execution.fragment.FragmentInstanceContext;
import org.apache.iotdb.db.mpp.execution.operator.source.AlignedSeriesScanUtil;
import org.apache.iotdb.db.mpp.execution.operator.source.SeriesScanUtil;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;

public class SeriesDataBlockReader
implements IDataBlockReader {
    private final SeriesScanUtil seriesScanUtil;
    private TsBlock tsBlock;
    private boolean hasCachedBatchData = false;

    public SeriesDataBlockReader(PartialPath seriesPath, Set<String> allSensors, TSDataType dataType, FragmentInstanceContext context, QueryDataSource dataSource, boolean ascending) {
        if (seriesPath instanceof AlignedPath) {
            this.seriesScanUtil = new AlignedSeriesScanUtil(seriesPath, allSensors, context, null, null, ascending);
        } else if (seriesPath instanceof MeasurementPath) {
            this.seriesScanUtil = new SeriesScanUtil(seriesPath, allSensors, dataType, context, null, null, ascending);
        } else {
            throw new IllegalArgumentException("Should call exact sub class!");
        }
        this.seriesScanUtil.initQueryDataSource(dataSource);
    }

    public SeriesDataBlockReader(PartialPath seriesPath, TSDataType dataType, FragmentInstanceContext context, List<TsFileResource> seqFileResource, List<TsFileResource> unseqFileResource, boolean ascending) {
        HashSet<String> allSensors = new HashSet<String>();
        if (seriesPath instanceof AlignedPath) {
            this.seriesScanUtil = new AlignedSeriesScanUtil(seriesPath, allSensors, context, null, null, ascending);
        } else {
            allSensors.add(seriesPath.getMeasurement());
            this.seriesScanUtil = new SeriesScanUtil(seriesPath, allSensors, dataType, context, null, null, ascending);
        }
        this.seriesScanUtil.initQueryDataSource(seqFileResource, unseqFileResource);
    }

    @Override
    public boolean hasNextBatch() throws IOException {
        if (this.hasCachedBatchData) {
            return true;
        }
        if (this.readPageData()) {
            this.hasCachedBatchData = true;
            return true;
        }
        if (this.readChunkData()) {
            this.hasCachedBatchData = true;
            return true;
        }
        while (this.seriesScanUtil.hasNextFile()) {
            if (!this.readChunkData()) continue;
            this.hasCachedBatchData = true;
            return true;
        }
        return this.hasCachedBatchData;
    }

    @Override
    public TsBlock nextBatch() throws IOException {
        if (this.hasCachedBatchData || this.hasNextBatch()) {
            this.hasCachedBatchData = false;
            return this.tsBlock;
        }
        throw new IOException("no next block");
    }

    @Override
    public void close() throws IOException {
    }

    private boolean readChunkData() throws IOException {
        while (this.seriesScanUtil.hasNextChunk()) {
            if (!this.readPageData()) continue;
            return true;
        }
        return false;
    }

    private boolean readPageData() throws IOException {
        while (this.seriesScanUtil.hasNextPage()) {
            this.tsBlock = this.seriesScanUtil.nextPage();
            if (this.isEmpty(this.tsBlock)) continue;
            return true;
        }
        return false;
    }

    private boolean isEmpty(TsBlock tsBlock) {
        return tsBlock == null || tsBlock.isEmpty();
    }
}

