/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction.writer;

import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.db.engine.compaction.writer.AbstractCompactionWriter;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.query.control.FileReaderManager;
import org.apache.iotdb.tsfile.file.metadata.TimeseriesMetadata;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.TimeColumn;
import org.apache.iotdb.tsfile.write.chunk.AlignedChunkWriterImpl;
import org.apache.iotdb.tsfile.write.writer.TsFileIOWriter;

public class CrossSpaceCompactionWriter
extends AbstractCompactionWriter {
    private List<TsFileIOWriter> fileWriterList = new ArrayList<TsFileIOWriter>();
    private List<TsFileResource> seqTsFileResources;
    private int[] seqFileIndexArray = new int[subTaskNum];
    private final long[] currentDeviceEndTime;
    private final boolean[] isEmptyFile;
    private final boolean[] isDeviceExistedInTargetFiles;
    private int chunkGroupHeaderSize;

    public CrossSpaceCompactionWriter(List<TsFileResource> targetResources, List<TsFileResource> seqFileResources) throws IOException {
        this.currentDeviceEndTime = new long[seqFileResources.size()];
        this.isEmptyFile = new boolean[seqFileResources.size()];
        this.isDeviceExistedInTargetFiles = new boolean[targetResources.size()];
        for (int i = 0; i < targetResources.size(); ++i) {
            this.fileWriterList.add(new TsFileIOWriter(targetResources.get(i).getTsFile()));
            this.isEmptyFile[i] = true;
        }
        this.seqTsFileResources = seqFileResources;
    }

    @Override
    public void startChunkGroup(String deviceId, boolean isAlign) throws IOException {
        this.deviceId = deviceId;
        this.isAlign = isAlign;
        this.seqFileIndexArray = new int[subTaskNum];
        this.checkIsDeviceExistAndGetDeviceEndTime();
        for (int i = 0; i < this.fileWriterList.size(); ++i) {
            this.chunkGroupHeaderSize = this.fileWriterList.get(i).startChunkGroup(deviceId);
        }
    }

    @Override
    public void endChunkGroup() throws IOException {
        for (int i = 0; i < this.seqTsFileResources.size(); ++i) {
            TsFileIOWriter targetFileWriter = this.fileWriterList.get(i);
            if (this.isDeviceExistedInTargetFiles[i]) {
                targetFileWriter.endChunkGroup();
            } else {
                targetFileWriter.truncate(targetFileWriter.getPos() - (long)this.chunkGroupHeaderSize);
            }
            this.isDeviceExistedInTargetFiles[i] = false;
        }
        this.deviceId = null;
    }

    @Override
    public void endMeasurement(int subTaskId) throws IOException {
        this.flushChunkToFileWriter(this.fileWriterList.get(this.seqFileIndexArray[subTaskId]), subTaskId);
        this.seqFileIndexArray[subTaskId] = 0;
    }

    @Override
    public void write(long timestamp, Object value, int subTaskId) throws IOException {
        this.checkTimeAndMayFlushChunkToCurrentFile(timestamp, subTaskId);
        this.writeDataPoint(timestamp, value, subTaskId);
        if (this.measurementPointCountArray[subTaskId] % 10 == 0) {
            this.checkChunkSizeAndMayOpenANewChunk(this.fileWriterList.get(this.seqFileIndexArray[subTaskId]), subTaskId);
        }
        this.isDeviceExistedInTargetFiles[this.seqFileIndexArray[subTaskId]] = true;
        this.isEmptyFile[this.seqFileIndexArray[subTaskId]] = false;
    }

    @Override
    public void write(TimeColumn timestamps, Column[] columns, int subTaskId, int batchSize) throws IOException {
        this.checkTimeAndMayFlushChunkToCurrentFile(timestamps.getStartTime(), subTaskId);
        AlignedChunkWriterImpl chunkWriter = (AlignedChunkWriterImpl)this.chunkWriters[subTaskId];
        chunkWriter.write(timestamps, columns, batchSize);
        this.checkChunkSizeAndMayOpenANewChunk(this.fileWriterList.get(this.seqFileIndexArray[subTaskId]), subTaskId);
        this.isDeviceExistedInTargetFiles[this.seqFileIndexArray[subTaskId]] = true;
        this.isEmptyFile[this.seqFileIndexArray[subTaskId]] = false;
    }

    @Override
    public void endFile() throws IOException {
        for (int i = 0; i < this.isEmptyFile.length; ++i) {
            this.fileWriterList.get(i).endFile();
            if (!this.isEmptyFile[i]) continue;
            this.fileWriterList.get(i).getFile().delete();
        }
    }

    @Override
    public void close() throws IOException {
        for (TsFileIOWriter targetWriter : this.fileWriterList) {
            if (targetWriter == null || !targetWriter.canWrite()) continue;
            targetWriter.close();
        }
        this.fileWriterList = null;
        this.seqTsFileResources = null;
    }

    @Override
    public List<TsFileIOWriter> getFileIOWriter() {
        return this.fileWriterList;
    }

    private void checkTimeAndMayFlushChunkToCurrentFile(long timestamp, int subTaskId) throws IOException {
        int fileIndex = this.seqFileIndexArray[subTaskId];
        while (timestamp > this.currentDeviceEndTime[fileIndex]) {
            if (fileIndex != this.seqTsFileResources.size() - 1) {
                this.flushChunkToFileWriter(this.fileWriterList.get(fileIndex), subTaskId);
                this.seqFileIndexArray[subTaskId] = ++fileIndex;
                continue;
            }
            return;
        }
    }

    private void checkIsDeviceExistAndGetDeviceEndTime() throws IOException {
        for (int fileIndex = 0; fileIndex < this.seqTsFileResources.size(); ++fileIndex) {
            if (this.seqTsFileResources.get(fileIndex).getTimeIndexType() == 1) {
                this.currentDeviceEndTime[fileIndex] = this.seqTsFileResources.get(fileIndex).getEndTime(this.deviceId);
                continue;
            }
            long endTime = Long.MIN_VALUE;
            Map deviceMetadataMap = FileReaderManager.getInstance().get(this.seqTsFileResources.get(fileIndex).getTsFilePath(), true).readDeviceMetadata(this.deviceId);
            for (Map.Entry entry : deviceMetadataMap.entrySet()) {
                long tmpStartTime = ((TimeseriesMetadata)entry.getValue()).getStatistics().getStartTime();
                long tmpEndTime = ((TimeseriesMetadata)entry.getValue()).getStatistics().getEndTime();
                if (tmpEndTime < tmpStartTime || endTime >= tmpEndTime) continue;
                endTime = tmpEndTime;
            }
            this.currentDeviceEndTime[fileIndex] = endTime;
        }
    }
}

