/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.storagegroup;

import java.util.List;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.storagegroup.DataRegion;
import org.apache.iotdb.db.engine.storagegroup.TsFileProcessor;
import org.apache.iotdb.db.rescon.SystemInfo;

public class StorageGroupInfo {
    private DataRegion dataRegion;
    private AtomicLong memoryCost;
    private long storageGroupSizeReportThreshold = IoTDBDescriptor.getInstance().getConfig().getStorageGroupSizeReportThreshold();
    private AtomicLong lastReportedSize = new AtomicLong();
    private List<TsFileProcessor> reportedTsps = new CopyOnWriteArrayList<TsFileProcessor>();

    public StorageGroupInfo(DataRegion dataRegion) {
        this.dataRegion = dataRegion;
        this.memoryCost = new AtomicLong();
    }

    public DataRegion getDataRegion() {
        return this.dataRegion;
    }

    public void initTsFileProcessorInfo(TsFileProcessor tsFileProcessor) {
        this.reportedTsps.add(tsFileProcessor);
    }

    public void addStorageGroupMemCost(long cost) {
        this.memoryCost.getAndAdd(cost);
    }

    public void releaseStorageGroupMemCost(long cost) {
        this.memoryCost.getAndAdd(-cost);
    }

    public long getMemCost() {
        return this.memoryCost.get();
    }

    public List<TsFileProcessor> getAllReportedTsp() {
        return this.reportedTsps;
    }

    public boolean needToReportToSystem() {
        return this.memoryCost.get() - this.lastReportedSize.get() > this.storageGroupSizeReportThreshold;
    }

    public void setLastReportedSize(long size) {
        this.lastReportedSize.set(size);
    }

    public void closeTsFileProcessorAndReportToSystem(TsFileProcessor tsFileProcessor) {
        this.reportedTsps.remove(tsFileProcessor);
        SystemInfo.getInstance().resetStorageGroupStatus(this);
    }
}

