/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.storagegroup;

import org.apache.iotdb.db.engine.storagegroup.StorageGroupInfo;
import org.apache.iotdb.db.service.metrics.MetricService;
import org.apache.iotdb.db.service.metrics.enums.Metric;
import org.apache.iotdb.db.service.metrics.enums.Tag;
import org.apache.iotdb.metrics.utils.MetricLevel;

public class TsFileProcessorInfo {
    private StorageGroupInfo storageGroupInfo;
    private long memCost;

    public TsFileProcessorInfo(StorageGroupInfo storageGroupInfo) {
        this.storageGroupInfo = storageGroupInfo;
        this.memCost = 0L;
    }

    public void addTSPMemCost(long cost) {
        this.memCost += cost;
        this.storageGroupInfo.addStorageGroupMemCost(cost);
        if (null != this.storageGroupInfo.getDataRegion()) {
            MetricService.getInstance().getOrCreateGauge(Metric.MEM.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), "chunkMetaData_" + this.storageGroupInfo.getDataRegion().getStorageGroupName()}).incr(cost);
        }
    }

    public void releaseTSPMemCost(long cost) {
        this.storageGroupInfo.releaseStorageGroupMemCost(cost);
        this.memCost -= cost;
        MetricService.getInstance().getOrCreateGauge(Metric.MEM.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), "chunkMetaData_" + this.storageGroupInfo.getDataRegion().getStorageGroupName()}).decr(cost);
    }

    public void clear() {
        this.storageGroupInfo.releaseStorageGroupMemCost(this.memCost);
        MetricService.getInstance().getOrCreateGauge(Metric.MEM.toString(), MetricLevel.IMPORTANT, new String[]{Tag.NAME.toString(), "chunkMetaData_" + this.storageGroupInfo.getDataRegion().getStorageGroupName()}).decr(this.memCost);
        this.memCost = 0L;
    }
}

