/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata;

import org.apache.iotdb.commons.path.PartialPath;

public class MetadataConstant {
    public static final String MTREE_PREFIX = "mtree";
    private static final String MTREE_VERSION = "1";
    public static final String MTREE_TXT_SNAPSHOT_OLD_VERSION = "mtree-1.snapshot";
    public static final String MTREE_SNAPSHOT_OLD_VERSION = "mtree-1.snapshot.bin";
    public static final String MTREE_SNAPSHOT_TMP_OLDVERSION = "mtree-1.snapshot.bin.tmp";
    public static final String ROOT = "root";
    public static final String METADATA_TXT_LOG = "mlog.txt";
    public static final String METADATA_LOG = "mlog.bin";
    public static final String TAG_LOG = "tlog.txt";
    public static final String TEMPLATE_FILE = "template_log.bin";
    public static final String STORAGE_GROUP_LOG = "storage_group_log.bin";
    public static final String SCHEMA_FILE_NAME = "schema_file.pst";
    public static final String SCHEMA_LOG_FILE_NAME = "schema_file_log.bin";
    public static final String METADATA_LOG_SNAPSHOT = "mlog.bin.snapshot";
    public static final String METADATA_LOG_SNAPSHOT_TMP = "mlog.bin.snapshot.tmp";
    public static final String TAG_LOG_SNAPSHOT = "tlog.txt.snapshot";
    public static final String TAG_LOG_SNAPSHOT_TMP = "tlog.txt.snapshot.tmp";
    public static final String MTREE_SNAPSHOT = "mtree.snapshot";
    public static final String MTREE_SNAPSHOT_TMP = "mtree.snapshot.tmp";
    public static final String[] ALL_RESULT_NODES = new String[]{"root", "**"};
    public static final PartialPath ALL_MATCH_PATTERN = new PartialPath(new String[]{"root", "**"});
    public static final int NON_TEMPLATE = -1;
    public static final int ALL_TEMPLATE = -2;
    public static final byte INTERNAL_MNODE_TYPE = 0;
    public static final byte STORAGE_GROUP_MNODE_TYPE = 1;
    public static final byte MEASUREMENT_MNODE_TYPE = 2;
    public static final byte ENTITY_MNODE_TYPE = 3;
    public static final byte STORAGE_GROUP_ENTITY_MNODE_TYPE = 4;
    public static final String INTERNAL_MNODE_TYPE_NAME = "InternalMNode";
    public static final String STORAGE_GROUP_MNODE_TYPE_NAME = "StorageGroupMNode";
    public static final String MEASUREMENT_MNODE_TYPE_NAME = "MeasurementMNode";
    public static final String ENTITY_MNODE_TYPE_NAME = "EntityMNode";
    public static final String STORAGE_GROUP_ENTITY_MNODE_TYPE_NAME = "StorageGroupEntityMNode";

    private MetadataConstant() {
    }

    public static String getMNodeTypeName(byte type) {
        switch (type) {
            case 0: {
                return INTERNAL_MNODE_TYPE_NAME;
            }
            case 1: {
                return STORAGE_GROUP_MNODE_TYPE_NAME;
            }
            case 2: {
                return MEASUREMENT_MNODE_TYPE_NAME;
            }
            case 3: {
                return ENTITY_MNODE_TYPE_NAME;
            }
            case 4: {
                return STORAGE_GROUP_ENTITY_MNODE_TYPE_NAME;
            }
        }
        throw new RuntimeException("Undefined MNode type " + type);
    }
}

