/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.mtree.snapshot;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayDeque;
import java.util.Deque;
import java.util.function.Consumer;
import org.apache.iotdb.commons.file.SystemFileFactory;
import org.apache.iotdb.db.metadata.mnode.EntityMNode;
import org.apache.iotdb.db.metadata.mnode.IMNode;
import org.apache.iotdb.db.metadata.mnode.IMeasurementMNode;
import org.apache.iotdb.db.metadata.mnode.InternalMNode;
import org.apache.iotdb.db.metadata.mnode.MNode;
import org.apache.iotdb.db.metadata.mnode.MeasurementMNode;
import org.apache.iotdb.db.metadata.mnode.StorageGroupEntityMNode;
import org.apache.iotdb.db.metadata.mnode.StorageGroupMNode;
import org.apache.iotdb.db.metadata.mnode.estimator.BasicMNodSizeEstimator;
import org.apache.iotdb.db.metadata.mnode.estimator.IMNodeSizeEstimator;
import org.apache.iotdb.db.metadata.mnode.iterator.IMNodeIterator;
import org.apache.iotdb.db.metadata.mnode.visitor.MNodeVisitor;
import org.apache.iotdb.db.metadata.mtree.store.MemMTreeStore;
import org.apache.iotdb.db.metadata.rescon.MemoryStatistics;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MemMTreeSnapshotUtil {
    private static final Logger logger = LoggerFactory.getLogger(MemMTreeSnapshotUtil.class);
    private static final String SERIALIZE_ERROR_INFO = "Error occurred during serializing MemMTree.";
    private static final String DESERIALIZE_ERROR_INFO = "Error occurred during deserializing MemMTree.";
    private static final byte VERSION = 0;
    private static final MemoryStatistics MEMORY_STATISTICS = MemoryStatistics.getInstance();
    private static final IMNodeSizeEstimator ESTIMATOR = new BasicMNodSizeEstimator();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean createSnapshot(File snapshotDir, MemMTreeStore store) {
        File snapshotTmp = SystemFileFactory.INSTANCE.getFile(snapshotDir, "mtree.snapshot.tmp");
        File snapshot = SystemFileFactory.INSTANCE.getFile(snapshotDir, "mtree.snapshot");
        try {
            try (BufferedOutputStream outputStream = new BufferedOutputStream(new FileOutputStream(snapshotTmp));){
                MemMTreeSnapshotUtil.serializeTo(store, outputStream);
            }
            if (snapshot.exists() && !snapshot.delete()) {
                logger.error("Failed to delete old snapshot {} while creating mtree snapshot.", (Object)snapshot.getName());
                boolean outputStream = false;
                return outputStream;
            }
            if (!snapshotTmp.renameTo(snapshot)) {
                logger.error("Failed to rename {} to {} while creating mtree snapshot.", (Object)snapshotTmp.getName(), (Object)snapshot.getName());
                snapshot.delete();
                boolean outputStream = false;
                return outputStream;
            }
            boolean outputStream = true;
            return outputStream;
        }
        catch (IOException e) {
            logger.error("Failed to create mtree snapshot due to {}", (Object)e.getMessage(), (Object)e);
            snapshot.delete();
            boolean bl = false;
            return bl;
        }
        finally {
            snapshotTmp.delete();
        }
    }

    public static IMNode loadSnapshot(File snapshotDir, Consumer<IMeasurementMNode> measurementProcess) throws IOException {
        IMNode iMNode;
        File snapshot = SystemFileFactory.INSTANCE.getFile(snapshotDir, "mtree.snapshot");
        BufferedInputStream inputStream = new BufferedInputStream(new FileInputStream(snapshot));
        try {
            iMNode = MemMTreeSnapshotUtil.deserializeFrom(inputStream, measurementProcess);
        }
        catch (Throwable throwable) {
            try {
                try {
                    inputStream.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (Throwable e) {
                MEMORY_STATISTICS.clear();
                throw e;
            }
        }
        inputStream.close();
        return iMNode;
    }

    private static void serializeTo(MemMTreeStore store, OutputStream outputStream) throws IOException {
        ReadWriteIOUtils.write((byte)0, (OutputStream)outputStream);
        MemMTreeSnapshotUtil.inorderSerialize(store.getRoot(), store, outputStream);
    }

    private static void inorderSerialize(IMNode root, MemMTreeStore store, OutputStream outputStream) throws IOException {
        MNodeSerializer serializer = new MNodeSerializer();
        if (!root.accept(serializer, outputStream).booleanValue()) {
            throw new IOException(SERIALIZE_ERROR_INFO);
        }
        ArrayDeque<IMNodeIterator> stack = new ArrayDeque<IMNodeIterator>();
        stack.push(store.getChildrenIterator(root));
        while (!stack.isEmpty()) {
            IMNodeIterator iterator = (IMNodeIterator)stack.peek();
            if (iterator.hasNext()) {
                IMNode node = (IMNode)iterator.next();
                if (!node.accept(serializer, outputStream).booleanValue()) {
                    throw new IOException(SERIALIZE_ERROR_INFO);
                }
                if (node.isMeasurement()) continue;
                stack.push(store.getChildrenIterator(node));
                continue;
            }
            stack.pop();
        }
    }

    private static IMNode deserializeFrom(InputStream inputStream, Consumer<IMeasurementMNode> measurementProcess) throws IOException {
        byte version = ReadWriteIOUtils.readByte((InputStream)inputStream);
        return MemMTreeSnapshotUtil.inorderDeserialize(inputStream, measurementProcess);
    }

    private static IMNode inorderDeserialize(InputStream inputStream, Consumer<IMeasurementMNode> measurementProcess) throws IOException {
        MNodeDeserializer deserializer = new MNodeDeserializer();
        ArrayDeque<IMNode> ancestors = new ArrayDeque<IMNode>();
        ArrayDeque<Integer> restChildrenNum = new ArrayDeque<Integer>();
        MemMTreeSnapshotUtil.deserializeMNode(ancestors, restChildrenNum, deserializer, inputStream, measurementProcess);
        IMNode root = (IMNode)ancestors.peek();
        while (!ancestors.isEmpty()) {
            int childrenNum = (Integer)restChildrenNum.pop();
            if (childrenNum == 0) {
                ancestors.pop();
                continue;
            }
            restChildrenNum.push(childrenNum - 1);
            MemMTreeSnapshotUtil.deserializeMNode(ancestors, restChildrenNum, deserializer, inputStream, measurementProcess);
        }
        return root;
    }

    private static void deserializeMNode(Deque<IMNode> ancestors, Deque<Integer> restChildrenNum, MNodeDeserializer deserializer, InputStream inputStream, Consumer<IMeasurementMNode> measurementProcess) throws IOException {
        MNode node;
        int childrenNum;
        byte type = ReadWriteIOUtils.readByte((InputStream)inputStream);
        switch (type) {
            case 0: {
                childrenNum = ReadWriteIOUtils.readInt((InputStream)inputStream);
                node = deserializer.deserializeInternalMNode(inputStream);
                break;
            }
            case 1: {
                childrenNum = ReadWriteIOUtils.readInt((InputStream)inputStream);
                node = deserializer.deserializeStorageGroupMNode(inputStream);
                break;
            }
            case 3: {
                childrenNum = ReadWriteIOUtils.readInt((InputStream)inputStream);
                node = deserializer.deserializeEntityMNode(inputStream);
                break;
            }
            case 4: {
                childrenNum = ReadWriteIOUtils.readInt((InputStream)inputStream);
                node = deserializer.deserializeStorageGroupEntityMNode(inputStream);
                break;
            }
            case 2: {
                childrenNum = 0;
                node = deserializer.deserializeMeasurementMNode(inputStream);
                measurementProcess.accept(node.getAsMeasurementMNode());
                break;
            }
            default: {
                throw new IOException("Unrecognized MNode type " + type);
            }
        }
        MEMORY_STATISTICS.requestMemory(ESTIMATOR.estimateSize(node));
        if (!ancestors.isEmpty()) {
            node.setParent(ancestors.peek());
            ancestors.peek().addChild(node);
        }
        if (childrenNum > 0) {
            ancestors.push(node);
            restChildrenNum.push(childrenNum);
        }
    }

    private static class MNodeDeserializer {
        private MNodeDeserializer() {
        }

        public InternalMNode deserializeInternalMNode(InputStream inputStream) throws IOException {
            String name = ReadWriteIOUtils.readString((InputStream)inputStream);
            InternalMNode node = new InternalMNode(null, name);
            this.deserializeInternalBasicInfo(node, inputStream);
            return node;
        }

        public StorageGroupMNode deserializeStorageGroupMNode(InputStream inputStream) throws IOException {
            String name = ReadWriteIOUtils.readString((InputStream)inputStream);
            StorageGroupMNode node = new StorageGroupMNode(null, name);
            this.deserializeInternalBasicInfo(node, inputStream);
            return node;
        }

        public StorageGroupEntityMNode deserializeStorageGroupEntityMNode(InputStream inputStream) throws IOException {
            String name = ReadWriteIOUtils.readString((InputStream)inputStream);
            StorageGroupEntityMNode node = new StorageGroupEntityMNode(null, name, 0L);
            this.deserializeInternalBasicInfo(node, inputStream);
            node.setAligned(ReadWriteIOUtils.readBool((InputStream)inputStream));
            return node;
        }

        public EntityMNode deserializeEntityMNode(InputStream inputStream) throws IOException {
            String name = ReadWriteIOUtils.readString((InputStream)inputStream);
            EntityMNode node = new EntityMNode(null, name);
            this.deserializeInternalBasicInfo(node, inputStream);
            node.setAligned(ReadWriteIOUtils.readBool((InputStream)inputStream));
            return node;
        }

        public MeasurementMNode deserializeMeasurementMNode(InputStream inputStream) throws IOException {
            String name = ReadWriteIOUtils.readString((InputStream)inputStream);
            MeasurementSchema schema = MeasurementSchema.deserializeFrom((InputStream)inputStream);
            String alias = ReadWriteIOUtils.readString((InputStream)inputStream);
            long tagOffset = ReadWriteIOUtils.readLong((InputStream)inputStream);
            MeasurementMNode node = new MeasurementMNode(null, name, (IMeasurementSchema)schema, alias);
            node.setOffset(tagOffset);
            return node;
        }

        private void deserializeInternalBasicInfo(InternalMNode node, InputStream inputStream) throws IOException {
            int templateId = ReadWriteIOUtils.readInt((InputStream)inputStream);
            node.setUseTemplate(ReadWriteIOUtils.readBool((InputStream)inputStream));
        }
    }

    private static class MNodeSerializer
    extends MNodeVisitor<Boolean, OutputStream> {
        private MNodeSerializer() {
        }

        @Override
        public Boolean visitInternalMNode(InternalMNode node, OutputStream outputStream) {
            try {
                ReadWriteIOUtils.write((byte)0, (OutputStream)outputStream);
                this.serializeInternalBasicInfo(node, outputStream);
                return true;
            }
            catch (IOException e) {
                logger.error(MemMTreeSnapshotUtil.SERIALIZE_ERROR_INFO, (Throwable)e);
                return false;
            }
        }

        @Override
        public Boolean visitStorageGroupMNode(StorageGroupMNode node, OutputStream outputStream) {
            try {
                ReadWriteIOUtils.write((byte)1, (OutputStream)outputStream);
                this.serializeInternalBasicInfo(node, outputStream);
                return true;
            }
            catch (IOException e) {
                logger.error(MemMTreeSnapshotUtil.SERIALIZE_ERROR_INFO, (Throwable)e);
                return false;
            }
        }

        @Override
        public Boolean visitStorageGroupEntityMNode(StorageGroupEntityMNode node, OutputStream outputStream) {
            try {
                ReadWriteIOUtils.write((byte)4, (OutputStream)outputStream);
                this.serializeInternalBasicInfo(node, outputStream);
                ReadWriteIOUtils.write((Boolean)node.isAligned(), (OutputStream)outputStream);
                return true;
            }
            catch (IOException e) {
                logger.error(MemMTreeSnapshotUtil.SERIALIZE_ERROR_INFO, (Throwable)e);
                return false;
            }
        }

        @Override
        public Boolean visitEntityMNode(EntityMNode node, OutputStream outputStream) {
            try {
                ReadWriteIOUtils.write((byte)3, (OutputStream)outputStream);
                this.serializeInternalBasicInfo(node, outputStream);
                ReadWriteIOUtils.write((Boolean)node.isAligned(), (OutputStream)outputStream);
                return true;
            }
            catch (IOException e) {
                logger.error(MemMTreeSnapshotUtil.SERIALIZE_ERROR_INFO, (Throwable)e);
                return false;
            }
        }

        @Override
        public Boolean visitMeasurementMNode(MeasurementMNode node, OutputStream outputStream) {
            try {
                ReadWriteIOUtils.write((byte)2, (OutputStream)outputStream);
                ReadWriteIOUtils.write((String)node.getName(), (OutputStream)outputStream);
                node.getSchema().serializeTo(outputStream);
                ReadWriteIOUtils.write((String)node.getAlias(), (OutputStream)outputStream);
                ReadWriteIOUtils.write((long)node.getOffset(), (OutputStream)outputStream);
                return true;
            }
            catch (IOException e) {
                logger.error(MemMTreeSnapshotUtil.SERIALIZE_ERROR_INFO, (Throwable)e);
                return false;
            }
        }

        private void serializeInternalBasicInfo(InternalMNode node, OutputStream outputStream) throws IOException {
            ReadWriteIOUtils.write((int)node.getChildren().size(), (OutputStream)outputStream);
            ReadWriteIOUtils.write((String)node.getName(), (OutputStream)outputStream);
            ReadWriteIOUtils.write((int)-1, (OutputStream)outputStream);
            ReadWriteIOUtils.write((Boolean)node.isUseTemplate(), (OutputStream)outputStream);
        }
    }
}

