/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.schemaregion;

import com.github.benmanes.caffeine.cache.CacheLoader;
import com.github.benmanes.caffeine.cache.Caffeine;
import com.github.benmanes.caffeine.cache.LoadingCache;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.iotdb.common.rpc.thrift.TSchemaNode;
import org.apache.iotdb.commons.consensus.SchemaRegionId;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.file.SystemFileFactory;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.utils.FileUtils;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.StorageEngine;
import org.apache.iotdb.db.engine.trigger.executor.TriggerEngine;
import org.apache.iotdb.db.exception.metadata.AliasAlreadyExistException;
import org.apache.iotdb.db.exception.metadata.DataTypeMismatchException;
import org.apache.iotdb.db.exception.metadata.DeleteFailedException;
import org.apache.iotdb.db.exception.metadata.PathAlreadyExistException;
import org.apache.iotdb.db.exception.metadata.PathNotExistException;
import org.apache.iotdb.db.exception.metadata.SchemaDirCreationFailureException;
import org.apache.iotdb.db.exception.metadata.SeriesNumberOverflowException;
import org.apache.iotdb.db.exception.metadata.SeriesOverflowException;
import org.apache.iotdb.db.exception.metadata.template.DifferentTemplateException;
import org.apache.iotdb.db.exception.metadata.template.NoTemplateOnMNodeException;
import org.apache.iotdb.db.exception.metadata.template.TemplateIsInUseException;
import org.apache.iotdb.db.metadata.LocalSchemaProcessor;
import org.apache.iotdb.db.metadata.idtable.IDTable;
import org.apache.iotdb.db.metadata.idtable.IDTableManager;
import org.apache.iotdb.db.metadata.logfile.MLogReader;
import org.apache.iotdb.db.metadata.logfile.MLogWriter;
import org.apache.iotdb.db.metadata.mnode.IEntityMNode;
import org.apache.iotdb.db.metadata.mnode.IMNode;
import org.apache.iotdb.db.metadata.mnode.IMeasurementMNode;
import org.apache.iotdb.db.metadata.mnode.IStorageGroupMNode;
import org.apache.iotdb.db.metadata.mnode.MeasurementMNode;
import org.apache.iotdb.db.metadata.mtree.MTreeBelowSGMemoryImpl;
import org.apache.iotdb.db.metadata.path.MeasurementPath;
import org.apache.iotdb.db.metadata.rescon.MemoryStatistics;
import org.apache.iotdb.db.metadata.rescon.SchemaStatisticsManager;
import org.apache.iotdb.db.metadata.schemaregion.ISchemaRegion;
import org.apache.iotdb.db.metadata.schemaregion.SchemaRegionUtils;
import org.apache.iotdb.db.metadata.tag.TagManager;
import org.apache.iotdb.db.metadata.template.Template;
import org.apache.iotdb.db.metadata.template.TemplateManager;
import org.apache.iotdb.db.mpp.common.schematree.DeviceSchemaInfo;
import org.apache.iotdb.db.mpp.common.schematree.MeasurementSchemaInfo;
import org.apache.iotdb.db.qp.constant.SQLConstant;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertRowPlan;
import org.apache.iotdb.db.qp.physical.crud.InsertTabletPlan;
import org.apache.iotdb.db.qp.physical.sys.ActivateTemplateInClusterPlan;
import org.apache.iotdb.db.qp.physical.sys.ActivateTemplatePlan;
import org.apache.iotdb.db.qp.physical.sys.AutoCreateDeviceMNodePlan;
import org.apache.iotdb.db.qp.physical.sys.ChangeAliasPlan;
import org.apache.iotdb.db.qp.physical.sys.ChangeTagOffsetPlan;
import org.apache.iotdb.db.qp.physical.sys.CreateAlignedTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.CreateTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.DeleteTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.SetTemplatePlan;
import org.apache.iotdb.db.qp.physical.sys.ShowDevicesPlan;
import org.apache.iotdb.db.qp.physical.sys.ShowTimeSeriesPlan;
import org.apache.iotdb.db.qp.physical.sys.UnsetTemplatePlan;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.dataset.ShowDevicesResult;
import org.apache.iotdb.db.query.dataset.ShowResult;
import org.apache.iotdb.db.query.dataset.ShowTimeSeriesResult;
import org.apache.iotdb.db.utils.EncodingInferenceUtils;
import org.apache.iotdb.db.utils.SchemaUtils;
import org.apache.iotdb.external.api.ISeriesNumerLimiter;
import org.apache.iotdb.tsfile.common.conf.TSFileDescriptor;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;
import org.apache.iotdb.tsfile.utils.Pair;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;
import org.checkerframework.checker.nullness.qual.NonNull;
import org.checkerframework.checker.nullness.qual.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SchemaRegionMemoryImpl
implements ISchemaRegion {
    private static final Logger logger = LoggerFactory.getLogger(SchemaRegionMemoryImpl.class);
    protected static IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private boolean isRecovering = true;
    private volatile boolean initialized = false;
    private String storageGroupDirPath;
    private String schemaRegionDirPath;
    private String storageGroupFullPath;
    private SchemaRegionId schemaRegionId;
    private int templateId = -1;
    private boolean usingMLog = true;
    private MLogWriter logWriter;
    private SchemaStatisticsManager schemaStatisticsManager = SchemaStatisticsManager.getInstance();
    private MemoryStatistics memoryStatistics = MemoryStatistics.getInstance();
    private final IStorageGroupMNode storageGroupMNode;
    private MTreeBelowSGMemoryImpl mtree;
    private LoadingCache<PartialPath, IMNode> mNodeCache;
    private TagManager tagManager;
    private final ISeriesNumerLimiter seriesNumerLimiter;

    public SchemaRegionMemoryImpl(PartialPath storageGroup, SchemaRegionId schemaRegionId, IStorageGroupMNode storageGroupMNode, ISeriesNumerLimiter seriesNumerLimiter) throws MetadataException {
        File schemaRegionDir;
        this.storageGroupFullPath = storageGroup.getFullPath();
        this.schemaRegionId = schemaRegionId;
        this.storageGroupDirPath = config.getSchemaDir() + File.separator + this.storageGroupFullPath;
        this.schemaRegionDirPath = this.storageGroupDirPath + File.separator + schemaRegionId.getId();
        int cacheSize = config.getSchemaRegionDeviceNodeCacheSize();
        this.mNodeCache = Caffeine.newBuilder().maximumSize((long)cacheSize).build((CacheLoader)new CacheLoader<PartialPath, IMNode>(){

            public @Nullable IMNode load(@NonNull PartialPath partialPath) throws MetadataException {
                return SchemaRegionMemoryImpl.this.mtree.getNodeByPath(partialPath);
            }
        });
        this.storageGroupMNode = storageGroupMNode;
        if (config.isClusterMode() && config.getSchemaRegionConsensusProtocolClass().equals("org.apache.iotdb.consensus.ratis.RatisConsensus") && (schemaRegionDir = new File(this.schemaRegionDirPath)).exists()) {
            FileUtils.deleteDirectory((File)schemaRegionDir);
        }
        this.seriesNumerLimiter = seriesNumerLimiter;
        this.init();
    }

    @Override
    public synchronized void init() throws MetadataException {
        if (this.initialized) {
            return;
        }
        this.templateId = -1;
        this.initDir();
        try {
            this.isRecovering = true;
            this.tagManager = new TagManager(this.schemaRegionDirPath);
            this.mtree = new MTreeBelowSGMemoryImpl(this.storageGroupMNode, this.schemaRegionId.getId());
            if (!config.isClusterMode() || !config.getSchemaRegionConsensusProtocolClass().equals("org.apache.iotdb.consensus.ratis.RatisConsensus")) {
                this.usingMLog = true;
                this.initMLog();
            } else {
                this.usingMLog = false;
            }
            this.isRecovering = false;
        }
        catch (IOException e) {
            logger.error("Cannot recover all schema info from {}, we try to recover as possible as we can", (Object)this.schemaRegionDirPath, (Object)e);
        }
        this.initialized = true;
    }

    private void initDir() throws SchemaDirCreationFailureException {
        File schemaRegionFolder;
        File sgSchemaFolder = SystemFileFactory.INSTANCE.getFile(this.storageGroupDirPath);
        if (!sgSchemaFolder.exists()) {
            if (sgSchemaFolder.mkdirs()) {
                logger.info("create storage group schema folder {}", (Object)this.storageGroupDirPath);
            } else if (!sgSchemaFolder.exists()) {
                logger.error("create storage group schema folder {} failed.", (Object)this.storageGroupDirPath);
                throw new SchemaDirCreationFailureException(this.storageGroupDirPath);
            }
        }
        if (!(schemaRegionFolder = SystemFileFactory.INSTANCE.getFile(this.schemaRegionDirPath)).exists()) {
            if (schemaRegionFolder.mkdirs()) {
                logger.info("create schema region folder {}", (Object)this.schemaRegionDirPath);
            } else if (!schemaRegionFolder.exists()) {
                logger.error("create schema region folder {} failed.", (Object)this.schemaRegionDirPath);
                throw new SchemaDirCreationFailureException(this.schemaRegionDirPath);
            }
        }
    }

    private void initMLog() throws IOException {
        int lineNumber = this.initFromLog();
        this.logWriter = new MLogWriter(this.schemaRegionDirPath, "mlog.bin");
        this.logWriter.setLogNum(lineNumber);
    }

    public void writeToMLog(PhysicalPlan plan) throws IOException {
        if (this.usingMLog && !this.isRecovering) {
            this.logWriter.putLog(plan);
        }
    }

    @Override
    public void forceMlog() {
        if (!this.initialized) {
            return;
        }
        if (this.usingMLog) {
            try {
                this.logWriter.force();
            }
            catch (IOException e) {
                logger.error("Cannot force {} mlog to the schema region", (Object)this.schemaRegionId, (Object)e);
            }
        }
    }

    private int initFromLog() throws IOException {
        File logFile = SystemFileFactory.INSTANCE.getFile(this.schemaRegionDirPath + File.separator + "mlog.bin");
        long time = System.currentTimeMillis();
        if (logFile.exists()) {
            int idx = 0;
            MLogReader mLogReader = new MLogReader(this.schemaRegionDirPath, "mlog.bin");
            try {
                idx = this.applyMLog(mLogReader);
                logger.debug("spend {} ms to deserialize {} mtree from mlog.bin", (Object)(System.currentTimeMillis() - time), (Object)this.storageGroupFullPath);
                int n = idx;
                mLogReader.close();
                return n;
            }
            catch (Throwable throwable) {
                try {
                    try {
                        mLogReader.close();
                    }
                    catch (Throwable throwable2) {
                        throwable.addSuppressed(throwable2);
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    e.printStackTrace();
                    throw new IOException("Failed to parse " + this.storageGroupFullPath + " mlog.bin for err:" + e);
                }
            }
        }
        return 0;
    }

    private int applyMLog(MLogReader mLogReader) {
        int idx = 0;
        while (mLogReader.hasNext()) {
            PhysicalPlan plan;
            try {
                plan = mLogReader.next();
                ++idx;
            }
            catch (Exception e) {
                logger.error("Parse mlog error at lineNumber {} because:", (Object)idx, (Object)e);
                break;
            }
            if (plan == null) continue;
            try {
                this.operation(plan);
            }
            catch (IOException | MetadataException e) {
                logger.error("Can not operate cmd {} for err:", (Object)plan.getOperatorType(), (Object)e);
            }
        }
        return idx;
    }

    @Override
    public synchronized void clear() {
        try {
            this.templateId = -1;
            if (this.mNodeCache != null) {
                this.mNodeCache.invalidateAll();
            }
            if (this.mtree != null) {
                this.mtree.clear();
            }
            if (this.logWriter != null) {
                this.logWriter.close();
                this.logWriter = null;
            }
            this.tagManager.clear();
            this.isRecovering = true;
            this.initialized = false;
        }
        catch (IOException e) {
            logger.error("Cannot close metadata log writer, because:", (Throwable)e);
        }
    }

    private void operation(PhysicalPlan plan) throws IOException, MetadataException {
        switch (plan.getOperatorType()) {
            case CREATE_TIMESERIES: {
                CreateTimeSeriesPlan createTimeSeriesPlan = (CreateTimeSeriesPlan)plan;
                this.createTimeseries(createTimeSeriesPlan, createTimeSeriesPlan.getTagOffset());
                break;
            }
            case CREATE_ALIGNED_TIMESERIES: {
                CreateAlignedTimeSeriesPlan createAlignedTimeSeriesPlan = (CreateAlignedTimeSeriesPlan)plan;
                this.createAlignedTimeSeries(createAlignedTimeSeriesPlan);
                break;
            }
            case DELETE_TIMESERIES: {
                DeleteTimeSeriesPlan deleteTimeSeriesPlan = (DeleteTimeSeriesPlan)plan;
                this.deleteOneTimeseriesUpdateStatisticsAndDropTrigger(deleteTimeSeriesPlan.getPaths().get(0));
                break;
            }
            case CHANGE_ALIAS: {
                ChangeAliasPlan changeAliasPlan = (ChangeAliasPlan)plan;
                this.changeAlias(changeAliasPlan.getPath(), changeAliasPlan.getAlias());
                break;
            }
            case CHANGE_TAG_OFFSET: {
                ChangeTagOffsetPlan changeTagOffsetPlan = (ChangeTagOffsetPlan)plan;
                this.changeOffset(changeTagOffsetPlan.getPath(), changeTagOffsetPlan.getOffset());
                break;
            }
            case SET_TEMPLATE: {
                SetTemplatePlan setTemplatePlan = (SetTemplatePlan)plan;
                this.setSchemaTemplate(setTemplatePlan);
                break;
            }
            case ACTIVATE_TEMPLATE: {
                ActivateTemplatePlan activateTemplatePlan = (ActivateTemplatePlan)plan;
                this.setUsingSchemaTemplate(activateTemplatePlan);
                break;
            }
            case AUTO_CREATE_DEVICE_MNODE: {
                AutoCreateDeviceMNodePlan autoCreateDeviceMNodePlan = (AutoCreateDeviceMNodePlan)plan;
                this.autoCreateDeviceMNode(autoCreateDeviceMNodePlan);
                break;
            }
            case UNSET_TEMPLATE: {
                UnsetTemplatePlan unsetTemplatePlan = (UnsetTemplatePlan)plan;
                this.unsetSchemaTemplate(unsetTemplatePlan);
                break;
            }
            case ACTIVATE_TEMPLATE_IN_CLUSTER: {
                ActivateTemplateInClusterPlan activateTemplateInClusterPlan = (ActivateTemplateInClusterPlan)plan;
                this.recoverActivatingSchemaTemplate(activateTemplateInClusterPlan);
                break;
            }
            default: {
                logger.error("Unrecognizable command {}", (Object)plan.getOperatorType());
            }
        }
    }

    @Override
    public String getStorageGroupFullPath() {
        return this.storageGroupFullPath;
    }

    @Override
    public SchemaRegionId getSchemaRegionId() {
        return this.schemaRegionId;
    }

    @Override
    public synchronized void deleteSchemaRegion() throws MetadataException {
        List<IMeasurementMNode> leafMNodes = this.mtree.getAllMeasurementMNode();
        int seriesCount = leafMNodes.size();
        this.schemaStatisticsManager.deleteTimeseries(seriesCount);
        this.seriesNumerLimiter.deleteTimeSeries(seriesCount);
        TriggerEngine.drop(leafMNodes);
        this.clear();
        SchemaRegionUtils.deleteSchemaRegionFolder(this.schemaRegionDirPath, logger);
    }

    @Override
    public synchronized boolean createSnapshot(File snapshotDir) {
        logger.info("Start create snapshot of schemaRegion {}", (Object)this.schemaRegionId);
        boolean isSuccess = true;
        long startTime = System.currentTimeMillis();
        long mtreeSnapshotStartTime = System.currentTimeMillis();
        isSuccess = isSuccess && this.mtree.createSnapshot(snapshotDir);
        logger.info("MTree snapshot creation of schemaRegion {} costs {}ms.", (Object)this.schemaRegionId, (Object)(System.currentTimeMillis() - mtreeSnapshotStartTime));
        long tagSnapshotStartTime = System.currentTimeMillis();
        isSuccess = isSuccess && this.tagManager.createSnapshot(snapshotDir);
        logger.info("Tag snapshot creation of schemaRegion {} costs {}ms.", (Object)this.schemaRegionId, (Object)(System.currentTimeMillis() - tagSnapshotStartTime));
        logger.info("Snapshot creation of schemaRegion {} costs {}ms.", (Object)this.schemaRegionId, (Object)(System.currentTimeMillis() - startTime));
        logger.info("Successfully create snapshot of schemaRegion {}", (Object)this.schemaRegionId);
        return isSuccess;
    }

    @Override
    public void loadSnapshot(File latestSnapshotRootDir) {
        this.clear();
        logger.info("Start loading snapshot of schemaRegion {}", (Object)this.schemaRegionId);
        long startTime = System.currentTimeMillis();
        try {
            this.usingMLog = false;
            this.isRecovering = true;
            long tagSnapshotStartTime = System.currentTimeMillis();
            this.tagManager = TagManager.loadFromSnapshot(latestSnapshotRootDir, this.schemaRegionDirPath);
            logger.info("Tag snapshot loading of schemaRegion {} costs {}ms.", (Object)this.schemaRegionId, (Object)(System.currentTimeMillis() - tagSnapshotStartTime));
            long mtreeSnapshotStartTime = System.currentTimeMillis();
            this.mtree = MTreeBelowSGMemoryImpl.loadFromSnapshot(latestSnapshotRootDir, this.storageGroupMNode, this.schemaRegionId.getId(), measurementMNode -> {
                if (measurementMNode.getOffset() == -1L) {
                    return;
                }
                try {
                    this.tagManager.recoverIndex(measurementMNode.getOffset(), (IMeasurementMNode)measurementMNode);
                }
                catch (IOException e) {
                    logger.error("Failed to recover tagIndex for {} in schemaRegion {}.", (Object)(this.storageGroupFullPath + "." + measurementMNode.getFullPath()), (Object)this.schemaRegionId);
                }
            });
            logger.info("MTree snapshot loading of schemaRegion {} costs {}ms.", (Object)this.schemaRegionId, (Object)(System.currentTimeMillis() - mtreeSnapshotStartTime));
            this.isRecovering = false;
            this.initialized = true;
            logger.info("Snapshot loading of schemaRegion {} costs {}ms.", (Object)this.schemaRegionId, (Object)(System.currentTimeMillis() - startTime));
            logger.info("Successfully load snapshot of schemaRegion {}", (Object)this.schemaRegionId);
        }
        catch (IOException e) {
            logger.error("Failed to load snapshot for schemaRegion {}  due to {}. Use empty schemaRegion", new Object[]{this.schemaRegionId, e.getMessage(), e});
            try {
                this.initialized = false;
                this.isRecovering = true;
                this.init();
            }
            catch (MetadataException metadataException) {
                logger.error("Error occurred during initializing schemaRegion {}", (Object)this.schemaRegionId, (Object)metadataException);
            }
        }
    }

    public void createTimeseries(CreateTimeSeriesPlan plan) throws MetadataException {
        this.createTimeseries(plan, -1L);
    }

    @Override
    public void createTimeseries(CreateTimeSeriesPlan plan, long offset) throws MetadataException {
        if (!this.memoryStatistics.isAllowToCreateNewSeries()) {
            throw new SeriesOverflowException();
        }
        if (!this.seriesNumerLimiter.addTimeSeries(1)) {
            throw new SeriesNumberOverflowException();
        }
        try {
            IMeasurementMNode leafMNode;
            try {
                PartialPath path = plan.getPath();
                SchemaUtils.checkDataTypeWithEncoding(plan.getDataType(), plan.getEncoding());
                TSDataType type = plan.getDataType();
                leafMNode = this.mtree.createTimeseries(path, type, plan.getEncoding(), plan.getCompressor(), plan.getProps(), plan.getAlias());
                this.mNodeCache.invalidate((Object)path.getDevicePath());
            }
            catch (Throwable t) {
                this.seriesNumerLimiter.deleteTimeSeries(1);
                throw t;
            }
            this.schemaStatisticsManager.addTimeseries(1);
            if (offset != -1L && this.isRecovering) {
                this.tagManager.recoverIndex(offset, leafMNode);
            } else if (plan.getTags() != null) {
                this.tagManager.addIndex(plan.getTags(), leafMNode);
            }
            if (!this.isRecovering) {
                if (plan.getTags() != null && !plan.getTags().isEmpty() || plan.getAttributes() != null && !plan.getAttributes().isEmpty()) {
                    offset = this.tagManager.writeTagFile(plan.getTags(), plan.getAttributes());
                }
                plan.setTagOffset(offset);
                this.writeToMLog(plan);
            }
            if (offset != -1L) {
                leafMNode.setOffset(offset);
            }
        }
        catch (IOException e) {
            throw new MetadataException((Throwable)e);
        }
        if (!(!config.isEnableIDTable() || this.isRecovering && config.isEnableIDTableLogFile())) {
            IDTable idTable = IDTableManager.getInstance().getIDTable(plan.getPath().getDevicePath());
            idTable.createTimeseries(plan);
        }
    }

    private void createTimeseries(PartialPath path, TSDataType dataType, TSEncoding encoding, CompressionType compressor, Map<String, String> props) throws MetadataException {
        block2: {
            try {
                this.createTimeseries(new CreateTimeSeriesPlan(path, dataType, encoding, compressor, props, null, null, null));
            }
            catch (AliasAlreadyExistException | PathAlreadyExistException e) {
                if (!logger.isDebugEnabled()) break block2;
                logger.debug("Ignore PathAlreadyExistException and AliasAlreadyExistException when Concurrent inserting a non-exist time series {}", (Object)path);
            }
        }
    }

    public void createAlignedTimeSeries(PartialPath prefixPath, List<String> measurements, List<TSDataType> dataTypes, List<TSEncoding> encodings, List<CompressionType> compressors) throws MetadataException {
        this.createAlignedTimeSeries(new CreateAlignedTimeSeriesPlan(prefixPath, measurements, dataTypes, encodings, compressors, null, null, null));
    }

    @Override
    public void createAlignedTimeSeries(CreateAlignedTimeSeriesPlan plan) throws MetadataException {
        int seriesCount = plan.getMeasurements().size();
        if (!this.memoryStatistics.isAllowToCreateNewSeries()) {
            throw new SeriesOverflowException();
        }
        if (!this.seriesNumerLimiter.addTimeSeries(seriesCount)) {
            throw new SeriesNumberOverflowException();
        }
        try {
            int i;
            List<IMeasurementMNode> measurementMNodeList;
            PartialPath prefixPath = plan.getPrefixPath();
            List<String> measurements = plan.getMeasurements();
            List<TSDataType> dataTypes = plan.getDataTypes();
            List<TSEncoding> encodings = plan.getEncodings();
            List<Map<String, String>> tagsList = plan.getTagsList();
            List<Map<String, String>> attributesList = plan.getAttributesList();
            try {
                for (int i2 = 0; i2 < measurements.size(); ++i2) {
                    SchemaUtils.checkDataTypeWithEncoding(dataTypes.get(i2), encodings.get(i2));
                }
                measurementMNodeList = this.mtree.createAlignedTimeseries(prefixPath, measurements, plan.getDataTypes(), plan.getEncodings(), plan.getCompressors(), plan.getAliasList());
                this.mNodeCache.invalidate((Object)prefixPath);
            }
            catch (Throwable t) {
                this.seriesNumerLimiter.deleteTimeSeries(seriesCount);
                throw t;
            }
            this.schemaStatisticsManager.addTimeseries(seriesCount);
            List<Long> tagOffsets = plan.getTagOffsets();
            for (i = 0; i < measurements.size(); ++i) {
                if (tagOffsets != null && !plan.getTagOffsets().isEmpty() && this.isRecovering) {
                    if (tagOffsets.get(i) == -1L) continue;
                    this.tagManager.recoverIndex(plan.getTagOffsets().get(i), measurementMNodeList.get(i));
                    continue;
                }
                if (tagsList == null || tagsList.isEmpty() || tagsList.get(i) == null) continue;
                this.tagManager.addIndex(tagsList.get(i), measurementMNodeList.get(i));
            }
            tagOffsets = new ArrayList<Long>();
            if (!this.isRecovering) {
                if (tagsList != null && !tagsList.isEmpty() || attributesList != null && !attributesList.isEmpty()) {
                    for (int i3 = 0; i3 < measurements.size(); ++i3) {
                        Map<String, String> attributes;
                        Map<String, String> tags = tagsList == null ? null : tagsList.get(i3);
                        Map<String, String> map = attributes = attributesList == null ? null : attributesList.get(i3);
                        if (tags == null && attributes == null) {
                            tagOffsets.add(-1L);
                            continue;
                        }
                        tagOffsets.add(this.tagManager.writeTagFile(tags, attributes));
                    }
                } else {
                    for (i = 0; i < measurements.size(); ++i) {
                        tagOffsets.add(-1L);
                    }
                }
                plan.setTagOffsets(tagOffsets);
                this.writeToMLog(plan);
            }
            tagOffsets = plan.getTagOffsets();
            for (i = 0; i < measurements.size(); ++i) {
                if (tagOffsets.get(i) == -1L) continue;
                measurementMNodeList.get(i).setOffset(tagOffsets.get(i));
            }
        }
        catch (IOException e) {
            throw new MetadataException((Throwable)e);
        }
        if (!(!config.isEnableIDTable() || this.isRecovering && config.isEnableIDTableLogFile())) {
            IDTable idTable = IDTableManager.getInstance().getIDTable(plan.getPrefixPath());
            idTable.createAlignedTimeseries(plan);
        }
    }

    @Override
    public synchronized Pair<Integer, Set<String>> deleteTimeseries(PartialPath pathPattern, boolean isPrefixMatch) throws MetadataException {
        try {
            List<MeasurementPath> allTimeseries = this.mtree.getMeasurementPaths(pathPattern, isPrefixMatch);
            HashSet<String> failedNames = new HashSet<String>();
            int deletedNum = 0;
            for (PartialPath partialPath : allTimeseries) {
                this.deleteSingleTimeseriesInternal(partialPath, failedNames);
                ++deletedNum;
            }
            return new Pair((Object)deletedNum, failedNames);
        }
        catch (IOException e) {
            throw new MetadataException(e.getMessage());
        }
    }

    public Pair<Integer, Set<String>> deleteTimeseries(PartialPath pathPattern) throws MetadataException {
        return this.deleteTimeseries(pathPattern, false);
    }

    private void deleteSingleTimeseriesInternal(PartialPath p, Set<String> failedNames) throws MetadataException, IOException {
        DeleteTimeSeriesPlan deleteTimeSeriesPlan = new DeleteTimeSeriesPlan();
        try {
            PartialPath emptyStorageGroup = this.deleteOneTimeseriesUpdateStatisticsAndDropTrigger(p);
            if (!this.isRecovering) {
                if (emptyStorageGroup != null) {
                    StorageEngine.getInstance().deleteAllDataFilesInOneStorageGroup(emptyStorageGroup);
                }
                deleteTimeSeriesPlan.setDeletePathList(Collections.singletonList(p));
                this.writeToMLog(deleteTimeSeriesPlan);
            }
        }
        catch (DeleteFailedException e) {
            failedNames.add(e.getName());
        }
    }

    private PartialPath deleteOneTimeseriesUpdateStatisticsAndDropTrigger(PartialPath path) throws MetadataException, IOException {
        Pair<PartialPath, IMeasurementMNode> pair = this.mtree.deleteTimeseriesAndReturnEmptyStorageGroup(path);
        IMeasurementMNode measurementMNode = (IMeasurementMNode)pair.right;
        this.removeFromTagInvertedIndex(measurementMNode);
        PartialPath storageGroupPath = (PartialPath)pair.left;
        TriggerEngine.drop((IMeasurementMNode)pair.right);
        IEntityMNode node = measurementMNode.getParent();
        if (node.isUseTemplate() && node.getSchemaTemplate().hasSchema(measurementMNode.getName())) {
            return storageGroupPath;
        }
        this.mNodeCache.invalidate((Object)node.getPartialPath());
        this.schemaStatisticsManager.deleteTimeseries(1);
        this.seriesNumerLimiter.deleteTimeSeries(1);
        return storageGroupPath;
    }

    private IMNode getDeviceNodeWithAutoCreate(PartialPath path) throws IOException, MetadataException {
        try {
            return (IMNode)this.mNodeCache.get((Object)path);
        }
        catch (Exception e) {
            if (!(e.getCause() instanceof MetadataException)) {
                throw e;
            }
            IMNode node = this.mtree.getDeviceNodeWithAutoCreating(path);
            this.writeToMLog(new AutoCreateDeviceMNodePlan(node.getPartialPath()));
            return node;
        }
    }

    @Override
    public void autoCreateDeviceMNode(AutoCreateDeviceMNodePlan plan) throws MetadataException {
        this.mtree.getDeviceNodeWithAutoCreating(plan.getPath());
        try {
            this.writeToMLog(plan);
        }
        catch (IOException e) {
            throw new MetadataException((Throwable)e);
        }
    }

    @Override
    public boolean isPathExist(PartialPath path) {
        try {
            return this.mtree.isPathExist(path);
        }
        catch (MetadataException e) {
            logger.error(e.getMessage());
            return false;
        }
    }

    @Override
    public int getAllTimeseriesCount(PartialPath pathPattern, boolean isPrefixMatch) throws MetadataException {
        return this.mtree.getAllTimeseriesCount(pathPattern, isPrefixMatch);
    }

    @Override
    public int getAllTimeseriesCount(PartialPath pathPattern, Map<Integer, Template> templateMap, boolean isPrefixMatch) throws MetadataException {
        return this.mtree.getAllTimeseriesCount(pathPattern, templateMap, isPrefixMatch);
    }

    @Override
    public int getAllTimeseriesCount(PartialPath pathPattern, boolean isPrefixMatch, String key, String value, boolean isContains) throws MetadataException {
        return this.mtree.getAllTimeseriesCount(pathPattern, isPrefixMatch, this.tagManager.getMatchedTimeseriesInIndex(key, value, isContains), true);
    }

    @Override
    public int getDevicesNum(PartialPath pathPattern, boolean isPrefixMatch) throws MetadataException {
        return this.mtree.getDevicesNum(pathPattern, isPrefixMatch);
    }

    public int getDevicesNum(PartialPath pathPattern) throws MetadataException {
        return this.getDevicesNum(pathPattern, false);
    }

    @Override
    public int getNodesCountInGivenLevel(PartialPath pathPattern, int level, boolean isPrefixMatch) throws MetadataException {
        return this.mtree.getNodesCountInGivenLevel(pathPattern, level, isPrefixMatch);
    }

    @Override
    public Map<PartialPath, Integer> getMeasurementCountGroupByLevel(PartialPath pathPattern, int level, boolean isPrefixMatch) throws MetadataException {
        return this.mtree.getMeasurementCountGroupByLevel(pathPattern, level, isPrefixMatch);
    }

    @Override
    public Map<PartialPath, Integer> getMeasurementCountGroupByLevel(PartialPath pathPattern, int level, boolean isPrefixMatch, String key, String value, boolean isContains) throws MetadataException {
        return this.mtree.getMeasurementCountGroupByLevel(pathPattern, level, isPrefixMatch, this.tagManager.getMatchedTimeseriesInIndex(key, value, isContains), true);
    }

    @Override
    public List<PartialPath> getNodesListInGivenLevel(PartialPath pathPattern, int nodeLevel, boolean isPrefixMatch, LocalSchemaProcessor.StorageGroupFilter filter) throws MetadataException {
        return this.mtree.getNodesListInGivenLevel(pathPattern, nodeLevel, isPrefixMatch, filter);
    }

    @Override
    public Set<TSchemaNode> getChildNodePathInNextLevel(PartialPath pathPattern) throws MetadataException {
        return this.mtree.getChildNodePathInNextLevel(pathPattern);
    }

    @Override
    public Set<String> getChildNodeNameInNextLevel(PartialPath pathPattern) throws MetadataException {
        return this.mtree.getChildNodeNameInNextLevel(pathPattern);
    }

    @Override
    public Set<PartialPath> getBelongedDevices(PartialPath timeseries) throws MetadataException {
        return this.mtree.getDevicesByTimeseries(timeseries);
    }

    @Override
    public Set<PartialPath> getMatchedDevices(PartialPath pathPattern, boolean isPrefixMatch) throws MetadataException {
        return this.mtree.getDevices(pathPattern, isPrefixMatch);
    }

    @Override
    public Pair<List<ShowDevicesResult>, Integer> getMatchedDevices(ShowDevicesPlan plan) throws MetadataException {
        return this.mtree.getDevices(plan);
    }

    @Override
    public List<MeasurementPath> getMeasurementPaths(PartialPath pathPattern, boolean isPrefixMatch) throws MetadataException {
        return (List)this.getMeasurementPathsWithAlias((PartialPath)pathPattern, (int)0, (int)0, (boolean)isPrefixMatch).left;
    }

    public List<MeasurementPath> getMeasurementPaths(PartialPath pathPattern) throws MetadataException {
        return this.getMeasurementPaths(pathPattern, false);
    }

    @Override
    public Pair<List<MeasurementPath>, Integer> getMeasurementPathsWithAlias(PartialPath pathPattern, int limit, int offset, boolean isPrefixMatch) throws MetadataException {
        return this.mtree.getMeasurementPathsWithAlias(pathPattern, limit, offset, isPrefixMatch);
    }

    @Override
    public List<MeasurementPath> fetchSchema(PartialPath pathPattern, Map<Integer, Template> templateMap) throws MetadataException {
        return this.mtree.fetchSchema(pathPattern, templateMap);
    }

    @Override
    public Pair<List<ShowTimeSeriesResult>, Integer> showTimeseries(ShowTimeSeriesPlan plan, QueryContext context) throws MetadataException {
        if (plan.getKey() != null && plan.getValue() != null) {
            return this.showTimeseriesWithIndex(plan, context);
        }
        return this.showTimeseriesWithoutIndex(plan, context);
    }

    private Pair<List<ShowTimeSeriesResult>, Integer> showTimeseriesWithIndex(ShowTimeSeriesPlan plan, QueryContext context) throws MetadataException {
        List<IMeasurementMNode> allMatchedNodes = this.tagManager.getMatchedTimeseriesInIndex(plan, context);
        List<Object> res = new LinkedList();
        PartialPath pathPattern = plan.getPath();
        boolean needLast = plan.isOrderByHeat();
        int curOffset = -1;
        int count = 0;
        int limit = needLast ? 0 : plan.getLimit();
        int offset = needLast ? 0 : plan.getOffset();
        for (IMeasurementMNode leaf : allMatchedNodes) {
            if (!((plan.isPrefixMatch() ? pathPattern.prefixMatchFullPath(leaf.getPartialPath()) : pathPattern.matchFullPath(leaf.getPartialPath())) && (limit == 0 && offset == 0 || ++curOffset >= offset && count != limit))) continue;
            try {
                Pair<Map<String, String>, Map<String, String>> tagAndAttributePair = this.tagManager.readTagFile(leaf.getOffset());
                IMeasurementSchema measurementSchema = leaf.getSchema();
                res.add(new ShowTimeSeriesResult(leaf.getFullPath(), leaf.getAlias(), this.storageGroupFullPath, measurementSchema.getType(), measurementSchema.getEncodingType(), measurementSchema.getCompressor(), leaf.getLastCacheContainer().getCachedLast() != null ? leaf.getLastCacheContainer().getCachedLast().getTimestamp() : 0L, (Map)tagAndAttributePair.left, (Map)tagAndAttributePair.right));
                if (limit == 0) continue;
                ++count;
            }
            catch (IOException e) {
                throw new MetadataException("Something went wrong while deserialize tag info of " + leaf.getFullPath(), (Throwable)e);
            }
        }
        if (needLast) {
            Stream<Object> stream = res.stream();
            limit = plan.getLimit();
            offset = plan.getOffset();
            stream = stream.sorted(Comparator.comparingLong(ShowTimeSeriesResult::getLastTime).reversed().thenComparing(ShowResult::getName));
            if (limit != 0) {
                stream = stream.skip(offset).limit(limit);
            }
            res = stream.collect(Collectors.toList());
        }
        return new Pair(res, (Object)(curOffset + 1));
    }

    private Pair<List<ShowTimeSeriesResult>, Integer> showTimeseriesWithoutIndex(ShowTimeSeriesPlan plan, QueryContext context) throws MetadataException {
        Pair<List<Pair<PartialPath, String[]>>, Integer> ans = this.mtree.getAllMeasurementSchema(plan, context);
        LinkedList<ShowTimeSeriesResult> res = new LinkedList<ShowTimeSeriesResult>();
        for (Pair ansString : (List)ans.left) {
            long tagFileOffset = Long.parseLong(((String[])ansString.right)[5]);
            try {
                Pair<Map<String, String>, Map<String, String>> tagAndAttributePair = new Pair<Map<String, String>, Map<String, String>>(Collections.emptyMap(), Collections.emptyMap());
                if (tagFileOffset >= 0L) {
                    tagAndAttributePair = this.tagManager.readTagFile(tagFileOffset);
                }
                res.add(new ShowTimeSeriesResult(((PartialPath)ansString.left).getFullPath(), ((String[])ansString.right)[0], ((String[])ansString.right)[1], TSDataType.valueOf((String)((String[])ansString.right)[2]), TSEncoding.valueOf((String)((String[])ansString.right)[3]), CompressionType.valueOf((String)((String[])ansString.right)[4]), ((String[])ansString.right)[6] != null ? Long.parseLong(((String[])ansString.right)[6]) : 0L, (Map)tagAndAttributePair.left, (Map)tagAndAttributePair.right));
            }
            catch (IOException e) {
                throw new MetadataException("Something went wrong while deserialize tag info of " + ((PartialPath)ansString.left).getFullPath(), (Throwable)e);
            }
        }
        return new Pair(res, (Object)((Integer)ans.right));
    }

    public TSDataType getSeriesType(PartialPath fullPath) throws MetadataException {
        if (fullPath.equals((Object)SQLConstant.TIME_PATH)) {
            return TSDataType.INT64;
        }
        return this.getSeriesSchema(fullPath).getType();
    }

    public IMeasurementSchema getSeriesSchema(PartialPath fullPath) throws MetadataException {
        return this.getMeasurementMNode(fullPath).getSchema();
    }

    @Override
    public List<MeasurementPath> getAllMeasurementByDevicePath(PartialPath devicePath) throws PathNotExistException {
        LinkedList<MeasurementPath> res = new LinkedList<MeasurementPath>();
        try {
            IMNode node = (IMNode)this.mNodeCache.get((Object)devicePath);
            for (IMNode child : node.getChildren().values()) {
                if (!child.isMeasurement()) continue;
                IMeasurementMNode measurementMNode = child.getAsMeasurementMNode();
                res.add(measurementMNode.getMeasurementPath());
            }
            Template template = node.getUpperTemplate();
            if (node.isUseTemplate() && template != null) {
                for (IMeasurementSchema schema : template.getSchemaMap().values()) {
                    MeasurementPath measurementPath = new MeasurementPath(devicePath.concatNode(schema.getMeasurementId()), schema);
                    measurementPath.setUnderAlignedEntity(node.getAsEntityMNode().isAligned());
                    res.add(measurementPath);
                }
            }
        }
        catch (Exception e) {
            if (e.getCause() instanceof MetadataException) {
                throw new PathNotExistException(devicePath.getFullPath());
            }
            throw e;
        }
        return new ArrayList<MeasurementPath>(res);
    }

    @Override
    public IMNode getDeviceNode(PartialPath path) throws MetadataException {
        try {
            IMNode node = (IMNode)this.mNodeCache.get((Object)path);
            return node;
        }
        catch (Exception e) {
            if (e.getCause() instanceof MetadataException) {
                throw new PathNotExistException(path.getFullPath());
            }
            throw e;
        }
    }

    @Override
    public IMeasurementMNode getMeasurementMNode(PartialPath fullPath) throws MetadataException {
        return this.mtree.getMeasurementMNode(fullPath);
    }

    protected IMeasurementMNode getMeasurementMNode(IMNode deviceMNode, String measurementName) throws MetadataException {
        IMNode result = deviceMNode.getChild(measurementName);
        if (result == null) {
            return null;
        }
        if (result.isMeasurement()) {
            return result.getAsMeasurementMNode();
        }
        throw new PathAlreadyExistException(deviceMNode.getFullPath() + "." + measurementName);
    }

    private void changeOffset(PartialPath path, long offset) throws MetadataException {
        IMeasurementMNode measurementMNode = this.mtree.getMeasurementMNode(path);
        measurementMNode.setOffset(offset);
        if (this.isRecovering) {
            try {
                this.tagManager.recoverIndex(offset, measurementMNode);
            }
            catch (IOException e) {
                throw new MetadataException((Throwable)e);
            }
        }
    }

    @Override
    public void changeAlias(PartialPath path, String alias) throws MetadataException {
        IMeasurementMNode leafMNode = this.mtree.getMeasurementMNode(path);
        if (leafMNode.getAlias() != null) {
            leafMNode.getParent().deleteAliasChild(leafMNode.getAlias());
        }
        leafMNode.getParent().addAlias(alias, leafMNode);
        this.mtree.setAlias(leafMNode, alias);
        try {
            this.writeToMLog(new ChangeAliasPlan(path, alias));
        }
        catch (IOException e) {
            throw new MetadataException((Throwable)e);
        }
    }

    @Override
    public void upsertTagsAndAttributes(String alias, Map<String, String> tagsMap, Map<String, String> attributesMap, PartialPath fullPath) throws MetadataException, IOException {
        IMeasurementMNode leafMNode = this.mtree.getMeasurementMNode(fullPath);
        this.upsertAlias(alias, fullPath, leafMNode);
        if (tagsMap == null && attributesMap == null) {
            return;
        }
        if (leafMNode.getOffset() < 0L) {
            long offset = this.tagManager.writeTagFile(tagsMap, attributesMap);
            this.writeToMLog(new ChangeTagOffsetPlan(fullPath, offset));
            leafMNode.setOffset(offset);
            if (tagsMap != null && !tagsMap.isEmpty()) {
                this.tagManager.addIndex(tagsMap, leafMNode);
            }
            return;
        }
        this.tagManager.updateTagsAndAttributes(tagsMap, attributesMap, leafMNode);
    }

    private void upsertAlias(String alias, PartialPath fullPath, IMeasurementMNode leafMNode) throws MetadataException, IOException {
        if (alias != null && !alias.equals(leafMNode.getAlias())) {
            if (!leafMNode.getParent().addAlias(alias, leafMNode)) {
                throw new MetadataException("The alias already exists.");
            }
            if (leafMNode.getAlias() != null) {
                leafMNode.getParent().deleteAliasChild(leafMNode.getAlias());
            }
            this.mtree.setAlias(leafMNode, alias);
            this.writeToMLog(new ChangeAliasPlan(fullPath, alias));
        }
    }

    @Override
    public void addAttributes(Map<String, String> attributesMap, PartialPath fullPath) throws MetadataException, IOException {
        IMeasurementMNode leafMNode = this.mtree.getMeasurementMNode(fullPath);
        if (leafMNode.getOffset() < 0L) {
            long offset = this.tagManager.writeTagFile(Collections.emptyMap(), attributesMap);
            this.writeToMLog(new ChangeTagOffsetPlan(fullPath, offset));
            leafMNode.setOffset(offset);
            return;
        }
        this.tagManager.addAttributes(attributesMap, fullPath, leafMNode);
    }

    @Override
    public void addTags(Map<String, String> tagsMap, PartialPath fullPath) throws MetadataException, IOException {
        IMeasurementMNode leafMNode = this.mtree.getMeasurementMNode(fullPath);
        if (leafMNode.getOffset() < 0L) {
            long offset = this.tagManager.writeTagFile(tagsMap, Collections.emptyMap());
            this.writeToMLog(new ChangeTagOffsetPlan(fullPath, offset));
            leafMNode.setOffset(offset);
            this.tagManager.addIndex(tagsMap, leafMNode);
            return;
        }
        this.tagManager.addTags(tagsMap, fullPath, leafMNode);
    }

    @Override
    public void dropTagsOrAttributes(Set<String> keySet, PartialPath fullPath) throws MetadataException, IOException {
        IMeasurementMNode leafMNode = this.mtree.getMeasurementMNode(fullPath);
        if (leafMNode.getOffset() != -1L) {
            this.tagManager.dropTagsOrAttributes(keySet, fullPath, leafMNode);
        }
    }

    @Override
    public void setTagsOrAttributesValue(Map<String, String> alterMap, PartialPath fullPath) throws MetadataException, IOException {
        IMeasurementMNode leafMNode = this.mtree.getMeasurementMNode(fullPath);
        if (leafMNode.getOffset() < 0L) {
            throw new MetadataException(String.format("TimeSeries [%s] does not have any tag/attribute.", fullPath));
        }
        this.tagManager.setTagsOrAttributesValue(alterMap, fullPath, leafMNode);
    }

    @Override
    public void renameTagOrAttributeKey(String oldKey, String newKey, PartialPath fullPath) throws MetadataException, IOException {
        IMeasurementMNode leafMNode = this.mtree.getMeasurementMNode(fullPath);
        if (leafMNode.getOffset() < 0L) {
            throw new MetadataException(String.format("TimeSeries [%s] does not have [%s] tag/attribute.", fullPath, oldKey), true);
        }
        this.tagManager.renameTagOrAttributeKey(oldKey, newKey, fullPath, leafMNode);
    }

    private void removeFromTagInvertedIndex(IMeasurementMNode node) throws IOException {
        this.tagManager.removeFromTagInvertedIndex(node);
    }

    @Override
    public IMNode getSeriesSchemasAndReadLockDevice(InsertPlan plan) throws MetadataException, IOException {
        boolean isDeviceInTemplate;
        PartialPath devicePath = plan.getDevicePath();
        String[] measurementList = plan.getMeasurements();
        IMeasurementMNode[] measurementMNodes = plan.getMeasurementMNodes();
        IMNode deviceMNode = this.getDeviceInTemplateIfUsingTemplate(devicePath, measurementList);
        boolean bl = isDeviceInTemplate = deviceMNode != null;
        if (!isDeviceInTemplate) {
            deviceMNode = this.getDeviceNodeWithAutoCreate(devicePath);
        }
        if (deviceMNode.isEntity()) {
            if (plan.isAligned()) {
                if (!deviceMNode.getAsEntityMNode().isAligned()) {
                    throw new MetadataException(String.format("Timeseries under path [%s] is not aligned , please set InsertPlan.isAligned() = false", plan.getDevicePath()));
                }
            } else if (deviceMNode.getAsEntityMNode().isAligned()) {
                throw new MetadataException(String.format("Timeseries under path [%s] is aligned , please set InsertPlan.isAligned() = true", plan.getDevicePath()));
            }
        }
        for (int i = 0; i < measurementList.length; ++i) {
            try {
                Pair<IMNode, IMeasurementMNode> pair = this.getMeasurementMNodeForInsertPlan(plan, i, deviceMNode, isDeviceInTemplate);
                deviceMNode = (IMNode)pair.left;
                IMeasurementMNode measurementMNode = (IMeasurementMNode)pair.right;
                if (!(plan instanceof InsertRowPlan) && !(plan instanceof InsertTabletPlan)) continue;
                try {
                    SchemaRegionUtils.checkDataTypeMatch(plan, i, measurementMNode.getSchema().getType());
                }
                catch (DataTypeMismatchException mismatchException) {
                    logger.warn(mismatchException.getMessage());
                    if (!config.isEnablePartialInsert()) {
                        throw mismatchException;
                    }
                    plan.markFailedMeasurementInsertion(i, (Exception)((Object)mismatchException));
                    continue;
                }
                measurementMNodes[i] = measurementMNode;
                measurementList[i] = measurementMNode.getName();
                continue;
            }
            catch (MetadataException e) {
                if (config.isClusterMode()) {
                    logger.debug("meet error when check {}.{}, message: {}", new Object[]{devicePath, measurementList[i], e.getMessage()});
                } else {
                    logger.warn("meet error when check {}.{}, message: {}", new Object[]{devicePath, measurementList[i], e.getMessage()});
                }
                if (config.isEnablePartialInsert()) {
                    plan.markFailedMeasurementInsertion(i, (Exception)((Object)e));
                    continue;
                }
                throw e;
            }
        }
        return deviceMNode;
    }

    private IMNode getDeviceInTemplateIfUsingTemplate(PartialPath devicePath, String[] measurementList) throws MetadataException, IOException {
        IMNode deviceMNode = null;
        int index = this.mtree.getMountedNodeIndexOnMeasurementPath(devicePath, measurementList);
        if (index == devicePath.getNodeLength()) {
            return null;
        }
        String[] mountedPathNodes = Arrays.copyOfRange(devicePath.getNodes(), 0, index + 1);
        IMNode mountedNode = this.getDeviceNodeWithAutoCreate(new PartialPath(mountedPathNodes));
        if (!mountedNode.isUseTemplate()) {
            mountedNode = this.setUsingSchemaTemplate(mountedNode);
        }
        if (index < devicePath.getNodeLength() - 1) {
            deviceMNode = mountedNode.getUpperTemplate().getPathNodeInTemplate(new PartialPath(Arrays.copyOfRange(devicePath.getNodes(), index + 1, devicePath.getNodeLength())));
        }
        return deviceMNode;
    }

    private Pair<IMNode, IMeasurementMNode> getMeasurementMNodeForInsertPlan(InsertPlan plan, int loc, IMNode deviceMNode, boolean isDeviceInTemplate) throws MetadataException {
        PartialPath devicePath = plan.getDevicePath();
        String[] measurementList = plan.getMeasurements();
        String measurement = measurementList[loc];
        IMeasurementMNode measurementMNode = null;
        if (isDeviceInTemplate) {
            measurementMNode = deviceMNode.getChild(measurement).getAsMeasurementMNode();
        } else {
            measurementMNode = this.getMeasurementMNode(deviceMNode, measurement);
            if (measurementMNode == null) {
                measurementMNode = this.findMeasurementInTemplate(deviceMNode, measurement);
            }
        }
        if (measurementMNode == null) {
            if (!config.isAutoCreateSchemaEnabled() || isDeviceInTemplate) {
                throw new PathNotExistException(devicePath + "." + measurement);
            }
            if (plan instanceof InsertRowPlan || plan instanceof InsertTabletPlan) {
                if (!plan.isAligned()) {
                    this.internalCreateTimeseries(devicePath.concatNode(measurement), plan.getDataTypes()[loc]);
                } else {
                    this.internalAlignedCreateTimeseries(devicePath, Collections.singletonList(measurement), Collections.singletonList(plan.getDataTypes()[loc]));
                }
                deviceMNode = this.mtree.getNodeByPath(devicePath);
                measurementMNode = this.getMeasurementMNode(deviceMNode, measurement);
            } else {
                throw new MetadataException(String.format("Only support insertRow and insertTablet, plan is [%s]", new Object[]{plan.getOperatorType()}));
            }
        }
        return new Pair((Object)deviceMNode, (Object)measurementMNode);
    }

    private IMeasurementMNode findMeasurementInTemplate(IMNode deviceMNode, String measurement) throws MetadataException {
        Template curTemplate = deviceMNode.getUpperTemplate();
        if (curTemplate == null) {
            return null;
        }
        IMeasurementSchema schema = curTemplate.getSchema(measurement);
        if (schema == null) {
            return null;
        }
        if (!deviceMNode.isUseTemplate()) {
            deviceMNode = this.setUsingSchemaTemplate(deviceMNode);
        }
        return MeasurementMNode.getMeasurementMNode(deviceMNode.getAsEntityMNode(), measurement, schema, null);
    }

    private void internalCreateTimeseries(PartialPath path, TSDataType dataType) throws MetadataException {
        this.createTimeseries(path, dataType, EncodingInferenceUtils.getDefaultEncoding(dataType), TSFileDescriptor.getInstance().getConfig().getCompressor(), Collections.emptyMap());
    }

    private void internalAlignedCreateTimeseries(PartialPath prefixPath, List<String> measurements, List<TSDataType> dataTypes) throws MetadataException {
        ArrayList<TSEncoding> encodings = new ArrayList<TSEncoding>();
        ArrayList<CompressionType> compressors = new ArrayList<CompressionType>();
        for (TSDataType dataType : dataTypes) {
            encodings.add(EncodingInferenceUtils.getDefaultEncoding(dataType));
            compressors.add(TSFileDescriptor.getInstance().getConfig().getCompressor());
        }
        this.createAlignedTimeSeries(prefixPath, measurements, dataTypes, encodings, compressors);
    }

    @Override
    public DeviceSchemaInfo getDeviceSchemaInfoWithAutoCreate(PartialPath devicePath, String[] measurements, Function<Integer, TSDataType> getDataType, boolean aligned) throws MetadataException {
        try {
            ArrayList<MeasurementSchemaInfo> measurementSchemaInfoList = new ArrayList<MeasurementSchemaInfo>(measurements.length);
            IMNode deviceMNode = this.getDeviceNodeWithAutoCreate(devicePath);
            for (int i = 0; i < measurements.length; ++i) {
                IMeasurementMNode measurementMNode = this.getMeasurementMNode(deviceMNode, measurements[i]);
                if (measurementMNode == null) {
                    if (config.isAutoCreateSchemaEnabled()) {
                        if (aligned) {
                            this.internalAlignedCreateTimeseries(devicePath, Collections.singletonList(measurements[i]), Collections.singletonList(getDataType.apply(i)));
                        } else {
                            this.internalCreateTimeseries(devicePath.concatNode(measurements[i]), getDataType.apply(i));
                        }
                        deviceMNode = this.mtree.getNodeByPath(devicePath);
                        measurementMNode = this.getMeasurementMNode(deviceMNode, measurements[i]);
                    } else {
                        throw new PathNotExistException(devicePath + "." + measurements[i]);
                    }
                }
                measurementSchemaInfoList.add(new MeasurementSchemaInfo(measurementMNode.getName(), (MeasurementSchema)measurementMNode.getSchema(), measurementMNode.getAlias()));
            }
            return new DeviceSchemaInfo(devicePath, deviceMNode.getAsEntityMNode().isAligned(), measurementSchemaInfoList);
        }
        catch (IOException e) {
            throw new MetadataException((Throwable)e);
        }
    }

    @Override
    public Set<String> getPathsSetTemplate(String templateName) throws MetadataException {
        return new HashSet<String>(this.mtree.getPathsSetOnTemplate(templateName));
    }

    @Override
    public Set<String> getPathsUsingTemplate(String templateName) throws MetadataException {
        return new HashSet<String>(this.mtree.getPathsUsingTemplate(templateName));
    }

    @Override
    public boolean isTemplateAppendable(Template template, List<String> measurements) throws MetadataException {
        return this.mtree.isTemplateAppendable(template, measurements);
    }

    @Override
    public synchronized void setSchemaTemplate(SetTemplatePlan plan) throws MetadataException {
        Template template = TemplateManager.getInstance().getTemplate(plan.getTemplateName());
        try {
            PartialPath path = new PartialPath(plan.getPrefixPath());
            this.mtree.checkTemplateOnPath(path);
            IMNode node = this.getDeviceNodeWithAutoCreate(path);
            TemplateManager.getInstance().checkIsTemplateCompatible(template, node);
            this.mtree.checkIsTemplateCompatibleWithChild(node, template);
            node.setSchemaTemplate(template);
            TemplateManager.getInstance().markSchemaRegion(template, this.storageGroupFullPath, this.schemaRegionId);
            this.writeToMLog(plan);
        }
        catch (IOException e) {
            throw new MetadataException((Throwable)e);
        }
    }

    @Override
    public synchronized void unsetSchemaTemplate(UnsetTemplatePlan plan) throws MetadataException {
        try {
            PartialPath path = new PartialPath(plan.getPrefixPath());
            IMNode node = this.mtree.getNodeByPath(path);
            if (node.getSchemaTemplate() == null) {
                throw new NoTemplateOnMNodeException(plan.getPrefixPath());
            }
            if (!node.getSchemaTemplate().getName().equals(plan.getTemplateName())) {
                throw new DifferentTemplateException(plan.getPrefixPath(), plan.getTemplateName());
            }
            if (node.isUseTemplate()) {
                throw new TemplateIsInUseException(plan.getPrefixPath());
            }
            this.mtree.checkTemplateInUseOnLowerNode(node);
            Template template = node.getSchemaTemplate();
            node.setSchemaTemplate(null);
            TemplateManager.getInstance().unmarkSchemaRegion(template, this.storageGroupFullPath, this.schemaRegionId);
            this.writeToMLog(plan);
        }
        catch (IOException e) {
            throw new MetadataException((Throwable)e);
        }
    }

    @Override
    public void setUsingSchemaTemplate(ActivateTemplatePlan plan) throws MetadataException {
        IMNode node;
        if (this.mtree.getTemplateOnPath(plan.getPrefixPath()) == null) {
            throw new MetadataException(String.format("Path [%s] has not been set any template.", plan.getPrefixPath().toString()));
        }
        try {
            node = this.getDeviceNodeWithAutoCreate(plan.getPrefixPath());
        }
        catch (IOException ioException) {
            throw new MetadataException((Throwable)ioException);
        }
        node = this.setUsingSchemaTemplate(node);
    }

    public IMNode setUsingSchemaTemplate(IMNode node) throws MetadataException {
        if (node.getUpperTemplate() == null) {
            throw new MetadataException(String.format("Path [%s] has not been set any template.", node.getFullPath()));
        }
        IMNode mountedMNode = this.mtree.checkTemplateAlignmentWithMountedNode(node, node.getUpperTemplate());
        if (mountedMNode.isEntity()) {
            mountedMNode.getAsEntityMNode().setAligned(node.isEntity() ? node.getAsEntityMNode().isAligned() : node.getUpperTemplate().isDirectAligned());
        }
        mountedMNode.setUseTemplate(true);
        if (node != mountedMNode) {
            this.mNodeCache.invalidate((Object)mountedMNode.getPartialPath());
        }
        try {
            this.writeToMLog(new ActivateTemplatePlan(node.getPartialPath()));
        }
        catch (IOException e) {
            throw new MetadataException((Throwable)e);
        }
        return mountedMNode;
    }

    @Override
    public void activateSchemaTemplate(ActivateTemplateInClusterPlan plan, Template template) throws MetadataException {
        try {
            if (plan.getPathSetTemplate().getFullPath().length() <= this.storageGroupFullPath.length()) {
                this.templateId = plan.getTemplateId();
            }
            this.getDeviceNodeWithAutoCreate(plan.getActivatePath());
            this.mtree.activateTemplate(plan.getActivatePath(), plan.getTemplateSetLevel(), template);
            this.writeToMLog(plan);
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            throw new MetadataException((Throwable)e);
        }
    }

    private void recoverActivatingSchemaTemplate(ActivateTemplateInClusterPlan plan) {
        if (plan.getPathSetTemplate().getFullPath().length() <= this.storageGroupFullPath.length()) {
            this.templateId = plan.getTemplateId();
        }
        this.mtree.activateTemplateWithoutCheck(plan.getActivatePath(), plan.getTemplateSetLevel(), plan.getTemplateId(), plan.isAligned());
    }

    @Override
    public List<String> getPathsUsingTemplate(int templateId) throws MetadataException {
        if (this.templateId != -1 && templateId != -2 && this.templateId != templateId) {
            return Collections.emptyList();
        }
        return this.mtree.getPathsUsingTemplate(templateId);
    }

    @Override
    public IMNode getMNodeForTrigger(PartialPath fullPath) throws MetadataException {
        return this.mtree.getNodeByPath(fullPath);
    }

    @Override
    public void releaseMNodeAfterDropTrigger(IMNode node) throws MetadataException {
    }
}

