/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.common.schematree;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.metadata.path.MeasurementPath;
import org.apache.iotdb.db.mpp.common.schematree.MeasurementSchemaInfo;
import org.apache.iotdb.tsfile.write.schema.IMeasurementSchema;
import org.apache.iotdb.tsfile.write.schema.MeasurementSchema;

public class DeviceSchemaInfo {
    private PartialPath devicePath;
    private boolean isAligned;
    private List<MeasurementSchemaInfo> measurementSchemaInfoList;
    private Map<String, MeasurementSchemaInfo> measurementSchemaInfoMap;
    private Map<String, MeasurementSchemaInfo> aliasMap;

    private DeviceSchemaInfo() {
    }

    public DeviceSchemaInfo(PartialPath devicePath, boolean isAligned, List<MeasurementSchemaInfo> measurementSchemaInfoList) {
        this.devicePath = devicePath;
        this.isAligned = isAligned;
        this.measurementSchemaInfoList = measurementSchemaInfoList;
    }

    public PartialPath getDevicePath() {
        return this.devicePath;
    }

    public boolean isAligned() {
        return this.isAligned;
    }

    public DeviceSchemaInfo getSubDeviceSchemaInfo(List<String> measurements) {
        DeviceSchemaInfo result = new DeviceSchemaInfo();
        result.devicePath = this.devicePath;
        result.isAligned = this.isAligned;
        ArrayList<MeasurementSchemaInfo> desiredMeasurementSchemaInfoList = new ArrayList<MeasurementSchemaInfo>(measurements.size());
        if (this.measurementSchemaInfoMap == null) {
            this.constructMap();
        }
        for (String measurement : measurements) {
            MeasurementSchemaInfo measurementSchemaInfo = this.measurementSchemaInfoMap.get(measurement);
            if (measurementSchemaInfo == null) {
                measurementSchemaInfo = this.aliasMap.get(measurement);
            }
            if (measurementSchemaInfo == null) {
                desiredMeasurementSchemaInfoList.add(null);
            }
            desiredMeasurementSchemaInfoList.add(measurementSchemaInfo);
        }
        result.measurementSchemaInfoList = desiredMeasurementSchemaInfoList;
        return result;
    }

    private void constructMap() {
        this.measurementSchemaInfoMap = new HashMap<String, MeasurementSchemaInfo>();
        this.aliasMap = new HashMap<String, MeasurementSchemaInfo>();
        this.measurementSchemaInfoList.forEach(measurementSchemaInfo -> {
            if (measurementSchemaInfo == null) {
                return;
            }
            this.measurementSchemaInfoMap.put(measurementSchemaInfo.getName(), (MeasurementSchemaInfo)measurementSchemaInfo);
            if (measurementSchemaInfo.getAlias() != null) {
                this.aliasMap.put(measurementSchemaInfo.getAlias(), (MeasurementSchemaInfo)measurementSchemaInfo);
            }
        });
    }

    public List<MeasurementSchema> getMeasurementSchemaList() {
        return this.measurementSchemaInfoList.stream().map(measurementSchemaInfo -> measurementSchemaInfo == null ? null : measurementSchemaInfo.getSchema()).collect(Collectors.toList());
    }

    public List<MeasurementPath> getMeasurements(Set<String> measurements) {
        if (measurements.contains("*")) {
            return this.measurementSchemaInfoList.stream().map(measurementInfo -> {
                if (measurementInfo == null) {
                    return null;
                }
                MeasurementPath measurementPath = new MeasurementPath(this.devicePath.concatNode(measurementInfo.getName()), (IMeasurementSchema)measurementInfo.getSchema());
                if (measurementInfo.getAlias() != null) {
                    measurementPath.setMeasurementAlias(measurementInfo.getAlias());
                }
                measurementPath.setUnderAlignedEntity(this.isAligned);
                return measurementPath;
            }).collect(Collectors.toList());
        }
        ArrayList<MeasurementPath> measurementPaths = new ArrayList<MeasurementPath>();
        for (MeasurementSchemaInfo measurementSchemaInfo : this.measurementSchemaInfoList) {
            MeasurementPath measurementPath = new MeasurementPath(this.devicePath.concatNode(measurementSchemaInfo.getName()), (IMeasurementSchema)measurementSchemaInfo.getSchema());
            measurementPath.setUnderAlignedEntity(this.isAligned);
            if (measurements.contains(measurementSchemaInfo.getName())) {
                measurementPaths.add(measurementPath);
                continue;
            }
            if (measurementSchemaInfo.getAlias() == null || !measurements.contains(measurementSchemaInfo.getAlias())) continue;
            measurementPath.setMeasurementAlias(measurementSchemaInfo.getAlias());
            measurementPaths.add(measurementPath);
        }
        return measurementPaths;
    }

    public MeasurementPath getPathByMeasurement(String measurementName) {
        for (MeasurementSchemaInfo measurementSchemaInfo : this.measurementSchemaInfoList) {
            MeasurementPath measurementPath = new MeasurementPath(this.devicePath.concatNode(measurementSchemaInfo.getName()), (IMeasurementSchema)measurementSchemaInfo.getSchema());
            measurementPath.setUnderAlignedEntity(this.isAligned);
            if (measurementSchemaInfo.getName().equals(measurementName)) {
                return measurementPath;
            }
            if (measurementSchemaInfo.getAlias() == null || !measurementSchemaInfo.getAlias().equals(measurementName)) continue;
            measurementPath.setMeasurementAlias(measurementSchemaInfo.getAlias());
            return measurementPath;
        }
        throw new SemanticException(String.format("ALIGN BY DEVICE: measurement '%s' does not exist in device '%s'", measurementName, this.getDevicePath()));
    }
}

