/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.schedule;

import org.apache.iotdb.db.mpp.execution.schedule.AbstractDriverThread;
import org.apache.iotdb.db.mpp.execution.schedule.ITaskScheduler;
import org.apache.iotdb.db.mpp.execution.schedule.queue.IndexedBlockingQueue;
import org.apache.iotdb.db.mpp.execution.schedule.task.DriverTask;

public class DriverTaskTimeoutSentinelThread
extends AbstractDriverThread {
    public DriverTaskTimeoutSentinelThread(String workerId, ThreadGroup tg, IndexedBlockingQueue<DriverTask> queue, ITaskScheduler scheduler) {
        super(workerId, tg, queue, scheduler);
    }

    @Override
    public void execute(DriverTask task) throws InterruptedException {
        task.lock();
        try {
            if (task.isEndState()) {
                return;
            }
        }
        finally {
            task.unlock();
        }
        long waitTime = task.getDDL() - System.currentTimeMillis();
        if (waitTime > 0L) {
            Thread.sleep(waitTime);
        }
        task.setAbortCause("timeout");
        this.scheduler.toAborted(task);
    }
}

