/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.analyze;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Set;
import java.util.TimeZone;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.partition.DataPartition;
import org.apache.iotdb.commons.partition.DataPartitionQueryParam;
import org.apache.iotdb.commons.partition.SchemaNodeManagementPartition;
import org.apache.iotdb.commons.partition.SchemaPartition;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.exception.metadata.template.TemplateImcompatibeException;
import org.apache.iotdb.db.exception.sql.MeasurementNotExistException;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.exception.sql.StatementAnalyzeException;
import org.apache.iotdb.db.metadata.MetadataConstant;
import org.apache.iotdb.db.metadata.path.MeasurementPath;
import org.apache.iotdb.db.metadata.template.Template;
import org.apache.iotdb.db.mpp.common.MPPQueryContext;
import org.apache.iotdb.db.mpp.common.header.ColumnHeader;
import org.apache.iotdb.db.mpp.common.header.DatasetHeader;
import org.apache.iotdb.db.mpp.common.header.DatasetHeaderFactory;
import org.apache.iotdb.db.mpp.common.schematree.DeviceSchemaInfo;
import org.apache.iotdb.db.mpp.common.schematree.ISchemaTree;
import org.apache.iotdb.db.mpp.common.schematree.PathPatternTree;
import org.apache.iotdb.db.mpp.plan.analyze.Analysis;
import org.apache.iotdb.db.mpp.plan.analyze.Analyzer;
import org.apache.iotdb.db.mpp.plan.analyze.ColumnPaginationController;
import org.apache.iotdb.db.mpp.plan.analyze.ConcatPathRewriter;
import org.apache.iotdb.db.mpp.plan.analyze.ExpressionAnalyzer;
import org.apache.iotdb.db.mpp.plan.analyze.ExpressionUtils;
import org.apache.iotdb.db.mpp.plan.analyze.GroupByLevelController;
import org.apache.iotdb.db.mpp.plan.analyze.IPartitionFetcher;
import org.apache.iotdb.db.mpp.plan.analyze.ISchemaFetcher;
import org.apache.iotdb.db.mpp.plan.analyze.QueryType;
import org.apache.iotdb.db.mpp.plan.analyze.TypeProvider;
import org.apache.iotdb.db.mpp.plan.expression.Expression;
import org.apache.iotdb.db.mpp.plan.expression.ExpressionType;
import org.apache.iotdb.db.mpp.plan.expression.leaf.TimeSeriesOperand;
import org.apache.iotdb.db.mpp.plan.expression.multi.FunctionExpression;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.FillDescriptor;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.GroupByTimeParameter;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.OrderByParameter;
import org.apache.iotdb.db.mpp.plan.statement.Statement;
import org.apache.iotdb.db.mpp.plan.statement.StatementNode;
import org.apache.iotdb.db.mpp.plan.statement.StatementVisitor;
import org.apache.iotdb.db.mpp.plan.statement.component.FillComponent;
import org.apache.iotdb.db.mpp.plan.statement.component.GroupByTimeComponent;
import org.apache.iotdb.db.mpp.plan.statement.component.Ordering;
import org.apache.iotdb.db.mpp.plan.statement.component.ResultColumn;
import org.apache.iotdb.db.mpp.plan.statement.component.SortItem;
import org.apache.iotdb.db.mpp.plan.statement.component.SortKey;
import org.apache.iotdb.db.mpp.plan.statement.component.WhereCondition;
import org.apache.iotdb.db.mpp.plan.statement.crud.DeleteDataStatement;
import org.apache.iotdb.db.mpp.plan.statement.crud.InsertMultiTabletsStatement;
import org.apache.iotdb.db.mpp.plan.statement.crud.InsertRowStatement;
import org.apache.iotdb.db.mpp.plan.statement.crud.InsertRowsOfOneDeviceStatement;
import org.apache.iotdb.db.mpp.plan.statement.crud.InsertRowsStatement;
import org.apache.iotdb.db.mpp.plan.statement.crud.InsertStatement;
import org.apache.iotdb.db.mpp.plan.statement.crud.InsertTabletStatement;
import org.apache.iotdb.db.mpp.plan.statement.crud.QueryStatement;
import org.apache.iotdb.db.mpp.plan.statement.internal.InternalCreateTimeSeriesStatement;
import org.apache.iotdb.db.mpp.plan.statement.internal.SchemaFetchStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.AlterTimeSeriesStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.CountDevicesStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.CountLevelTimeSeriesStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.CountNodesStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.CountStorageGroupStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.CountTimeSeriesStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.CreateAlignedTimeSeriesStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.CreateMultiTimeSeriesStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.CreateTimeSeriesStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.ShowChildNodesStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.ShowChildPathsStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.ShowClusterStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.ShowDevicesStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.ShowStorageGroupStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.ShowTTLStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.ShowTimeSeriesStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.template.ActivateTemplateStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.template.CreateSchemaTemplateStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.template.SetSchemaTemplateStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.template.ShowNodesInSchemaTemplateStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.template.ShowPathSetTemplateStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.template.ShowPathsUsingTemplateStatement;
import org.apache.iotdb.db.mpp.plan.statement.metadata.template.ShowSchemaTemplateStatement;
import org.apache.iotdb.db.mpp.plan.statement.sys.ExplainStatement;
import org.apache.iotdb.db.mpp.plan.statement.sys.ShowVersionStatement;
import org.apache.iotdb.db.mpp.plan.statement.sys.sync.ShowPipeSinkTypeStatement;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.filter.GroupByFilter;
import org.apache.iotdb.tsfile.read.filter.GroupByMonthFilter;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.filter.factory.FilterFactory;
import org.apache.iotdb.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AnalyzeVisitor
extends StatementVisitor<Analysis, MPPQueryContext> {
    private static final Logger logger = LoggerFactory.getLogger(Analyzer.class);
    private final IPartitionFetcher partitionFetcher;
    private final ISchemaFetcher schemaFetcher;
    private final TypeProvider typeProvider;
    private final MPPQueryContext context;

    public AnalyzeVisitor(IPartitionFetcher partitionFetcher, ISchemaFetcher schemaFetcher, TypeProvider typeProvider, MPPQueryContext context) {
        this.context = context;
        this.partitionFetcher = partitionFetcher;
        this.schemaFetcher = schemaFetcher;
        this.typeProvider = typeProvider;
    }

    private String getLogHeader() {
        return String.format("Query[%s]:", this.context.getQueryId());
    }

    @Override
    public Analysis visitNode(StatementNode node, MPPQueryContext context) {
        throw new UnsupportedOperationException("Unsupported statement type: " + node.getClass().getName());
    }

    @Override
    public Analysis visitExplain(ExplainStatement explainStatement, MPPQueryContext context) {
        Analysis analysis = this.visitQuery(explainStatement.getQueryStatement(), context);
        analysis.setStatement(explainStatement);
        analysis.setFinishQueryAfterAnalyze(true);
        return analysis;
    }

    @Override
    public Analysis visitQuery(QueryStatement queryStatement, MPPQueryContext context) {
        Analysis analysis = new Analysis();
        try {
            List<Pair<Expression, String>> outputExpressions;
            queryStatement.semanticCheck();
            PathPatternTree patternTree = new PathPatternTree();
            queryStatement = (QueryStatement)new ConcatPathRewriter().rewrite(queryStatement, patternTree);
            analysis.setStatement(queryStatement);
            logger.info("{} fetch query schema...", (Object)this.getLogHeader());
            ISchemaTree schemaTree = this.schemaFetcher.fetchSchema(patternTree);
            logger.info("{} fetch schema done", (Object)this.getLogHeader());
            if (schemaTree.isEmpty()) {
                if (queryStatement.isLastQuery()) {
                    analysis.setRespDatasetHeader(DatasetHeaderFactory.getLastQueryHeader());
                }
                analysis.setFinishQueryAfterAnalyze(true);
                return analysis;
            }
            Pair<Filter, Boolean> resultPair = this.analyzeGlobalTimeFilter(queryStatement);
            Filter globalTimeFilter = (Filter)resultPair.left;
            boolean hasValueFilter = (Boolean)resultPair.right;
            analysis.setGlobalTimeFilter(globalTimeFilter);
            analysis.setHasValueFilter(hasValueFilter);
            if (queryStatement.isLastQuery()) {
                if (hasValueFilter) {
                    throw new SemanticException("Only time filters are supported in LAST query");
                }
                analysis.setMergeOrderParameter(this.analyzeOrderBy(queryStatement));
                return this.analyzeLast(analysis, schemaTree.getAllMeasurement(), schemaTree);
            }
            if (queryStatement.isAlignByDevice()) {
                HashMap<String, Set<Expression>> deviceToTransformExpressions = new HashMap<String, Set<Expression>>();
                HashMap deviceToTransformExpressionsInHaving = new HashMap();
                Set<PartialPath> deviceList = this.analyzeFrom(queryStatement, schemaTree);
                HashMap<String, Set<String>> deviceToMeasurementsMap = new HashMap<String, Set<String>>();
                outputExpressions = this.analyzeSelect(queryStatement, schemaTree, deviceList, deviceToTransformExpressions, deviceToMeasurementsMap);
                if (queryStatement.hasHaving()) {
                    ArrayList<PartialPath> measurementNotExistDevices = new ArrayList<PartialPath>();
                    for (PartialPath device : deviceList) {
                        try {
                            deviceToTransformExpressionsInHaving.put(device.toString(), ExpressionAnalyzer.removeWildcardInFilterByDevice(queryStatement.getHavingCondition().getPredicate(), device, schemaTree, this.typeProvider, false).stream().collect(Collectors.toSet()));
                        }
                        catch (SemanticException e) {
                            if (e instanceof MeasurementNotExistException) {
                                logger.warn(e.getMessage());
                                measurementNotExistDevices.add(device);
                                continue;
                            }
                            throw e;
                        }
                    }
                    for (PartialPath measurementNotExistDevice : measurementNotExistDevices) {
                        deviceList.remove(measurementNotExistDevice);
                        deviceToTransformExpressions.remove(measurementNotExistDevice.getFullPath());
                    }
                }
                HashMap<String, List<Integer>> deviceToMeasurementIndexesMap = new HashMap<String, List<Integer>>();
                List allMeasurements = outputExpressions.stream().map(Pair::getLeft).map(Expression::getExpressionString).distinct().collect(Collectors.toList());
                for (String deviceName : deviceToMeasurementsMap.keySet()) {
                    ArrayList measurementsUnderDevice = new ArrayList((Collection)deviceToMeasurementsMap.get(deviceName));
                    ArrayList<Integer> indexes = new ArrayList<Integer>();
                    for (String measurement : measurementsUnderDevice) {
                        indexes.add(allMeasurements.indexOf(measurement) + 1);
                    }
                    deviceToMeasurementIndexesMap.put(deviceName, indexes);
                }
                analysis.setDeviceToMeasurementIndexesMap(deviceToMeasurementIndexesMap);
                HashMap<String, Set<Expression>> deviceToSourceExpressions = new HashMap<String, Set<Expression>>();
                boolean isValueFilterAggregation = queryStatement.isAggregationQuery() && hasValueFilter;
                HashMap<String, Boolean> deviceToIsRawDataSource = new HashMap<String, Boolean>();
                HashMap<String, Set<Expression>> deviceToAggregationExpressions = new HashMap<String, Set<Expression>>();
                HashMap<String, Set<Expression>> deviceToAggregationTransformExpressions = new HashMap<String, Set<Expression>>();
                HashMap<String, Expression> deviceToHavingExpression = new HashMap<String, Expression>();
                for (String deviceName : deviceToTransformExpressions.keySet()) {
                    Set transformExpressions = (Set)deviceToTransformExpressions.get(deviceName);
                    Set transformExpressionsInHaving = (Set)deviceToTransformExpressionsInHaving.get(deviceName);
                    LinkedHashSet<Expression> aggregationExpressions = new LinkedHashSet<Expression>();
                    LinkedHashSet<Expression> aggregationTransformExpressions = new LinkedHashSet<Expression>();
                    boolean isHasRawDataInputAggregation = false;
                    if (queryStatement.isAggregationQuery()) {
                        isHasRawDataInputAggregation = this.analyzeAggregation(transformExpressions, aggregationExpressions, aggregationTransformExpressions);
                        if (queryStatement.hasHaving() && transformExpressionsInHaving != null) {
                            ArrayList<Expression> aggregationExpressionsInHaving = new ArrayList<Expression>();
                            isHasRawDataInputAggregation |= this.analyzeAggregationInHaving(transformExpressionsInHaving, aggregationExpressionsInHaving, aggregationExpressions, aggregationTransformExpressions);
                            Expression havingExpression = this.analyzeHavingSplitByDevice(transformExpressionsInHaving);
                            havingExpression.inferTypes(this.typeProvider);
                            deviceToHavingExpression.put(deviceName, havingExpression);
                        }
                        deviceToAggregationExpressions.put(deviceName, aggregationExpressions);
                        deviceToAggregationTransformExpressions.put(deviceName, aggregationTransformExpressions);
                    }
                    boolean isRawDataSource = !queryStatement.isAggregationQuery() || isValueFilterAggregation || isHasRawDataInputAggregation;
                    for (Expression expression : transformExpressions) {
                        this.updateSource(expression, deviceToSourceExpressions.computeIfAbsent(deviceName, key -> new LinkedHashSet()), isRawDataSource);
                    }
                    if (queryStatement.hasHaving() && transformExpressionsInHaving != null) {
                        for (Expression expression : transformExpressionsInHaving) {
                            this.updateSource(expression, deviceToSourceExpressions.computeIfAbsent(deviceName, key -> new LinkedHashSet()), isRawDataSource);
                        }
                    }
                    deviceToIsRawDataSource.put(deviceName, isRawDataSource);
                }
                analysis.setDeviceToAggregationExpressions(deviceToAggregationExpressions);
                analysis.setDeviceToAggregationTransformExpressions(deviceToAggregationTransformExpressions);
                analysis.setDeviceToIsRawDataSource(deviceToIsRawDataSource);
                analysis.setDeviceToHavingExpression(deviceToHavingExpression);
                if (queryStatement.getWhereCondition() != null) {
                    HashMap<String, Expression> deviceToQueryFilter = new HashMap<String, Expression>();
                    Iterator<PartialPath> deviceIterator = deviceList.iterator();
                    while (deviceIterator.hasNext()) {
                        PartialPath devicePath = deviceIterator.next();
                        Expression queryFilter = null;
                        try {
                            queryFilter = this.analyzeWhereSplitByDevice(queryStatement, devicePath, schemaTree);
                        }
                        catch (SemanticException e) {
                            if (e instanceof MeasurementNotExistException) {
                                logger.warn(e.getMessage());
                                deviceIterator.remove();
                                deviceToSourceExpressions.remove(devicePath.getFullPath());
                                continue;
                            }
                            throw e;
                        }
                        deviceToQueryFilter.put(devicePath.getFullPath(), queryFilter);
                        queryFilter.inferTypes(this.typeProvider);
                        this.updateSource(queryFilter, deviceToSourceExpressions.computeIfAbsent(devicePath.getFullPath(), key -> new LinkedHashSet()), true);
                    }
                    analysis.setDeviceToQueryFilter(deviceToQueryFilter);
                }
                analysis.setDeviceToSourceExpressions(deviceToSourceExpressions);
                analysis.setDeviceToTransformExpressions(deviceToTransformExpressions);
            } else {
                Set<Expression> transformExpressionsInHaving;
                outputExpressions = this.analyzeSelect(queryStatement, schemaTree);
                Set transformExpressions = outputExpressions.stream().map(Pair::getLeft).collect(Collectors.toCollection(LinkedHashSet::new));
                Set<Expression> set = transformExpressionsInHaving = queryStatement.hasHaving() ? ExpressionAnalyzer.removeWildcardInFilter(queryStatement.getHavingCondition().getPredicate(), queryStatement.getFromComponent().getPrefixPaths(), schemaTree, this.typeProvider, false).stream().collect(Collectors.toSet()) : null;
                if (queryStatement.isGroupByLevel()) {
                    HashMap<Expression, Expression> rawPathToGroupedPathMap = new HashMap<Expression, Expression>();
                    Map<Expression, Set<Expression>> groupByLevelExpressions = this.analyzeGroupByLevel(queryStatement, outputExpressions, transformExpressions, rawPathToGroupedPathMap);
                    analysis.setGroupByLevelExpressions(groupByLevelExpressions);
                    analysis.setRawPathToGroupedPathMap(rawPathToGroupedPathMap);
                }
                boolean isHasRawDataInputAggregation = false;
                if (queryStatement.isAggregationQuery()) {
                    HashSet<Expression> aggregationExpressions = new HashSet<Expression>();
                    HashSet<Expression> aggregationTransformExpressions = new HashSet<Expression>();
                    ArrayList<Expression> aggregationExpressionsInHaving = new ArrayList<Expression>();
                    isHasRawDataInputAggregation = this.analyzeAggregation(transformExpressions, aggregationExpressions, aggregationTransformExpressions);
                    if (queryStatement.hasHaving()) {
                        isHasRawDataInputAggregation |= this.analyzeAggregationInHaving(transformExpressionsInHaving, aggregationExpressionsInHaving, aggregationExpressions, aggregationTransformExpressions);
                        Expression havingExpression = this.analyzeHaving(queryStatement, analysis.getGroupByLevelExpressions(), transformExpressionsInHaving, aggregationExpressionsInHaving);
                        havingExpression.inferTypes(this.typeProvider);
                        analysis.setHavingExpression(havingExpression);
                    }
                    analysis.setAggregationExpressions(aggregationExpressions);
                    analysis.setAggregationTransformExpressions(aggregationTransformExpressions);
                }
                HashSet<Expression> sourceExpressions = new HashSet<Expression>();
                boolean isValueFilterAggregation = queryStatement.isAggregationQuery() && hasValueFilter;
                boolean isRawDataSource = !queryStatement.isAggregationQuery() || isValueFilterAggregation || isHasRawDataInputAggregation;
                for (Expression expression : transformExpressions) {
                    this.updateSource(expression, sourceExpressions, isRawDataSource);
                }
                if (queryStatement.hasHaving()) {
                    for (Expression expression : transformExpressionsInHaving) {
                        this.updateSource(expression, sourceExpressions, isRawDataSource);
                    }
                }
                if (queryStatement.getWhereCondition() != null) {
                    Expression queryFilter = this.analyzeWhere(queryStatement, schemaTree);
                    queryFilter.inferTypes(this.typeProvider);
                    this.updateSource(queryFilter, sourceExpressions, isRawDataSource);
                    analysis.setQueryFilter(queryFilter);
                }
                analysis.setRawDataSource(isRawDataSource);
                analysis.setSourceExpressions(sourceExpressions);
                analysis.setTransformExpressions(transformExpressions);
            }
            if (queryStatement.isGroupByTime()) {
                GroupByTimeComponent groupByTimeComponent = queryStatement.getGroupByTimeComponent();
                if ((groupByTimeComponent.isIntervalByMonth() || groupByTimeComponent.isSlidingStepByMonth()) && queryStatement.getResultTimeOrder() == Ordering.DESC) {
                    throw new SemanticException("Group by month doesn't support order by time desc now.");
                }
                analysis.setGroupByTimeParameter(new GroupByTimeParameter(groupByTimeComponent));
            }
            if (queryStatement.getFillComponent() != null) {
                FillComponent fillComponent = queryStatement.getFillComponent();
                List fillColumnList = outputExpressions.stream().map(Pair::getLeft).distinct().collect(Collectors.toList());
                analysis.setFillDescriptor(new FillDescriptor(fillComponent.getFillPolicy(), fillComponent.getFillValue()));
            }
            DatasetHeader datasetHeader = this.analyzeOutput(queryStatement, outputExpressions);
            analysis.setRespDatasetHeader(datasetHeader);
            analysis.setTypeProvider(this.typeProvider);
            HashSet<String> deviceSet = new HashSet();
            if (queryStatement.isAlignByDevice()) {
                deviceSet = analysis.getDeviceToSourceExpressions().keySet();
            } else {
                for (Expression expression : analysis.getSourceExpressions()) {
                    deviceSet.add(ExpressionAnalyzer.getDeviceNameInSourceExpression(expression));
                }
            }
            DataPartition dataPartition = this.fetchDataPartitionByDevices(deviceSet, schemaTree);
            analysis.setDataPartitionInfo(dataPartition);
        }
        catch (StatementAnalyzeException e) {
            logger.error("Meet error when analyzing the query statement: ", (Throwable)e);
            throw new StatementAnalyzeException("Meet error when analyzing the query statement: " + e.getMessage());
        }
        return analysis;
    }

    private List<Pair<Expression, String>> analyzeSelect(QueryStatement queryStatement, ISchemaTree schemaTree) {
        ArrayList<Pair<Expression, String>> outputExpressions = new ArrayList<Pair<Expression, String>>();
        boolean isGroupByLevel = queryStatement.isGroupByLevel();
        ColumnPaginationController paginationController = new ColumnPaginationController(queryStatement.getSeriesLimit(), queryStatement.getSeriesOffset(), queryStatement.isLastQuery() || isGroupByLevel);
        block0: for (ResultColumn resultColumn : queryStatement.getSelectComponent().getResultColumns()) {
            boolean hasAlias = resultColumn.hasAlias();
            List<Expression> resultExpressions = ExpressionAnalyzer.removeWildcardInExpression(resultColumn.getExpression(), schemaTree);
            if (hasAlias && !queryStatement.isGroupByLevel() && resultExpressions.size() > 1) {
                throw new SemanticException(String.format("alias '%s' can only be matched with one time series", resultColumn.getAlias()));
            }
            for (Expression expression : resultExpressions) {
                if (paginationController.hasCurOffset()) {
                    paginationController.consumeOffset();
                    continue;
                }
                if (!paginationController.hasCurLimit()) continue block0;
                if (isGroupByLevel) {
                    ExpressionAnalyzer.updateTypeProvider(expression, this.typeProvider);
                    expression.inferTypes(this.typeProvider);
                    outputExpressions.add((Pair<Expression, String>)new Pair((Object)expression, (Object)resultColumn.getAlias()));
                    if (resultColumn.getExpression() instanceof FunctionExpression) {
                        queryStatement.getGroupByLevelComponent().updateIsCountStar((FunctionExpression)resultColumn.getExpression());
                    }
                } else {
                    Expression expressionWithoutAlias = ExpressionAnalyzer.removeAliasFromExpression(expression);
                    String alias = !Objects.equals(expressionWithoutAlias, expression) ? expression.getExpressionString() : null;
                    alias = hasAlias ? resultColumn.getAlias() : alias;
                    ExpressionAnalyzer.updateTypeProvider(expressionWithoutAlias, this.typeProvider);
                    expressionWithoutAlias.inferTypes(this.typeProvider);
                    outputExpressions.add((Pair<Expression, String>)new Pair((Object)expressionWithoutAlias, (Object)alias));
                }
                paginationController.consumeLimit();
            }
        }
        return outputExpressions;
    }

    private Set<PartialPath> analyzeFrom(QueryStatement queryStatement, ISchemaTree schemaTree) {
        List<PartialPath> devicePatternList = queryStatement.getFromComponent().getPrefixPaths();
        LinkedHashSet<PartialPath> deviceList = new LinkedHashSet<PartialPath>();
        for (PartialPath devicePattern : devicePatternList) {
            deviceList.addAll(schemaTree.getMatchedDevices(devicePattern).stream().map(DeviceSchemaInfo::getDevicePath).collect(Collectors.toList()));
        }
        return deviceList;
    }

    private List<Pair<Expression, String>> analyzeSelect(QueryStatement queryStatement, ISchemaTree schemaTree, Set<PartialPath> deviceList, Map<String, Set<Expression>> deviceToTransformExpressions, Map<String, Set<String>> deviceToMeasurementsMap) {
        ArrayList<Pair<Expression, String>> outputExpressions = new ArrayList<Pair<Expression, String>>();
        ColumnPaginationController paginationController = new ColumnPaginationController(queryStatement.getSeriesLimit(), queryStatement.getSeriesOffset(), false);
        block0: for (ResultColumn resultColumn : queryStatement.getSelectComponent().getResultColumns()) {
            Expression selectExpression = resultColumn.getExpression();
            boolean hasAlias = resultColumn.hasAlias();
            LinkedHashMap<Expression, Map> measurementToDeviceTransformExpressions = new LinkedHashMap<Expression, Map>();
            for (PartialPath device : deviceList) {
                List<Expression> transformExpressions = ExpressionAnalyzer.concatDeviceAndRemoveWildcard(selectExpression, device, schemaTree, this.typeProvider);
                for (Expression transformExpression : transformExpressions) {
                    measurementToDeviceTransformExpressions.computeIfAbsent(ExpressionAnalyzer.getMeasurementExpression(transformExpression), key -> new LinkedHashMap()).put(device.getFullPath(), ExpressionAnalyzer.removeAliasFromExpression(transformExpression));
                }
            }
            if (hasAlias && measurementToDeviceTransformExpressions.keySet().size() > 1) {
                throw new SemanticException(String.format("alias '%s' can only be matched with one time series", resultColumn.getAlias()));
            }
            for (Expression measurementExpression : measurementToDeviceTransformExpressions.keySet()) {
                if (paginationController.hasCurOffset()) {
                    paginationController.consumeOffset();
                    continue;
                }
                if (!paginationController.hasCurLimit()) continue block0;
                Map deviceToTransformExpressionOfOneMeasurement = (Map)measurementToDeviceTransformExpressions.get(measurementExpression);
                deviceToTransformExpressionOfOneMeasurement.values().forEach(expression -> expression.inferTypes(this.typeProvider));
                this.checkDataTypeConsistencyInAlignByDevice(new ArrayList<Expression>(deviceToTransformExpressionOfOneMeasurement.values()));
                Expression measurementExpressionWithoutAlias = ExpressionAnalyzer.removeAliasFromExpression(measurementExpression);
                String alias = !Objects.equals(measurementExpressionWithoutAlias, measurementExpression) ? measurementExpression.getExpressionString() : null;
                alias = hasAlias ? resultColumn.getAlias() : alias;
                ExpressionAnalyzer.updateTypeProvider(measurementExpressionWithoutAlias, this.typeProvider);
                measurementExpressionWithoutAlias.inferTypes(this.typeProvider);
                outputExpressions.add((Pair<Expression, String>)new Pair((Object)measurementExpressionWithoutAlias, (Object)alias));
                for (String deviceName : deviceToTransformExpressionOfOneMeasurement.keySet()) {
                    Expression transformExpression = (Expression)deviceToTransformExpressionOfOneMeasurement.get(deviceName);
                    ExpressionAnalyzer.updateTypeProvider(transformExpression, this.typeProvider);
                    transformExpression.inferTypes(this.typeProvider);
                    deviceToTransformExpressions.computeIfAbsent(deviceName, key -> new LinkedHashSet()).add(ExpressionAnalyzer.removeAliasFromExpression(transformExpression));
                    deviceToMeasurementsMap.computeIfAbsent(deviceName, key -> new LinkedHashSet()).add(measurementExpressionWithoutAlias.getExpressionString());
                }
                paginationController.consumeLimit();
            }
        }
        return outputExpressions;
    }

    private Pair<Filter, Boolean> analyzeGlobalTimeFilter(QueryStatement queryStatement) {
        Object globalTimeFilter = null;
        boolean hasValueFilter = false;
        if (queryStatement.getWhereCondition() != null) {
            Expression predicate = queryStatement.getWhereCondition().getPredicate();
            WhereCondition whereCondition = queryStatement.getWhereCondition();
            Pair<Filter, Boolean> resultPair = ExpressionAnalyzer.transformToGlobalTimeFilter(predicate, true, true);
            if ((predicate = ExpressionAnalyzer.evaluatePredicate(predicate)).getExpressionType().equals((Object)ExpressionType.CONSTANT) && Boolean.parseBoolean(predicate.getExpressionString())) {
                queryStatement.setWhereCondition(null);
            } else {
                whereCondition.setPredicate(predicate);
            }
            globalTimeFilter = (Filter)resultPair.left;
            hasValueFilter = (Boolean)resultPair.right;
        }
        if (queryStatement.isGroupByTime()) {
            GroupByTimeComponent groupByTimeComponent = queryStatement.getGroupByTimeComponent();
            GroupByFilter groupByFilter = this.initGroupByFilter(groupByTimeComponent);
            globalTimeFilter = globalTimeFilter == null ? groupByFilter : FilterFactory.and((Filter)globalTimeFilter, (Filter)groupByFilter);
        }
        return new Pair(globalTimeFilter, (Object)hasValueFilter);
    }

    private void updateSource(Expression selectExpr, Set<Expression> sourceExpressions, boolean isRawDataSource) {
        sourceExpressions.addAll(ExpressionAnalyzer.searchSourceExpressions(selectExpr, isRawDataSource));
    }

    private boolean analyzeAggregation(Set<Expression> transformExpressions, Set<Expression> aggregationExpressions, Set<Expression> aggregationTransformExpressions) {
        boolean isHasRawDataInputAggregation = false;
        for (Expression expression : transformExpressions) {
            for (Expression aggregationExpression : ExpressionAnalyzer.searchAggregationExpressions(expression)) {
                aggregationExpressions.add(aggregationExpression);
                aggregationTransformExpressions.addAll(aggregationExpression.getExpressions());
            }
        }
        for (Expression aggregationTransformExpression : aggregationTransformExpressions) {
            if (!ExpressionAnalyzer.checkIsNeedTransform(aggregationTransformExpression)) continue;
            isHasRawDataInputAggregation = true;
            break;
        }
        return isHasRawDataInputAggregation;
    }

    private boolean analyzeAggregationInHaving(Set<Expression> expressions, List<Expression> aggregationExpressionsInHaving, Set<Expression> aggregationExpressions, Set<Expression> aggregationTransformExpressions) {
        boolean isHasRawDataInputAggregation = false;
        for (Expression expression : expressions) {
            for (Expression aggregationExpression : ExpressionAnalyzer.searchAggregationExpressions(expression)) {
                aggregationExpressionsInHaving.add(aggregationExpression);
                aggregationExpressions.add(aggregationExpression);
                aggregationTransformExpressions.addAll(aggregationExpression.getExpressions());
            }
        }
        for (Expression aggregationTransformExpression : aggregationTransformExpressions) {
            if (!ExpressionAnalyzer.checkIsNeedTransform(aggregationTransformExpression)) continue;
            isHasRawDataInputAggregation = true;
            break;
        }
        return isHasRawDataInputAggregation;
    }

    private Expression analyzeWhere(QueryStatement queryStatement, ISchemaTree schemaTree) {
        List<Expression> rewrittenPredicates = ExpressionAnalyzer.removeWildcardInFilter(queryStatement.getWhereCondition().getPredicate(), queryStatement.getFromComponent().getPrefixPaths(), schemaTree, this.typeProvider, true);
        return ExpressionUtils.constructQueryFilter(rewrittenPredicates.stream().distinct().collect(Collectors.toList()));
    }

    private Expression analyzeWhereSplitByDevice(QueryStatement queryStatement, PartialPath devicePath, ISchemaTree schemaTree) {
        List<Expression> rewrittenPredicates = ExpressionAnalyzer.removeWildcardInFilterByDevice(queryStatement.getWhereCondition().getPredicate(), devicePath, schemaTree, this.typeProvider, true);
        return ExpressionUtils.constructQueryFilter(rewrittenPredicates.stream().distinct().collect(Collectors.toList()));
    }

    private Expression analyzeHaving(QueryStatement queryStatement, Map<Expression, Set<Expression>> groupByLevelExpressions, Set<Expression> transformExpressionsInHaving, List<Expression> aggregationExpressionsInHaving) {
        if (queryStatement.isGroupByLevel()) {
            Map<Expression, Expression> rawPathToGroupedPathMapInHaving = this.analyzeGroupByLevelInHaving(queryStatement, aggregationExpressionsInHaving, groupByLevelExpressions);
            ArrayList<Expression> convertedPredicates = new ArrayList<Expression>();
            for (Expression expression : transformExpressionsInHaving) {
                convertedPredicates.add(ExpressionAnalyzer.replaceRawPathWithGroupedPath(expression, rawPathToGroupedPathMapInHaving));
            }
            return ExpressionUtils.constructQueryFilter(convertedPredicates.stream().distinct().collect(Collectors.toList()));
        }
        return ExpressionUtils.constructQueryFilter(transformExpressionsInHaving.stream().distinct().collect(Collectors.toList()));
    }

    private Expression analyzeHavingSplitByDevice(Set<Expression> transformExpressionsInHaving) {
        return ExpressionUtils.constructQueryFilter(transformExpressionsInHaving.stream().distinct().collect(Collectors.toList()));
    }

    private Map<Expression, Expression> analyzeGroupByLevelInHaving(QueryStatement queryStatement, List<Expression> inputExpressions, Map<Expression, Set<Expression>> groupByLevelExpressions) {
        GroupByLevelController groupByLevelController = new GroupByLevelController(queryStatement.getGroupByLevelComponent().getLevels(), this.typeProvider);
        for (Expression inputExpression : inputExpressions) {
            groupByLevelController.control(false, inputExpression, null);
        }
        Map<Expression, Set<Expression>> groupedPathMap = groupByLevelController.getGroupedPathMap();
        groupByLevelExpressions.putAll(groupedPathMap);
        return groupByLevelController.getRawPathToGroupedPathMap();
    }

    private Map<Expression, Set<Expression>> analyzeGroupByLevel(QueryStatement queryStatement, List<Pair<Expression, String>> outputExpressions, Set<Expression> transformExpressions, Map<Expression, Expression> rawPathToGroupedPathMap) {
        GroupByLevelController groupByLevelController = new GroupByLevelController(queryStatement.getGroupByLevelComponent().getLevels(), this.typeProvider);
        for (int i = 0; i < outputExpressions.size(); ++i) {
            Pair<Expression, String> measurementWithAlias = outputExpressions.get(i);
            boolean isCountStar = queryStatement.getGroupByLevelComponent().isCountStar(i);
            groupByLevelController.control(isCountStar, (Expression)measurementWithAlias.left, (String)measurementWithAlias.right);
        }
        Map<Expression, Set<Expression>> rawGroupByLevelExpressions = groupByLevelController.getGroupedPathMap();
        rawPathToGroupedPathMap.putAll(groupByLevelController.getRawPathToGroupedPathMap());
        LinkedHashMap<Expression, Set<Expression>> groupByLevelExpressions = new LinkedHashMap<Expression, Set<Expression>>();
        outputExpressions.clear();
        ColumnPaginationController paginationController = new ColumnPaginationController(queryStatement.getSeriesLimit(), queryStatement.getSeriesOffset(), false);
        for (Expression groupedExpression : rawGroupByLevelExpressions.keySet()) {
            if (paginationController.hasCurOffset()) {
                paginationController.consumeOffset();
                continue;
            }
            if (!paginationController.hasCurLimit()) break;
            Pair<Expression, String> outputExpression = this.removeAliasFromExpression(groupedExpression, groupByLevelController.getAlias(groupedExpression.getExpressionString()));
            Expression groupedExpressionWithoutAlias = (Expression)outputExpression.left;
            Set<Expression> rawExpressions = rawGroupByLevelExpressions.get(groupedExpression);
            rawExpressions.forEach(expression -> ExpressionAnalyzer.updateTypeProvider(expression, this.typeProvider));
            rawExpressions.forEach(expression -> expression.inferTypes(this.typeProvider));
            Set<Expression> rawExpressionsWithoutAlias = rawExpressions.stream().map(ExpressionAnalyzer::removeAliasFromExpression).collect(Collectors.toSet());
            rawExpressionsWithoutAlias.forEach(expression -> ExpressionAnalyzer.updateTypeProvider(expression, this.typeProvider));
            rawExpressionsWithoutAlias.forEach(expression -> expression.inferTypes(this.typeProvider));
            groupByLevelExpressions.put(groupedExpressionWithoutAlias, rawExpressionsWithoutAlias);
            TSDataType dataType = this.typeProvider.getType(((Expression)new ArrayList((Collection)groupByLevelExpressions.get(groupedExpressionWithoutAlias)).get(0)).getExpressionString());
            this.typeProvider.setType(groupedExpression.getExpressionString(), dataType);
            this.typeProvider.setType(groupedExpressionWithoutAlias.getExpressionString(), dataType);
            outputExpressions.add(outputExpression);
            paginationController.consumeLimit();
        }
        transformExpressions.clear();
        transformExpressions.addAll(groupByLevelExpressions.values().stream().flatMap(Collection::stream).collect(Collectors.toSet()));
        return groupByLevelExpressions;
    }

    private Pair<Expression, String> removeAliasFromExpression(Expression rawExpression, String rawAlias) {
        Expression expressionWithoutAlias = ExpressionAnalyzer.removeAliasFromExpression(rawExpression);
        String alias = !Objects.equals(expressionWithoutAlias, rawExpression) ? rawExpression.getExpressionString() : null;
        alias = rawAlias == null ? alias : rawAlias;
        return new Pair((Object)expressionWithoutAlias, (Object)alias);
    }

    private DatasetHeader analyzeOutput(QueryStatement queryStatement, List<Pair<Expression, String>> outputExpressions) {
        boolean isIgnoreTimestamp = queryStatement.isAggregationQuery() && !queryStatement.isGroupByTime();
        ArrayList<ColumnHeader> columnHeaders = new ArrayList<ColumnHeader>();
        if (queryStatement.isAlignByDevice()) {
            columnHeaders.add(new ColumnHeader("Device", TSDataType.TEXT, null));
            this.typeProvider.setType("Device", TSDataType.TEXT);
        }
        columnHeaders.addAll(outputExpressions.stream().map(expressionWithAlias -> {
            String columnName = ((Expression)expressionWithAlias.left).getExpressionString();
            String alias = (String)expressionWithAlias.right;
            return new ColumnHeader(columnName, this.typeProvider.getType(columnName), alias);
        }).collect(Collectors.toList()));
        return new DatasetHeader(columnHeaders, isIgnoreTimestamp);
    }

    private Analysis analyzeLast(Analysis analysis, List<MeasurementPath> allSelectedPath, ISchemaTree schemaTree) {
        Set sourceExpressions;
        List<SortItem> sortItemList = analysis.getMergeOrderParameter().getSortItemList();
        if (sortItemList.size() > 0) {
            Preconditions.checkState((sortItemList.size() == 1 && sortItemList.get(0).getSortKey() == SortKey.TIMESERIES ? 1 : 0) != 0, (Object)"Last queries only support sorting by timeseries now.");
            boolean isAscending = sortItemList.get(0).getOrdering() == Ordering.ASC;
            sourceExpressions = allSelectedPath.stream().map(TimeSeriesOperand::new).sorted((o1, o2) -> isAscending ? o1.getExpressionString().compareTo(o2.getExpressionString()) : o2.getExpressionString().compareTo(o1.getExpressionString())).collect(Collectors.toCollection(LinkedHashSet::new));
        } else {
            sourceExpressions = allSelectedPath.stream().map(TimeSeriesOperand::new).collect(Collectors.toCollection(LinkedHashSet::new));
        }
        sourceExpressions.forEach(expression -> ExpressionAnalyzer.updateTypeProvider(expression, this.typeProvider));
        analysis.setSourceExpressions(sourceExpressions);
        analysis.setRespDatasetHeader(DatasetHeaderFactory.getLastQueryHeader());
        this.typeProvider.setType("timeseries", TSDataType.TEXT);
        this.typeProvider.setType("value", TSDataType.TEXT);
        this.typeProvider.setType("dataType", TSDataType.TEXT);
        Set deviceSet = allSelectedPath.stream().map(PartialPath::getDevice).collect(Collectors.toSet());
        HashMap<String, List<DataPartitionQueryParam>> sgNameToQueryParamsMap = new HashMap<String, List<DataPartitionQueryParam>>();
        for (String devicePath : deviceSet) {
            DataPartitionQueryParam queryParam = new DataPartitionQueryParam();
            queryParam.setDevicePath(devicePath);
            sgNameToQueryParamsMap.computeIfAbsent(schemaTree.getBelongedStorageGroup(devicePath), key -> new ArrayList()).add(queryParam);
        }
        DataPartition dataPartition = this.partitionFetcher.getDataPartition(sgNameToQueryParamsMap);
        analysis.setDataPartitionInfo(dataPartition);
        return analysis;
    }

    private DataPartition fetchDataPartitionByDevices(Set<String> deviceSet, ISchemaTree schemaTree) {
        HashMap<String, List<DataPartitionQueryParam>> sgNameToQueryParamsMap = new HashMap<String, List<DataPartitionQueryParam>>();
        for (String devicePath : deviceSet) {
            DataPartitionQueryParam queryParam = new DataPartitionQueryParam();
            queryParam.setDevicePath(devicePath);
            sgNameToQueryParamsMap.computeIfAbsent(schemaTree.getBelongedStorageGroup(devicePath), key -> new ArrayList()).add(queryParam);
        }
        return this.partitionFetcher.getDataPartition(sgNameToQueryParamsMap);
    }

    private OrderByParameter analyzeOrderBy(QueryStatement queryStatement) {
        return new OrderByParameter(queryStatement.getSortItemList());
    }

    private void checkDataTypeConsistencyInAlignByDevice(List<Expression> expressions) {
        TSDataType checkedDataType = this.typeProvider.getType(expressions.get(0).getExpressionString());
        for (Expression expression : expressions) {
            if (this.typeProvider.getType(expression.getExpressionString()) == checkedDataType) continue;
            throw new SemanticException("ALIGN BY DEVICE: the data types of the same measurement column should be the same across devices.");
        }
    }

    @Override
    public Analysis visitInsert(InsertStatement insertStatement, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        insertStatement.semanticCheck();
        long[] timeArray = insertStatement.getTimes();
        PartialPath devicePath = insertStatement.getDevice();
        String[] measurementList = insertStatement.getMeasurementList();
        if (timeArray.length == 1) {
            InsertRowStatement insertRowStatement = new InsertRowStatement();
            insertRowStatement.setDevicePath(devicePath);
            insertRowStatement.setTime(timeArray[0]);
            insertRowStatement.setMeasurements(measurementList);
            insertRowStatement.setDataTypes(new TSDataType[measurementList.length]);
            Object[] values = new Object[measurementList.length];
            System.arraycopy(insertStatement.getValuesList().get(0), 0, values, 0, values.length);
            insertRowStatement.setValues(values);
            insertRowStatement.setNeedInferType(true);
            insertRowStatement.setAligned(insertStatement.isAligned());
            return insertRowStatement.accept(this, context);
        }
        InsertRowsStatement insertRowsStatement = new InsertRowsStatement();
        ArrayList<InsertRowStatement> insertRowStatementList = new ArrayList<InsertRowStatement>();
        for (int i = 0; i < timeArray.length; ++i) {
            InsertRowStatement statement = new InsertRowStatement();
            statement.setDevicePath(devicePath);
            String[] measurements = new String[measurementList.length];
            System.arraycopy(measurementList, 0, measurements, 0, measurements.length);
            statement.setMeasurements(measurements);
            statement.setTime(timeArray[i]);
            statement.setDataTypes(new TSDataType[measurementList.length]);
            Object[] values = new Object[measurementList.length];
            System.arraycopy(insertStatement.getValuesList().get(i), 0, values, 0, values.length);
            statement.setValues(values);
            statement.setAligned(insertStatement.isAligned());
            statement.setNeedInferType(true);
            insertRowStatementList.add(statement);
        }
        insertRowsStatement.setInsertRowStatementList(insertRowStatementList);
        return insertRowsStatement.accept(this, context);
    }

    @Override
    public Analysis visitCreateTimeseries(CreateTimeSeriesStatement createTimeSeriesStatement, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        if (createTimeSeriesStatement.getTags() != null && !createTimeSeriesStatement.getTags().isEmpty() && createTimeSeriesStatement.getAttributes() != null && !createTimeSeriesStatement.getAttributes().isEmpty()) {
            for (String tagKey : createTimeSeriesStatement.getTags().keySet()) {
                if (!createTimeSeriesStatement.getAttributes().containsKey(tagKey)) continue;
                throw new SemanticException(String.format("Tag and attribute shouldn't have the same property key [%s]", tagKey));
            }
        }
        Analysis analysis = new Analysis();
        analysis.setStatement(createTimeSeriesStatement);
        this.checkIsTemplateCompatible(createTimeSeriesStatement.getPath(), createTimeSeriesStatement.getAlias());
        PathPatternTree patternTree = new PathPatternTree();
        patternTree.appendFullPath(createTimeSeriesStatement.getPath());
        SchemaPartition schemaPartitionInfo = this.partitionFetcher.getOrCreateSchemaPartition(patternTree);
        analysis.setSchemaPartitionInfo(schemaPartitionInfo);
        return analysis;
    }

    private void checkIsTemplateCompatible(PartialPath timeseriesPath, String alias) {
        Pair<Template, PartialPath> templateInfo = this.schemaFetcher.checkTemplateSetInfo(timeseriesPath);
        if (templateInfo != null) {
            if (((Template)templateInfo.left).hasSchema(timeseriesPath.getMeasurement())) {
                throw new RuntimeException((Throwable)((Object)new TemplateImcompatibeException(timeseriesPath.getFullPath(), ((Template)templateInfo.left).getName(), timeseriesPath.getMeasurement())));
            }
            if (alias != null && ((Template)templateInfo.left).hasSchema(alias)) {
                throw new RuntimeException((Throwable)((Object)new TemplateImcompatibeException(timeseriesPath.getDevicePath().concatNode(alias).getFullPath(), ((Template)templateInfo.left).getName(), alias)));
            }
        }
    }

    private void checkIsTemplateCompatible(PartialPath devicePath, List<String> measurements, List<String> aliasList) {
        Pair<Template, PartialPath> templateInfo = this.schemaFetcher.checkTemplateSetInfo(devicePath);
        if (templateInfo != null) {
            Template template = (Template)templateInfo.left;
            for (String measurement : measurements) {
                if (!template.hasSchema(measurement)) continue;
                throw new RuntimeException((Throwable)((Object)new TemplateImcompatibeException(devicePath.concatNode(measurement).getFullPath(), ((Template)templateInfo.left).getName(), measurement)));
            }
            if (aliasList == null) {
                return;
            }
            for (String alias : aliasList) {
                if (!template.hasSchema(alias)) continue;
                throw new RuntimeException((Throwable)((Object)new TemplateImcompatibeException(devicePath.concatNode(alias).getFullPath(), ((Template)templateInfo.left).getName(), alias)));
            }
        }
    }

    @Override
    public Analysis visitCreateAlignedTimeseries(CreateAlignedTimeSeriesStatement createAlignedTimeSeriesStatement, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        List<String> measurements = createAlignedTimeSeriesStatement.getMeasurements();
        HashSet<String> measurementsSet = new HashSet<String>(measurements);
        if (measurementsSet.size() < measurements.size()) {
            throw new SemanticException("Measurement under an aligned device is not allowed to have the same measurement name");
        }
        Analysis analysis = new Analysis();
        analysis.setStatement(createAlignedTimeSeriesStatement);
        this.checkIsTemplateCompatible(createAlignedTimeSeriesStatement.getDevicePath(), createAlignedTimeSeriesStatement.getMeasurements(), createAlignedTimeSeriesStatement.getAliasList());
        PathPatternTree pathPatternTree = new PathPatternTree();
        for (String measurement : createAlignedTimeSeriesStatement.getMeasurements()) {
            pathPatternTree.appendFullPath(createAlignedTimeSeriesStatement.getDevicePath(), measurement);
        }
        SchemaPartition schemaPartitionInfo = this.partitionFetcher.getOrCreateSchemaPartition(pathPatternTree);
        analysis.setSchemaPartitionInfo(schemaPartitionInfo);
        return analysis;
    }

    @Override
    public Analysis visitInternalCreateTimeseries(InternalCreateTimeSeriesStatement internalCreateTimeSeriesStatement, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        Analysis analysis = new Analysis();
        analysis.setStatement(internalCreateTimeSeriesStatement);
        this.checkIsTemplateCompatible(internalCreateTimeSeriesStatement.getDevicePath(), internalCreateTimeSeriesStatement.getMeasurements(), null);
        PathPatternTree pathPatternTree = new PathPatternTree();
        for (String measurement : internalCreateTimeSeriesStatement.getMeasurements()) {
            pathPatternTree.appendFullPath(internalCreateTimeSeriesStatement.getDevicePath(), measurement);
        }
        SchemaPartition schemaPartitionInfo = this.partitionFetcher.getOrCreateSchemaPartition(pathPatternTree);
        analysis.setSchemaPartitionInfo(schemaPartitionInfo);
        return analysis;
    }

    @Override
    public Analysis visitCreateMultiTimeseries(CreateMultiTimeSeriesStatement createMultiTimeSeriesStatement, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        Analysis analysis = new Analysis();
        analysis.setStatement(createMultiTimeSeriesStatement);
        List<PartialPath> timeseriesPathList = createMultiTimeSeriesStatement.getPaths();
        List<String> aliasList = createMultiTimeSeriesStatement.getAliasList();
        for (int i = 0; i < timeseriesPathList.size(); ++i) {
            this.checkIsTemplateCompatible(timeseriesPathList.get(i), aliasList == null ? null : aliasList.get(i));
        }
        PathPatternTree patternTree = new PathPatternTree();
        for (PartialPath path : createMultiTimeSeriesStatement.getPaths()) {
            patternTree.appendFullPath(path);
        }
        SchemaPartition schemaPartitionInfo = this.partitionFetcher.getOrCreateSchemaPartition(patternTree);
        analysis.setSchemaPartitionInfo(schemaPartitionInfo);
        return analysis;
    }

    @Override
    public Analysis visitAlterTimeseries(AlterTimeSeriesStatement alterTimeSeriesStatement, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        Analysis analysis = new Analysis();
        analysis.setStatement(alterTimeSeriesStatement);
        if (alterTimeSeriesStatement.getAlias() != null) {
            this.checkIsTemplateCompatible(alterTimeSeriesStatement.getPath(), alterTimeSeriesStatement.getAlias());
        }
        PathPatternTree patternTree = new PathPatternTree();
        patternTree.appendFullPath(alterTimeSeriesStatement.getPath());
        SchemaPartition schemaPartitionInfo = this.partitionFetcher.getSchemaPartition(patternTree);
        analysis.setSchemaPartitionInfo(schemaPartitionInfo);
        return analysis;
    }

    @Override
    public Analysis visitInsertTablet(InsertTabletStatement insertTabletStatement, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        DataPartitionQueryParam dataPartitionQueryParam = new DataPartitionQueryParam();
        dataPartitionQueryParam.setDevicePath(insertTabletStatement.getDevicePath().getFullPath());
        dataPartitionQueryParam.setTimePartitionSlotList(insertTabletStatement.getTimePartitionSlots());
        DataPartition dataPartition = this.partitionFetcher.getOrCreateDataPartition(Collections.singletonList(dataPartitionQueryParam));
        Analysis analysis = new Analysis();
        analysis.setStatement(insertTabletStatement);
        analysis.setDataPartitionInfo(dataPartition);
        return analysis;
    }

    @Override
    public Analysis visitInsertRow(InsertRowStatement insertRowStatement, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        DataPartitionQueryParam dataPartitionQueryParam = new DataPartitionQueryParam();
        dataPartitionQueryParam.setDevicePath(insertRowStatement.getDevicePath().getFullPath());
        dataPartitionQueryParam.setTimePartitionSlotList(insertRowStatement.getTimePartitionSlots());
        DataPartition dataPartition = this.partitionFetcher.getOrCreateDataPartition(Collections.singletonList(dataPartitionQueryParam));
        Analysis analysis = new Analysis();
        analysis.setStatement(insertRowStatement);
        analysis.setDataPartitionInfo(dataPartition);
        return analysis;
    }

    @Override
    public Analysis visitInsertRows(InsertRowsStatement insertRowsStatement, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        ArrayList<DataPartitionQueryParam> dataPartitionQueryParams = new ArrayList<DataPartitionQueryParam>();
        for (InsertRowStatement insertRowStatement : insertRowsStatement.getInsertRowStatementList()) {
            DataPartitionQueryParam dataPartitionQueryParam = new DataPartitionQueryParam();
            dataPartitionQueryParam.setDevicePath(insertRowStatement.getDevicePath().getFullPath());
            dataPartitionQueryParam.setTimePartitionSlotList(insertRowStatement.getTimePartitionSlots());
            dataPartitionQueryParams.add(dataPartitionQueryParam);
        }
        DataPartition dataPartition = this.partitionFetcher.getOrCreateDataPartition(dataPartitionQueryParams);
        Analysis analysis = new Analysis();
        analysis.setStatement(insertRowsStatement);
        analysis.setDataPartitionInfo(dataPartition);
        return analysis;
    }

    @Override
    public Analysis visitInsertMultiTablets(InsertMultiTabletsStatement insertMultiTabletsStatement, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        ArrayList<DataPartitionQueryParam> dataPartitionQueryParams = new ArrayList<DataPartitionQueryParam>();
        for (InsertTabletStatement insertTabletStatement : insertMultiTabletsStatement.getInsertTabletStatementList()) {
            DataPartitionQueryParam dataPartitionQueryParam = new DataPartitionQueryParam();
            dataPartitionQueryParam.setDevicePath(insertTabletStatement.getDevicePath().getFullPath());
            dataPartitionQueryParam.setTimePartitionSlotList(insertTabletStatement.getTimePartitionSlots());
            dataPartitionQueryParams.add(dataPartitionQueryParam);
        }
        DataPartition dataPartition = this.partitionFetcher.getOrCreateDataPartition(dataPartitionQueryParams);
        Analysis analysis = new Analysis();
        analysis.setStatement(insertMultiTabletsStatement);
        analysis.setDataPartitionInfo(dataPartition);
        return analysis;
    }

    @Override
    public Analysis visitInsertRowsOfOneDevice(InsertRowsOfOneDeviceStatement insertRowsOfOneDeviceStatement, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        DataPartitionQueryParam dataPartitionQueryParam = new DataPartitionQueryParam();
        dataPartitionQueryParam.setDevicePath(insertRowsOfOneDeviceStatement.getDevicePath().getFullPath());
        dataPartitionQueryParam.setTimePartitionSlotList(insertRowsOfOneDeviceStatement.getTimePartitionSlots());
        DataPartition dataPartition = this.partitionFetcher.getOrCreateDataPartition(Collections.singletonList(dataPartitionQueryParam));
        Analysis analysis = new Analysis();
        analysis.setStatement(insertRowsOfOneDeviceStatement);
        analysis.setDataPartitionInfo(dataPartition);
        return analysis;
    }

    @Override
    public Analysis visitShowTimeSeries(ShowTimeSeriesStatement showTimeSeriesStatement, MPPQueryContext context) {
        Analysis analysis = new Analysis();
        analysis.setStatement(showTimeSeriesStatement);
        PathPatternTree patternTree = new PathPatternTree();
        patternTree.appendPathPattern(showTimeSeriesStatement.getPathPattern());
        SchemaPartition schemaPartitionInfo = this.partitionFetcher.getSchemaPartition(patternTree);
        analysis.setSchemaPartitionInfo(schemaPartitionInfo);
        Map<Integer, Template> templateMap = this.schemaFetcher.checkAllRelatedTemplate(showTimeSeriesStatement.getPathPattern());
        analysis.setRelatedTemplateInfo(templateMap);
        if (showTimeSeriesStatement.isOrderByHeat()) {
            patternTree.constructTree();
            logger.info("{} fetch query schema...", (Object)this.getLogHeader());
            ISchemaTree schemaTree = this.schemaFetcher.fetchSchema(patternTree);
            logger.info("{} fetch schema done", (Object)this.getLogHeader());
            List<MeasurementPath> allSelectedPath = schemaTree.getAllMeasurement();
            Set sourceExpressions = allSelectedPath.stream().map(TimeSeriesOperand::new).collect(Collectors.toCollection(LinkedHashSet::new));
            analysis.setSourceExpressions(sourceExpressions);
            Set deviceSet = allSelectedPath.stream().map(PartialPath::getDevice).collect(Collectors.toSet());
            HashMap<String, List<DataPartitionQueryParam>> sgNameToQueryParamsMap = new HashMap<String, List<DataPartitionQueryParam>>();
            for (String devicePath : deviceSet) {
                DataPartitionQueryParam queryParam = new DataPartitionQueryParam();
                queryParam.setDevicePath(devicePath);
                sgNameToQueryParamsMap.computeIfAbsent(schemaTree.getBelongedStorageGroup(devicePath), key -> new ArrayList()).add(queryParam);
            }
            DataPartition dataPartition = this.partitionFetcher.getDataPartition(sgNameToQueryParamsMap);
            analysis.setDataPartitionInfo(dataPartition);
        }
        analysis.setRespDatasetHeader(DatasetHeaderFactory.getShowTimeSeriesHeader());
        return analysis;
    }

    @Override
    public Analysis visitShowStorageGroup(ShowStorageGroupStatement showStorageGroupStatement, MPPQueryContext context) {
        Analysis analysis = new Analysis();
        analysis.setStatement(showStorageGroupStatement);
        analysis.setRespDatasetHeader(DatasetHeaderFactory.getShowStorageGroupHeader());
        return analysis;
    }

    @Override
    public Analysis visitShowTTL(ShowTTLStatement showTTLStatement, MPPQueryContext context) {
        Analysis analysis = new Analysis();
        analysis.setStatement(showTTLStatement);
        analysis.setRespDatasetHeader(DatasetHeaderFactory.getShowTTLHeader());
        return analysis;
    }

    @Override
    public Analysis visitShowDevices(ShowDevicesStatement showDevicesStatement, MPPQueryContext context) {
        Analysis analysis = new Analysis();
        analysis.setStatement(showDevicesStatement);
        PathPatternTree patternTree = new PathPatternTree();
        patternTree.appendPathPattern(showDevicesStatement.getPathPattern().concatNode("*"));
        SchemaPartition schemaPartitionInfo = this.partitionFetcher.getSchemaPartition(patternTree);
        analysis.setSchemaPartitionInfo(schemaPartitionInfo);
        analysis.setRespDatasetHeader(showDevicesStatement.hasSgCol() ? DatasetHeaderFactory.getShowDevicesWithSgHeader() : DatasetHeaderFactory.getShowDevicesHeader());
        return analysis;
    }

    @Override
    public Analysis visitShowCluster(ShowClusterStatement showClusterStatement, MPPQueryContext context) {
        Analysis analysis = new Analysis();
        analysis.setStatement(showClusterStatement);
        analysis.setRespDatasetHeader(DatasetHeaderFactory.getShowClusterHeader());
        return analysis;
    }

    @Override
    public Analysis visitCountStorageGroup(CountStorageGroupStatement countStorageGroupStatement, MPPQueryContext context) {
        Analysis analysis = new Analysis();
        analysis.setStatement(countStorageGroupStatement);
        analysis.setRespDatasetHeader(DatasetHeaderFactory.getCountStorageGroupHeader());
        return analysis;
    }

    @Override
    public Analysis visitSchemaFetch(SchemaFetchStatement schemaFetchStatement, MPPQueryContext context) {
        Analysis analysis = new Analysis();
        analysis.setStatement(schemaFetchStatement);
        SchemaPartition schemaPartition = this.partitionFetcher.getSchemaPartition(schemaFetchStatement.getPatternTree());
        analysis.setSchemaPartitionInfo(schemaPartition);
        if (schemaPartition.isEmpty()) {
            analysis.setFinishQueryAfterAnalyze(true);
        }
        return analysis;
    }

    @Override
    public Analysis visitCountDevices(CountDevicesStatement countDevicesStatement, MPPQueryContext context) {
        Analysis analysis = new Analysis();
        analysis.setStatement(countDevicesStatement);
        PathPatternTree patternTree = new PathPatternTree();
        patternTree.appendPathPattern(countDevicesStatement.getPathPattern().concatNode("*"));
        SchemaPartition schemaPartitionInfo = this.partitionFetcher.getSchemaPartition(patternTree);
        analysis.setSchemaPartitionInfo(schemaPartitionInfo);
        analysis.setRespDatasetHeader(DatasetHeaderFactory.getCountDevicesHeader());
        return analysis;
    }

    @Override
    public Analysis visitCountTimeSeries(CountTimeSeriesStatement countTimeSeriesStatement, MPPQueryContext context) {
        Analysis analysis = new Analysis();
        analysis.setStatement(countTimeSeriesStatement);
        PathPatternTree patternTree = new PathPatternTree();
        patternTree.appendPathPattern(countTimeSeriesStatement.getPathPattern());
        SchemaPartition schemaPartitionInfo = this.partitionFetcher.getSchemaPartition(patternTree);
        analysis.setSchemaPartitionInfo(schemaPartitionInfo);
        Map<Integer, Template> templateMap = this.schemaFetcher.checkAllRelatedTemplate(countTimeSeriesStatement.getPathPattern());
        analysis.setRelatedTemplateInfo(templateMap);
        analysis.setRespDatasetHeader(DatasetHeaderFactory.getCountTimeSeriesHeader());
        return analysis;
    }

    @Override
    public Analysis visitCountLevelTimeSeries(CountLevelTimeSeriesStatement countLevelTimeSeriesStatement, MPPQueryContext context) {
        Analysis analysis = new Analysis();
        analysis.setStatement(countLevelTimeSeriesStatement);
        PathPatternTree patternTree = new PathPatternTree();
        patternTree.appendPathPattern(countLevelTimeSeriesStatement.getPathPattern());
        SchemaPartition schemaPartitionInfo = this.partitionFetcher.getSchemaPartition(patternTree);
        analysis.setSchemaPartitionInfo(schemaPartitionInfo);
        analysis.setRespDatasetHeader(DatasetHeaderFactory.getCountLevelTimeSeriesHeader());
        return analysis;
    }

    @Override
    public Analysis visitCountNodes(CountNodesStatement countStatement, MPPQueryContext context) {
        Analysis analysis = new Analysis();
        analysis.setStatement(countStatement);
        PathPatternTree patternTree = new PathPatternTree();
        patternTree.appendPathPattern(countStatement.getPathPattern());
        SchemaNodeManagementPartition schemaNodeManagementPartition = this.partitionFetcher.getSchemaNodeManagementPartitionWithLevel(patternTree, countStatement.getLevel());
        if (schemaNodeManagementPartition == null) {
            return analysis;
        }
        if (!schemaNodeManagementPartition.getMatchedNode().isEmpty() && schemaNodeManagementPartition.getSchemaPartition().getSchemaPartitionMap().size() == 0) {
            analysis.setFinishQueryAfterAnalyze(true);
        }
        analysis.setMatchedNodes(schemaNodeManagementPartition.getMatchedNode());
        analysis.setSchemaPartitionInfo(schemaNodeManagementPartition.getSchemaPartition());
        analysis.setRespDatasetHeader(DatasetHeaderFactory.getCountNodesHeader());
        return analysis;
    }

    @Override
    public Analysis visitShowChildPaths(ShowChildPathsStatement showChildPathsStatement, MPPQueryContext context) {
        return this.visitSchemaNodeManagementPartition(showChildPathsStatement, showChildPathsStatement.getPartialPath(), DatasetHeaderFactory.getShowChildPathsHeader());
    }

    @Override
    public Analysis visitShowChildNodes(ShowChildNodesStatement showChildNodesStatement, MPPQueryContext context) {
        return this.visitSchemaNodeManagementPartition(showChildNodesStatement, showChildNodesStatement.getPartialPath(), DatasetHeaderFactory.getShowChildNodesHeader());
    }

    @Override
    public Analysis visitShowVersion(ShowVersionStatement showVersionStatement, MPPQueryContext context) {
        Analysis analysis = new Analysis();
        analysis.setStatement(showVersionStatement);
        analysis.setRespDatasetHeader(DatasetHeaderFactory.getShowVersionHeader());
        analysis.setFinishQueryAfterAnalyze(true);
        return analysis;
    }

    private Analysis visitSchemaNodeManagementPartition(Statement statement, PartialPath path, DatasetHeader header) {
        Analysis analysis = new Analysis();
        analysis.setStatement(statement);
        PathPatternTree patternTree = new PathPatternTree();
        patternTree.appendPathPattern(path);
        SchemaNodeManagementPartition schemaNodeManagementPartition = this.partitionFetcher.getSchemaNodeManagementPartition(patternTree);
        if (schemaNodeManagementPartition == null) {
            return analysis;
        }
        if (!schemaNodeManagementPartition.getMatchedNode().isEmpty() && schemaNodeManagementPartition.getSchemaPartition().getSchemaPartitionMap().size() == 0) {
            analysis.setFinishQueryAfterAnalyze(true);
        }
        analysis.setMatchedNodes(schemaNodeManagementPartition.getMatchedNode());
        analysis.setSchemaPartitionInfo(schemaNodeManagementPartition.getSchemaPartition());
        analysis.setRespDatasetHeader(header);
        return analysis;
    }

    @Override
    public Analysis visitDeleteData(DeleteDataStatement deleteDataStatement, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        Analysis analysis = new Analysis();
        analysis.setStatement(deleteDataStatement);
        PathPatternTree patternTree = new PathPatternTree();
        for (PartialPath pathPattern : deleteDataStatement.getPathList()) {
            patternTree.appendPathPattern(pathPattern);
        }
        ISchemaTree schemaTree = this.schemaFetcher.fetchSchema(patternTree);
        analysis.setSchemaTree(schemaTree);
        HashMap<String, List<DataPartitionQueryParam>> sgNameToQueryParamsMap = new HashMap<String, List<DataPartitionQueryParam>>();
        schemaTree.getMatchedDevices(new PartialPath(MetadataConstant.ALL_RESULT_NODES)).forEach(deviceSchemaInfo -> {
            PartialPath devicePath = deviceSchemaInfo.getDevicePath();
            DataPartitionQueryParam queryParam = new DataPartitionQueryParam();
            queryParam.setDevicePath(devicePath.getFullPath());
            sgNameToQueryParamsMap.computeIfAbsent(schemaTree.getBelongedStorageGroup(devicePath), key -> new ArrayList()).add(queryParam);
        });
        DataPartition dataPartition = this.partitionFetcher.getDataPartition(sgNameToQueryParamsMap);
        analysis.setDataPartitionInfo(dataPartition);
        if (dataPartition.isEmpty()) {
            analysis.setFinishQueryAfterAnalyze(true);
        }
        return analysis;
    }

    @Override
    public Analysis visitCreateSchemaTemplate(CreateSchemaTemplateStatement createTemplateStatement, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        List<List<String>> measurementsList = createTemplateStatement.getMeasurements();
        for (List<String> measurements : measurementsList) {
            HashSet<String> measurementsSet = new HashSet<String>(measurements);
            if (measurementsSet.size() >= measurements.size()) continue;
            throw new SemanticException("Measurement under an aligned device is not allowed to have the same measurement name");
        }
        Analysis analysis = new Analysis();
        analysis.setStatement(createTemplateStatement);
        return analysis;
    }

    @Override
    public Analysis visitShowNodesInSchemaTemplate(ShowNodesInSchemaTemplateStatement showNodesInSchemaTemplateStatement, MPPQueryContext context) {
        Analysis analysis = new Analysis();
        analysis.setStatement(showNodesInSchemaTemplateStatement);
        analysis.setRespDatasetHeader(DatasetHeaderFactory.getShowNodesInSchemaTemplateHeader());
        return analysis;
    }

    @Override
    public Analysis visitShowSchemaTemplate(ShowSchemaTemplateStatement showSchemaTemplateStatement, MPPQueryContext context) {
        Analysis analysis = new Analysis();
        analysis.setStatement(showSchemaTemplateStatement);
        analysis.setRespDatasetHeader(DatasetHeaderFactory.getShowSchemaTemplateHeader());
        return analysis;
    }

    private GroupByFilter initGroupByFilter(GroupByTimeComponent groupByTimeComponent) {
        if (groupByTimeComponent.isIntervalByMonth() || groupByTimeComponent.isSlidingStepByMonth()) {
            return new GroupByMonthFilter(groupByTimeComponent.getInterval(), groupByTimeComponent.getSlidingStep(), groupByTimeComponent.getStartTime(), groupByTimeComponent.getEndTime(), groupByTimeComponent.isSlidingStepByMonth(), groupByTimeComponent.isIntervalByMonth(), TimeZone.getTimeZone("+00:00"));
        }
        long startTime = groupByTimeComponent.isLeftCRightO() ? groupByTimeComponent.getStartTime() : groupByTimeComponent.getStartTime() + 1L;
        long endTime = groupByTimeComponent.isLeftCRightO() ? groupByTimeComponent.getEndTime() : groupByTimeComponent.getEndTime() + 1L;
        return new GroupByFilter(groupByTimeComponent.getInterval(), groupByTimeComponent.getSlidingStep(), startTime, endTime);
    }

    @Override
    public Analysis visitSetSchemaTemplate(SetSchemaTemplateStatement setSchemaTemplateStatement, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        Analysis analysis = new Analysis();
        analysis.setStatement(setSchemaTemplateStatement);
        return analysis;
    }

    @Override
    public Analysis visitShowPathSetTemplate(ShowPathSetTemplateStatement showPathSetTemplateStatement, MPPQueryContext context) {
        Analysis analysis = new Analysis();
        analysis.setStatement(showPathSetTemplateStatement);
        analysis.setRespDatasetHeader(DatasetHeaderFactory.getShowPathSetTemplateHeader());
        return analysis;
    }

    @Override
    public Analysis visitActivateTemplate(ActivateTemplateStatement activateTemplateStatement, MPPQueryContext context) {
        context.setQueryType(QueryType.WRITE);
        Analysis analysis = new Analysis();
        analysis.setStatement(activateTemplateStatement);
        PartialPath activatePath = activateTemplateStatement.getPath();
        Pair<Template, PartialPath> templateSetInfo = this.schemaFetcher.checkTemplateSetInfo(activatePath);
        if (templateSetInfo == null) {
            throw new StatementAnalyzeException((Exception)((Object)new MetadataException(String.format("Path [%s] has not been set any template.", activatePath.getFullPath()))));
        }
        analysis.setTemplateSetInfo((Pair<Template, List<PartialPath>>)new Pair((Object)((Template)templateSetInfo.left), Collections.singletonList((PartialPath)templateSetInfo.right)));
        PathPatternTree patternTree = new PathPatternTree();
        patternTree.appendPathPattern(activatePath.concatNode("*"));
        SchemaPartition partition = this.partitionFetcher.getOrCreateSchemaPartition(patternTree);
        analysis.setSchemaPartitionInfo(partition);
        return analysis;
    }

    @Override
    public Analysis visitShowPathsUsingTemplate(ShowPathsUsingTemplateStatement showPathsUsingTemplateStatement, MPPQueryContext context) {
        Analysis analysis = new Analysis();
        analysis.setStatement(showPathsUsingTemplateStatement);
        analysis.setRespDatasetHeader(DatasetHeaderFactory.getShowPathsUsingTemplateHeader());
        Pair<Template, List<PartialPath>> templateSetInfo = this.schemaFetcher.getAllPathsSetTemplate(showPathsUsingTemplateStatement.getTemplateName());
        analysis.setTemplateSetInfo(templateSetInfo);
        if (templateSetInfo == null || templateSetInfo.right == null || ((List)templateSetInfo.right).isEmpty()) {
            analysis.setFinishQueryAfterAnalyze(true);
            return analysis;
        }
        PathPatternTree patternTree = new PathPatternTree();
        ((List)templateSetInfo.right).forEach(path -> {
            patternTree.appendPathPattern((PartialPath)path);
            patternTree.appendPathPattern(path.concatNode("**"));
        });
        SchemaPartition partition = this.partitionFetcher.getOrCreateSchemaPartition(patternTree);
        analysis.setSchemaPartitionInfo(partition);
        if (partition.isEmpty()) {
            analysis.setFinishQueryAfterAnalyze(true);
            return analysis;
        }
        return analysis;
    }

    @Override
    public Analysis visitShowPipeSinkType(ShowPipeSinkTypeStatement showPipeSinkTypeStatement, MPPQueryContext context) {
        Analysis analysis = new Analysis();
        analysis.setStatement(showPipeSinkTypeStatement);
        analysis.setRespDatasetHeader(DatasetHeaderFactory.getShowPipeSinkTypeHeader());
        analysis.setFinishQueryAfterAnalyze(true);
        return analysis;
    }
}

