/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.execution.config.metadata;

import com.google.common.util.concurrent.ListenableFuture;
import com.google.common.util.concurrent.SettableFuture;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.iotdb.confignode.rpc.thrift.TStorageGroupInfo;
import org.apache.iotdb.db.mpp.common.header.ColumnHeader;
import org.apache.iotdb.db.mpp.common.header.ColumnHeaderConstant;
import org.apache.iotdb.db.mpp.common.header.DatasetHeader;
import org.apache.iotdb.db.mpp.common.header.DatasetHeaderFactory;
import org.apache.iotdb.db.mpp.plan.execution.config.ConfigTaskResult;
import org.apache.iotdb.db.mpp.plan.execution.config.IConfigTask;
import org.apache.iotdb.db.mpp.plan.execution.config.executor.IConfigTaskExecutor;
import org.apache.iotdb.db.mpp.plan.statement.metadata.ShowStorageGroupStatement;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.utils.Binary;

public class ShowStorageGroupTask
implements IConfigTask {
    private final ShowStorageGroupStatement showStorageGroupStatement;

    public ShowStorageGroupTask(ShowStorageGroupStatement showStorageGroupStatement) {
        this.showStorageGroupStatement = showStorageGroupStatement;
    }

    @Override
    public ListenableFuture<ConfigTaskResult> execute(IConfigTaskExecutor configTaskExecutor) throws InterruptedException {
        return configTaskExecutor.showStorageGroup(this.showStorageGroupStatement);
    }

    public static void buildTSBlock(Map<String, TStorageGroupInfo> storageGroupInfoMap, SettableFuture<ConfigTaskResult> future) {
        List outputDataTypes = ColumnHeaderConstant.showStorageGroupColumnHeaders.stream().map(ColumnHeader::getColumnType).collect(Collectors.toList());
        TsBlockBuilder builder = new TsBlockBuilder(outputDataTypes);
        for (Map.Entry<String, TStorageGroupInfo> entry : storageGroupInfoMap.entrySet()) {
            String storageGroup = entry.getKey();
            TStorageGroupInfo storageGroupInfo = entry.getValue();
            builder.getTimeColumnBuilder().writeLong(0L);
            builder.getColumnBuilder(0).writeBinary(new Binary(storageGroup));
            if (Long.MAX_VALUE == storageGroupInfo.getTTL()) {
                builder.getColumnBuilder(1).appendNull();
            } else {
                builder.getColumnBuilder(1).writeLong(storageGroupInfo.getTTL());
            }
            builder.getColumnBuilder(2).writeInt(storageGroupInfo.getSchemaReplicationFactor());
            builder.getColumnBuilder(3).writeInt(storageGroupInfo.getDataReplicationFactor());
            builder.getColumnBuilder(4).writeLong(storageGroupInfo.getTimePartitionInterval());
            builder.getColumnBuilder(5).writeInt(storageGroupInfo.getSchemaRegionNum());
            builder.getColumnBuilder(6).writeInt(storageGroupInfo.getDataRegionNum());
            builder.declarePosition();
        }
        DatasetHeader datasetHeader = DatasetHeaderFactory.getShowStorageGroupHeader();
        future.set((Object)new ConfigTaskResult(TSStatusCode.SUCCESS_STATUS, builder.build(), datasetHeader));
    }
}

