/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.planner.plan.node;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.Validate;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.commons.partition.DataPartition;
import org.apache.iotdb.db.mpp.plan.expression.Expression;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanVisitor;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.AggregationNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.DeviceMergeNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.DeviceViewNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.ExchangeNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.FillNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.FilterNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.GroupByLevelNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.LimitNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.OffsetNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.SlidingWindowAggregationNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.SortNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.TimeJoinNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.process.TransformNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.sink.FragmentSinkNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.source.AlignedSeriesAggregationScanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.source.AlignedSeriesScanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.source.SeriesAggregationScanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.source.SeriesScanNode;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.AggregationDescriptor;

public class PlanGraphPrinter
extends PlanVisitor<List<String>, GraphContext> {
    private static final String INDENT = " ";
    private static final String HORIZONTAL = "\u2500";
    private static final String VERTICAL = "\u2502";
    private static final String LEFT_BOTTOM = "\u2514";
    private static final String RIGHT_BOTTOM = "\u2518";
    private static final String LEFT_TOP = "\u250c";
    private static final String RIGHT_TOP = "\u2510";
    private static final String UP = "\u2534";
    private static final String DOWN = "\u252c";
    private static final String CROSS = "\u253c";
    private static final int BOX_MARGIN = 1;
    private static final int CONNECTION_LINE_HEIGHT = 2;

    @Override
    public List<String> visitPlan(PlanNode node, GraphContext context) {
        ArrayList<String> boxValue = new ArrayList<String>();
        boxValue.add(String.format("PlanNode-%s", node.getPlanNodeId().getId()));
        return this.render(node, boxValue, context);
    }

    @Override
    public List<String> visitSeriesScan(SeriesScanNode node, GraphContext context) {
        ArrayList<String> boxValue = new ArrayList<String>();
        boxValue.add(String.format("SeriesScan-%s", node.getPlanNodeId().getId()));
        boxValue.add(String.format("Series: %s", new Object[]{node.getSeriesPath()}));
        boxValue.add(this.printRegion(node.getRegionReplicaSet()));
        return this.render(node, boxValue, context);
    }

    @Override
    public List<String> visitAlignedSeriesScan(AlignedSeriesScanNode node, GraphContext context) {
        ArrayList<String> boxValue = new ArrayList<String>();
        boxValue.add(String.format("AlignedSeriesScan-%s", node.getPlanNodeId().getId()));
        boxValue.add(String.format("Series: %s%s", node.getAlignedPath().getDevice(), node.getAlignedPath().getMeasurementList()));
        boxValue.add(this.printRegion(node.getRegionReplicaSet()));
        return this.render(node, boxValue, context);
    }

    @Override
    public List<String> visitSeriesAggregationScan(SeriesAggregationScanNode node, GraphContext context) {
        ArrayList<String> boxValue = new ArrayList<String>();
        boxValue.add(String.format("SeriesAggregationScan-%s", node.getPlanNodeId().getId()));
        boxValue.add(String.format("Series: %s", new Object[]{node.getSeriesPath()}));
        for (int i = 0; i < node.getAggregationDescriptorList().size(); ++i) {
            AggregationDescriptor descriptor = node.getAggregationDescriptorList().get(i);
            boxValue.add(String.format("Aggregator-%d: %s, %s", new Object[]{i, descriptor.getAggregationType(), descriptor.getStep()}));
        }
        boxValue.add(this.printRegion(node.getRegionReplicaSet()));
        return this.render(node, boxValue, context);
    }

    @Override
    public List<String> visitAlignedSeriesAggregationScan(AlignedSeriesAggregationScanNode node, GraphContext context) {
        ArrayList<String> boxValue = new ArrayList<String>();
        boxValue.add(String.format("AlignedSeriesAggregationScan-%s", node.getPlanNodeId().getId()));
        boxValue.add(String.format("Series: %s%s", node.getAlignedPath().getDevice(), node.getAlignedPath().getMeasurementList()));
        for (int i = 0; i < node.getAggregationDescriptorList().size(); ++i) {
            AggregationDescriptor descriptor = node.getAggregationDescriptorList().get(i);
            boxValue.add(String.format("Aggregator-%d: %s, %s", new Object[]{i, descriptor.getAggregationType(), descriptor.getStep()}));
        }
        boxValue.add(this.printRegion(node.getRegionReplicaSet()));
        return this.render(node, boxValue, context);
    }

    @Override
    public List<String> visitDeviceView(DeviceViewNode node, GraphContext context) {
        ArrayList<String> boxValue = new ArrayList<String>();
        boxValue.add(String.format("DeviceView-%s", node.getPlanNodeId().getId()));
        boxValue.add(String.format("DeviceCount: %d", node.getDevices().size()));
        return this.render(node, boxValue, context);
    }

    @Override
    public List<String> visitDeviceMerge(DeviceMergeNode node, GraphContext context) {
        ArrayList<String> boxValue = new ArrayList<String>();
        boxValue.add(String.format("DeviceMerge-%s", node.getPlanNodeId().getId()));
        boxValue.add(String.format("DeviceCount: %d", node.getDevices().size()));
        return this.render(node, boxValue, context);
    }

    @Override
    public List<String> visitFill(FillNode node, GraphContext context) {
        ArrayList<String> boxValue = new ArrayList<String>();
        boxValue.add(String.format("Fill-%s", node.getPlanNodeId().getId()));
        boxValue.add(String.format("Policy: %s", new Object[]{node.getFillDescriptor().getFillPolicy()}));
        return this.render(node, boxValue, context);
    }

    @Override
    public List<String> visitFilter(FilterNode node, GraphContext context) {
        ArrayList<String> boxValue = new ArrayList<String>();
        boxValue.add(String.format("Filter-%s", node.getPlanNodeId().getId()));
        boxValue.add(String.format("Predicate: %s", node.getPredicate()));
        return this.render(node, boxValue, context);
    }

    @Override
    public List<String> visitGroupByLevel(GroupByLevelNode node, GraphContext context) {
        ArrayList<String> boxValue = new ArrayList<String>();
        boxValue.add(String.format("GroupByLevel-%s", node.getPlanNodeId().getId()));
        for (int i = 0; i < node.getGroupByLevelDescriptors().size(); ++i) {
            AggregationDescriptor descriptor = node.getGroupByLevelDescriptors().get(i);
            boxValue.add(String.format("Aggregator-%d: %s, %s", new Object[]{i, descriptor.getAggregationType(), descriptor.getStep()}));
            boxValue.add(String.format("  Output: %s", descriptor.getOutputColumnNames()));
            boxValue.add(String.format("  Input: %s", descriptor.getInputExpressions()));
        }
        return this.render(node, boxValue, context);
    }

    @Override
    public List<String> visitSlidingWindowAggregation(SlidingWindowAggregationNode node, GraphContext context) {
        ArrayList<String> boxValue = new ArrayList<String>();
        boxValue.add(String.format("SlidingWindowAggregation-%s", node.getPlanNodeId().getId()));
        for (int i = 0; i < node.getAggregationDescriptorList().size(); ++i) {
            AggregationDescriptor descriptor = node.getAggregationDescriptorList().get(i);
            boxValue.add(String.format("Aggregator-%d: %s, %s", new Object[]{i, descriptor.getAggregationType(), descriptor.getStep()}));
        }
        return this.render(node, boxValue, context);
    }

    @Override
    public List<String> visitOffset(OffsetNode node, GraphContext context) {
        ArrayList<String> boxValue = new ArrayList<String>();
        boxValue.add(String.format("Offset-%s", node.getPlanNodeId().getId()));
        boxValue.add(String.format("value: %d", node.getOffset()));
        return this.render(node, boxValue, context);
    }

    @Override
    public List<String> visitAggregation(AggregationNode node, GraphContext context) {
        ArrayList<String> boxValue = new ArrayList<String>();
        boxValue.add(String.format("Aggregation-%s", node.getPlanNodeId().getId()));
        for (int i = 0; i < node.getAggregationDescriptorList().size(); ++i) {
            AggregationDescriptor descriptor = node.getAggregationDescriptorList().get(i);
            boxValue.add(String.format("Aggregator-%d: %s, %s", new Object[]{i, descriptor.getAggregationType(), descriptor.getStep()}));
        }
        return this.render(node, boxValue, context);
    }

    @Override
    public List<String> visitSort(SortNode node, GraphContext context) {
        ArrayList<String> boxValue = new ArrayList<String>();
        boxValue.add(String.format("Sort-%s", node.getPlanNodeId().getId()));
        boxValue.add(String.format("OrderBy: %s", new Object[]{node.getSortOrder()}));
        return this.render(node, boxValue, context);
    }

    @Override
    public List<String> visitExchange(ExchangeNode node, GraphContext context) {
        ArrayList<String> boxValue = new ArrayList<String>();
        boxValue.add(String.format("Exchange-%s", node.getPlanNodeId().getId()));
        return this.render(node, boxValue, context);
    }

    @Override
    public List<String> visitTimeJoin(TimeJoinNode node, GraphContext context) {
        ArrayList<String> boxValue = new ArrayList<String>();
        boxValue.add(String.format("TimeJoin-%s", node.getPlanNodeId().getId()));
        boxValue.add(String.format("Order: %s", new Object[]{node.getMergeOrder()}));
        return this.render(node, boxValue, context);
    }

    @Override
    public List<String> visitLimit(LimitNode node, GraphContext context) {
        ArrayList<String> boxValue = new ArrayList<String>();
        boxValue.add(String.format("Limit-%s", node.getPlanNodeId().getId()));
        boxValue.add(String.format("Count: %d", node.getLimit()));
        return this.render(node, boxValue, context);
    }

    @Override
    public List<String> visitFragmentSink(FragmentSinkNode node, GraphContext context) {
        ArrayList<String> boxValue = new ArrayList<String>();
        boxValue.add(String.format("FragmentSink-%s", node.getPlanNodeId().getId()));
        boxValue.add(String.format("Destination: %s", node.getDownStreamPlanNodeId()));
        return this.render(node, boxValue, context);
    }

    @Override
    public List<String> visitTransform(TransformNode node, GraphContext context) {
        ArrayList<String> boxValue = new ArrayList<String>();
        boxValue.add(String.format("Transform-%s", node.getPlanNodeId().getId()));
        for (int i = 0; i < node.getOutputExpressions().length; ++i) {
            Expression exp = node.getOutputExpressions()[i];
            boxValue.add(String.format("Exp-%d[%s]: %s", new Object[]{i, exp.getExpressionType(), exp.getExpressionString()}));
        }
        return this.render(node, boxValue, context);
    }

    private String printRegion(TRegionReplicaSet regionReplicaSet) {
        return String.format("Partition: %s", regionReplicaSet == null || regionReplicaSet == DataPartition.NOT_ASSIGNED ? "Not Assigned" : String.valueOf(regionReplicaSet.getRegionId().id));
    }

    private List<String> render(PlanNode node, List<String> nodeBoxString, GraphContext context) {
        StringBuilder line;
        int i;
        Box box = new Box(nodeBoxString);
        ArrayList<List<String>> children = new ArrayList<List<String>>();
        for (PlanNode child : node.getChildren()) {
            children.add(child.accept(this, context));
        }
        box.calculateBoxParams(children);
        box.lines.add(this.printBoxEdge(box, true));
        for (String valueLine : nodeBoxString) {
            StringBuilder line2 = new StringBuilder();
            for (i = 0; i < box.lineWidth; ++i) {
                if (i < box.startPosition) {
                    line2.append(INDENT);
                    continue;
                }
                if (i > box.endPosition) {
                    line2.append(INDENT);
                    continue;
                }
                if (i == box.startPosition || i == box.endPosition) {
                    line2.append(VERTICAL);
                    continue;
                }
                if (i - box.startPosition - 1 < valueLine.length()) {
                    line2.append(valueLine.charAt(i - box.startPosition - 1));
                    continue;
                }
                line2.append(INDENT);
            }
            box.lines.add(line2.toString());
        }
        box.lines.add(this.printBoxEdge(box, false));
        if (children.size() == 0) {
            return box.lines;
        }
        if (children.size() == 1) {
            for (int i2 = 0; i2 < 2; ++i2) {
                line = new StringBuilder();
                for (int j = 0; j < box.lineWidth; ++j) {
                    line.append(j == box.midPosition ? VERTICAL : INDENT);
                }
                box.lines.add(line.toString());
            }
        } else {
            HashMap<Integer, String> symbolMap = new HashMap<Integer, String>();
            HashMap<Integer, Boolean> childMidPositionMap = new HashMap<Integer, Boolean>();
            symbolMap.put(box.midPosition, UP);
            for (int i3 = 0; i3 < children.size(); ++i3) {
                int childMidPosition = PlanGraphPrinter.getChildMidPosition(children, i3);
                childMidPositionMap.put(childMidPosition, true);
                if (childMidPosition == box.midPosition) {
                    symbolMap.put(box.midPosition, CROSS);
                    continue;
                }
                symbolMap.put(childMidPosition, i3 == 0 ? LEFT_TOP : (i3 == children.size() - 1 ? RIGHT_TOP : DOWN));
            }
            StringBuilder line1 = new StringBuilder();
            for (i = 0; i < box.lineWidth; ++i) {
                if (i < PlanGraphPrinter.getChildMidPosition(children, 0) || i > PlanGraphPrinter.getChildMidPosition(children, children.size() - 1)) {
                    line1.append(INDENT);
                    continue;
                }
                line1.append(symbolMap.getOrDefault(i, HORIZONTAL));
            }
            box.lines.add(line1.toString());
            for (int row = 1; row < 2; ++row) {
                StringBuilder nextLine = new StringBuilder();
                for (int i4 = 0; i4 < box.lineWidth; ++i4) {
                    nextLine.append(childMidPositionMap.containsKey(i4) ? VERTICAL : INDENT);
                }
                box.lines.add(nextLine.toString());
            }
        }
        for (int i5 = 0; i5 < this.getChildrenLineCount(children); ++i5) {
            line = new StringBuilder();
            for (int j = 0; j < children.size(); ++j) {
                line.append(this.getLine(children, j, i5));
                if (j == children.size() - 1) continue;
                for (int m = 0; m < 1; ++m) {
                    line.append(INDENT);
                }
            }
            box.lines.add(line.toString());
        }
        return box.lines;
    }

    private String printBoxEdge(Box box, boolean isTopEdge) {
        StringBuilder line = new StringBuilder();
        for (int i = 0; i < box.lineWidth; ++i) {
            if (i < box.startPosition) {
                line.append(INDENT);
                continue;
            }
            if (i > box.endPosition) {
                line.append(INDENT);
                continue;
            }
            if (i == box.startPosition) {
                line.append(isTopEdge ? LEFT_TOP : LEFT_BOTTOM);
                continue;
            }
            if (i == box.endPosition) {
                line.append(isTopEdge ? RIGHT_TOP : RIGHT_BOTTOM);
                continue;
            }
            line.append(HORIZONTAL);
        }
        return line.toString();
    }

    private String getLine(List<List<String>> children, int child, int line) {
        if (line < children.get(child).size()) {
            return children.get(child).get(line);
        }
        return this.genEmptyLine(children.get(child).get(0).length());
    }

    private String genEmptyLine(int lineWidth) {
        StringBuilder line = new StringBuilder();
        for (int i = 0; i < lineWidth; ++i) {
            line.append(INDENT);
        }
        return line.toString();
    }

    private int getChildrenLineCount(List<List<String>> children) {
        int count = 0;
        for (List<String> child : children) {
            count = Math.max(count, child.size());
        }
        return count;
    }

    private static int getChildMidPosition(List<List<String>> children, int idx) {
        int left = 0;
        for (int i = 0; i < idx; ++i) {
            left += children.get(i).get(0).length();
            ++left;
        }
        return left += children.get(idx).get(0).length() / 2;
    }

    public static List<String> getGraph(PlanNode node) {
        return node.accept(new PlanGraphPrinter(), new GraphContext());
    }

    public static void print(PlanNode node) {
        List<String> lines = PlanGraphPrinter.getGraph(node);
        for (String line : lines) {
            System.out.println(line);
        }
    }

    public static class GraphContext {
    }

    private static class Box {
        private List<String> boxString;
        private int boxWidth;
        private int lineWidth;
        private List<String> lines;
        private int startPosition;
        private int endPosition;
        private int midPosition;

        public Box(List<String> boxString) {
            this.boxString = boxString;
            this.boxWidth = this.getBoxWidth();
            this.lines = new ArrayList<String>();
        }

        public int getBoxWidth() {
            int width = 0;
            for (String line : this.boxString) {
                width = Math.max(width, line.length());
            }
            return width + 2;
        }

        public String getLine(int idx) {
            if (idx < this.lines.size()) {
                return this.lines.get(idx);
            }
            return this.genEmptyLine(this.lineWidth);
        }

        private String genEmptyLine(int lineWidth) {
            StringBuilder line = new StringBuilder();
            for (int i = 0; i < lineWidth; ++i) {
                line.append(PlanGraphPrinter.INDENT);
            }
            return line.toString();
        }

        public void calculateBoxParams(List<List<String>> childBoxStrings) {
            int childrenWidth = 0;
            for (List<String> childBoxString : childBoxStrings) {
                Validate.isTrue((childBoxString.size() > 0 ? 1 : 0) != 0, (String)"Lines of box string should be greater than 0", (Object[])new Object[0]);
                childrenWidth += childBoxString.get(0).length();
            }
            this.lineWidth = Math.max(this.boxWidth, childrenWidth += childBoxStrings.size() > 1 ? (childBoxStrings.size() - 1) * 1 : 0);
            this.startPosition = (this.lineWidth - this.boxWidth) / 2;
            this.endPosition = this.startPosition + this.boxWidth - 1;
            this.midPosition = this.lineWidth / 2;
        }
    }
}

