/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.transformation.dag.column.binary;

import org.apache.iotdb.db.mpp.transformation.dag.column.ColumnTransformer;
import org.apache.iotdb.db.mpp.transformation.dag.column.binary.BinaryColumnTransformer;
import org.apache.iotdb.db.mpp.transformation.dag.util.TransformUtils;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnBuilder;
import org.apache.iotdb.tsfile.read.common.type.Type;
import org.apache.iotdb.tsfile.read.common.type.TypeEnum;

public abstract class CompareBinaryColumnTransformer
extends BinaryColumnTransformer {
    public CompareBinaryColumnTransformer(Type returnType, ColumnTransformer leftTransformer, ColumnTransformer rightTransformer) {
        super(returnType, leftTransformer, rightTransformer);
    }

    @Override
    protected void doTransform(Column leftColumn, Column rightColumn, ColumnBuilder builder, int positionCount) {
        for (int i = 0; i < positionCount; ++i) {
            if (!leftColumn.isNull(i) && !rightColumn.isNull(i)) {
                boolean flag;
                if (this.leftTransformer.getType().getTypeEnum().equals((Object)TypeEnum.BINARY)) {
                    flag = this.transform(TransformUtils.compare(this.leftTransformer.getType().getBinary(leftColumn, i).getStringValue(), this.rightTransformer.getType().getBinary(rightColumn, i).getStringValue()));
                } else if (this.leftTransformer.getType().getTypeEnum().equals((Object)TypeEnum.BOOLEAN)) {
                    flag = this.transform(Boolean.compare(this.leftTransformer.getType().getBoolean(leftColumn, i), this.rightTransformer.getType().getBoolean(rightColumn, i)));
                } else {
                    double left = this.leftTransformer.getType().getDouble(leftColumn, i);
                    double right = this.rightTransformer.getType().getDouble(rightColumn, i);
                    flag = Double.isNaN(left) || Double.isNaN(right) ? false : this.transform(this.compare(left, right));
                }
                this.returnType.writeBoolean(builder, flag);
                continue;
            }
            builder.appendNull();
        }
    }

    @Override
    protected void checkType() {
        if (this.leftTransformer.getType().getTypeEnum().equals((Object)TypeEnum.BOOLEAN) || this.rightTransformer.getType().getTypeEnum().equals((Object)TypeEnum.BOOLEAN)) {
            throw new UnsupportedOperationException("Unsupported Type");
        }
    }

    protected int compare(double d1, double d2) {
        return Double.compare(d1, d2);
    }

    protected abstract boolean transform(int var1);
}

