/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.transformation.dag.input;

import java.io.IOException;
import java.util.List;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.mpp.transformation.api.LayerPointReader;
import org.apache.iotdb.db.mpp.transformation.api.YieldableState;
import org.apache.iotdb.db.mpp.transformation.dag.input.IUDFInputDataSet;
import org.apache.iotdb.db.mpp.transformation.dag.memory.SafetyLine;
import org.apache.iotdb.db.mpp.transformation.datastructure.row.ElasticSerializableRowRecordList;
import org.apache.iotdb.db.qp.physical.crud.UDTFPlan;
import org.apache.iotdb.db.query.dataset.RawQueryDataSetWithValueFilter;
import org.apache.iotdb.db.query.dataset.UDFRawQueryInputDataSetWithoutValueFilter;
import org.apache.iotdb.db.query.reader.series.IReaderByTimestamp;
import org.apache.iotdb.db.query.reader.series.ManagedSeriesReader;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.query.timegenerator.TimeGenerator;
import org.apache.iotdb.tsfile.utils.Binary;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class QueryDataSetInputLayer {
    private static final Logger LOGGER = LoggerFactory.getLogger(QueryDataSetInputLayer.class);
    private IUDFInputDataSet queryDataSet;
    private TSDataType[] dataTypes;
    private int timestampIndex;
    private ElasticSerializableRowRecordList rowRecordList;
    private SafetyLine safetyLine;

    public QueryDataSetInputLayer(long queryId, float memoryBudgetInMB, UDTFPlan queryPlan, List<ManagedSeriesReader> readers) throws QueryProcessException, IOException, InterruptedException {
        this.construct(queryId, memoryBudgetInMB, new UDFRawQueryInputDataSetWithoutValueFilter(queryId, queryPlan, readers));
    }

    public QueryDataSetInputLayer(long queryId, float memoryBudgetInMB, List<PartialPath> paths, List<TSDataType> dataTypes, TimeGenerator timeGenerator, List<IReaderByTimestamp> readers, List<List<Integer>> readerToIndexList, List<Boolean> cached) throws QueryProcessException {
        this.construct(queryId, memoryBudgetInMB, new RawQueryDataSetWithValueFilter(paths, dataTypes, timeGenerator, readers, readerToIndexList, cached, true));
    }

    public QueryDataSetInputLayer(long queryId, float memoryBudgetInMB, IUDFInputDataSet queryDataSet) throws QueryProcessException {
        this.construct(queryId, memoryBudgetInMB, queryDataSet);
    }

    private void construct(long queryId, float memoryBudgetInMB, IUDFInputDataSet queryDataSet) throws QueryProcessException {
        this.queryDataSet = queryDataSet;
        this.dataTypes = queryDataSet.getDataTypes().toArray(new TSDataType[0]);
        this.timestampIndex = this.dataTypes.length;
        this.rowRecordList = new ElasticSerializableRowRecordList(this.dataTypes, queryId, memoryBudgetInMB, 1 + this.dataTypes.length / 2);
        this.safetyLine = new SafetyLine();
    }

    public void updateRowRecordListEvictionUpperBound() {
        this.rowRecordList.setEvictionUpperBound(this.safetyLine.getSafetyLine());
    }

    public LayerPointReader constructTimePointReader() {
        return new TimePointReader();
    }

    public LayerPointReader constructValuePointReader(int columnIndex) {
        return new ValuePointReader(columnIndex);
    }

    private class TimePointReader
    extends AbstractLayerPointReader {
        private TimePointReader() {
        }

        @Override
        public YieldableState yield() throws IOException, QueryProcessException {
            if (this.hasCachedRowRecord) {
                return YieldableState.YIELDABLE;
            }
            int nextIndex = this.currentRowIndex + 1;
            if (nextIndex < QueryDataSetInputLayer.this.rowRecordList.size()) {
                this.hasCachedRowRecord = true;
                this.cachedRowRecord = QueryDataSetInputLayer.this.rowRecordList.getRowRecord(nextIndex);
                this.currentRowIndex = nextIndex;
                return YieldableState.YIELDABLE;
            }
            YieldableState yieldableState = QueryDataSetInputLayer.this.queryDataSet.canYieldNextRowInObjects();
            if (YieldableState.YIELDABLE == yieldableState) {
                Object[] rowRecordCandidate = QueryDataSetInputLayer.this.queryDataSet.nextRowInObjects();
                QueryDataSetInputLayer.this.rowRecordList.put(rowRecordCandidate);
                this.hasCachedRowRecord = true;
                this.cachedRowRecord = rowRecordCandidate;
                this.currentRowIndex = QueryDataSetInputLayer.this.rowRecordList.size() - 1;
            }
            return yieldableState;
        }

        @Override
        public boolean next() throws QueryProcessException, IOException {
            if (this.hasCachedRowRecord) {
                return true;
            }
            int nextIndex = this.currentRowIndex + 1;
            if (nextIndex < QueryDataSetInputLayer.this.rowRecordList.size()) {
                this.hasCachedRowRecord = true;
                this.cachedRowRecord = QueryDataSetInputLayer.this.rowRecordList.getRowRecord(nextIndex);
                this.currentRowIndex = nextIndex;
                return true;
            }
            if (QueryDataSetInputLayer.this.queryDataSet.hasNextRowInObjects()) {
                Object[] rowRecordCandidate = QueryDataSetInputLayer.this.queryDataSet.nextRowInObjects();
                QueryDataSetInputLayer.this.rowRecordList.put(rowRecordCandidate);
                this.hasCachedRowRecord = true;
                this.cachedRowRecord = rowRecordCandidate;
                this.currentRowIndex = QueryDataSetInputLayer.this.rowRecordList.size() - 1;
                return true;
            }
            return false;
        }

        @Override
        public TSDataType getDataType() {
            return TSDataType.INT64;
        }

        @Override
        public int currentInt() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public long currentLong() throws IOException {
            return (Long)this.cachedRowRecord[QueryDataSetInputLayer.this.timestampIndex];
        }

        @Override
        public float currentFloat() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public double currentDouble() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean currentBoolean() throws IOException {
            throw new UnsupportedOperationException();
        }

        @Override
        public boolean isCurrentNull() throws IOException {
            return false;
        }

        @Override
        public Binary currentBinary() throws IOException {
            throw new UnsupportedOperationException();
        }
    }

    private class ValuePointReader
    extends AbstractLayerPointReader {
        protected final int columnIndex;

        ValuePointReader(int columnIndex) {
            this.columnIndex = columnIndex;
        }

        @Override
        public YieldableState yield() throws IOException, QueryProcessException {
            YieldableState yieldableState;
            Object[] rowRecordCandidate;
            if (this.hasCachedRowRecord) {
                return YieldableState.YIELDABLE;
            }
            for (int i = this.currentRowIndex + 1; i < QueryDataSetInputLayer.this.rowRecordList.size(); ++i) {
                rowRecordCandidate = QueryDataSetInputLayer.this.rowRecordList.getRowRecord(i);
                if (rowRecordCandidate[this.columnIndex] == null && !QueryDataSetInputLayer.this.rowRecordList.fieldsHasAnyNull(i)) continue;
                this.hasCachedRowRecord = true;
                this.cachedRowRecord = rowRecordCandidate;
                this.currentRowIndex = i;
                return YieldableState.YIELDABLE;
            }
            while (YieldableState.YIELDABLE.equals((Object)(yieldableState = QueryDataSetInputLayer.this.queryDataSet.canYieldNextRowInObjects()))) {
                rowRecordCandidate = QueryDataSetInputLayer.this.queryDataSet.nextRowInObjects();
                QueryDataSetInputLayer.this.rowRecordList.put(rowRecordCandidate);
                if (rowRecordCandidate[this.columnIndex] == null && !QueryDataSetInputLayer.this.rowRecordList.fieldsHasAnyNull(QueryDataSetInputLayer.this.rowRecordList.size() - 1)) continue;
                this.hasCachedRowRecord = true;
                this.cachedRowRecord = rowRecordCandidate;
                this.currentRowIndex = QueryDataSetInputLayer.this.rowRecordList.size() - 1;
                return YieldableState.YIELDABLE;
            }
            return yieldableState;
        }

        @Override
        public boolean next() throws IOException, QueryProcessException {
            if (this.hasCachedRowRecord) {
                return true;
            }
            for (int i = this.currentRowIndex + 1; i < QueryDataSetInputLayer.this.rowRecordList.size(); ++i) {
                Object[] rowRecordCandidate = QueryDataSetInputLayer.this.rowRecordList.getRowRecord(i);
                if (rowRecordCandidate[this.columnIndex] == null && !QueryDataSetInputLayer.this.rowRecordList.fieldsHasAnyNull(i)) continue;
                this.hasCachedRowRecord = true;
                this.cachedRowRecord = rowRecordCandidate;
                this.currentRowIndex = i;
                break;
            }
            if (!this.hasCachedRowRecord) {
                while (QueryDataSetInputLayer.this.queryDataSet.hasNextRowInObjects()) {
                    Object[] rowRecordCandidate = QueryDataSetInputLayer.this.queryDataSet.nextRowInObjects();
                    QueryDataSetInputLayer.this.rowRecordList.put(rowRecordCandidate);
                    if (rowRecordCandidate[this.columnIndex] == null && !QueryDataSetInputLayer.this.rowRecordList.fieldsHasAnyNull(QueryDataSetInputLayer.this.rowRecordList.size() - 1)) continue;
                    this.hasCachedRowRecord = true;
                    this.cachedRowRecord = rowRecordCandidate;
                    this.currentRowIndex = QueryDataSetInputLayer.this.rowRecordList.size() - 1;
                    break;
                }
            }
            return this.hasCachedRowRecord;
        }

        @Override
        public TSDataType getDataType() {
            return QueryDataSetInputLayer.this.dataTypes[this.columnIndex];
        }

        @Override
        public int currentInt() {
            return (Integer)this.cachedRowRecord[this.columnIndex];
        }

        @Override
        public long currentLong() {
            return (Long)this.cachedRowRecord[this.columnIndex];
        }

        @Override
        public float currentFloat() {
            return ((Float)this.cachedRowRecord[this.columnIndex]).floatValue();
        }

        @Override
        public double currentDouble() {
            return (Double)this.cachedRowRecord[this.columnIndex];
        }

        @Override
        public boolean currentBoolean() {
            return (Boolean)this.cachedRowRecord[this.columnIndex];
        }

        @Override
        public boolean isCurrentNull() {
            return this.cachedRowRecord[this.columnIndex] == null;
        }

        @Override
        public Binary currentBinary() {
            return (Binary)this.cachedRowRecord[this.columnIndex];
        }
    }

    private abstract class AbstractLayerPointReader
    implements LayerPointReader {
        protected final SafetyLine.SafetyPile safetyPile;
        protected int currentRowIndex;
        protected boolean hasCachedRowRecord;
        protected Object[] cachedRowRecord;

        AbstractLayerPointReader() {
            this.safetyPile = QueryDataSetInputLayer.this.safetyLine.addSafetyPile();
            this.hasCachedRowRecord = false;
            this.cachedRowRecord = null;
            this.currentRowIndex = -1;
        }

        @Override
        public final long currentTime() throws IOException {
            return (Long)this.cachedRowRecord[QueryDataSetInputLayer.this.timestampIndex];
        }

        @Override
        public final boolean isConstantPointReader() {
            return false;
        }

        @Override
        public final void readyForNext() {
            this.hasCachedRowRecord = false;
            this.cachedRowRecord = null;
            this.safetyPile.moveForwardTo(this.currentRowIndex + 1);
        }
    }
}

