/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.transformation.dag.transformer.multi;

import java.io.IOException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.mpp.transformation.api.LayerRowWindowReader;
import org.apache.iotdb.db.mpp.transformation.api.YieldableState;
import org.apache.iotdb.db.mpp.transformation.dag.transformer.multi.UniversalUDFQueryTransformer;
import org.apache.iotdb.db.mpp.transformation.dag.udf.UDTFExecutor;

public class UDFQueryRowWindowTransformer
extends UniversalUDFQueryTransformer {
    protected final LayerRowWindowReader layerRowWindowReader;

    public UDFQueryRowWindowTransformer(LayerRowWindowReader layerRowWindowReader, UDTFExecutor executor) {
        super(executor);
        this.layerRowWindowReader = layerRowWindowReader;
    }

    @Override
    protected YieldableState tryExecuteUDFOnce() throws QueryProcessException, IOException {
        YieldableState yieldableState = this.layerRowWindowReader.yield();
        if (yieldableState != YieldableState.YIELDABLE) {
            return yieldableState;
        }
        this.executor.execute(this.layerRowWindowReader.currentWindow());
        this.layerRowWindowReader.readyForNext();
        return YieldableState.YIELDABLE;
    }

    @Override
    protected boolean executeUDFOnce() throws QueryProcessException, IOException {
        if (!this.layerRowWindowReader.next()) {
            return false;
        }
        this.executor.execute(this.layerRowWindowReader.currentWindow());
        this.layerRowWindowReader.readyForNext();
        return true;
    }
}

