/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.protocol.influxdb.meta;

import java.io.IOException;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.metadata.StorageGroupNotSetException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.protocol.influxdb.meta.AbstractInfluxDBMetaManager;
import org.apache.iotdb.db.protocol.influxdb.meta.TagInfoRecords;
import org.apache.iotdb.db.qp.Planner;
import org.apache.iotdb.db.qp.physical.crud.InsertRowPlan;
import org.apache.iotdb.db.qp.physical.crud.QueryPlan;
import org.apache.iotdb.db.qp.physical.sys.SetStorageGroupPlan;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.service.basic.ServiceProvider;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.iotdb.tsfile.exception.filter.QueryFilterOptimizationException;
import org.apache.iotdb.tsfile.read.common.Field;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;
import org.apache.thrift.TException;
import org.influxdb.InfluxDBException;

public class InfluxDBMetaManager
extends AbstractInfluxDBMetaManager {
    protected final Planner planner;
    private final ServiceProvider serviceProvider = IoTDB.serviceProvider;

    private InfluxDBMetaManager() {
        database2Measurement2TagOrders = new HashMap();
        this.planner = this.serviceProvider.getPlanner();
    }

    public static InfluxDBMetaManager getInstance() {
        return InfluxDBMetaManagerHolder.INSTANCE;
    }

    @Override
    public void recover() {
        long queryId = ServiceProvider.SESSION_MANAGER.requestQueryId(true);
        try {
            QueryPlan queryPlan = (QueryPlan)this.planner.parseSQLToPhysicalPlan("select database_name,measurement_name,tag_name,tag_order from root.TAG_INFO ");
            QueryContext queryContext = this.serviceProvider.genQueryContext(queryId, true, System.currentTimeMillis(), "select database_name,measurement_name,tag_name,tag_order from root.TAG_INFO ", 0L);
            QueryDataSet queryDataSet = this.serviceProvider.createQueryDataSet(queryContext, queryPlan, 5000);
            while (queryDataSet.hasNext()) {
                Map<String, Integer> tagOrders;
                Map measurement2TagOrders;
                List fields = queryDataSet.next().getFields();
                String databaseName = ((Field)fields.get(0)).getStringValue();
                String measurementName = ((Field)fields.get(1)).getStringValue();
                if (database2Measurement2TagOrders.containsKey(databaseName)) {
                    measurement2TagOrders = (Map)database2Measurement2TagOrders.get(databaseName);
                    tagOrders = measurement2TagOrders.containsKey(measurementName) ? (Map)measurement2TagOrders.get(measurementName) : new HashMap();
                } else {
                    measurement2TagOrders = new HashMap();
                    tagOrders = new HashMap<String, Integer>();
                }
                tagOrders.put(((Field)fields.get(2)).getStringValue(), ((Field)fields.get(3)).getIntV());
                measurement2TagOrders.put(measurementName, tagOrders);
                database2Measurement2TagOrders.put(databaseName, measurement2TagOrders);
            }
        }
        catch (IOException | InterruptedException | SQLException | MetadataException | StorageEngineException | QueryProcessException | QueryFilterOptimizationException | TException e) {
            throw new InfluxDBException(((Throwable)e).getMessage());
        }
        finally {
            ServiceProvider.SESSION_MANAGER.releaseQueryResourceNoExceptions(queryId);
        }
    }

    @Override
    public void setStorageGroup(String database, long sessionID) {
        try {
            SetStorageGroupPlan setStorageGroupPlan = new SetStorageGroupPlan(new PartialPath("root." + database));
            this.serviceProvider.executeNonQuery(setStorageGroupPlan);
        }
        catch (QueryProcessException e) {
            if (e.getErrorCode() != TSStatusCode.STORAGE_GROUP_ALREADY_EXISTS.getStatusCode()) {
                throw new InfluxDBException(e.getMessage());
            }
        }
        catch (IllegalPathException | StorageEngineException | StorageGroupNotSetException e) {
            throw new InfluxDBException(e.getMessage());
        }
    }

    @Override
    public void updateTagInfoRecords(TagInfoRecords tagInfoRecords, long sessionID) {
        List<InsertRowPlan> plans = tagInfoRecords.convertToInsertRowPlans();
        for (InsertRowPlan plan : plans) {
            try {
                this.serviceProvider.executeNonQuery(plan);
            }
            catch (StorageEngineException | StorageGroupNotSetException | QueryProcessException e) {
                throw new InfluxDBException(e.getMessage());
            }
        }
    }

    private static class InfluxDBMetaManagerHolder {
        private static final InfluxDBMetaManager INSTANCE = new InfluxDBMetaManager();

        private InfluxDBMetaManagerHolder() {
        }
    }
}

