/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.logical.sys;

import java.util.HashMap;
import java.util.Map;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.sys.CreatePipePlan;
import org.apache.iotdb.db.qp.strategy.PhysicalGenerator;

public class CreatePipeOperator
extends Operator {
    private String pipeName;
    private String pipeSinkName;
    private long startTime;
    private Map<String, String> pipeAttributes;

    public CreatePipeOperator(String pipeName, String pipeSinkName) {
        super(204);
        this.operatorType = Operator.OperatorType.CREATE_PIPE;
        this.pipeName = pipeName;
        this.pipeSinkName = pipeSinkName;
        this.startTime = 0L;
        this.pipeAttributes = new HashMap<String, String>();
    }

    public void setStartTime(long startTime) {
        this.startTime = startTime;
    }

    public void setPipeAttributes(Map<String, String> pipeAttributes) {
        this.pipeAttributes = pipeAttributes;
    }

    @Override
    public PhysicalPlan generatePhysicalPlan(PhysicalGenerator generator) throws QueryProcessException {
        CreatePipePlan plan = new CreatePipePlan(this.pipeName, this.pipeSinkName);
        plan.setDataStartTimestamp(this.startTime);
        for (Map.Entry<String, String> entry : this.pipeAttributes.entrySet()) {
            plan.addPipeAttribute(entry.getKey(), entry.getValue());
        }
        return plan;
    }
}

