/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.dataset.groupby;

import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.engine.StorageEngine;
import org.apache.iotdb.db.engine.storagegroup.DataRegion;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.path.AlignedPath;
import org.apache.iotdb.db.metadata.path.MeasurementPath;
import org.apache.iotdb.db.metadata.utils.MetaUtils;
import org.apache.iotdb.db.qp.physical.crud.GroupByTimePlan;
import org.apache.iotdb.db.query.aggregation.AggregateResult;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.control.QueryResourceManager;
import org.apache.iotdb.db.query.dataset.groupby.GroupByTimeEngineDataSet;
import org.apache.iotdb.db.query.executor.groupby.AlignedGroupByExecutor;
import org.apache.iotdb.db.query.executor.groupby.GroupByExecutor;
import org.apache.iotdb.db.query.executor.groupby.SlidingWindowGroupByExecutor;
import org.apache.iotdb.db.query.executor.groupby.SlidingWindowGroupByExecutorFactory;
import org.apache.iotdb.db.query.executor.groupby.impl.LocalAlignedGroupByExecutor;
import org.apache.iotdb.db.query.executor.groupby.impl.LocalGroupByExecutor;
import org.apache.iotdb.db.query.factory.AggregateResultFactory;
import org.apache.iotdb.db.query.filter.TsFileFilter;
import org.apache.iotdb.tsfile.read.expression.IExpression;
import org.apache.iotdb.tsfile.read.expression.impl.GlobalTimeExpression;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GroupByWithoutValueFilterDataSet
extends GroupByTimeEngineDataSet {
    private static final Logger logger = LoggerFactory.getLogger(GroupByWithoutValueFilterDataSet.class);
    protected Map<PartialPath, GroupByExecutor> pathExecutors = new HashMap<PartialPath, GroupByExecutor>();
    protected Map<AlignedPath, AlignedGroupByExecutor> alignedPathExecutors = new HashMap<AlignedPath, AlignedGroupByExecutor>();
    protected Map<PartialPath, List<Integer>> pathToAggrIndexesMap = new HashMap<PartialPath, List<Integer>>();
    protected Map<AlignedPath, List<List<Integer>>> alignedPathToAggrIndexesMap = new HashMap<AlignedPath, List<List<Integer>>>();

    public GroupByWithoutValueFilterDataSet() {
    }

    public GroupByWithoutValueFilterDataSet(QueryContext context, GroupByTimePlan groupByTimePlan) {
        super(context, groupByTimePlan);
    }

    public void initGroupBy(QueryContext context, GroupByTimePlan groupByTimePlan) throws StorageEngineException, QueryProcessException {
        PartialPath path;
        IExpression expression = groupByTimePlan.getExpression();
        Filter timeFilter = null;
        if (expression != null) {
            timeFilter = ((GlobalTimeExpression)expression).getFilter();
        }
        if (timeFilter == null) {
            throw new QueryProcessException("TimeFilter cannot be null in GroupBy query.");
        }
        this.pathToAggrIndexesMap = MetaUtils.groupAggregationsBySeries(this.paths);
        this.alignedPathToAggrIndexesMap = MetaUtils.groupAlignedSeriesWithAggregations(this.pathToAggrIndexesMap);
        ArrayList<PartialPath> groupedPathList = new ArrayList<PartialPath>(this.pathToAggrIndexesMap.size() + this.alignedPathToAggrIndexesMap.size());
        groupedPathList.addAll(this.pathToAggrIndexesMap.keySet());
        groupedPathList.addAll(this.alignedPathToAggrIndexesMap.keySet());
        Pair<List<DataRegion>, Map<DataRegion, List<PartialPath>>> lockListAndProcessorToSeriesMapPair = StorageEngine.getInstance().mergeLock(groupedPathList);
        List lockList = (List)lockListAndProcessorToSeriesMapPair.left;
        Map processorToSeriesMap = (Map)lockListAndProcessorToSeriesMapPair.right;
        try {
            QueryResourceManager.getInstance().initQueryDataSourceCache(processorToSeriesMap, context, timeFilter);
        }
        catch (Exception e) {
            logger.error("Meet error when init QueryDataSource ", (Throwable)e);
            throw new QueryProcessException("Meet error when init QueryDataSource.", e);
        }
        finally {
            StorageEngine.getInstance().mergeUnLock(lockList);
        }
        for (Map.Entry<PartialPath, List<Integer>> entry : this.pathToAggrIndexesMap.entrySet()) {
            path = (MeasurementPath)entry.getKey();
            List<Integer> indexes = entry.getValue();
            if (!this.pathExecutors.containsKey(path)) {
                this.pathExecutors.put(path, this.getGroupByExecutor(path, groupByTimePlan.getAllMeasurementsInDevice(path.getDevice()), context, timeFilter.copy(), null, this.ascending));
            }
            for (int index : indexes) {
                AggregateResult aggrResult = AggregateResultFactory.getAggrResultByName(groupByTimePlan.getDeduplicatedAggregations().get(index), path.getSeriesType(), this.ascending);
                this.slidingWindowGroupByExecutors[index] = SlidingWindowGroupByExecutorFactory.getSlidingWindowGroupByExecutor(groupByTimePlan.getDeduplicatedAggregations().get(index), path.getSeriesType(), this.ascending);
                this.pathExecutors.get(path).addAggregateResult(aggrResult);
            }
        }
        for (Map.Entry<Object, List<Object>> entry : this.alignedPathToAggrIndexesMap.entrySet()) {
            path = (AlignedPath)((Object)entry.getKey());
            List<Object> indexesList = entry.getValue();
            if (!this.alignedPathExecutors.containsKey(path)) {
                this.alignedPathExecutors.put((AlignedPath)path, this.getAlignedGroupByExecutor(path, context, timeFilter.copy(), null, this.ascending));
            }
            for (int i = 0; i < path.getMeasurementList().size(); ++i) {
                ArrayList<AggregateResult> aggrResultList = new ArrayList<AggregateResult>();
                Iterator iterator = ((List)indexesList.get(i)).iterator();
                while (iterator.hasNext()) {
                    int index = (Integer)iterator.next();
                    AggregateResult aggrResult = AggregateResultFactory.getAggrResultByName(groupByTimePlan.getDeduplicatedAggregations().get(index), path.getSchemaList().get(i).getType(), this.ascending);
                    this.slidingWindowGroupByExecutors[index] = SlidingWindowGroupByExecutorFactory.getSlidingWindowGroupByExecutor(groupByTimePlan.getDeduplicatedAggregations().get(index), path.getSchemaList().get(i).getType(), this.ascending);
                    aggrResultList.add(aggrResult);
                }
                this.alignedPathExecutors.get(path).addAggregateResult(aggrResultList);
            }
        }
    }

    @Override
    protected AggregateResult[] getNextAggregateResult() throws IOException {
        this.curAggregateResults = new AggregateResult[this.paths.size()];
        for (SlidingWindowGroupByExecutor slidingWindowGroupByExecutor : this.slidingWindowGroupByExecutors) {
            slidingWindowGroupByExecutor.setTimeRange(this.curAggrTimeRange.getMin(), this.curAggrTimeRange.getMax());
        }
        try {
            while (!this.isEndCal()) {
                int i;
                Object groupByExecutor;
                for (Map.Entry entry : this.pathToAggrIndexesMap.entrySet()) {
                    MeasurementPath path = (MeasurementPath)((Object)entry.getKey());
                    List indexes = (List)entry.getValue();
                    groupByExecutor = this.pathExecutors.get((Object)path);
                    List<AggregateResult> aggregations = groupByExecutor.calcResult(this.curPreAggrTimeRange.getMin(), this.curPreAggrTimeRange.getMax());
                    for (i = 0; i < aggregations.size(); ++i) {
                        int resultIndex = (Integer)indexes.get(i);
                        this.slidingWindowGroupByExecutors[resultIndex].update(aggregations.get(i).clone());
                    }
                }
                for (Map.Entry entry : this.alignedPathToAggrIndexesMap.entrySet()) {
                    AlignedPath path = (AlignedPath)((Object)entry.getKey());
                    List indexesList = (List)entry.getValue();
                    groupByExecutor = this.alignedPathExecutors.get((Object)path);
                    List<List<AggregateResult>> aggregationsList = groupByExecutor.calcAlignedResult(this.curPreAggrTimeRange.getMin(), this.curPreAggrTimeRange.getMax());
                    for (i = 0; i < path.getMeasurementList().size(); ++i) {
                        List<AggregateResult> aggregations = aggregationsList.get(i);
                        List indexes = (List)indexesList.get(i);
                        for (int j = 0; j < aggregations.size(); ++j) {
                            int resultIndex = (Integer)indexes.get(j);
                            this.slidingWindowGroupByExecutors[resultIndex].update(aggregations.get(j).clone());
                        }
                    }
                }
                this.updatePreAggrInterval();
            }
            for (int i = 0; i < this.curAggregateResults.length; ++i) {
                this.curAggregateResults[i] = this.slidingWindowGroupByExecutors[i].getAggregateResult();
            }
        }
        catch (QueryProcessException e) {
            logger.error("GroupByWithoutValueFilterDataSet execute has error", (Throwable)((Object)e));
            throw new IOException(e.getMessage(), (Throwable)((Object)e));
        }
        return this.curAggregateResults;
    }

    protected GroupByExecutor getGroupByExecutor(PartialPath path, Set<String> allSensors, QueryContext context, Filter timeFilter, TsFileFilter fileFilter, boolean ascending) throws StorageEngineException, QueryProcessException {
        return new LocalGroupByExecutor(path, allSensors, context, timeFilter, fileFilter, ascending);
    }

    protected AlignedGroupByExecutor getAlignedGroupByExecutor(PartialPath path, QueryContext context, Filter timeFilter, TsFileFilter fileFilter, boolean ascending) throws StorageEngineException, QueryProcessException {
        return new LocalAlignedGroupByExecutor(path, context, timeFilter, fileFilter, ascending);
    }
}

