/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.query.executor;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.StorageEngine;
import org.apache.iotdb.db.engine.querycontext.QueryDataSource;
import org.apache.iotdb.db.engine.storagegroup.DataRegion;
import org.apache.iotdb.db.exception.StorageEngineException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.idtable.IDTable;
import org.apache.iotdb.db.metadata.idtable.entry.TimeseriesID;
import org.apache.iotdb.db.metadata.mnode.IMeasurementMNode;
import org.apache.iotdb.db.metadata.path.MeasurementPath;
import org.apache.iotdb.db.metadata.utils.ResourceByPathUtils;
import org.apache.iotdb.db.mpp.execution.operator.process.last.LastQueryUtil;
import org.apache.iotdb.db.qp.physical.crud.LastQueryPlan;
import org.apache.iotdb.db.qp.physical.crud.RawDataQueryPlan;
import org.apache.iotdb.db.query.context.QueryContext;
import org.apache.iotdb.db.query.control.QueryResourceManager;
import org.apache.iotdb.db.query.dataset.ListDataSet;
import org.apache.iotdb.db.query.executor.fill.LastPointReader;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.TimeValuePair;
import org.apache.iotdb.tsfile.read.common.Field;
import org.apache.iotdb.tsfile.read.common.RowRecord;
import org.apache.iotdb.tsfile.read.expression.IExpression;
import org.apache.iotdb.tsfile.read.expression.impl.GlobalTimeExpression;
import org.apache.iotdb.tsfile.read.filter.basic.Filter;
import org.apache.iotdb.tsfile.read.filter.operator.Gt;
import org.apache.iotdb.tsfile.read.filter.operator.GtEq;
import org.apache.iotdb.tsfile.read.query.dataset.QueryDataSet;
import org.apache.iotdb.tsfile.utils.Binary;
import org.apache.iotdb.tsfile.utils.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LastQueryExecutor {
    private List<PartialPath> selectedSeries;
    private List<TSDataType> dataTypes;
    protected IExpression expression;
    private static final boolean CACHE_ENABLED = IoTDBDescriptor.getInstance().getConfig().isLastCacheEnabled();
    private static final Logger DEBUG_LOGGER = LoggerFactory.getLogger((String)"QUERY_DEBUG");
    private static boolean ID_TABLE_ENABLED = IoTDBDescriptor.getInstance().getConfig().isEnableIDTable();
    private static boolean ascending;
    private static final Logger logger;

    public LastQueryExecutor(LastQueryPlan lastQueryPlan) {
        this.selectedSeries = lastQueryPlan.getDeduplicatedPaths();
        this.dataTypes = lastQueryPlan.getDeduplicatedDataTypes();
        this.expression = lastQueryPlan.getExpression();
        ascending = lastQueryPlan.isAscending();
    }

    public LastQueryExecutor(List<PartialPath> selectedSeries, List<TSDataType> dataTypes) {
        this.selectedSeries = selectedSeries;
        this.dataTypes = dataTypes;
    }

    public QueryDataSet execute(QueryContext context, LastQueryPlan lastQueryPlan) throws StorageEngineException, IOException, QueryProcessException {
        ListDataSet dataSet = new ListDataSet(Arrays.asList(new PartialPath("timeseries", false), new PartialPath("value", false), new PartialPath("dataType", false)), Arrays.asList(TSDataType.TEXT, TSDataType.TEXT, TSDataType.TEXT));
        List<TimeValuePair> lastPairList = this.calculateLastPairForSeries(this.selectedSeries, this.dataTypes, context, this.expression, lastQueryPlan);
        for (int i = 0; i < lastPairList.size(); ++i) {
            if (lastPairList.get(i) == null || lastPairList.get(i).getValue() == null) continue;
            TimeValuePair lastTimeValuePair = lastPairList.get(i);
            RowRecord resultRecord = new RowRecord(lastTimeValuePair.getTimestamp());
            Field pathField = new Field(TSDataType.TEXT);
            pathField.setBinaryV(new Binary(lastQueryPlan.getResultColumns().get(i).getResultColumnName()));
            resultRecord.addField(pathField);
            Field valueField = new Field(TSDataType.TEXT);
            valueField.setBinaryV(new Binary(lastTimeValuePair.getValue().getStringValue()));
            resultRecord.addField(valueField);
            Field typeField = new Field(TSDataType.TEXT);
            typeField.setBinaryV(new Binary(lastTimeValuePair.getValue().getDataType().name()));
            resultRecord.addField(typeField);
            dataSet.putRecord(resultRecord);
        }
        if (!lastQueryPlan.isAscending()) {
            dataSet.sortByTime();
        }
        return dataSet;
    }

    protected List<TimeValuePair> calculateLastPairForSeries(List<PartialPath> seriesPaths, List<TSDataType> dataTypes, QueryContext context, IExpression expression, RawDataQueryPlan lastQueryPlan) throws QueryProcessException, StorageEngineException, IOException {
        return LastQueryExecutor.calculateLastPairForSeriesLocally(seriesPaths, dataTypes, context, expression, lastQueryPlan.getDeviceToMeasurements());
    }

    public static List<TimeValuePair> calculateLastPairForSeriesLocally(List<PartialPath> seriesPaths, List<TSDataType> dataTypes, QueryContext context, IExpression expression, Map<String, Set<String>> deviceMeasurementsMap) throws QueryProcessException, StorageEngineException, IOException {
        Filter filter;
        Filter filter2 = filter = expression == null ? null : ((GlobalTimeExpression)expression).getFilter();
        if (CACHE_ENABLED) {
            ArrayList<LastCacheAccessor> cacheAccessors = new ArrayList<LastCacheAccessor>();
            for (PartialPath path : seriesPaths) {
                if (ID_TABLE_ENABLED) {
                    cacheAccessors.add(new IDTableLastCacheAccessor(path));
                    continue;
                }
                cacheAccessors.add(new SchemaProcessorLastCacheAccessor(path));
            }
            List<TimeValuePair> lastPairs = LastQueryExecutor.readLastPairsFromCache(seriesPaths, cacheAccessors, context.isDebug());
            ArrayList<Integer> nonCachedIndices = new ArrayList<Integer>();
            ArrayList<PartialPath> nonCachedPaths = new ArrayList<PartialPath>();
            ArrayList<TSDataType> nonCachedDataTypes = new ArrayList<TSDataType>();
            for (int i = 0; i < lastPairs.size(); ++i) {
                boolean isFilterGtOrGe;
                TimeValuePair lastPair = lastPairs.get(i);
                if (lastPair == null) {
                    nonCachedPaths.add(((MeasurementPath)seriesPaths.get(i)).transformToExactPath());
                    nonCachedDataTypes.add(dataTypes.get(i));
                    nonCachedIndices.add(i);
                    continue;
                }
                if (LastQueryUtil.satisfyFilter(filter, lastPair)) continue;
                lastPairs.set(i, null);
                boolean bl = isFilterGtOrGe = filter instanceof Gt || filter instanceof GtEq;
                if (isFilterGtOrGe) continue;
                nonCachedPaths.add(((MeasurementPath)seriesPaths.get(i)).transformToExactPath());
                nonCachedDataTypes.add(dataTypes.get(i));
                nonCachedIndices.add(i);
            }
            List<TimeValuePair> nonCachedLastPairs = LastQueryExecutor.readLastPairsFromStorage(nonCachedPaths, nonCachedDataTypes, filter, context, deviceMeasurementsMap);
            for (int i = 0; i < nonCachedLastPairs.size(); ++i) {
                if (lastPairs.get((Integer)nonCachedIndices.get(i)) == null && nonCachedLastPairs.get(i) != null && (filter instanceof GtEq || filter instanceof Gt)) {
                    ((LastCacheAccessor)cacheAccessors.get((Integer)nonCachedIndices.get(i))).write(nonCachedLastPairs.get(i));
                }
                lastPairs.set((Integer)nonCachedIndices.get(i), nonCachedLastPairs.get(i));
            }
            return lastPairs;
        }
        return LastQueryExecutor.readLastPairsFromStorage(seriesPaths.stream().map(p -> ((MeasurementPath)((Object)p)).transformToExactPath()).collect(Collectors.toList()), dataTypes, filter, context, deviceMeasurementsMap);
    }

    private static List<TimeValuePair> readLastPairsFromCache(List<PartialPath> seriesPaths, List<LastCacheAccessor> cacheAccessors, boolean debugOn) {
        ArrayList<TimeValuePair> ret = new ArrayList<TimeValuePair>();
        for (int i = 0; i < cacheAccessors.size(); ++i) {
            TimeValuePair tvPair = cacheAccessors.get(i).read();
            ret.add(tvPair);
            if (tvPair == null || !debugOn) continue;
            DEBUG_LOGGER.info("[LastQueryExecutor] Last cache hit for path: {} with timestamp: {}", (Object)seriesPaths.get(i), (Object)tvPair.getTimestamp());
        }
        return ret;
    }

    private static List<TimeValuePair> readLastPairsFromStorage(List<PartialPath> seriesPaths, List<TSDataType> dataTypes, Filter filter, QueryContext context, Map<String, Set<String>> deviceMeasurementsMap) throws StorageEngineException, QueryProcessException, IOException {
        Pair<List<DataRegion>, Map<DataRegion, List<PartialPath>>> lockListAndProcessorToSeriesMapPair = StorageEngine.getInstance().mergeLock(seriesPaths);
        List lockList = (List)lockListAndProcessorToSeriesMapPair.left;
        Map processorToSeriesMap = (Map)lockListAndProcessorToSeriesMapPair.right;
        try {
            QueryResourceManager.getInstance().initQueryDataSourceCache(processorToSeriesMap, context, filter);
        }
        catch (Exception e) {
            logger.error("Meet error when init QueryDataSource ", (Throwable)e);
            throw new QueryProcessException("Meet error when init QueryDataSource.", e);
        }
        finally {
            StorageEngine.getInstance().mergeUnLock(lockList);
        }
        ArrayList<LastPointReader> readers = new ArrayList<LastPointReader>();
        for (int i = 0; i < seriesPaths.size(); ++i) {
            QueryDataSource dataSource = QueryResourceManager.getInstance().getQueryDataSource(seriesPaths.get(i), context, filter, ascending);
            LastPointReader lastReader = ResourceByPathUtils.getResourceInstance(seriesPaths.get(i)).createLastPointReader(dataTypes.get(i), deviceMeasurementsMap.getOrDefault(seriesPaths.get(i).getDevice(), new HashSet()), context, dataSource, Long.MAX_VALUE, filter);
            readers.add(lastReader);
        }
        ArrayList<TimeValuePair> lastPairs = new ArrayList<TimeValuePair>(seriesPaths.size());
        for (LastPointReader reader : readers) {
            lastPairs.add(reader.readLastPoint());
        }
        return lastPairs;
    }

    public static void clear() {
        ID_TABLE_ENABLED = IoTDBDescriptor.getInstance().getConfig().isEnableIDTable();
    }

    static {
        logger = LoggerFactory.getLogger(LastQueryExecutor.class);
    }

    private static class IDTableLastCacheAccessor
    implements LastCacheAccessor {
        private PartialPath fullPath;

        IDTableLastCacheAccessor(PartialPath seriesPath) {
            this.fullPath = seriesPath;
        }

        @Override
        public TimeValuePair read() {
            try {
                IDTable table = StorageEngine.getInstance().getProcessor(this.fullPath.getDevicePath()).getIdTable();
                return table.getLastCache(new TimeseriesID(this.fullPath));
            }
            catch (MetadataException | StorageEngineException e) {
                logger.error("last query can't find storage group: path is: " + this.fullPath);
                return null;
            }
        }

        @Override
        public void write(TimeValuePair pair) {
            try {
                IDTable table = StorageEngine.getInstance().getProcessor(this.fullPath.getDevicePath()).getIdTable();
                table.updateLastCache(new TimeseriesID(this.fullPath), pair, false, Long.MIN_VALUE);
            }
            catch (MetadataException | StorageEngineException e) {
                logger.error("last query can't find storage group: path is: " + this.fullPath);
            }
        }
    }

    private static class SchemaProcessorLastCacheAccessor
    implements LastCacheAccessor {
        private final MeasurementPath path;
        private IMeasurementMNode node;

        SchemaProcessorLastCacheAccessor(PartialPath seriesPath) {
            this.path = (MeasurementPath)seriesPath;
        }

        @Override
        public TimeValuePair read() {
            block3: {
                try {
                    this.node = IoTDB.schemaProcessor.getMeasurementMNode(this.path);
                }
                catch (MetadataException e) {
                    TimeValuePair timeValuePair = IoTDB.schemaProcessor.getLastCache(this.path);
                    if (timeValuePair == null) break block3;
                    return timeValuePair;
                }
            }
            if (this.node == null) {
                return null;
            }
            return IoTDB.schemaProcessor.getLastCache(this.node);
        }

        @Override
        public void write(TimeValuePair pair) {
            if (this.node == null) {
                IoTDB.schemaProcessor.updateLastCache(this.path, pair, false, (Long)Long.MIN_VALUE);
            } else {
                IoTDB.schemaProcessor.updateLastCache(this.node, pair, false, (Long)Long.MIN_VALUE);
            }
        }
    }

    private static interface LastCacheAccessor {
        public TimeValuePair read();

        public void write(TimeValuePair var1);
    }
}

