/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.service;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.concurrent.TimeUnit;
import org.apache.iotdb.common.rpc.thrift.TConfigNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupType;
import org.apache.iotdb.common.rpc.thrift.TDataNodeConfiguration;
import org.apache.iotdb.common.rpc.thrift.TDataNodeLocation;
import org.apache.iotdb.common.rpc.thrift.TEndPoint;
import org.apache.iotdb.common.rpc.thrift.TNodeResource;
import org.apache.iotdb.commons.concurrent.IoTDBDefaultThreadExceptionHandler;
import org.apache.iotdb.commons.exception.ConfigurationException;
import org.apache.iotdb.commons.exception.StartupException;
import org.apache.iotdb.commons.service.IService;
import org.apache.iotdb.commons.service.JMXService;
import org.apache.iotdb.commons.service.RegisterManager;
import org.apache.iotdb.commons.service.StartupChecks;
import org.apache.iotdb.commons.udf.service.UDFClassLoaderManager;
import org.apache.iotdb.commons.udf.service.UDFExecutableManager;
import org.apache.iotdb.commons.udf.service.UDFRegistrationService;
import org.apache.iotdb.confignode.rpc.thrift.TDataNodeRegisterReq;
import org.apache.iotdb.confignode.rpc.thrift.TDataNodeRegisterResp;
import org.apache.iotdb.db.client.ConfigNodeClient;
import org.apache.iotdb.db.client.ConfigNodeInfo;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.conf.IoTDBStartCheck;
import org.apache.iotdb.db.conf.rest.IoTDBRestServiceDescriptor;
import org.apache.iotdb.db.consensus.DataRegionConsensusImpl;
import org.apache.iotdb.db.consensus.SchemaRegionConsensusImpl;
import org.apache.iotdb.db.engine.StorageEngineV2;
import org.apache.iotdb.db.engine.cache.CacheHitRatioMonitor;
import org.apache.iotdb.db.engine.compaction.CompactionTaskManager;
import org.apache.iotdb.db.engine.cq.ContinuousQueryService;
import org.apache.iotdb.db.engine.flush.FlushManager;
import org.apache.iotdb.db.engine.trigger.service.TriggerRegistrationService;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.metadata.schemaregion.SchemaEngine;
import org.apache.iotdb.db.metadata.template.ClusterTemplateManager;
import org.apache.iotdb.db.mpp.execution.exchange.MPPDataExchangeService;
import org.apache.iotdb.db.mpp.execution.schedule.DriverScheduler;
import org.apache.iotdb.db.protocol.mpprest.MPPRestService;
import org.apache.iotdb.db.service.DataNodeInternalRPCService;
import org.apache.iotdb.db.service.DataNodeMBean;
import org.apache.iotdb.db.service.DataNodeServerCommandLine;
import org.apache.iotdb.db.service.InfluxDBRPCService;
import org.apache.iotdb.db.service.IoTDB;
import org.apache.iotdb.db.service.IoTDBShutdownHook;
import org.apache.iotdb.db.service.MQTTService;
import org.apache.iotdb.db.service.RPCService;
import org.apache.iotdb.db.service.RegionMigrateService;
import org.apache.iotdb.db.service.TemporaryQueryDataFileService;
import org.apache.iotdb.db.service.UpgradeSevice;
import org.apache.iotdb.db.service.basic.ServiceProvider;
import org.apache.iotdb.db.service.basic.StandaloneServiceProvider;
import org.apache.iotdb.db.service.metrics.MetricService;
import org.apache.iotdb.db.service.thrift.impl.ClientRPCServiceImpl;
import org.apache.iotdb.db.sync.SyncService;
import org.apache.iotdb.db.wal.WALManager;
import org.apache.iotdb.db.wal.utils.WALMode;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DataNode
implements DataNodeMBean {
    private static final Logger logger = LoggerFactory.getLogger(DataNode.class);
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private final String mbeanName = String.format("%s:%s=%s", "org.apache.iotdb.datanode.service", "type", "DataNode");
    private static final int DEFAULT_JOIN_RETRY = 10;
    private final TEndPoint thisNode = new TEndPoint();
    private static final RegisterManager registerManager = new RegisterManager();
    public static ServiceProvider serviceProvider;

    private DataNode() {
    }

    public static DataNode getInstance() {
        return DataNodeHolder.INSTANCE;
    }

    public static void main(String[] args) {
        new DataNodeServerCommandLine().doMain(args);
    }

    protected void serverCheckAndInit() throws ConfigurationException, IOException {
        IoTDBStartCheck.getInstance().checkConfig();
        if (config.getRpcAddress().equals("0.0.0.0")) {
            config.setRpcAddress(config.getInternalAddress());
        }
        this.thisNode.setIp(IoTDBDescriptor.getInstance().getConfig().getInternalAddress());
        this.thisNode.setPort(IoTDBDescriptor.getInstance().getConfig().getInternalPort());
    }

    protected void doAddNode() {
        try {
            this.prepareDataNode();
            this.registerInConfigNode();
            this.active();
            this.setUpRPCService();
            logger.info("IoTDB configuration: " + config.getConfigMessage());
            logger.info("Congratulation, IoTDB DataNode is set up successfully. Now, enjoy yourself!");
        }
        catch (StartupException e) {
            logger.error("Fail to start server", (Throwable)e);
            this.stop();
        }
    }

    public boolean initLocalEngines() {
        config.setClusterMode(true);
        return true;
    }

    private void prepareDataNode() throws StartupException {
        StartupChecks checks = new StartupChecks().withDefaultTest();
        checks.verify();
        JMXService.registerMBean((Object)DataNode.getInstance(), (String)this.mbeanName);
        IoTDBDescriptor.getInstance().getConfig().setMppMode(true);
        IoTDBDescriptor.getInstance().getConfig().setClusterMode(true);
    }

    private void registerInConfigNode() throws StartupException {
        ConfigNodeInfo.getInstance().updateConfigNodeList(IoTDBDescriptor.getInstance().getConfig().getTargetConfigNodeList());
        for (int retry = 10; retry > 0; --retry) {
            logger.info("start registering to the cluster.");
            try (ConfigNodeClient configNodeClient = new ConfigNodeClient();){
                TDataNodeRegisterReq req = new TDataNodeRegisterReq();
                req.setDataNodeConfiguration(this.generateDataNodeConfiguration());
                TDataNodeRegisterResp dataNodeRegisterResp = configNodeClient.registerDataNode(req);
                ArrayList<TEndPoint> configNodeList = new ArrayList<TEndPoint>();
                for (TConfigNodeLocation configNodeLocation : dataNodeRegisterResp.getConfigNodeList()) {
                    configNodeList.add(configNodeLocation.getInternalEndPoint());
                }
                ConfigNodeInfo.getInstance().updateConfigNodeList(configNodeList);
                ClusterTemplateManager.getInstance().updateTemplateSetInfo(dataNodeRegisterResp.getTemplateInfo());
                if (dataNodeRegisterResp.getStatus().getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode() || dataNodeRegisterResp.getStatus().getCode() == TSStatusCode.DATANODE_ALREADY_REGISTERED.getStatusCode()) {
                    logger.info(dataNodeRegisterResp.getStatus().getMessage());
                    int dataNodeID = dataNodeRegisterResp.getDataNodeId();
                    if (dataNodeID != config.getDataNodeId()) {
                        IoTDBStartCheck.getInstance().serializeDataNodeId(dataNodeID);
                        config.setDataNodeId(dataNodeID);
                    }
                    IoTDBDescriptor.getInstance().loadGlobalConfig(dataNodeRegisterResp.globalConfig);
                    IoTDBDescriptor.getInstance().initClusterSchemaMemoryAllocate();
                    if (!IoTDBStartCheck.getInstance().checkConsensusProtocolExists(TConsensusGroupType.DataRegion)) {
                        config.setDataRegionConsensusProtocolClass(dataNodeRegisterResp.globalConfig.getDataRegionConsensusProtocolClass());
                    }
                    if (!IoTDBStartCheck.getInstance().checkConsensusProtocolExists(TConsensusGroupType.SchemaRegion)) {
                        config.setSchemaRegionConsensusProtocolClass(dataNodeRegisterResp.globalConfig.getSchemaRegionConsensusProtocolClass());
                    }
                    IoTDBStartCheck.getInstance().serializeGlobalConfig(dataNodeRegisterResp.globalConfig);
                    logger.info("Register to the cluster successfully");
                    return;
                }
            }
            catch (IOException e) {
                logger.warn("Cannot register to the cluster, because: {}", (Object)e.getMessage());
            }
            catch (TException e) {
                logger.warn("Cannot register to the cluster, because: {}", (Object)e.getMessage());
                ConfigNodeInfo.getInstance().loadConfigNodeList();
            }
            try {
                Thread.sleep(IoTDBDescriptor.getInstance().getConfig().getJoinClusterTimeOutMs());
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                logger.warn("Unexpected interruption when waiting to register to the cluster", (Throwable)e);
                break;
            }
        }
        logger.error("Cannot register to the cluster after {} retries", (Object)10);
        throw new StartupException("Cannot register to the cluster.");
    }

    private void active() throws StartupException {
        try {
            this.setUp();
        }
        catch (StartupException | QueryProcessException e) {
            logger.error("meet error while starting up.", (Throwable)e);
            throw new StartupException("Error in activating IoTDB DataNode.");
        }
        logger.info("IoTDB DataNode has started.");
        try {
            SchemaRegionConsensusImpl.setupAndGetInstance().start();
            DataRegionConsensusImpl.setupAndGetInstance().start();
        }
        catch (IOException e) {
            throw new StartupException((Throwable)e);
        }
    }

    private void setUp() throws StartupException, QueryProcessException {
        logger.info("Setting up IoTDB DataNode...");
        Runtime.getRuntime().addShutdownHook(new IoTDBShutdownHook());
        this.setUncaughtExceptionHandler();
        this.initServiceProvider();
        registerManager.register((IService)MetricService.getInstance());
        logger.info("recover the schema...");
        this.initSchemaEngine();
        registerManager.register((IService)new JMXService());
        registerManager.register((IService)FlushManager.getInstance());
        registerManager.register((IService)CacheHitRatioMonitor.getInstance());
        registerManager.register((IService)CompactionTaskManager.getInstance());
        JMXService.registerMBean((Object)DataNode.getInstance(), (String)this.mbeanName);
        if (config.isClusterMode() && config.getDataRegionConsensusProtocolClass().equals("org.apache.iotdb.consensus.ratis.RatisConsensus")) {
            config.setWalMode(WALMode.DISABLE);
        }
        registerManager.register((IService)WALManager.getInstance());
        registerManager.register((IService)StorageEngineV2.getInstance());
        registerManager.register((IService)MPPDataExchangeService.getInstance());
        registerManager.register((IService)DriverScheduler.getInstance());
        this.registerUdfServices();
        logger.info("IoTDB DataNode is setting up, some storage groups may not be ready now, please wait several seconds...");
        while (!StorageEngineV2.getInstance().isAllSgReady()) {
            try {
                Thread.sleep(1000L);
            }
            catch (InterruptedException e) {
                logger.warn("IoTDB DataNode failed to set up.", (Throwable)e);
                Thread.currentThread().interrupt();
                return;
            }
        }
        registerManager.register((IService)SyncService.getInstance());
        registerManager.register((IService)UpgradeSevice.getINSTANCE());
        registerManager.register((IService)TriggerRegistrationService.getInstance());
        registerManager.register((IService)ContinuousQueryService.getInstance());
        MetricService.getInstance().startAllReporter();
        registerManager.register((IService)RegionMigrateService.getInstance());
    }

    private void setUpRPCService() throws StartupException {
        registerManager.register((IService)DataNodeInternalRPCService.getInstance());
        IoTDBDescriptor.getInstance().getConfig().setRpcImplClassName(ClientRPCServiceImpl.class.getName());
        if (IoTDBDescriptor.getInstance().getConfig().isEnableRpcService()) {
            registerManager.register((IService)RPCService.getInstance());
        }
        this.initProtocols();
    }

    private TDataNodeConfiguration generateDataNodeConfiguration() {
        TDataNodeLocation location = new TDataNodeLocation();
        location.setDataNodeId(config.getDataNodeId());
        location.setClientRpcEndPoint(new TEndPoint(config.getRpcAddress(), config.getRpcPort()));
        location.setInternalEndPoint(new TEndPoint(config.getInternalAddress(), config.getInternalPort()));
        location.setMPPDataExchangeEndPoint(new TEndPoint(config.getInternalAddress(), config.getMppDataExchangePort()));
        location.setDataRegionConsensusEndPoint(new TEndPoint(config.getInternalAddress(), config.getDataRegionConsensusPort()));
        location.setSchemaRegionConsensusEndPoint(new TEndPoint(config.getInternalAddress(), config.getSchemaRegionConsensusPort()));
        TNodeResource resource = new TNodeResource();
        resource.setCpuCoreNum(Runtime.getRuntime().availableProcessors());
        resource.setMaxMemory(Runtime.getRuntime().totalMemory());
        return new TDataNodeConfiguration(location, resource);
    }

    private void registerUdfServices() throws StartupException {
        registerManager.register((IService)TemporaryQueryDataFileService.getInstance());
        registerManager.register((IService)UDFExecutableManager.setupAndGetInstance((String)IoTDBDescriptor.getInstance().getConfig().getTemporaryLibDir(), (String)IoTDBDescriptor.getInstance().getConfig().getUdfDir()));
        registerManager.register((IService)UDFClassLoaderManager.setupAndGetInstance((String)IoTDBDescriptor.getInstance().getConfig().getUdfDir()));
        registerManager.register((IService)UDFRegistrationService.setupAndGetInstance((String)(IoTDBDescriptor.getInstance().getConfig().getSystemDir() + File.separator + "udf" + File.separator)));
    }

    private void initSchemaEngine() {
        long time = System.currentTimeMillis();
        SchemaEngine.getInstance().init();
        long end = System.currentTimeMillis() - time;
        logger.info("spend {}ms to recover schema.", (Object)end);
        logger.info("After initializing, sequence tsFile threshold is {}, unsequence tsFile threshold is {}", (Object)IoTDBDescriptor.getInstance().getConfig().getSeqTsFileSize(), (Object)IoTDBDescriptor.getInstance().getConfig().getUnSeqTsFileSize());
    }

    public void stop() {
        this.deactivate();
        try {
            MetricService.getInstance().stop();
            SchemaRegionConsensusImpl.getInstance().stop();
            DataRegionConsensusImpl.getInstance().stop();
        }
        catch (Exception e) {
            logger.error("stop data node error", (Throwable)e);
        }
        new Thread(() -> {
            try {
                TimeUnit.SECONDS.sleep(5L);
            }
            catch (InterruptedException e) {
                logger.error("Meets InterruptedException in stop method of DataNode");
            }
            finally {
                System.exit(0);
            }
        }).start();
    }

    private void initServiceProvider() throws QueryProcessException {
        serviceProvider = new StandaloneServiceProvider();
    }

    private void initProtocols() throws StartupException {
        if (IoTDBDescriptor.getInstance().getConfig().isEnableInfluxDBRpcService()) {
            registerManager.register((IService)InfluxDBRPCService.getInstance());
            IoTDB.initInfluxDBMManager();
        }
        if (IoTDBDescriptor.getInstance().getConfig().isEnableMQTTService()) {
            registerManager.register((IService)MQTTService.getInstance());
        }
        if (IoTDBRestServiceDescriptor.getInstance().getConfig().isEnableRestService()) {
            registerManager.register((IService)MPPRestService.getInstance());
        }
    }

    private void deactivate() {
        logger.info("Deactivating IoTDB DataNode...");
        registerManager.deregisterAll();
        JMXService.deregisterMBean((String)this.mbeanName);
        logger.info("IoTDB DataNode is deactivated.");
    }

    private void setUncaughtExceptionHandler() {
        Thread.setDefaultUncaughtExceptionHandler((Thread.UncaughtExceptionHandler)new IoTDBDefaultThreadExceptionHandler());
    }

    private static class DataNodeHolder {
        private static final DataNode INSTANCE = new DataNode();

        private DataNodeHolder() {
        }
    }
}

