/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.service.metrics.predefined;

import java.io.File;
import java.io.UncheckedIOException;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.apache.commons.io.FileUtils;
import org.apache.iotdb.commons.concurrent.threadpool.ScheduledExecutorUtil;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.service.metrics.enums.Metric;
import org.apache.iotdb.db.service.metrics.enums.Tag;
import org.apache.iotdb.db.wal.WALManager;
import org.apache.iotdb.metrics.AbstractMetricManager;
import org.apache.iotdb.metrics.config.MetricConfigDescriptor;
import org.apache.iotdb.metrics.predefined.IMetricSet;
import org.apache.iotdb.metrics.predefined.PredefinedMetric;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class FileMetrics
implements IMetricSet {
    private static final Logger logger = LoggerFactory.getLogger(FileMetrics.class);
    private final String[] walDirs = IoTDBDescriptor.getInstance().getConfig().getWalDirs();
    private final String[] dataDirs = IoTDBDescriptor.getInstance().getConfig().getDataDirs();
    private final ScheduledExecutorService service = Executors.newSingleThreadScheduledExecutor();
    private long walFileTotalSize = 0L;
    private long walFileTotalCount = 0L;
    private long sequenceFileTotalSize = 0L;
    private long sequenceFileTotalCount = 0L;
    private long unsequenceFileTotalSize = 0L;
    private long unsequenceFileTotalCount = 0L;

    public void bindTo(AbstractMetricManager metricManager) {
        metricManager.getOrCreateAutoGauge(Metric.FILE_SIZE.toString(), MetricLevel.IMPORTANT, (Object)this, FileMetrics::getWalFileTotalSize, new String[]{Tag.NAME.toString(), "wal"});
        metricManager.getOrCreateAutoGauge(Metric.FILE_SIZE.toString(), MetricLevel.IMPORTANT, (Object)this, FileMetrics::getSequenceFileTotalSize, new String[]{Tag.NAME.toString(), "seq"});
        metricManager.getOrCreateAutoGauge(Metric.FILE_SIZE.toString(), MetricLevel.IMPORTANT, (Object)this, FileMetrics::getUnsequenceFileTotalSize, new String[]{Tag.NAME.toString(), "unseq"});
        metricManager.getOrCreateAutoGauge(Metric.FILE_COUNT.toString(), MetricLevel.IMPORTANT, (Object)this, FileMetrics::getWalFileTotalCount, new String[]{Tag.NAME.toString(), "wal"});
        metricManager.getOrCreateAutoGauge(Metric.FILE_COUNT.toString(), MetricLevel.IMPORTANT, (Object)this, FileMetrics::getSequenceFileTotalCount, new String[]{Tag.NAME.toString(), "seq"});
        metricManager.getOrCreateAutoGauge(Metric.FILE_COUNT.toString(), MetricLevel.IMPORTANT, (Object)this, FileMetrics::getUnsequenceFileTotalCount, new String[]{Tag.NAME.toString(), "unseq"});
    }

    public PredefinedMetric getType() {
        return PredefinedMetric.FILE;
    }

    public void startAsyncCollectedMetrics() {
        ScheduledExecutorUtil.safelyScheduleAtFixedRate((ScheduledExecutorService)this.service, this::collect, (long)1L, (long)MetricConfigDescriptor.getInstance().getMetricConfig().getAsyncCollectPeriodInSecond().intValue(), (TimeUnit)TimeUnit.SECONDS);
    }

    public void stopAsyncCollectedMetrics() {
        this.service.shutdown();
    }

    private void collect() {
        String[] dataDirs = IoTDBDescriptor.getInstance().getConfig().getDataDirs();
        String[] walDirs = IoTDBDescriptor.getInstance().getConfig().getWalDirs();
        this.walFileTotalSize = WALManager.getInstance().getTotalDiskUsage();
        this.sequenceFileTotalSize = Stream.of(dataDirs).mapToLong(dir -> {
            dir = dir + File.separator + "sequence";
            return org.apache.iotdb.commons.utils.FileUtils.getDirSize((String)dir);
        }).sum();
        this.unsequenceFileTotalSize = Stream.of(dataDirs).mapToLong(dir -> {
            dir = dir + File.separator + "unsequence";
            return org.apache.iotdb.commons.utils.FileUtils.getDirSize((String)dir);
        }).sum();
        this.walFileTotalCount = Stream.of(walDirs).mapToLong(dir -> {
            File walFolder = new File((String)dir);
            if (walFolder.exists()) {
                File[] walNodeFolders = walFolder.listFiles(File::isDirectory);
                long result = 0L;
                if (null != walNodeFolders) {
                    for (File walNodeFolder : walNodeFolders) {
                        if (!walNodeFolder.exists() || !walNodeFolder.isDirectory()) continue;
                        try {
                            result += (long)FileUtils.listFiles((File)walFolder, null, (boolean)true).size();
                        }
                        catch (UncheckedIOException exception) {
                            logger.debug("Failed when count wal folder {}: ", (Object)walNodeFolder.getName(), (Object)exception);
                        }
                    }
                }
                return result;
            }
            return 0L;
        }).sum();
        this.sequenceFileTotalCount = Stream.of(dataDirs).mapToLong(dir -> {
            File folder = new File(dir = dir + File.separator + "sequence");
            if (folder.exists()) {
                try {
                    return FileUtils.listFiles((File)new File((String)dir), (String[])new String[]{"tsfile"}, (boolean)true).size();
                }
                catch (UncheckedIOException exception) {
                    logger.debug("Failed when count sequence tsfile: ", (Throwable)exception);
                }
            }
            return 0L;
        }).sum();
        this.unsequenceFileTotalCount = Stream.of(dataDirs).mapToLong(dir -> {
            File folder = new File(dir = dir + File.separator + "unsequence");
            if (folder.exists()) {
                try {
                    return FileUtils.listFiles((File)new File((String)dir), (String[])new String[]{"tsfile"}, (boolean)true).size();
                }
                catch (UncheckedIOException exception) {
                    logger.debug("Failed when count unsequence tsfile: ", (Throwable)exception);
                }
            }
            return 0L;
        }).sum();
    }

    public long getWalFileTotalSize() {
        return this.walFileTotalSize;
    }

    public long getWalFileTotalCount() {
        return this.walFileTotalCount;
    }

    public long getSequenceFileTotalSize() {
        return this.sequenceFileTotalSize;
    }

    public long getSequenceFileTotalCount() {
        return this.sequenceFileTotalCount;
    }

    public long getUnsequenceFileTotalSize() {
        return this.unsequenceFileTotalSize;
    }

    public long getUnsequenceFileTotalCount() {
        return this.unsequenceFileTotalCount;
    }
}

