/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.service.metrics.predefined;

import com.sun.management.OperatingSystemMXBean;
import java.lang.management.ManagementFactory;
import org.apache.iotdb.db.service.metrics.enums.Metric;
import org.apache.iotdb.db.service.metrics.enums.Tag;
import org.apache.iotdb.metrics.AbstractMetricManager;
import org.apache.iotdb.metrics.predefined.IMetricSet;
import org.apache.iotdb.metrics.predefined.PredefinedMetric;
import org.apache.iotdb.metrics.utils.MetricLevel;

public class ProcessMetrics
implements IMetricSet {
    private OperatingSystemMXBean sunOsMXBean = (OperatingSystemMXBean)ManagementFactory.getOperatingSystemMXBean();
    private Runtime runtime = Runtime.getRuntime();

    public void bindTo(AbstractMetricManager metricManager) {
        this.collectProcessCPUInfo(metricManager);
        this.collectProcessMemInfo(metricManager);
        this.collectProcessStatusInfo(metricManager);
        this.collectThreadInfo(metricManager);
    }

    public PredefinedMetric getType() {
        return PredefinedMetric.PROCESS;
    }

    private void collectProcessCPUInfo(AbstractMetricManager metricManager) {
        metricManager.getOrCreateAutoGauge(Metric.PROCESS_CPU_LOAD.toString(), MetricLevel.CORE, (Object)this.sunOsMXBean, a -> (long)(this.sunOsMXBean.getProcessCpuLoad() * 100.0), new String[]{Tag.NAME.toString(), "process"});
        metricManager.getOrCreateAutoGauge(Metric.PROCESS_CPU_TIME.toString(), MetricLevel.CORE, (Object)this.sunOsMXBean, OperatingSystemMXBean::getProcessCpuTime, new String[]{Tag.NAME.toString(), "process"});
    }

    private void collectProcessMemInfo(AbstractMetricManager metricManager) {
        Runtime runtime = Runtime.getRuntime();
        metricManager.getOrCreateAutoGauge(Metric.PROCESS_MAX_MEM.toString(), MetricLevel.CORE, (Object)runtime, a -> runtime.maxMemory(), new String[]{Tag.NAME.toString(), "process"});
        metricManager.getOrCreateAutoGauge(Metric.PROCESS_TOTAL_MEM.toString(), MetricLevel.CORE, (Object)runtime, a -> runtime.totalMemory(), new String[]{Tag.NAME.toString(), "process"});
        metricManager.getOrCreateAutoGauge(Metric.PROCESS_FREE_MEM.toString(), MetricLevel.CORE, (Object)runtime, a -> runtime.freeMemory(), new String[]{Tag.NAME.toString(), "process"});
        metricManager.getOrCreateAutoGauge(Metric.PROCESS_USED_MEM.toString(), MetricLevel.CORE, (Object)this, a -> this.getProcessUsedMemory(), new String[]{Tag.NAME.toString(), "process"});
        metricManager.getOrCreateAutoGauge(Metric.PROCESS_MEM_RATIO.toString(), MetricLevel.CORE, (Object)this, a -> Math.round(this.getProcessMemoryRatio()), new String[]{Tag.NAME.toString(), "process"});
    }

    private void collectThreadInfo(AbstractMetricManager metricManager) {
        metricManager.getOrCreateAutoGauge(Metric.PROCESS_THREADS_COUNT.toString(), MetricLevel.CORE, (Object)this, a -> this.getThreadsCount(), new String[]{Tag.NAME.toString(), "process"});
    }

    private void collectProcessStatusInfo(AbstractMetricManager metricManager) {
        metricManager.getOrCreateAutoGauge(Metric.PROCESS_STATUS.toString(), MetricLevel.CORE, (Object)this, a -> this.getProcessStatus(), new String[]{Tag.NAME.toString(), "process"});
    }

    private long getProcessUsedMemory() {
        return this.runtime.totalMemory() - this.runtime.freeMemory();
    }

    private long getProcessStatus() {
        return Thread.currentThread().isAlive() ? 1L : 0L;
    }

    private int getThreadsCount() {
        ThreadGroup parentThread = Thread.currentThread().getThreadGroup();
        while (parentThread.getParent() != null) {
            parentThread = parentThread.getParent();
        }
        return parentThread.activeCount();
    }

    private double getProcessMemoryRatio() {
        long processUsedMemory = this.getProcessUsedMemory();
        long totalPhysicalMemorySize = this.sunOsMXBean.getTotalPhysicalMemorySize();
        return (double)processUsedMemory / (double)totalPhysicalMemorySize * 100.0;
    }
}

