/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.compaction;

import java.io.File;
import java.io.IOException;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.engine.modification.Modification;
import org.apache.iotdb.db.engine.modification.ModificationFile;
import org.apache.iotdb.db.engine.storagegroup.TsFileNameGenerator;
import org.apache.iotdb.db.engine.storagegroup.TsFileResource;
import org.apache.iotdb.db.query.control.FileReaderManager;
import org.apache.iotdb.tsfile.exception.write.WriteProcessException;
import org.apache.iotdb.tsfile.fileSystem.FSFactoryProducer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompactionUtils {
    private static final Logger logger = LoggerFactory.getLogger((String)"COMPACTION");
    private static final int subTaskNum = IoTDBDescriptor.getInstance().getConfig().getSubCompactionTaskNum();

    public static void moveTargetFile(List<TsFileResource> targetResources, boolean isInnerSpace, String fullStorageGroupName) throws IOException, WriteProcessException {
        String fileSuffix = isInnerSpace ? ".inner" : ".cross";
        for (TsFileResource targetResource : targetResources) {
            CompactionUtils.moveOneTargetFile(targetResource, fileSuffix, fullStorageGroupName);
        }
    }

    private static void moveOneTargetFile(TsFileResource targetResource, String tmpFileSuffix, String fullStorageGroupName) throws IOException {
        if (!targetResource.getTsFile().exists()) {
            logger.info("{} [Compaction] Tmp target tsfile {} may be deleted after compaction.", (Object)fullStorageGroupName, (Object)targetResource.getTsFilePath());
            return;
        }
        File newFile = new File(targetResource.getTsFilePath().replace(tmpFileSuffix, ".tsfile"));
        if (!newFile.exists()) {
            FSFactoryProducer.getFSFactory().moveFile(targetResource.getTsFile(), newFile);
        }
        targetResource.setFile(newFile);
        targetResource.serialize();
        targetResource.close();
    }

    public static void combineModsInCrossCompaction(List<TsFileResource> seqResources, List<TsFileResource> unseqResources, List<TsFileResource> targetResources) throws IOException {
        HashMap<String, TsFileResource> seqFileInfoMap = new HashMap<String, TsFileResource>();
        for (TsFileResource tsFileResource : seqResources) {
            seqFileInfoMap.put(TsFileNameGenerator.increaseCrossCompactionCnt(tsFileResource.getTsFile()).getName(), tsFileResource);
        }
        for (TsFileResource targetResource : targetResources) {
            TsFileResource seqFile = (TsFileResource)seqFileInfoMap.get(targetResource.getTsFile().getName());
            HashSet<Modification> modifications = new HashSet<Modification>();
            if (seqFile != null) {
                modifications.addAll(ModificationFile.getCompactionMods(seqFile).getModifications());
            }
            for (TsFileResource unseqFile : unseqResources) {
                modifications.addAll(ModificationFile.getCompactionMods(unseqFile).getModifications());
            }
            CompactionUtils.updateOneTargetMods(targetResource, modifications);
        }
    }

    public static void combineModsInInnerCompaction(Collection<TsFileResource> sourceFiles, TsFileResource targetTsFile) throws IOException {
        HashSet<Modification> modifications = new HashSet<Modification>();
        for (TsFileResource mergeTsFile : sourceFiles) {
            ModificationFile sourceCompactionModificationFile = ModificationFile.getCompactionMods(mergeTsFile);
            try {
                modifications.addAll(sourceCompactionModificationFile.getModifications());
            }
            finally {
                if (sourceCompactionModificationFile == null) continue;
                sourceCompactionModificationFile.close();
            }
        }
        CompactionUtils.updateOneTargetMods(targetTsFile, modifications);
    }

    private static void updateOneTargetMods(TsFileResource targetFile, Set<Modification> modifications) throws IOException {
        if (!modifications.isEmpty()) {
            try (ModificationFile modificationFile = ModificationFile.getNormalMods(targetFile);){
                for (Modification modification : modifications) {
                    modification.setFileOffset(Long.MAX_VALUE);
                    modificationFile.write(modification);
                }
            }
        }
    }

    public static void deleteCompactionModsFile(List<TsFileResource> selectedSeqTsFileResourceList, List<TsFileResource> selectedUnSeqTsFileResourceList) throws IOException {
        ModificationFile modificationFile;
        for (TsFileResource seqFile : selectedSeqTsFileResourceList) {
            modificationFile = seqFile.getCompactionModFile();
            if (!modificationFile.exists()) continue;
            modificationFile.remove();
        }
        for (TsFileResource unseqFile : selectedUnSeqTsFileResourceList) {
            modificationFile = unseqFile.getCompactionModFile();
            if (!modificationFile.exists()) continue;
            modificationFile.remove();
        }
    }

    public static boolean deleteTsFilesInDisk(Collection<TsFileResource> mergeTsFiles, String storageGroupName) {
        logger.info("{} [Compaction] Compaction starts to delete real file ", (Object)storageGroupName);
        boolean result = true;
        for (TsFileResource mergeTsFile : mergeTsFiles) {
            if (!CompactionUtils.deleteTsFile(mergeTsFile)) {
                result = false;
            }
            logger.info("{} [Compaction] delete TsFile {}", (Object)storageGroupName, (Object)mergeTsFile.getTsFilePath());
        }
        return result;
    }

    public static boolean deleteTsFile(TsFileResource seqFile) {
        try {
            FileReaderManager.getInstance().closeFileAndRemoveReader(seqFile.getTsFilePath());
            seqFile.remove();
        }
        catch (IOException e) {
            logger.error(e.getMessage(), (Throwable)e);
            return false;
        }
        return true;
    }

    public static void deleteModificationForSourceFile(Collection<TsFileResource> sourceFiles, String storageGroupName) throws IOException {
        logger.info("{} [Compaction] Start to delete modifications of source files", (Object)storageGroupName);
        for (TsFileResource tsFileResource : sourceFiles) {
            ModificationFile normalModification;
            ModificationFile compactionModificationFile = ModificationFile.getCompactionMods(tsFileResource);
            if (compactionModificationFile.exists()) {
                compactionModificationFile.remove();
            }
            if (!(normalModification = ModificationFile.getNormalMods(tsFileResource)).exists()) continue;
            normalModification.remove();
        }
    }
}

