/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.engine.storagegroup;

import java.util.Objects;
import org.apache.iotdb.db.service.metrics.MetricService;
import org.apache.iotdb.db.service.metrics.enums.Metric;
import org.apache.iotdb.db.service.metrics.enums.Tag;
import org.apache.iotdb.metrics.AbstractMetricService;
import org.apache.iotdb.metrics.metricsets.IMetricSet;
import org.apache.iotdb.metrics.utils.MetricLevel;
import org.apache.iotdb.metrics.utils.MetricType;

public class TsFileProcessorInfoMetrics
implements IMetricSet {
    private String storageGroupName;
    private long memCost;

    public TsFileProcessorInfoMetrics(String storageGroupName, long memCost) {
        this.storageGroupName = storageGroupName;
        this.memCost = memCost;
    }

    public void bindTo(AbstractMetricService metricService) {
        MetricService.getInstance().getOrCreateAutoGauge(Metric.MEM.toString(), MetricLevel.IMPORTANT, this.memCost, o -> o, new String[]{Tag.NAME.toString(), "chunkMetaData_" + this.storageGroupName});
    }

    public void unbindFrom(AbstractMetricService metricService) {
        MetricService.getInstance().remove(MetricType.GAUGE, Metric.MEM.toString(), new String[]{Tag.NAME.toString(), "chunkMetaData_" + this.storageGroupName});
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TsFileProcessorInfoMetrics that = (TsFileProcessorInfoMetrics)o;
        return this.memCost == that.memCost && Objects.equals(this.storageGroupName, that.storageGroupName);
    }

    public int hashCode() {
        return Objects.hash(this.storageGroupName, this.memCost);
    }
}

