/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.path;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.HashSet;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.path.PathPatternNode;
import org.apache.iotdb.commons.path.PatternTreeMap;
import org.apache.iotdb.db.engine.modification.Deletion;
import org.apache.iotdb.db.engine.modification.Modification;
import org.apache.iotdb.tsfile.utils.PublicBAOS;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class PatternTreeMapFactory {
    public static PatternTreeMap<String, StringSerializer> getTriggerPatternTreeMap() {
        return new PatternTreeMap(HashSet::new, (triggerName, set) -> set.add(triggerName), (triggerName, set) -> set.remove(triggerName), (PathPatternNode.Serializer)StringSerializer.getInstance());
    }

    public static PatternTreeMap<Modification, ModsSerializer> getModsPatternTreeMap() {
        return new PatternTreeMap(HashSet::new, (mod, set) -> set.add(mod), null, (PathPatternNode.Serializer)ModsSerializer.getInstance());
    }

    public static class StringSerializer
    implements PathPatternNode.Serializer<String> {
        public static StringSerializer getInstance() {
            return StringSerializerHolder.INSTANCE;
        }

        private StringSerializer() {
        }

        public void write(String s, ByteBuffer buffer) {
            ReadWriteIOUtils.write((String)s, (ByteBuffer)buffer);
        }

        public void write(String s, PublicBAOS stream) throws IOException {
            ReadWriteIOUtils.write((String)s, (OutputStream)stream);
        }

        public void write(String s, DataOutputStream stream) throws IOException {
            ReadWriteIOUtils.write((String)s, (OutputStream)stream);
        }

        public String read(ByteBuffer buffer) {
            return ReadWriteIOUtils.readString((ByteBuffer)buffer);
        }

        private static class StringSerializerHolder {
            private static final StringSerializer INSTANCE = new StringSerializer();

            private StringSerializerHolder() {
            }
        }
    }

    public static class ModsSerializer
    implements PathPatternNode.Serializer<Modification> {
        public void write(Modification modification, ByteBuffer buffer) {
            ReadWriteIOUtils.write((int)modification.getType().ordinal(), (ByteBuffer)buffer);
            modification.getPath().serialize(buffer);
            ReadWriteIOUtils.write((long)modification.getFileOffset(), (ByteBuffer)buffer);
            switch (modification.getType()) {
                case DELETION: {
                    ReadWriteIOUtils.write((long)((Deletion)modification).getStartTime(), (ByteBuffer)buffer);
                    ReadWriteIOUtils.write((long)((Deletion)modification).getEndTime(), (ByteBuffer)buffer);
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }

        public void write(Modification modification, PublicBAOS stream) throws IOException {
            ReadWriteIOUtils.write((int)modification.getType().ordinal(), (OutputStream)stream);
            modification.getPath().serialize(stream);
            ReadWriteIOUtils.write((long)modification.getFileOffset(), (OutputStream)stream);
            switch (modification.getType()) {
                case DELETION: {
                    ReadWriteIOUtils.write((long)((Deletion)modification).getStartTime(), (OutputStream)stream);
                    ReadWriteIOUtils.write((long)((Deletion)modification).getEndTime(), (OutputStream)stream);
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }

        public void write(Modification modification, DataOutputStream stream) throws IOException {
            ReadWriteIOUtils.write((int)modification.getType().ordinal(), (OutputStream)stream);
            modification.getPath().serialize((OutputStream)stream);
            ReadWriteIOUtils.write((long)modification.getFileOffset(), (OutputStream)stream);
            switch (modification.getType()) {
                case DELETION: {
                    ReadWriteIOUtils.write((long)((Deletion)modification).getStartTime(), (OutputStream)stream);
                    ReadWriteIOUtils.write((long)((Deletion)modification).getEndTime(), (OutputStream)stream);
                    break;
                }
                default: {
                    throw new IllegalArgumentException();
                }
            }
        }

        public Modification read(ByteBuffer buffer) {
            int type = ReadWriteIOUtils.read((ByteBuffer)buffer);
            PartialPath partialPath = PartialPath.deserialize((ByteBuffer)buffer);
            long fileOffset = ReadWriteIOUtils.readLong((ByteBuffer)buffer);
            switch (Modification.Type.values()[type]) {
                case DELETION: {
                    long startTime = ReadWriteIOUtils.readLong((ByteBuffer)buffer);
                    long endTime = ReadWriteIOUtils.readLong((ByteBuffer)buffer);
                    return new Deletion(partialPath, fileOffset, startTime, endTime);
                }
            }
            throw new IllegalArgumentException();
        }

        public static ModsSerializer getInstance() {
            return ModsSerializerHolder.INSTANCE;
        }

        private static class ModsSerializerHolder {
            private static final ModsSerializer INSTANCE = new ModsSerializer();

            private ModsSerializerHolder() {
            }
        }
    }
}

