/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.metadata.rescon;

import java.util.concurrent.atomic.AtomicLong;

public class SchemaStatisticsManager {
    private final AtomicLong totalSeriesNumber = new AtomicLong();

    public static SchemaStatisticsManager getInstance() {
        return SchemaStatisticsHolder.INSTANCE;
    }

    public long getTotalSeriesNumber() {
        return this.totalSeriesNumber.get();
    }

    public void addTimeseries(int addedNum) {
        this.totalSeriesNumber.addAndGet(addedNum);
    }

    public void deleteTimeseries(int deletedNum) {
        this.totalSeriesNumber.addAndGet(-deletedNum);
    }

    public void clear() {
        this.totalSeriesNumber.getAndSet(0L);
    }

    private static class SchemaStatisticsHolder {
        private static final SchemaStatisticsManager INSTANCE = new SchemaStatisticsManager();

        private SchemaStatisticsHolder() {
        }
    }
}

