/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.aggregation;

import com.google.common.base.Preconditions;
import org.apache.iotdb.db.mpp.aggregation.Accumulator;
import org.apache.iotdb.db.mpp.execution.operator.window.IWindow;
import org.apache.iotdb.tsfile.exception.write.UnSupportedDataTypeException;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.statistics.IntegerStatistics;
import org.apache.iotdb.tsfile.file.metadata.statistics.Statistics;
import org.apache.iotdb.tsfile.read.common.block.column.Column;
import org.apache.iotdb.tsfile.read.common.block.column.ColumnBuilder;

public class AvgAccumulator
implements Accumulator {
    private TSDataType seriesDataType;
    private long countValue;
    private double sumValue;
    private boolean initResult = false;

    public AvgAccumulator(TSDataType seriesDataType) {
        this.seriesDataType = seriesDataType;
    }

    @Override
    public int addInput(Column[] column, IWindow curWindow) {
        switch (this.seriesDataType) {
            case INT32: {
                return this.addIntInput(column, curWindow);
            }
            case INT64: {
                return this.addLongInput(column, curWindow);
            }
            case FLOAT: {
                return this.addFloatInput(column, curWindow);
            }
            case DOUBLE: {
                return this.addDoubleInput(column, curWindow);
            }
        }
        throw new UnSupportedDataTypeException(String.format("Unsupported data type in aggregation AVG : %s", this.seriesDataType));
    }

    @Override
    public void addIntermediate(Column[] partialResult) {
        Preconditions.checkArgument((partialResult.length == 2 ? 1 : 0) != 0, (Object)"partialResult of Avg should be 2");
        if (partialResult[0].isNull(0)) {
            return;
        }
        this.initResult = true;
        this.countValue += partialResult[0].getLong(0);
        this.sumValue += partialResult[1].getDouble(0);
        if (this.countValue == 0L) {
            this.initResult = false;
        }
    }

    @Override
    public void addStatistics(Statistics statistics) {
        if (statistics == null) {
            return;
        }
        this.initResult = true;
        this.countValue += statistics.getCount();
        this.sumValue = statistics instanceof IntegerStatistics ? (this.sumValue += (double)statistics.getSumLongValue()) : (this.sumValue += statistics.getSumDoubleValue());
        if (this.countValue == 0L) {
            this.initResult = false;
        }
    }

    @Override
    public void setFinal(Column finalResult) {
        this.reset();
        if (finalResult.isNull(0)) {
            return;
        }
        this.initResult = true;
        this.countValue = 1L;
        this.sumValue = finalResult.getDouble(0);
    }

    @Override
    public void outputIntermediate(ColumnBuilder[] columnBuilders) {
        Preconditions.checkArgument((columnBuilders.length == 2 ? 1 : 0) != 0, (Object)"partialResult of Avg should be 2");
        if (!this.initResult) {
            columnBuilders[0].appendNull();
            columnBuilders[1].appendNull();
        } else {
            columnBuilders[0].writeLong(this.countValue);
            columnBuilders[1].writeDouble(this.sumValue);
        }
    }

    @Override
    public void outputFinal(ColumnBuilder columnBuilder) {
        if (!this.initResult) {
            columnBuilder.appendNull();
        } else {
            columnBuilder.writeDouble(this.sumValue / (double)this.countValue);
        }
    }

    @Override
    public void reset() {
        this.initResult = false;
        this.countValue = 0L;
        this.sumValue = 0.0;
    }

    @Override
    public boolean hasFinalResult() {
        return false;
    }

    @Override
    public TSDataType[] getIntermediateType() {
        return new TSDataType[]{TSDataType.INT64, TSDataType.DOUBLE};
    }

    @Override
    public TSDataType getFinalType() {
        return TSDataType.DOUBLE;
    }

    private int addIntInput(Column[] column, IWindow curWindow) {
        int curPositionCount = column[0].getPositionCount();
        for (int i = 0; i < curPositionCount; ++i) {
            if (column[0].isNull(i)) continue;
            if (!curWindow.satisfy(column[0], i)) {
                return i;
            }
            curWindow.mergeOnePoint();
            if (column[2].isNull(i)) continue;
            this.initResult = true;
            ++this.countValue;
            this.sumValue += (double)column[2].getInt(i);
        }
        return curPositionCount;
    }

    private int addLongInput(Column[] column, IWindow curWindow) {
        int curPositionCount = column[0].getPositionCount();
        for (int i = 0; i < curPositionCount; ++i) {
            if (column[0].isNull(i)) continue;
            if (!curWindow.satisfy(column[0], i)) {
                return i;
            }
            curWindow.mergeOnePoint();
            if (column[2].isNull(i)) continue;
            this.initResult = true;
            ++this.countValue;
            this.sumValue += (double)column[2].getLong(i);
        }
        return curPositionCount;
    }

    private int addFloatInput(Column[] column, IWindow curWindow) {
        int curPositionCount = column[0].getPositionCount();
        for (int i = 0; i < curPositionCount; ++i) {
            if (column[0].isNull(i)) continue;
            if (!curWindow.satisfy(column[0], i)) {
                return i;
            }
            curWindow.mergeOnePoint();
            if (column[2].isNull(i)) continue;
            this.initResult = true;
            ++this.countValue;
            this.sumValue += (double)column[2].getFloat(i);
        }
        return curPositionCount;
    }

    private int addDoubleInput(Column[] column, IWindow curWindow) {
        int curPositionCount = column[0].getPositionCount();
        for (int i = 0; i < curPositionCount; ++i) {
            if (column[0].isNull(i)) continue;
            if (!curWindow.satisfy(column[0], i)) {
                return i;
            }
            curWindow.mergeOnePoint();
            if (column[2].isNull(i)) continue;
            this.initResult = true;
            ++this.countValue;
            this.sumValue += column[2].getDouble(i);
        }
        return curPositionCount;
    }
}

