/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.operator.schema;

import java.util.List;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.mpp.common.header.ColumnHeader;
import org.apache.iotdb.db.mpp.common.header.ColumnHeaderConstant;
import org.apache.iotdb.db.mpp.execution.driver.SchemaDriverContext;
import org.apache.iotdb.db.mpp.execution.operator.OperatorContext;
import org.apache.iotdb.db.mpp.execution.operator.schema.SchemaQueryScanOperator;
import org.apache.iotdb.db.mpp.execution.operator.schema.SchemaTsBlockUtil;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.db.qp.physical.sys.ShowDevicesPlan;
import org.apache.iotdb.db.query.dataset.ShowDevicesResult;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilder;
import org.apache.iotdb.tsfile.utils.Binary;

public class DevicesSchemaScanOperator
extends SchemaQueryScanOperator {
    private final boolean hasSgCol;
    private final List<TSDataType> outputDataTypes;

    public DevicesSchemaScanOperator(PlanNodeId sourceId, OperatorContext operatorContext, int limit, int offset, PartialPath partialPath, boolean isPrefixPath, boolean hasSgCol) {
        super(sourceId, operatorContext, limit, offset, partialPath, isPrefixPath);
        this.hasSgCol = hasSgCol;
        this.outputDataTypes = (hasSgCol ? ColumnHeaderConstant.showDevicesWithSgColumnHeaders : ColumnHeaderConstant.showDevicesColumnHeaders).stream().map(ColumnHeader::getColumnType).collect(Collectors.toList());
    }

    @Override
    protected List<TsBlock> createTsBlockList() {
        try {
            List schemaRegionResult = (List)((SchemaDriverContext)this.operatorContext.getInstanceContext().getDriverContext()).getSchemaRegion().getMatchedDevices((ShowDevicesPlan)this.convertToPhysicalPlan()).left;
            return SchemaTsBlockUtil.transferSchemaResultToTsBlockList(schemaRegionResult.iterator(), this.outputDataTypes, this::setColumns);
        }
        catch (MetadataException e) {
            throw new RuntimeException(e.getMessage(), e);
        }
    }

    private ShowDevicesPlan convertToPhysicalPlan() {
        return new ShowDevicesPlan(this.partialPath, this.limit, this.offset, this.hasSgCol);
    }

    private void setColumns(ShowDevicesResult device, TsBlockBuilder builder) {
        builder.getTimeColumnBuilder().writeLong(0L);
        builder.getColumnBuilder(0).writeBinary(new Binary(device.getName()));
        if (this.hasSgCol) {
            builder.getColumnBuilder(1).writeBinary(new Binary(device.getSgName()));
            builder.getColumnBuilder(2).writeBinary(new Binary(String.valueOf(device.isAligned())));
        } else {
            builder.getColumnBuilder(1).writeBinary(new Binary(String.valueOf(device.isAligned())));
        }
        builder.declarePosition();
    }
}

