/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.execution.operator.schema;

import java.util.List;
import java.util.NoSuchElementException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.mpp.execution.operator.OperatorContext;
import org.apache.iotdb.db.mpp.execution.operator.source.SourceOperator;
import org.apache.iotdb.db.mpp.plan.planner.plan.node.PlanNodeId;
import org.apache.iotdb.tsfile.read.common.block.TsBlock;
import org.apache.iotdb.tsfile.read.common.block.TsBlockBuilderStatus;

public abstract class SchemaQueryScanOperator
implements SourceOperator {
    protected OperatorContext operatorContext;
    protected List<TsBlock> tsBlockList;
    protected int currentIndex = 0;
    protected int limit;
    protected int offset;
    protected PartialPath partialPath;
    protected boolean isPrefixPath;
    protected PlanNodeId sourceId;

    protected SchemaQueryScanOperator(PlanNodeId sourceId, OperatorContext operatorContext, int limit, int offset, PartialPath partialPath, boolean isPrefixPath) {
        this.operatorContext = operatorContext;
        this.limit = limit;
        this.offset = offset;
        this.partialPath = partialPath;
        this.isPrefixPath = isPrefixPath;
        this.sourceId = sourceId;
    }

    protected abstract List<TsBlock> createTsBlockList();

    public PartialPath getPartialPath() {
        return this.partialPath;
    }

    public int getLimit() {
        return this.limit;
    }

    public int getOffset() {
        return this.offset;
    }

    public void setLimit(int limit) {
        this.limit = limit;
    }

    public void setOffset(int offset) {
        this.offset = offset;
    }

    public boolean isPrefixPath() {
        return this.isPrefixPath;
    }

    @Override
    public OperatorContext getOperatorContext() {
        return this.operatorContext;
    }

    @Override
    public TsBlock next() {
        if (!this.hasNext()) {
            throw new NoSuchElementException();
        }
        ++this.currentIndex;
        return this.tsBlockList.get(this.currentIndex - 1);
    }

    @Override
    public boolean hasNext() {
        if (this.tsBlockList == null) {
            this.tsBlockList = this.createTsBlockList();
        }
        return this.currentIndex < this.tsBlockList.size();
    }

    @Override
    public boolean isFinished() {
        return !this.hasNext();
    }

    @Override
    public PlanNodeId getSourceId() {
        return this.sourceId;
    }

    @Override
    public long calculateMaxPeekMemory() {
        return TsBlockBuilderStatus.DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES;
    }

    @Override
    public long calculateMaxReturnSize() {
        return TsBlockBuilderStatus.DEFAULT_MAX_TSBLOCK_SIZE_IN_BYTES;
    }

    @Override
    public long calculateRetainedSizeAfterCallingNext() {
        return 0L;
    }
}

