/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.analyze;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.path.MeasurementPath;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.exception.sql.SemanticException;
import org.apache.iotdb.db.mpp.plan.analyze.ExpressionAnalyzer;
import org.apache.iotdb.db.mpp.plan.expression.Expression;
import org.apache.iotdb.db.mpp.plan.expression.leaf.TimeSeriesOperand;
import org.apache.iotdb.tsfile.utils.Pair;

public class GroupByLevelController {
    private final int[] levels;
    private final Map<Expression, Set<Expression>> groupedExpressionToRawExpressionsMap;
    private final RawPathToGroupedPathMap rawPathToGroupedPathMap;
    private final Map<String, String> columnToAliasMap;
    private final Map<String, String> aliasToColumnMap;

    public GroupByLevelController(int[] levels) {
        this.levels = levels;
        this.groupedExpressionToRawExpressionsMap = new LinkedHashMap<Expression, Set<Expression>>();
        this.rawPathToGroupedPathMap = new RawPathToGroupedPathMap();
        this.columnToAliasMap = new HashMap<String, String>();
        this.aliasToColumnMap = new HashMap<String, String>();
    }

    public Expression control(Expression expression) {
        return this.control(false, expression, null);
    }

    public Expression control(boolean isCountStar, Expression expression, String alias) {
        List rawPaths = ExpressionAnalyzer.searchSourceExpressions(expression).stream().map(timeSeriesOperand -> ((TimeSeriesOperand)timeSeriesOperand).getPath()).collect(Collectors.toList());
        for (Object rawPath : rawPaths) {
            if (this.rawPathToGroupedPathMap.containsKey((PartialPath)rawPath)) continue;
            this.rawPathToGroupedPathMap.put((PartialPath)rawPath, this.generatePartialPathByLevel(isCountStar, (PartialPath)rawPath));
        }
        HashSet<Expression> rawAggregationExpressions = new HashSet<Expression>(ExpressionAnalyzer.searchAggregationExpressions(expression));
        for (Expression rawAggregationExpression : rawAggregationExpressions) {
            Expression groupedExpression = ExpressionAnalyzer.replaceRawPathWithGroupedPath(rawAggregationExpression, this.rawPathToGroupedPathMap);
            this.groupedExpressionToRawExpressionsMap.computeIfAbsent(groupedExpression, key -> new HashSet()).add(rawAggregationExpression);
        }
        Expression groupedExpression = ExpressionAnalyzer.replaceRawPathWithGroupedPath(expression, this.rawPathToGroupedPathMap);
        if (alias != null) {
            this.checkAliasAndUpdateAliasMap(alias, groupedExpression.getExpressionString());
        }
        return groupedExpression;
    }

    private void checkAliasAndUpdateAliasMap(String alias, String groupedExpressionString) {
        if (this.columnToAliasMap.get(groupedExpressionString) == null) {
            if (this.aliasToColumnMap.get(alias) != null) {
                throw new SemanticException(String.format("alias '%s' can only be matched with one result column", alias));
            }
            this.columnToAliasMap.put(groupedExpressionString, alias);
            this.aliasToColumnMap.put(alias, groupedExpressionString);
        } else if (!this.columnToAliasMap.get(groupedExpressionString).equals(alias)) {
            throw new SemanticException(String.format("Result column %s with more than one alias[%s, %s]", groupedExpressionString, this.columnToAliasMap.get(groupedExpressionString), alias));
        }
    }

    public PartialPath generatePartialPathByLevel(boolean isCountStar, PartialPath rawPath) {
        String[] nodes = rawPath.getNodes();
        HashSet<Integer> levelSet = new HashSet<Integer>();
        for (int level : this.levels) {
            levelSet.add(level);
        }
        ArrayList<String> transformedNodes = new ArrayList<String>(nodes.length);
        transformedNodes.add(nodes[0]);
        for (int k = 1; k < nodes.length - 1; ++k) {
            if (levelSet.contains(k)) {
                transformedNodes.add(nodes[k]);
                continue;
            }
            transformedNodes.add("*");
        }
        if (isCountStar) {
            transformedNodes.add("*");
        } else {
            transformedNodes.add(nodes[nodes.length - 1]);
        }
        MeasurementPath groupedPath = new MeasurementPath(new PartialPath(transformedNodes.toArray(new String[0])), ((MeasurementPath)rawPath).getMeasurementSchema());
        if (rawPath.isMeasurementAliasExists()) {
            groupedPath.setMeasurementAlias(rawPath.getMeasurementAlias());
        }
        return groupedPath;
    }

    public Map<Expression, Set<Expression>> getGroupedExpressionToRawExpressionsMap() {
        return this.groupedExpressionToRawExpressionsMap;
    }

    public String getAlias(String columnName) {
        return this.columnToAliasMap.get(columnName) != null ? this.columnToAliasMap.get(columnName) : null;
    }

    public static class RawPathToGroupedPathMap {
        private final Map<Pair<PartialPath, String>, PartialPath> map = new HashMap<Pair<PartialPath, String>, PartialPath>();

        public boolean containsKey(PartialPath rawPath) {
            return this.map.containsKey(new Pair((Object)rawPath, (Object)rawPath.getMeasurementAlias()));
        }

        public void put(PartialPath rawPath, PartialPath groupedPath) {
            this.map.put((Pair<PartialPath, String>)new Pair((Object)rawPath, (Object)rawPath.getMeasurementAlias()), groupedPath);
        }

        public PartialPath get(PartialPath rawPath) {
            PartialPath groupedPath = this.map.get(new Pair((Object)rawPath, (Object)rawPath.getMeasurementAlias()));
            Preconditions.checkState((groupedPath != null ? 1 : 0) != 0, (String)"path '%s' is not analyzed in GroupByLevelController.", (Object)rawPath);
            return groupedPath;
        }
    }
}

