/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.analyze.cache;

import com.github.benmanes.caffeine.cache.Cache;
import com.github.benmanes.caffeine.cache.Caffeine;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.locks.ReentrantReadWriteLock;
import org.apache.iotdb.common.rpc.thrift.TConsensusGroupId;
import org.apache.iotdb.common.rpc.thrift.TRegionReplicaSet;
import org.apache.iotdb.common.rpc.thrift.TSStatus;
import org.apache.iotdb.common.rpc.thrift.TSeriesPartitionSlot;
import org.apache.iotdb.common.rpc.thrift.TTimePartitionSlot;
import org.apache.iotdb.commons.client.IClientManager;
import org.apache.iotdb.commons.client.IClientPoolFactory;
import org.apache.iotdb.commons.consensus.PartitionRegionId;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.partition.DataPartition;
import org.apache.iotdb.commons.partition.DataPartitionQueryParam;
import org.apache.iotdb.commons.partition.DataPartitionTable;
import org.apache.iotdb.commons.partition.SchemaPartition;
import org.apache.iotdb.commons.partition.SchemaPartitionTable;
import org.apache.iotdb.commons.partition.SeriesPartitionTable;
import org.apache.iotdb.commons.partition.executor.SeriesPartitionExecutor;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.utils.PathUtils;
import org.apache.iotdb.confignode.rpc.thrift.TRegionRouteMapResp;
import org.apache.iotdb.confignode.rpc.thrift.TSetStorageGroupReq;
import org.apache.iotdb.confignode.rpc.thrift.TStorageGroupSchema;
import org.apache.iotdb.confignode.rpc.thrift.TStorageGroupSchemaResp;
import org.apache.iotdb.db.client.ConfigNodeClient;
import org.apache.iotdb.db.client.ConfigNodeInfo;
import org.apache.iotdb.db.client.DataNodeClientPoolFactory;
import org.apache.iotdb.db.conf.IoTDBConfig;
import org.apache.iotdb.db.conf.IoTDBDescriptor;
import org.apache.iotdb.db.exception.sql.StatementAnalyzeException;
import org.apache.iotdb.db.metadata.utils.MetaUtils;
import org.apache.iotdb.db.mpp.plan.analyze.cache.StorageGroupCacheResult;
import org.apache.iotdb.db.service.metrics.recorder.CacheMetricsRecorder;
import org.apache.iotdb.rpc.TSStatusCode;
import org.apache.thrift.TException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PartitionCache {
    private static final Logger logger = LoggerFactory.getLogger(PartitionCache.class);
    private static final IoTDBConfig config = IoTDBDescriptor.getInstance().getConfig();
    private static final List<String> ROOT_PATH = Arrays.asList("root", "**");
    private static final String STORAGE_GROUP_CACHE_NAME = "StorageGroup";
    private static final String SCHEMA_PARTITION_CACHE_NAME = "SchemaPartition";
    private static final String DATA_PARTITION_CACHE_NAME = "DataPartition";
    private final String seriesSlotExecutorName = config.getSeriesPartitionExecutorClass();
    private final int seriesPartitionSlotNum = config.getSeriesPartitionSlotNum();
    private final SeriesPartitionExecutor partitionExecutor;
    private final int cacheSize = config.getPartitionCacheSize();
    private final Set<String> storageGroupCache = Collections.synchronizedSet(new HashSet());
    private final Cache<String, SchemaPartitionTable> schemaPartitionCache;
    private final Cache<String, DataPartitionTable> dataPartitionCache;
    private final AtomicLong latestUpdateTime = new AtomicLong(0L);
    private final Map<TConsensusGroupId, TRegionReplicaSet> groupIdToReplicaSetMap = new HashMap<TConsensusGroupId, TRegionReplicaSet>();
    private final ReentrantReadWriteLock storageGroupCacheLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock schemaPartitionCacheLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock dataPartitionCacheLock = new ReentrantReadWriteLock();
    private final ReentrantReadWriteLock regionReplicaSetLock = new ReentrantReadWriteLock();
    private final IClientManager<PartitionRegionId, ConfigNodeClient> configNodeClientManager = new IClientManager.Factory().createClientManager((IClientPoolFactory)new DataNodeClientPoolFactory.ConfigNodeClientPoolFactory());

    public PartitionCache() {
        this.schemaPartitionCache = Caffeine.newBuilder().maximumSize((long)this.cacheSize).build();
        this.dataPartitionCache = Caffeine.newBuilder().maximumSize((long)this.cacheSize).build();
        this.partitionExecutor = SeriesPartitionExecutor.getSeriesPartitionExecutor((String)this.seriesSlotExecutorName, (int)this.seriesPartitionSlotNum);
    }

    public Map<String, List<String>> getStorageGroupToDevice(List<String> devicePaths, boolean tryToFetch, boolean isAutoCreate) {
        StorageGroupCacheResult<List<String>> result = new StorageGroupCacheResult<List<String>>(){

            @Override
            public void put(String device, String storageGroupName) {
                this.map.computeIfAbsent(storageGroupName, k -> new ArrayList());
                ((List)this.map.get(storageGroupName)).add(device);
            }
        };
        this.getStorageGroupCacheResult(result, devicePaths, tryToFetch, isAutoCreate);
        return result.getMap();
    }

    public Map<String, String> getDeviceToStorageGroup(List<String> devicePaths, boolean tryToFetch, boolean isAutoCreate) {
        StorageGroupCacheResult<String> result = new StorageGroupCacheResult<String>(){

            @Override
            public void put(String device, String storageGroupName) {
                this.map.put(device, storageGroupName);
            }
        };
        this.getStorageGroupCacheResult(result, devicePaths, tryToFetch, isAutoCreate);
        return result.getMap();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private String getStorageGroupName(String devicePath) {
        Set<String> set = this.storageGroupCache;
        synchronized (set) {
            for (String storageGroupName : this.storageGroupCache) {
                if (!PathUtils.isStartWith((String)devicePath, (String)storageGroupName)) continue;
                return storageGroupName;
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fetchStorageGroupAndUpdateCache(StorageGroupCacheResult<?> result, List<String> devicePaths) throws IOException, TException {
        try (ConfigNodeClient client = (ConfigNodeClient)this.configNodeClientManager.borrowClient((Object)ConfigNodeInfo.partitionRegionId);){
            TStorageGroupSchemaResp storageGroupSchemaResp;
            this.storageGroupCacheLock.writeLock().lock();
            result.reset();
            this.getStorageGroupMap(result, devicePaths, true);
            if (!result.isSuccess() && (storageGroupSchemaResp = client.getMatchedStorageGroupSchemas(ROOT_PATH)).getStatus().getCode() == TSStatusCode.SUCCESS_STATUS.getStatusCode()) {
                Set<String> storageGroupNames = storageGroupSchemaResp.getStorageGroupSchemaMap().keySet();
                this.updateStorageCache(storageGroupNames);
            }
        }
        finally {
            this.storageGroupCacheLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void createStorageGroupAndUpdateCache(StorageGroupCacheResult<?> result, List<String> devicePaths) throws IOException, MetadataException, TException {
        try (ConfigNodeClient client = (ConfigNodeClient)this.configNodeClientManager.borrowClient((Object)ConfigNodeInfo.partitionRegionId);){
            this.storageGroupCacheLock.writeLock().lock();
            result.reset();
            this.getStorageGroupMap(result, devicePaths, false);
            if (!result.isSuccess()) {
                HashSet<String> storageGroupNamesNeedCreated = new HashSet<String>();
                for (String devicePath : result.getMissedDevices()) {
                    PartialPath storageGroupNameNeedCreated = MetaUtils.getStorageGroupPathByLevel(new PartialPath(devicePath), config.getDefaultStorageGroupLevel());
                    storageGroupNamesNeedCreated.add(storageGroupNameNeedCreated.getFullPath());
                }
                HashSet<String> successFullyCreatedStorageGroup = new HashSet<String>();
                for (String storageGroupName : storageGroupNamesNeedCreated) {
                    TStorageGroupSchema storageGroupSchema = new TStorageGroupSchema();
                    storageGroupSchema.setName(storageGroupName);
                    TSetStorageGroupReq req = new TSetStorageGroupReq(storageGroupSchema);
                    TSStatus tsStatus = client.setStorageGroup(req);
                    if (TSStatusCode.SUCCESS_STATUS.getStatusCode() == tsStatus.getCode()) {
                        successFullyCreatedStorageGroup.add(storageGroupName);
                        continue;
                    }
                    this.updateStorageCache(successFullyCreatedStorageGroup);
                    logger.warn("[{} Cache] failed to create storage group {}", (Object)STORAGE_GROUP_CACHE_NAME, (Object)storageGroupName);
                    throw new RuntimeException(new IoTDBException(tsStatus.message, tsStatus.code));
                }
                this.updateStorageCache(storageGroupNamesNeedCreated);
            }
        }
        finally {
            this.storageGroupCacheLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void getStorageGroupMap(StorageGroupCacheResult<?> result, List<String> devicePaths, boolean failFast) {
        try {
            this.storageGroupCacheLock.readLock().lock();
            result.reset();
            boolean status = true;
            for (String devicePath : devicePaths) {
                String storageGroupName = this.getStorageGroupName(devicePath);
                if (null == storageGroupName) {
                    logger.debug("[{} Cache] miss when search device {}", (Object)STORAGE_GROUP_CACHE_NAME, (Object)devicePath);
                    status = false;
                    if (failFast) break;
                    result.addMissedDevice(devicePath);
                    continue;
                }
                result.put(devicePath, storageGroupName);
            }
            if (!status) {
                result.setFailed();
            }
            logger.debug("[{} Cache] hit when search device {}", (Object)STORAGE_GROUP_CACHE_NAME, devicePaths);
            CacheMetricsRecorder.record(status, STORAGE_GROUP_CACHE_NAME);
        }
        finally {
            this.storageGroupCacheLock.readLock().unlock();
        }
    }

    private void getStorageGroupCacheResult(StorageGroupCacheResult<?> result, List<String> devicePaths, boolean tryToFetch, boolean isAutoCreate) {
        for (String devicePath : devicePaths) {
            if (!devicePath.contains("*")) continue;
            return;
        }
        this.getStorageGroupMap(result, devicePaths, true);
        if (!result.isSuccess() && tryToFetch) {
            try {
                this.fetchStorageGroupAndUpdateCache(result, devicePaths);
                this.getStorageGroupMap(result, devicePaths, true);
                if (!result.isSuccess() && isAutoCreate) {
                    this.createStorageGroupAndUpdateCache(result, devicePaths);
                    this.getStorageGroupMap(result, devicePaths, true);
                    if (!result.isSuccess()) {
                        throw new StatementAnalyzeException("Failed to get Storage Group Map in three attempts.");
                    }
                }
            }
            catch (IOException | MetadataException | TException e) {
                throw new StatementAnalyzeException("An error occurred when executing getDeviceToStorageGroup():" + e.getMessage());
            }
        }
    }

    public void updateStorageCache(Set<String> storageGroupNames) {
        this.storageGroupCacheLock.writeLock().lock();
        try {
            this.storageGroupCache.addAll(storageGroupNames);
        }
        finally {
            this.storageGroupCacheLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeFromStorageGroupCache(List<String> storageGroupNames) {
        this.storageGroupCacheLock.writeLock().lock();
        try {
            for (String storageGroupName : storageGroupNames) {
                this.storageGroupCache.remove(storageGroupName);
            }
        }
        finally {
            this.storageGroupCacheLock.writeLock().unlock();
        }
    }

    public void removeFromStorageGroupCache() {
        this.storageGroupCacheLock.writeLock().lock();
        try {
            this.storageGroupCache.clear();
        }
        finally {
            this.storageGroupCacheLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public TRegionReplicaSet getRegionReplicaSet(TConsensusGroupId consensusGroupId) {
        TRegionReplicaSet result;
        try {
            this.regionReplicaSetLock.readLock().lock();
            result = this.groupIdToReplicaSetMap.get(consensusGroupId);
        }
        finally {
            this.regionReplicaSetLock.readLock().unlock();
        }
        if (result == null) {
            try {
                this.regionReplicaSetLock.writeLock().lock();
                if (!this.groupIdToReplicaSetMap.containsKey(consensusGroupId)) {
                    try (ConfigNodeClient client = (ConfigNodeClient)this.configNodeClientManager.borrowClient((Object)ConfigNodeInfo.partitionRegionId);){
                        TRegionRouteMapResp resp = client.getLatestRegionRouteMap();
                        if (TSStatusCode.SUCCESS_STATUS.getStatusCode() == resp.getStatus().getCode()) {
                            this.updateGroupIdToReplicaSetMap(resp.getTimestamp(), resp.getRegionRouteMap());
                        }
                        if (!this.groupIdToReplicaSetMap.containsKey(consensusGroupId)) {
                            throw new RuntimeException("Failed to get replicaSet of consensus group[id= " + consensusGroupId + "]");
                        }
                    }
                    catch (IOException | TException e) {
                        throw new StatementAnalyzeException("An error occurred when executing getRegionReplicaSet():" + e.getMessage());
                    }
                }
                result = this.groupIdToReplicaSetMap.get(consensusGroupId);
            }
            finally {
                this.regionReplicaSetLock.writeLock().unlock();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean updateGroupIdToReplicaSetMap(long timestamp, Map<TConsensusGroupId, TRegionReplicaSet> map) {
        try {
            boolean result;
            this.regionReplicaSetLock.writeLock().lock();
            boolean bl = result = timestamp == this.latestUpdateTime.accumulateAndGet(timestamp, Math::max);
            if (result) {
                this.groupIdToReplicaSetMap.clear();
                this.groupIdToReplicaSetMap.putAll(map);
            }
            boolean bl2 = result;
            return bl2;
        }
        finally {
            this.regionReplicaSetLock.writeLock().unlock();
        }
    }

    public void invalidReplicaSetCache() {
        try {
            this.regionReplicaSetLock.writeLock().lock();
            this.groupIdToReplicaSetMap.clear();
        }
        finally {
            this.regionReplicaSetLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SchemaPartition getSchemaPartition(Map<String, List<String>> storageGroupToDeviceMap) {
        this.schemaPartitionCacheLock.readLock().lock();
        try {
            if (storageGroupToDeviceMap.size() == 0) {
                CacheMetricsRecorder.record(false, SCHEMA_PARTITION_CACHE_NAME);
                SchemaPartition schemaPartition = null;
                return schemaPartition;
            }
            HashMap<String, Map> schemaPartitionMap = new HashMap<String, Map>();
            for (Map.Entry<String, List<String>> entry : storageGroupToDeviceMap.entrySet()) {
                String storageGroupName = entry.getKey();
                Map regionReplicaSetMap = schemaPartitionMap.computeIfAbsent(storageGroupName, k -> new HashMap());
                SchemaPartitionTable schemaPartitionTable = (SchemaPartitionTable)this.schemaPartitionCache.getIfPresent((Object)storageGroupName);
                if (null == schemaPartitionTable) {
                    logger.debug("[{} Cache] miss when search storage group {}", (Object)SCHEMA_PARTITION_CACHE_NAME, (Object)storageGroupName);
                    CacheMetricsRecorder.record(false, SCHEMA_PARTITION_CACHE_NAME);
                    SchemaPartition schemaPartition = null;
                    return schemaPartition;
                }
                Map map = schemaPartitionTable.getSchemaPartitionMap();
                for (String device : entry.getValue()) {
                    TSeriesPartitionSlot seriesPartitionSlot = this.partitionExecutor.getSeriesPartitionSlot(device);
                    if (!map.containsKey(seriesPartitionSlot)) {
                        logger.debug("[{} Cache] miss when search device {}", (Object)SCHEMA_PARTITION_CACHE_NAME, (Object)device);
                        CacheMetricsRecorder.record(false, SCHEMA_PARTITION_CACHE_NAME);
                        SchemaPartition schemaPartition = null;
                        return schemaPartition;
                    }
                    TConsensusGroupId consensusGroupId = (TConsensusGroupId)map.get(seriesPartitionSlot);
                    TRegionReplicaSet regionReplicaSet = this.getRegionReplicaSet(consensusGroupId);
                    regionReplicaSetMap.put(seriesPartitionSlot, regionReplicaSet);
                }
            }
            logger.debug("[{} Cache] hit", (Object)SCHEMA_PARTITION_CACHE_NAME);
            CacheMetricsRecorder.record(true, SCHEMA_PARTITION_CACHE_NAME);
            SchemaPartition schemaPartition = new SchemaPartition(schemaPartitionMap, this.seriesSlotExecutorName, this.seriesPartitionSlotNum);
            return schemaPartition;
        }
        finally {
            this.schemaPartitionCacheLock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateSchemaPartitionCache(Map<String, Map<TSeriesPartitionSlot, TConsensusGroupId>> schemaPartitionTable) {
        this.schemaPartitionCacheLock.writeLock().lock();
        try {
            for (Map.Entry<String, Map<TSeriesPartitionSlot, TConsensusGroupId>> entry1 : schemaPartitionTable.entrySet()) {
                String storageGroupName = entry1.getKey();
                SchemaPartitionTable result = (SchemaPartitionTable)this.schemaPartitionCache.getIfPresent((Object)storageGroupName);
                if (null == result) {
                    result = new SchemaPartitionTable();
                    this.schemaPartitionCache.put((Object)storageGroupName, (Object)result);
                }
                Map seriesPartitionSlotTConsensusGroupIdMap = result.getSchemaPartitionMap();
                seriesPartitionSlotTConsensusGroupIdMap.putAll(entry1.getValue());
            }
        }
        finally {
            this.schemaPartitionCacheLock.writeLock().unlock();
        }
    }

    public void invalidSchemaPartitionCache(String storageGroupName) {
        this.schemaPartitionCacheLock.writeLock().lock();
        try {
            this.schemaPartitionCache.invalidate((Object)storageGroupName);
        }
        finally {
            this.schemaPartitionCacheLock.writeLock().unlock();
        }
    }

    public void invalidAllSchemaPartitionCache() {
        this.schemaPartitionCacheLock.writeLock().lock();
        try {
            this.schemaPartitionCache.invalidateAll();
        }
        finally {
            this.schemaPartitionCacheLock.writeLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DataPartition getDataPartition(Map<String, List<DataPartitionQueryParam>> storageGroupToQueryParamsMap) {
        this.dataPartitionCacheLock.readLock().lock();
        try {
            if (storageGroupToQueryParamsMap.size() == 0) {
                CacheMetricsRecorder.record(false, DATA_PARTITION_CACHE_NAME);
                DataPartition dataPartition = null;
                return dataPartition;
            }
            HashMap<String, Map<TSeriesPartitionSlot, Map<TTimePartitionSlot, List<TRegionReplicaSet>>>> dataPartitionMap = new HashMap<String, Map<TSeriesPartitionSlot, Map<TTimePartitionSlot, List<TRegionReplicaSet>>>>();
            for (Map.Entry<String, List<DataPartitionQueryParam>> entry : storageGroupToQueryParamsMap.entrySet()) {
                if (null != entry.getValue() && 0 != entry.getValue().size() && this.getStorageGroupDataPartition(dataPartitionMap, entry.getKey(), entry.getValue())) continue;
                CacheMetricsRecorder.record(false, DATA_PARTITION_CACHE_NAME);
                DataPartition dataPartition = null;
                return dataPartition;
            }
            logger.debug("[{} Cache] hit", (Object)DATA_PARTITION_CACHE_NAME);
            CacheMetricsRecorder.record(true, DATA_PARTITION_CACHE_NAME);
            DataPartition dataPartition = new DataPartition(dataPartitionMap, this.seriesSlotExecutorName, this.seriesPartitionSlotNum);
            return dataPartition;
        }
        finally {
            this.dataPartitionCacheLock.readLock().unlock();
        }
    }

    private boolean getStorageGroupDataPartition(Map<String, Map<TSeriesPartitionSlot, Map<TTimePartitionSlot, List<TRegionReplicaSet>>>> dataPartitionMap, String storageGroupName, List<DataPartitionQueryParam> dataPartitionQueryParams) {
        DataPartitionTable dataPartitionTable = (DataPartitionTable)this.dataPartitionCache.getIfPresent((Object)storageGroupName);
        if (null == dataPartitionTable) {
            logger.debug("[{} Cache] miss when search storage group {}", (Object)DATA_PARTITION_CACHE_NAME, (Object)storageGroupName);
            return false;
        }
        Map cachedStorageGroupPartitionMap = dataPartitionTable.getDataPartitionMap();
        Map seriesSlotToTimePartitionMap = dataPartitionMap.computeIfAbsent(storageGroupName, k -> new HashMap());
        for (DataPartitionQueryParam dataPartitionQueryParam : dataPartitionQueryParams) {
            if (this.getDeviceDataPartition(seriesSlotToTimePartitionMap, dataPartitionQueryParam, cachedStorageGroupPartitionMap)) continue;
            return false;
        }
        return true;
    }

    private boolean getDeviceDataPartition(Map<TSeriesPartitionSlot, Map<TTimePartitionSlot, List<TRegionReplicaSet>>> seriesSlotToTimePartitionMap, DataPartitionQueryParam dataPartitionQueryParam, Map<TSeriesPartitionSlot, SeriesPartitionTable> cachedStorageGroupPartitionMap) {
        if (null == dataPartitionQueryParam.getDevicePath()) {
            return false;
        }
        TSeriesPartitionSlot seriesPartitionSlot = this.partitionExecutor.getSeriesPartitionSlot(dataPartitionQueryParam.getDevicePath());
        SeriesPartitionTable cachedSeriesPartitionTable = cachedStorageGroupPartitionMap.get(seriesPartitionSlot);
        if (null == cachedSeriesPartitionTable) {
            logger.debug("[{} Cache] miss when search device {}", (Object)DATA_PARTITION_CACHE_NAME, (Object)dataPartitionQueryParam.getDevicePath());
            return false;
        }
        Map cachedTimePartitionSlot = cachedSeriesPartitionTable.getSeriesPartitionMap();
        Map timePartitionSlotListMap = seriesSlotToTimePartitionMap.computeIfAbsent(seriesPartitionSlot, k -> new HashMap());
        if (0 == dataPartitionQueryParam.getTimePartitionSlotList().size()) {
            return false;
        }
        for (TTimePartitionSlot timePartitionSlot : dataPartitionQueryParam.getTimePartitionSlotList()) {
            if (this.getTimeSlotDataPartition(timePartitionSlotListMap, timePartitionSlot, cachedTimePartitionSlot)) continue;
            return false;
        }
        return true;
    }

    private boolean getTimeSlotDataPartition(Map<TTimePartitionSlot, List<TRegionReplicaSet>> timePartitionSlotListMap, TTimePartitionSlot timePartitionSlot, Map<TTimePartitionSlot, List<TConsensusGroupId>> cachedTimePartitionSlot) {
        List<TConsensusGroupId> cacheConsensusGroupId = cachedTimePartitionSlot.get(timePartitionSlot);
        if (null == cacheConsensusGroupId || 0 == cacheConsensusGroupId.size() || null == timePartitionSlot) {
            logger.debug("[{} Cache] miss when search time partition {}", (Object)DATA_PARTITION_CACHE_NAME, (Object)timePartitionSlot);
            return false;
        }
        LinkedList<TRegionReplicaSet> regionReplicaSets = new LinkedList<TRegionReplicaSet>();
        for (TConsensusGroupId consensusGroupId : cacheConsensusGroupId) {
            regionReplicaSets.add(this.getRegionReplicaSet(consensusGroupId));
        }
        timePartitionSlotListMap.put(timePartitionSlot, regionReplicaSets);
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateDataPartitionCache(Map<String, Map<TSeriesPartitionSlot, Map<TTimePartitionSlot, List<TConsensusGroupId>>>> dataPartitionTable) {
        this.dataPartitionCacheLock.writeLock().lock();
        try {
            for (Map.Entry<String, Map<TSeriesPartitionSlot, Map<TTimePartitionSlot, List<TConsensusGroupId>>>> entry1 : dataPartitionTable.entrySet()) {
                String storageGroupName = entry1.getKey();
                if (null == storageGroupName) continue;
                DataPartitionTable result = (DataPartitionTable)this.dataPartitionCache.getIfPresent((Object)storageGroupName);
                if (null == result) {
                    result = new DataPartitionTable();
                    this.dataPartitionCache.put((Object)storageGroupName, (Object)result);
                }
                Map seriesPartitionSlotSeriesPartitionTableMap = result.getDataPartitionMap();
                for (Map.Entry<TSeriesPartitionSlot, Map<TTimePartitionSlot, List<TConsensusGroupId>>> entry2 : entry1.getValue().entrySet()) {
                    SeriesPartitionTable seriesPartitionTable;
                    TSeriesPartitionSlot seriesPartitionSlot = entry2.getKey();
                    if (null == seriesPartitionSlot) continue;
                    if (!seriesPartitionSlotSeriesPartitionTableMap.containsKey(seriesPartitionSlot)) {
                        seriesPartitionTable = new SeriesPartitionTable(entry2.getValue());
                        seriesPartitionSlotSeriesPartitionTableMap.put(seriesPartitionSlot, seriesPartitionTable);
                        continue;
                    }
                    seriesPartitionTable = (SeriesPartitionTable)seriesPartitionSlotSeriesPartitionTableMap.get(seriesPartitionSlot);
                    Map result3 = seriesPartitionTable.getSeriesPartitionMap();
                    result3.putAll(entry2.getValue());
                }
            }
        }
        finally {
            this.dataPartitionCacheLock.writeLock().unlock();
        }
    }

    public void invalidDataPartitionCache(String storageGroup) {
        this.dataPartitionCacheLock.writeLock().lock();
        try {
            this.dataPartitionCache.invalidate((Object)storageGroup);
        }
        finally {
            this.dataPartitionCacheLock.writeLock().unlock();
        }
    }

    public void invalidAllDataPartitionCache() {
        this.dataPartitionCacheLock.writeLock().lock();
        try {
            this.dataPartitionCache.invalidateAll();
        }
        finally {
            this.dataPartitionCacheLock.writeLock().unlock();
        }
    }

    public void invalidAllCache() {
        logger.debug("[Partition Cache] invalid");
        this.removeFromStorageGroupCache();
        this.invalidAllDataPartitionCache();
        this.invalidAllSchemaPartitionCache();
        this.invalidReplicaSetCache();
        logger.debug("[Partition Cache] is invalid:{}", (Object)this);
    }

    public String toString() {
        return "PartitionCache{cacheSize=" + this.cacheSize + ", storageGroupCache=" + this.storageGroupCache + ", replicaSetCache=" + this.groupIdToReplicaSetMap + ", schemaPartitionCache=" + this.schemaPartitionCache + ", dataPartitionCache=" + this.dataPartitionCache + '}';
    }
}

