/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.expression.multi;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.time.ZoneId;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.udf.builtin.BuiltinAggregationFunction;
import org.apache.iotdb.db.exception.query.LogicalOptimizeException;
import org.apache.iotdb.db.mpp.common.NodeRef;
import org.apache.iotdb.db.mpp.plan.expression.Expression;
import org.apache.iotdb.db.mpp.plan.expression.ExpressionType;
import org.apache.iotdb.db.mpp.plan.expression.leaf.TimeSeriesOperand;
import org.apache.iotdb.db.mpp.plan.expression.visitor.ExpressionVisitor;
import org.apache.iotdb.db.mpp.plan.planner.plan.parameter.InputLocation;
import org.apache.iotdb.db.mpp.transformation.dag.memory.LayerMemoryAssigner;
import org.apache.iotdb.db.mpp.transformation.dag.udf.UDTFExecutor;
import org.apache.iotdb.db.mpp.transformation.dag.udf.UDTFInformationInferrer;
import org.apache.iotdb.db.qp.physical.crud.UDTFPlan;
import org.apache.iotdb.db.qp.strategy.optimizer.ConcatPathOptimizer;
import org.apache.iotdb.db.qp.utils.WildcardsRemover;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;
import org.apache.iotdb.udf.api.customizer.strategy.AccessStrategy;

public class FunctionExpression
extends Expression {
    private final boolean isBuiltInAggregationFunctionExpression;
    private boolean isUserDefinedAggregationFunctionExpression;
    private final String functionName;
    private final LinkedHashMap<String, String> functionAttributes;
    private List<Expression> expressions;
    private List<PartialPath> paths;
    private String parametersString;

    public FunctionExpression(String functionName) {
        this.functionName = functionName;
        this.functionAttributes = new LinkedHashMap();
        this.expressions = new ArrayList<Expression>();
        this.isBuiltInAggregationFunctionExpression = BuiltinAggregationFunction.getNativeFunctionNames().contains(functionName.toLowerCase());
        this.isConstantOperandCache = true;
    }

    public FunctionExpression(String functionName, LinkedHashMap<String, String> functionAttributes, List<Expression> expressions) {
        this.functionName = functionName;
        this.functionAttributes = functionAttributes;
        this.expressions = expressions;
        this.isBuiltInAggregationFunctionExpression = BuiltinAggregationFunction.getNativeFunctionNames().contains(functionName.toLowerCase());
        this.isConstantOperandCache = expressions.stream().anyMatch(Expression::isConstantOperand);
        this.isUserDefinedAggregationFunctionExpression = expressions.stream().anyMatch(v -> v.isUserDefinedAggregationFunctionExpression() || v.isBuiltInAggregationFunctionExpression());
    }

    public FunctionExpression(ByteBuffer byteBuffer) {
        this.functionName = ReadWriteIOUtils.readString((ByteBuffer)byteBuffer);
        this.functionAttributes = ReadWriteIOUtils.readLinkedHashMap((ByteBuffer)byteBuffer);
        int expressionSize = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer);
        this.expressions = new ArrayList<Expression>();
        for (int i = 0; i < expressionSize; ++i) {
            this.expressions.add(Expression.deserialize(byteBuffer));
        }
        this.isBuiltInAggregationFunctionExpression = BuiltinAggregationFunction.getNativeFunctionNames().contains(this.functionName);
        this.isConstantOperandCache = this.expressions.stream().anyMatch(Expression::isConstantOperand);
        this.isUserDefinedAggregationFunctionExpression = this.expressions.stream().anyMatch(v -> v.isUserDefinedAggregationFunctionExpression() || v.isBuiltInAggregationFunctionExpression());
    }

    @Override
    public <R, C> R accept(ExpressionVisitor<R, C> visitor, C context) {
        return visitor.visitFunctionExpression(this, context);
    }

    @Override
    public boolean isBuiltInAggregationFunctionExpression() {
        return this.isBuiltInAggregationFunctionExpression;
    }

    @Override
    public boolean isConstantOperandInternal() {
        return this.isConstantOperandCache;
    }

    @Override
    public boolean isTimeSeriesGeneratingFunctionExpression() {
        return !this.isBuiltInAggregationFunctionExpression() && !this.isUserDefinedAggregationFunctionExpression();
    }

    @Override
    public boolean isUserDefinedAggregationFunctionExpression() {
        return this.isUserDefinedAggregationFunctionExpression;
    }

    public boolean isCountStar() {
        if (!this.isBuiltInAggregationFunctionExpression) {
            return false;
        }
        return this.getPaths().size() == 1 && this.paths.get(0) != null && (this.paths.get(0).getTailNode().equals("*") || this.paths.get(0).getTailNode().equals("**")) && this.functionName.equals("count");
    }

    public void addAttribute(String key, String value) {
        this.functionAttributes.put(key, value);
    }

    public void addExpression(Expression expression) {
        this.isConstantOperandCache = this.isConstantOperandCache != false && expression.isConstantOperand();
        this.isUserDefinedAggregationFunctionExpression = this.isUserDefinedAggregationFunctionExpression || expression.isUserDefinedAggregationFunctionExpression() || expression.isBuiltInAggregationFunctionExpression();
        this.expressions.add(expression);
    }

    public void setExpressions(List<Expression> expressions) {
        this.expressions = expressions;
    }

    public String getFunctionName() {
        return this.functionName;
    }

    public LinkedHashMap<String, String> getFunctionAttributes() {
        return this.functionAttributes;
    }

    @Override
    public List<Expression> getExpressions() {
        return this.expressions;
    }

    @Override
    public void concat(List<PartialPath> prefixPaths, List<Expression> resultExpressions) {
        ArrayList resultExpressionsForRecursionList = new ArrayList();
        for (Expression suffixExpression : this.expressions) {
            ArrayList<Expression> arrayList = new ArrayList<Expression>();
            suffixExpression.concat(prefixPaths, arrayList);
            resultExpressionsForRecursionList.add(arrayList);
        }
        ArrayList functionExpressions = new ArrayList();
        ConcatPathOptimizer.cartesianProduct(resultExpressionsForRecursionList, functionExpressions, 0, new ArrayList());
        for (List list : functionExpressions) {
            resultExpressions.add(new FunctionExpression(this.functionName, this.functionAttributes, list));
        }
    }

    @Override
    public void removeWildcards(WildcardsRemover wildcardsRemover, List<Expression> resultExpressions) throws LogicalOptimizeException {
        for (List<Expression> functionExpression : wildcardsRemover.removeWildcardsFrom(this.expressions)) {
            resultExpressions.add(new FunctionExpression(this.functionName, this.functionAttributes, functionExpression));
        }
    }

    @Override
    public void collectPaths(Set<PartialPath> pathSet) {
        for (Expression expression : this.expressions) {
            expression.collectPaths(pathSet);
        }
    }

    @Override
    public void constructUdfExecutors(Map<String, UDTFExecutor> expressionName2Executor, ZoneId zoneId) {
        String expressionString = this.getExpressionString();
        if (expressionName2Executor.containsKey(expressionString)) {
            return;
        }
        for (Expression expression : this.expressions) {
            expression.constructUdfExecutors(expressionName2Executor, zoneId);
        }
        expressionName2Executor.put(expressionString, new UDTFExecutor(this.functionName, zoneId));
    }

    @Override
    public void bindInputLayerColumnIndexWithExpression(UDTFPlan udtfPlan) {
        for (Expression expression : this.expressions) {
            expression.bindInputLayerColumnIndexWithExpression(udtfPlan);
        }
        this.inputColumnIndex = udtfPlan.getReaderIndexByExpressionName(this.toString());
    }

    @Override
    public void bindInputLayerColumnIndexWithExpression(Map<String, List<InputLocation>> inputLocations) {
        for (Expression expression : this.expressions) {
            expression.bindInputLayerColumnIndexWithExpression(inputLocations);
        }
        String digest = this.toString();
        if (inputLocations.containsKey(digest)) {
            this.inputColumnIndex = inputLocations.get(digest).get(0).getValueColumnIndex();
        }
    }

    @Override
    public void updateStatisticsForMemoryAssigner(LayerMemoryAssigner memoryAssigner) {
        for (Expression expression : this.expressions) {
            expression.updateStatisticsForMemoryAssigner(memoryAssigner);
        }
        memoryAssigner.increaseExpressionReference(this);
    }

    @Override
    public boolean isMappable(Map<NodeRef<Expression>, TSDataType> expressionTypes) {
        if (this.isBuiltInAggregationFunctionExpression) {
            return true;
        }
        return new UDTFInformationInferrer(this.functionName).getAccessStrategy(this.expressions.stream().map(Expression::toString).collect(Collectors.toList()), this.expressions.stream().map(f -> (TSDataType)expressionTypes.get(NodeRef.of(f))).collect(Collectors.toList()), this.functionAttributes).getAccessStrategyType().equals((Object)AccessStrategy.AccessStrategyType.MAPPABLE_ROW_BY_ROW);
    }

    public List<PartialPath> getPaths() {
        if (this.paths == null) {
            this.paths = new ArrayList<PartialPath>();
            for (Expression expression : this.expressions) {
                this.paths.add(expression instanceof TimeSeriesOperand ? ((TimeSeriesOperand)expression).getPath() : null);
            }
        }
        return this.paths;
    }

    @Override
    public String getExpressionStringInternal() {
        return this.functionName + "(" + this.getParametersString() + ")";
    }

    private String getParametersString() {
        if (this.parametersString == null) {
            StringBuilder builder = new StringBuilder();
            if (!this.expressions.isEmpty()) {
                builder.append(this.expressions.get(0).toString());
                for (int i = 1; i < this.expressions.size(); ++i) {
                    builder.append(", ").append(this.expressions.get(i).toString());
                }
            }
            if (!this.functionAttributes.isEmpty()) {
                if (!this.expressions.isEmpty()) {
                    builder.append(", ");
                }
                Iterator<Map.Entry<String, String>> iterator = this.functionAttributes.entrySet().iterator();
                Map.Entry<String, String> entry = iterator.next();
                builder.append("\"").append(entry.getKey()).append("\"=\"").append(entry.getValue()).append("\"");
                while (iterator.hasNext()) {
                    entry = iterator.next();
                    builder.append(", ").append("\"").append(entry.getKey()).append("\"=\"").append(entry.getValue()).append("\"");
                }
            }
            this.parametersString = builder.toString();
        }
        return this.parametersString;
    }

    @Override
    public ExpressionType getExpressionType() {
        return ExpressionType.FUNCTION;
    }

    @Override
    protected void serialize(ByteBuffer byteBuffer) {
        ReadWriteIOUtils.write((String)this.functionName, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write(this.functionAttributes, (ByteBuffer)byteBuffer);
        ReadWriteIOUtils.write((int)this.expressions.size(), (ByteBuffer)byteBuffer);
        for (Expression expression : this.expressions) {
            Expression.serialize(expression, byteBuffer);
        }
    }

    @Override
    protected void serialize(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((String)this.functionName, (OutputStream)stream);
        ReadWriteIOUtils.write(this.functionAttributes, (OutputStream)stream);
        ReadWriteIOUtils.write((int)this.expressions.size(), (OutputStream)stream);
        for (Expression expression : this.expressions) {
            Expression.serialize(expression, stream);
        }
    }
}

