/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.planner.plan.parameter;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.db.mpp.plan.statement.component.SortItem;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class OrderByParameter {
    private final List<SortItem> sortItemList;

    public OrderByParameter(List<SortItem> sortItemList) {
        this.sortItemList = sortItemList;
    }

    public OrderByParameter() {
        this.sortItemList = new ArrayList<SortItem>();
    }

    public List<SortItem> getSortItemList() {
        return this.sortItemList;
    }

    public boolean isEmpty() {
        return this.sortItemList.isEmpty();
    }

    public void serializeAttributes(ByteBuffer byteBuffer) {
        ReadWriteIOUtils.write((int)this.sortItemList.size(), (ByteBuffer)byteBuffer);
        for (SortItem sortItem : this.sortItemList) {
            sortItem.serialize(byteBuffer);
        }
    }

    public void serializeAttributes(DataOutputStream stream) throws IOException {
        ReadWriteIOUtils.write((int)this.sortItemList.size(), (OutputStream)stream);
        for (SortItem sortItem : this.sortItemList) {
            sortItem.serialize(stream);
        }
    }

    public static OrderByParameter deserialize(ByteBuffer byteBuffer) {
        int sortItemSize;
        ArrayList<SortItem> sortItemList = new ArrayList<SortItem>(sortItemSize);
        for (sortItemSize = ReadWriteIOUtils.readInt((ByteBuffer)byteBuffer); sortItemSize > 0; --sortItemSize) {
            sortItemList.add(SortItem.deserialize(byteBuffer));
        }
        return new OrderByParameter(sortItemList);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        OrderByParameter that = (OrderByParameter)o;
        return this.sortItemList.equals(that.sortItemList);
    }

    public int hashCode() {
        return Objects.hash(this.sortItemList);
    }
}

