/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.mpp.plan.statement.metadata.template;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.mpp.plan.analyze.QueryType;
import org.apache.iotdb.db.mpp.plan.constant.StatementType;
import org.apache.iotdb.db.mpp.plan.statement.IConfigStatement;
import org.apache.iotdb.db.mpp.plan.statement.Statement;
import org.apache.iotdb.db.mpp.plan.statement.StatementVisitor;
import org.apache.iotdb.tsfile.file.metadata.enums.CompressionType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;
import org.apache.iotdb.tsfile.file.metadata.enums.TSEncoding;

public class CreateSchemaTemplateStatement
extends Statement
implements IConfigStatement {
    String name;
    Set<String> alignedDeviceId;
    String[][] measurements;
    TSDataType[][] dataTypes;
    TSEncoding[][] encodings;
    CompressionType[][] compressors;
    private static final int NEW_PLAN = -1;

    public CreateSchemaTemplateStatement() {
        this.statementType = StatementType.CREATE_TEMPLATE;
    }

    public CreateSchemaTemplateStatement(String name, List<List<String>> measurements, List<List<TSDataType>> dataTypes, List<List<TSEncoding>> encodings, List<List<CompressionType>> compressors) {
        this();
        int j;
        int i;
        this.name = name;
        this.measurements = new String[measurements.size()][];
        for (i = 0; i < measurements.size(); ++i) {
            this.measurements[i] = new String[measurements.get(i).size()];
            for (j = 0; j < measurements.get(i).size(); ++j) {
                this.measurements[i][j] = measurements.get(i).get(j);
            }
        }
        this.dataTypes = new TSDataType[dataTypes.size()][];
        for (i = 0; i < dataTypes.size(); ++i) {
            this.dataTypes[i] = new TSDataType[dataTypes.get(i).size()];
            for (j = 0; j < dataTypes.get(i).size(); ++j) {
                this.dataTypes[i][j] = dataTypes.get(i).get(j);
            }
        }
        this.encodings = new TSEncoding[dataTypes.size()][];
        for (i = 0; i < encodings.size(); ++i) {
            this.encodings[i] = new TSEncoding[dataTypes.get(i).size()];
            for (j = 0; j < encodings.get(i).size(); ++j) {
                this.encodings[i][j] = encodings.get(i).get(j);
            }
        }
        this.compressors = new CompressionType[dataTypes.size()][];
        for (i = 0; i < compressors.size(); ++i) {
            this.compressors[i] = new CompressionType[compressors.get(i).size()];
            for (j = 0; j < compressors.get(i).size(); ++j) {
                this.compressors[i][j] = compressors.get(i).get(j);
            }
        }
        this.alignedDeviceId = new HashSet<String>();
    }

    public CreateSchemaTemplateStatement(String name, List<List<String>> measurements, List<List<TSDataType>> dataTypes, List<List<TSEncoding>> encodings, List<List<CompressionType>> compressors, Set<String> alignedDeviceId) {
        this(name, measurements, dataTypes, encodings, compressors);
        this.alignedDeviceId = alignedDeviceId;
    }

    public CreateSchemaTemplateStatement(String name, String[][] measurements, TSDataType[][] dataTypes, TSEncoding[][] encodings, CompressionType[][] compressors) {
        this();
        this.name = name;
        this.measurements = measurements;
        this.dataTypes = dataTypes;
        this.encodings = encodings;
        this.compressors = compressors;
    }

    @Override
    public List<? extends PartialPath> getPaths() {
        return null;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public Set<String> getAlignedDeviceId() {
        return this.alignedDeviceId;
    }

    public List<List<String>> getMeasurements() {
        ArrayList<List<String>> ret = new ArrayList<List<String>>();
        for (String[] measurement : this.measurements) {
            ret.add(Arrays.asList(measurement));
        }
        return ret;
    }

    public List<List<TSDataType>> getDataTypes() {
        ArrayList<List<TSDataType>> ret = new ArrayList<List<TSDataType>>();
        for (TSDataType[] alignedDataTypes : this.dataTypes) {
            ret.add(Arrays.asList(alignedDataTypes));
        }
        return ret;
    }

    public List<List<TSEncoding>> getEncodings() {
        ArrayList<List<TSEncoding>> ret = new ArrayList<List<TSEncoding>>();
        for (TSEncoding[] alignedEncodings : this.encodings) {
            ret.add(Arrays.asList(alignedEncodings));
        }
        return ret;
    }

    public List<List<CompressionType>> getCompressors() {
        ArrayList<List<CompressionType>> ret = new ArrayList<List<CompressionType>>();
        for (CompressionType[] alignedCompressor : this.compressors) {
            ret.add(Arrays.asList(alignedCompressor));
        }
        return ret;
    }

    @Override
    public <R, C> R accept(StatementVisitor<R, C> visitor, C context) {
        return visitor.visitCreateSchemaTemplate(this, context);
    }

    @Override
    public QueryType getQueryType() {
        return QueryType.WRITE;
    }
}

