/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.protocol.influxdb.function;

import java.util.List;
import org.apache.iotdb.db.mpp.plan.expression.Expression;
import org.apache.iotdb.db.protocol.influxdb.function.InfluxFunction;
import org.apache.iotdb.db.protocol.influxdb.function.aggregator.InfluxCountFunction;
import org.apache.iotdb.db.protocol.influxdb.function.aggregator.InfluxMeanFunction;
import org.apache.iotdb.db.protocol.influxdb.function.aggregator.InfluxMedianFunction;
import org.apache.iotdb.db.protocol.influxdb.function.aggregator.InfluxModeFunction;
import org.apache.iotdb.db.protocol.influxdb.function.aggregator.InfluxSpreadFunction;
import org.apache.iotdb.db.protocol.influxdb.function.aggregator.InfluxStddevFunction;
import org.apache.iotdb.db.protocol.influxdb.function.aggregator.InfluxSumFunction;
import org.apache.iotdb.db.protocol.influxdb.function.selector.InfluxFirstFunction;
import org.apache.iotdb.db.protocol.influxdb.function.selector.InfluxLastFunction;
import org.apache.iotdb.db.protocol.influxdb.function.selector.InfluxMaxFunction;
import org.apache.iotdb.db.protocol.influxdb.function.selector.InfluxMinFunction;

public class InfluxFunctionFactory {
    public static InfluxFunction generateFunction(String functionName, List<Expression> expressionList) {
        switch (functionName) {
            case "max": {
                return new InfluxMaxFunction(expressionList);
            }
            case "min": {
                return new InfluxMinFunction(expressionList);
            }
            case "last": {
                return new InfluxLastFunction(expressionList);
            }
            case "first": {
                return new InfluxFirstFunction(expressionList);
            }
            case "count": {
                return new InfluxCountFunction(expressionList);
            }
            case "mean": {
                return new InfluxMeanFunction(expressionList);
            }
            case "median": {
                return new InfluxMedianFunction(expressionList);
            }
            case "mode": {
                return new InfluxModeFunction(expressionList);
            }
            case "spread": {
                return new InfluxSpreadFunction(expressionList);
            }
            case "stddev": {
                return new InfluxStddevFunction(expressionList);
            }
            case "sum": {
                return new InfluxSumFunction(expressionList);
            }
        }
        throw new IllegalArgumentException("not support aggregation name:" + functionName);
    }
}

