/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.protocol.influxdb.function.aggregator;

import java.util.ArrayList;
import java.util.List;
import org.apache.iotdb.db.mpp.plan.expression.Expression;
import org.apache.iotdb.db.protocol.influxdb.function.InfluxFunctionValue;
import org.apache.iotdb.db.protocol.influxdb.function.aggregator.InfluxAggregator;
import org.apache.iotdb.db.utils.MathUtils;

public class InfluxStddevFunction
extends InfluxAggregator {
    private final List<Double> numbers = new ArrayList<Double>();

    public InfluxStddevFunction(List<Expression> expressionList) {
        super(expressionList);
    }

    @Override
    public InfluxFunctionValue calculateBruteForce() {
        return new InfluxFunctionValue(this.numbers.size() == 0 ? this.numbers : Double.valueOf(MathUtils.popStdDev(this.numbers)), 0L);
    }

    @Override
    public InfluxFunctionValue calculateByIoTDBFunc() {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getFunctionName() {
        return "stddev";
    }

    @Override
    public void updateValueBruteForce(InfluxFunctionValue functionValue) {
        Object value = functionValue.getValue();
        if (!(value instanceof Number)) {
            throw new IllegalArgumentException("not support this type");
        }
        double tmpValue = ((Number)value).doubleValue();
        this.numbers.add(tmpValue);
    }

    @Override
    public void updateValueIoTDBFunc(InfluxFunctionValue ... functionValues) {
        throw new UnsupportedOperationException();
    }
}

