/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.protocol.rest;

import java.util.EnumSet;
import javax.servlet.DispatcherType;
import org.apache.iotdb.commons.exception.StartupException;
import org.apache.iotdb.commons.service.IService;
import org.apache.iotdb.commons.service.ServiceType;
import org.apache.iotdb.db.conf.rest.IoTDBRestServiceConfig;
import org.apache.iotdb.db.conf.rest.IoTDBRestServiceDescriptor;
import org.apache.iotdb.db.protocol.rest.filter.ApiOriginFilter;
import org.eclipse.jetty.http.HttpVersion;
import org.eclipse.jetty.server.ConnectionFactory;
import org.eclipse.jetty.server.Connector;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HttpConfiguration;
import org.eclipse.jetty.server.HttpConnectionFactory;
import org.eclipse.jetty.server.SecureRequestCustomizer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.ServerConnector;
import org.eclipse.jetty.server.SslConnectionFactory;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.ssl.SslContextFactory;
import org.glassfish.jersey.servlet.ServletContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RestService
implements IService {
    private static final Logger LOGGER = LoggerFactory.getLogger(RestService.class);
    private static Server server;

    private void startSSL(int port, String keyStorePath, String trustStorePath, String keyStorePwd, String trustStorePwd, int idleTime, boolean clientAuth) {
        server = new Server();
        HttpConfiguration httpsConfig = new HttpConfiguration();
        httpsConfig.setSecurePort(port);
        httpsConfig.addCustomizer((HttpConfiguration.Customizer)new SecureRequestCustomizer());
        SslContextFactory.Server sslContextFactory = new SslContextFactory.Server();
        sslContextFactory.setKeyStorePath(keyStorePath);
        sslContextFactory.setKeyStorePassword(keyStorePwd);
        if (clientAuth) {
            sslContextFactory.setTrustStorePath(trustStorePath);
            sslContextFactory.setTrustStorePassword(trustStorePwd);
            sslContextFactory.setNeedClientAuth(clientAuth);
        }
        ServerConnector httpsConnector = new ServerConnector(server, new ConnectionFactory[]{new SslConnectionFactory((SslContextFactory)sslContextFactory, HttpVersion.HTTP_1_1.asString()), new HttpConnectionFactory(httpsConfig)});
        httpsConnector.setPort(port);
        httpsConnector.setIdleTimeout((long)idleTime);
        server.addConnector((Connector)httpsConnector);
        server.setHandler((Handler)this.constructServletContextHandler());
        this.serverStart();
    }

    private void startNonSSL(int port) {
        server = new Server(port);
        server.setHandler((Handler)this.constructServletContextHandler());
        this.serverStart();
    }

    private ServletContextHandler constructServletContextHandler() {
        ServletContextHandler context = new ServletContextHandler(0);
        context.addFilter(ApiOriginFilter.class, "/*", EnumSet.of(DispatcherType.INCLUDE, DispatcherType.REQUEST));
        ServletHolder holder = context.addServlet(ServletContainer.class, "/*");
        holder.setInitOrder(1);
        holder.setInitParameter("jersey.config.server.provider.packages", "io.swagger.jaxrs.listing, io.swagger.sample.resource, org.apache.iotdb.db.protocol.rest");
        holder.setInitParameter("jersey.config.server.provider.classnames", "org.glassfish.jersey.media.multipart.MultiPartFeature");
        holder.setInitParameter("jersey.config.server.wadl.disableWadl", "true");
        context.setContextPath("/");
        return context;
    }

    private void serverStart() {
        try {
            server.start();
        }
        catch (Exception e) {
            LOGGER.warn("RestService failed to start: {}", (Object)e.getMessage());
            server.destroy();
        }
    }

    public void start() throws StartupException {
        IoTDBRestServiceConfig config = IoTDBRestServiceDescriptor.getInstance().getConfig();
        if (IoTDBRestServiceDescriptor.getInstance().getConfig().isEnableHttps()) {
            this.startSSL(config.getRestServicePort(), config.getKeyStorePath(), config.getTrustStorePath(), config.getKeyStorePwd(), config.getTrustStorePwd(), config.getIdleTimeoutInSeconds(), config.isClientAuth());
        } else {
            this.startNonSSL(config.getRestServicePort());
        }
    }

    public void stop() {
        try {
            server.stop();
        }
        catch (Exception e) {
            LOGGER.warn("RestService failed to stop: {}", (Object)e.getMessage());
        }
        finally {
            server.destroy();
        }
    }

    public ServiceType getID() {
        return ServiceType.REST_SERVICE;
    }

    public static RestService getInstance() {
        return RestServiceHolder.INSTANCE;
    }

    private static class RestServiceHolder {
        private static final RestService INSTANCE = new RestService();

        private RestServiceHolder() {
        }
    }
}

