/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.logical.crud;

import java.util.List;
import org.apache.iotdb.commons.exception.IoTDBException;
import org.apache.iotdb.commons.exception.MetadataException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.exception.query.LogicalOperatorException;
import org.apache.iotdb.db.exception.query.QueryProcessException;
import org.apache.iotdb.db.mpp.plan.expression.Expression;
import org.apache.iotdb.db.mpp.plan.expression.ResultColumn;
import org.apache.iotdb.db.mpp.plan.expression.leaf.TimeSeriesOperand;
import org.apache.iotdb.db.mpp.plan.expression.multi.FunctionExpression;
import org.apache.iotdb.db.qp.logical.crud.QueryOperator;
import org.apache.iotdb.db.qp.logical.crud.SelectComponent;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.crud.AggregationPlan;
import org.apache.iotdb.db.qp.physical.crud.AlignByDevicePlan;
import org.apache.iotdb.db.qp.physical.crud.QueryPlan;
import org.apache.iotdb.db.qp.strategy.PhysicalGenerator;
import org.apache.iotdb.db.utils.SchemaUtils;
import org.apache.iotdb.tsfile.file.metadata.enums.TSDataType;

public class AggregationQueryOperator
extends QueryOperator {
    public static final String ERROR_MESSAGE1 = "Common queries and aggregated queries are not allowed to appear at the same time";

    public AggregationQueryOperator() {
    }

    public AggregationQueryOperator(QueryOperator queryOperator) {
        super(queryOperator);
    }

    @Override
    public void check() throws LogicalOperatorException {
        super.check();
        if (!this.isAlignByTime()) {
            throw new LogicalOperatorException("AGGREGATION doesn't support disable align clause.");
        }
        this.checkSelectComponent(this.selectComponent);
        if (this.isGroupByLevel() && this.isAlignByDevice()) {
            throw new LogicalOperatorException("group by level does not support align by device now.");
        }
    }

    protected void checkSelectComponent(SelectComponent selectComponent) throws LogicalOperatorException {
        if (this.hasTimeSeriesGeneratingFunction()) {
            throw new LogicalOperatorException("User-defined and built-in hybrid aggregation is not supported together.");
        }
        for (ResultColumn resultColumn : selectComponent.getResultColumns()) {
            Expression expression = resultColumn.getExpression();
            if (expression instanceof TimeSeriesOperand) {
                throw new LogicalOperatorException(ERROR_MESSAGE1);
            }
            if (!(expression instanceof FunctionExpression) || expression.getExpressions().size() == 1 && expression.getExpressions().get(0) instanceof TimeSeriesOperand) continue;
            throw new LogicalOperatorException("The argument of the aggregation function must be a time series.");
        }
    }

    @Override
    public PhysicalPlan generatePhysicalPlan(PhysicalGenerator generator) throws QueryProcessException {
        AlignByDevicePlan plan = this.isAlignByDevice() ? this.generateAlignByDevicePlan(generator) : super.generateRawDataQueryPlan(generator, this.initAggregationPlan(new AggregationPlan()));
        AggregationPlan aggregationPlan = this.isAlignByDevice() ? plan.getAggregationPlan() : (AggregationPlan)((Object)plan);
        aggregationPlan.verifyAllAggregationDataTypesMatched();
        return plan;
    }

    private boolean verifyAllAggregationDataTypesEqual() throws MetadataException {
        String aggType;
        List<String> aggregations = this.selectComponent.getAggregationFunctions();
        if (aggregations.isEmpty()) {
            return true;
        }
        List<PartialPath> paths = this.selectComponent.getPaths();
        List<TSDataType> dataTypes = SchemaUtils.getSeriesTypesByPaths(paths);
        switch (aggType = aggregations.get(0)) {
            case "min_value": 
            case "max_value": 
            case "avg": 
            case "sum": {
                return dataTypes.stream().allMatch(arg_0 -> dataTypes.get(0).equals(arg_0));
            }
        }
        return true;
    }

    @Override
    protected AlignByDevicePlan generateAlignByDevicePlan(PhysicalGenerator generator) throws QueryProcessException {
        AlignByDevicePlan alignByDevicePlan = super.generateAlignByDevicePlan(generator);
        alignByDevicePlan.setAggregationPlan(this.initAggregationPlan(new AggregationPlan()));
        return alignByDevicePlan;
    }

    protected AggregationPlan initAggregationPlan(QueryPlan queryPlan) throws QueryProcessException {
        AggregationPlan aggregationPlan = (AggregationPlan)queryPlan;
        aggregationPlan.setAggregations(this.selectComponent.getAggregationFunctions());
        if (this.isGroupByLevel()) {
            this.initGroupByLevel(aggregationPlan);
        }
        return aggregationPlan;
    }

    protected void initGroupByLevel(AggregationPlan aggregationPlan) throws QueryProcessException {
        aggregationPlan.setLevels(this.specialClauseComponent.getLevels());
        aggregationPlan.setGroupByLevelController(this.specialClauseComponent.groupByLevelController);
        try {
            if (!this.verifyAllAggregationDataTypesEqual()) {
                throw new LogicalOperatorException("Aggregate among unmatched data types");
            }
        }
        catch (MetadataException e) {
            throw new LogicalOperatorException((IoTDBException)((Object)e));
        }
    }
}

