/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.physical.sys;

import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.commons.exception.IllegalPathException;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.metadata.plan.schemaregion.write.IActivateTemplateInClusterPlan;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.tsfile.utils.ReadWriteIOUtils;

public class ActivateTemplateInClusterPlan
extends PhysicalPlan
implements IActivateTemplateInClusterPlan {
    private PartialPath activatePath;
    private int templateSetLevel;
    private int templateId;
    private boolean isAligned;

    public ActivateTemplateInClusterPlan() {
        super(Operator.OperatorType.ACTIVATE_TEMPLATE_IN_CLUSTER);
    }

    public ActivateTemplateInClusterPlan(PartialPath activatePath, int templateSetLevel, int templateId) {
        this.activatePath = activatePath;
        this.templateSetLevel = templateSetLevel;
        this.templateId = templateId;
    }

    @Override
    public PartialPath getActivatePath() {
        return this.activatePath;
    }

    @Override
    public void setActivatePath(PartialPath activatePath) {
        this.activatePath = activatePath;
    }

    @Override
    public PartialPath getPathSetTemplate() {
        return new PartialPath(Arrays.copyOf(this.activatePath.getNodes(), this.templateSetLevel + 1));
    }

    @Override
    public int getTemplateId() {
        return this.templateId;
    }

    @Override
    public void setTemplateId(int templateSetLevel) {
        this.templateSetLevel = templateSetLevel;
    }

    @Override
    public int getTemplateSetLevel() {
        return this.templateSetLevel;
    }

    @Override
    public void setTemplateSetLevel(int templateId) {
        this.templateId = templateId;
    }

    @Override
    public boolean isAligned() {
        return this.isAligned;
    }

    @Override
    public void setAligned(boolean aligned) {
        this.isAligned = aligned;
    }

    @Override
    public List<? extends PartialPath> getPaths() {
        return Collections.singletonList(this.activatePath);
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        stream.writeByte((byte)PhysicalPlan.PhysicalPlanType.ACTIVATE_TEMPLATE_IN_CLUSTER.ordinal());
        ReadWriteIOUtils.write((String)this.activatePath.getFullPath(), (OutputStream)stream);
        ReadWriteIOUtils.write((int)this.templateSetLevel, (OutputStream)stream);
        ReadWriteIOUtils.write((int)this.templateId, (OutputStream)stream);
        ReadWriteIOUtils.write((Boolean)this.isAligned, (OutputStream)stream);
        stream.writeLong(this.index);
    }

    @Override
    protected void serializeImpl(ByteBuffer buffer) {
        buffer.put((byte)PhysicalPlan.PhysicalPlanType.ACTIVATE_TEMPLATE_IN_CLUSTER.ordinal());
        ReadWriteIOUtils.write((String)this.activatePath.getFullPath(), (ByteBuffer)buffer);
        ReadWriteIOUtils.write((int)this.templateSetLevel, (ByteBuffer)buffer);
        ReadWriteIOUtils.write((int)this.templateId, (ByteBuffer)buffer);
        ReadWriteIOUtils.write((Boolean)this.isAligned, (ByteBuffer)buffer);
        buffer.putLong(this.index);
    }

    @Override
    public void deserialize(ByteBuffer buffer) throws IllegalPathException, IOException {
        this.activatePath = new PartialPath(ReadWriteIOUtils.readString((ByteBuffer)buffer));
        this.templateSetLevel = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
        this.templateId = ReadWriteIOUtils.readInt((ByteBuffer)buffer);
        this.isAligned = ReadWriteIOUtils.readBool((ByteBuffer)buffer);
        this.index = buffer.getLong();
    }
}

