/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.physical.sys;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.commons.utils.IOUtils;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;

public class LogPlan
extends PhysicalPlan {
    private ByteBuffer log;

    public LogPlan() {
    }

    public LogPlan(ByteBuffer log) {
        this.log = log;
    }

    public LogPlan(LogPlan plan) {
        this.log = IOUtils.clone((ByteBuffer)plan.log);
    }

    public ByteBuffer getLog() {
        this.log.rewind();
        return this.log;
    }

    public void setLog(ByteBuffer log) {
        this.log = log;
    }

    public List<PartialPath> getPaths() {
        return Collections.emptyList();
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        stream.writeByte((byte)PhysicalPlan.PhysicalPlanType.CLUSTER_LOG.ordinal());
        stream.writeInt(this.log.array().length);
        stream.write(this.log.array());
    }

    @Override
    public void deserialize(ByteBuffer buffer) {
        int len = buffer.getInt();
        byte[] data = new byte[len];
        System.arraycopy(buffer.array(), buffer.position(), data, 0, len);
        this.log = ByteBuffer.wrap(data);
    }
}

