/*
 * Decompiled with CFR 0.152.
 */
package org.apache.iotdb.db.qp.physical.sys;

import java.io.DataOutputStream;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.apache.iotdb.commons.path.PartialPath;
import org.apache.iotdb.db.qp.logical.Operator;
import org.apache.iotdb.db.qp.physical.PhysicalPlan;
import org.apache.iotdb.db.qp.physical.sys.MNodePlan;

public class StorageGroupMNodePlan
extends MNodePlan {
    private long dataTTL;

    public StorageGroupMNodePlan() {
        super(Operator.OperatorType.STORAGE_GROUP_MNODE);
    }

    public StorageGroupMNodePlan(String name, long dataTTL, int childSize) {
        super(Operator.OperatorType.STORAGE_GROUP_MNODE);
        this.name = name;
        this.dataTTL = dataTTL;
        this.childSize = childSize;
    }

    @Override
    public List<PartialPath> getPaths() {
        return new ArrayList<PartialPath>();
    }

    public long getDataTTL() {
        return this.dataTTL;
    }

    public void setDataTTL(long dataTTL) {
        this.dataTTL = dataTTL;
    }

    @Override
    public void serializeImpl(ByteBuffer buffer) {
        buffer.put((byte)PhysicalPlan.PhysicalPlanType.STORAGE_GROUP_MNODE.ordinal());
        this.putString(buffer, this.name);
        buffer.putLong(this.dataTTL);
        buffer.putInt(this.childSize);
        buffer.putLong(this.index);
    }

    @Override
    public void serialize(DataOutputStream stream) throws IOException {
        stream.write((byte)PhysicalPlan.PhysicalPlanType.STORAGE_GROUP_MNODE.ordinal());
        this.putString(stream, this.name);
        stream.writeLong(this.dataTTL);
        stream.writeInt(this.childSize);
        stream.writeLong(this.index);
    }

    @Override
    public void deserialize(ByteBuffer buffer) {
        this.name = this.readString(buffer);
        this.dataTTL = buffer.getLong();
        this.childSize = buffer.getInt();
        this.index = buffer.getLong();
    }

    @Override
    public String toString() {
        return "StorageGroupMNode{" + this.name + "," + this.dataTTL + "," + this.childSize + "}";
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StorageGroupMNodePlan that = (StorageGroupMNodePlan)o;
        return Objects.equals(this.name, that.name) && Objects.equals(this.dataTTL, that.dataTTL) && Objects.equals(this.childSize, that.childSize);
    }

    @Override
    public int hashCode() {
        return Objects.hash(this.name, this.dataTTL, this.childSize);
    }
}

